package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人工资支付申请主实体
 *
 * @author generator
 */
public class SalaryPayApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String createUserName; // 创建者名称
    private String updateUserName; // 修改者名称
    private Long salaryId; // 工人工资单主表ID
    private Long salaryDetailId; // 工人工资单子表ID
    private String billCode; // 单据编码
    private String billCodeRepeat; // 重发的单据编码
    private String billCodeOld; // 重发的单据编码
    private Integer isRepeatBill; // 是否为重发的单据，1-是，0-否
    private Integer payState; // 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
    private String payStateName; // 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billStateName; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Integer repeatState; // 重发状态：0-无需重发，1-已重发，2-待重发
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date payDate; // 支付日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastPaySucTime; // 最后支付成功日期  无效字段-后期删除
    private String payResSource; // 支付结果来源，0-系统自动推送，1-手动确认
    private Long paySupplierId; // 收款单位ID
    private String paySupplierName; // 收款单位名称
    private Long applyId; // 申请人ID
    private String applyName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long contractCategoryId; // 合同类别ID
    private String contractCategoryName; // 合同类别名称
    private Long orgId; // 项目所属项目部ID
    private String orgCode; // 项目所属项目部编码
    private String orgName; // 项目所属项目部名称
    private Long parentOrgId; // 项目所属上级组织ID
    private String parentOrgCode; // 项目所属上级组织编码
    private String parentOrgName; // 项目所属上级组织名称
    private Long departmentId; // 经办部门ID
    private String departmentName; // 经办部门ID
    private Long accountId; // 银行账号id
    private String accountNum; // 银行账号
    private String accountName; // 银行账户名称
    private String bankName; // 开户行
    private BigDecimal contractTaxMny; // 合同金额（有税）
    private BigDecimal contractMny; // 合同金额（无税）
    private BigDecimal contractTax; // 合同金额（税额）
    private BigDecimal contractTotalActualTaxMny; //合同累计实付金额：所有已生效的付款申请单和已生效的工人工资支付申请单的实付金额的总和；
    private BigDecimal contractTotalApproveTaxMny; //合同累计批复金额：所有已生效的付款申请批复金额+已生效的工人工资支付申请金额
    private BigDecimal totalShouldPayTaxMny; // 累计应发金额（有税）
    private BigDecimal totalShouldPayMny; // 累计应发金额（无税）
    private BigDecimal totalShouldPayTax; // 累计应发金额（税额）
    private BigDecimal lastApplyTaxMny; // 截止上期已申请金额（有税）
    private BigDecimal lastApplyMny; // 截止上期已申请金额（无税）
    private BigDecimal lastApplyTax; // 截止上期已申请金额（税额）
    private BigDecimal curCanApplyTaxMny; // 本期可申请金额（有税）= 累计应发金额-截止截止上期已申请金额
    private BigDecimal curCanApplyMny; // 本期可申请金额（无税）= 累计应发金额-截止截止上期已申请金额
    private BigDecimal curCanApplyTax; // 本期可申请金额（税额）= 累计应发金额-截止截止上期已申请金额
    private BigDecimal totalActualPaidTaxMny; // 累计实付金额（有税）
    private BigDecimal totalActualPaidMny; // 累计实付金额（无税）
    private BigDecimal totalActualPaidTax; // 累计实付金额（税额）
    private BigDecimal totalProcessSettleTaxMny; // 累计月度结算金额（有税）
    private BigDecimal totalProcessSettleMny; // 累计月度结算金额（无税）
    private BigDecimal totalProcessSettleTax; // 累计月度结算金额（税额）
    private BigDecimal totalNodeSettleTaxMny; // 累计节点结算金额（有税）
    private BigDecimal totalNodeSettleMny; // 累计节点结算金额（无税）
    private BigDecimal totalNodeSettleTax; // 累计节点结算金额（税额）
    private BigDecimal applyTaxMny; // 本次申请金额（有税）
    private BigDecimal applyMny; // 本次申请金额（无税）
    private BigDecimal applyTax; // 本次申请金额（税额）
    private BigDecimal actualPaidTaxMny; // 实际支付金额（有税）
    private BigDecimal actualPaidMny; // 实际支付金额（无税）
    private BigDecimal actualPaidTax; // 实际支付金额（税额）
    private String payReason; // 付款事由
    private String memo; // 备注
    private String contractLinkUrl;// 合同穿透URL
    private String contractSourceType; // 合同所属大分类 proSub-专业分包合同，laborSub-劳务分包合同
    private String contractSourceTypeName; //合同所属大分类名称
    private BigDecimal payProcessSettleTaxMnyScale; // 【工资支付占月度结算比例】=工资累计申请金额（含本期）/累计月度结算金额
    private BigDecimal sumApplyTaxMny; // 【工资累计申请金额（含本期）】=截止上期已申请工资金额+本期申请金额
    private BigDecimal sumActualPaidTaxMny; // 【工资累计实付金额（含本期）】=截止上期工资实付金额+本期实付金
    private BigDecimal applyShouldPayScale; // 【工资累计申请比例（占应发）】=工资累计申请金额（含本期）/累计应发金额
    private BigDecimal actualShouldPayScale; // 【工资累计实付比例（占应发）】=工资累计实付金额（含本期）/累计应发金额
    private BigDecimal contractApplyTaxMnySum; // 【合同总计申请金额（含本期）】=合同累计申请金额+本期申请金额
    private BigDecimal contractActualTaxMnySum; // 【合同总计实付金额（含本期）】=合同累计实付金额+本期实付金额
    private BigDecimal contractApplyTaxMnyScale; // 【合同总计申请比例】=合同总计申请金额/合同金额
    private BigDecimal contractActualTaxMnyScale; // 【合同总计实付比例】=合同总计实付金额/合同金额
    private Integer isClose; // 单据是否关闭（1已关闭，0未关闭，默认未关闭）
    private BigDecimal applyTaxMnyOld; // 本次申请金额（有税）(原始)
    private BigDecimal totalSettleTaxMny; // 累计结算金额（有税）
    private BigDecimal totalSettleMny; // 累计结算金额（无税）
    private BigDecimal totalSettleTax; // 累计结算金额（税额）


    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }
    public Integer getIsClose() {
        return isClose;
    }

    public void setIsClose(Integer isClose) {
        this.isClose = isClose;
    }

    public BigDecimal getApplyTaxMnyOld() {
        return applyTaxMnyOld;
    }

    public void setApplyTaxMnyOld(BigDecimal applyTaxMnyOld) {
        this.applyTaxMnyOld = applyTaxMnyOld;
    }

    public BigDecimal getPayProcessSettleTaxMnyScale() {
        return payProcessSettleTaxMnyScale;
    }

    public void setPayProcessSettleTaxMnyScale(BigDecimal payProcessSettleTaxMnyScale) {
        this.payProcessSettleTaxMnyScale = payProcessSettleTaxMnyScale;
    }

    public BigDecimal getSumApplyTaxMny() {
        return sumApplyTaxMny;
    }

    public void setSumApplyTaxMny(BigDecimal sumApplyTaxMny) {
        this.sumApplyTaxMny = sumApplyTaxMny;
    }

    public BigDecimal getSumActualPaidTaxMny() {
        return sumActualPaidTaxMny;
    }

    public void setSumActualPaidTaxMny(BigDecimal sumActualPaidTaxMny) {
        this.sumActualPaidTaxMny = sumActualPaidTaxMny;
    }

    public BigDecimal getApplyShouldPayScale() {
        return applyShouldPayScale;
    }

    public void setApplyShouldPayScale(BigDecimal applyShouldPayScale) {
        this.applyShouldPayScale = applyShouldPayScale;
    }

    public BigDecimal getActualShouldPayScale() {
        return actualShouldPayScale;
    }

    public void setActualShouldPayScale(BigDecimal actualShouldPayScale) {
        this.actualShouldPayScale = actualShouldPayScale;
    }

    public BigDecimal getContractApplyTaxMnySum() {
        return contractApplyTaxMnySum;
    }

    public void setContractApplyTaxMnySum(BigDecimal contractApplyTaxMnySum) {
        this.contractApplyTaxMnySum = contractApplyTaxMnySum;
    }

    public BigDecimal getContractActualTaxMnySum() {
        return contractActualTaxMnySum;
    }

    public void setContractActualTaxMnySum(BigDecimal contractActualTaxMnySum) {
        this.contractActualTaxMnySum = contractActualTaxMnySum;
    }

    public BigDecimal getContractApplyTaxMnyScale() {
        return contractApplyTaxMnyScale;
    }

    public void setContractApplyTaxMnyScale(BigDecimal contractApplyTaxMnyScale) {
        this.contractApplyTaxMnyScale = contractApplyTaxMnyScale;
    }

    public BigDecimal getContractActualTaxMnyScale() {
        return contractActualTaxMnyScale;
    }

    public void setContractActualTaxMnyScale(BigDecimal contractActualTaxMnyScale) {
        this.contractActualTaxMnyScale = contractActualTaxMnyScale;
    }
    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    private List<SalaryPayApplyDetailVO> salaryList = new ArrayList<>(); // 工人工资支付申请子实体

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @Override
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }

    public Long getSalaryDetailId() {
        return salaryDetailId;
    }

    public void setSalaryDetailId(Long salaryDetailId) {
        this.salaryDetailId = salaryDetailId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillCodeRepeat() {
        return billCodeRepeat;
    }

    public String getBillCodeOld() {
        return billCodeOld;
    }

    public void setBillCodeOld(String billCodeOld) {
        this.billCodeOld = billCodeOld;
    }

    public void setBillCodeRepeat(String billCodeRepeat) {
        this.billCodeRepeat = billCodeRepeat;
    }

    public Integer getIsRepeatBill() {
        return isRepeatBill;
    }

    public void setIsRepeatBill(Integer isRepeatBill) {
        this.isRepeatBill = isRepeatBill;
    }

    public Integer getPayState() {
        return payState;
    }

    public void setPayState(Integer payState) {
        this.payState = payState;
    }

    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getRepeatState() {
        return repeatState;
    }

    public void setRepeatState(Integer repeatState) {
        this.repeatState = repeatState;
    }

    public Date getPayDate() {
        return payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public Date getLastPaySucTime() {
        return lastPaySucTime;
    }

    public void setLastPaySucTime(Date lastPaySucTime) {
        this.lastPaySucTime = lastPaySucTime;
    }

    public String getPayResSource() {
        return payResSource;
    }

    public void setPayResSource(String payResSource) {
        this.payResSource = payResSource;
    }

    public Long getPaySupplierId() {
        return paySupplierId;
    }

    @ReferDeserialTransfer
    public void setPaySupplierId(Long paySupplierId) {
        this.paySupplierId = paySupplierId;
    }

    public String getPaySupplierName() {
        return paySupplierName;
    }

    public void setPaySupplierName(String paySupplierName) {
        this.paySupplierName = paySupplierName;
    }

    public Long getApplyId() {
        return applyId;
    }

    @ReferDeserialTransfer
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getAccountId() {
        return accountId;
    }

    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getTotalShouldPayTaxMny() {
        return totalShouldPayTaxMny;
    }

    public void setTotalShouldPayTaxMny(BigDecimal totalShouldPayTaxMny) {
        this.totalShouldPayTaxMny = totalShouldPayTaxMny;
    }

    public BigDecimal getTotalShouldPayMny() {
        return totalShouldPayMny;
    }

    public void setTotalShouldPayMny(BigDecimal totalShouldPayMny) {
        this.totalShouldPayMny = totalShouldPayMny;
    }

    public BigDecimal getTotalShouldPayTax() {
        return totalShouldPayTax;
    }

    public void setTotalShouldPayTax(BigDecimal totalShouldPayTax) {
        this.totalShouldPayTax = totalShouldPayTax;
    }

    public BigDecimal getLastApplyTaxMny() {
        return lastApplyTaxMny;
    }

    public void setLastApplyTaxMny(BigDecimal lastApplyTaxMny) {
        this.lastApplyTaxMny = lastApplyTaxMny;
    }

    public BigDecimal getLastApplyMny() {
        return lastApplyMny;
    }

    public void setLastApplyMny(BigDecimal lastApplyMny) {
        this.lastApplyMny = lastApplyMny;
    }

    public BigDecimal getLastApplyTax() {
        return lastApplyTax;
    }

    public void setLastApplyTax(BigDecimal lastApplyTax) {
        this.lastApplyTax = lastApplyTax;
    }

    public BigDecimal getCurCanApplyTaxMny() {
        return curCanApplyTaxMny;
    }

    public void setCurCanApplyTaxMny(BigDecimal curCanApplyTaxMny) {
        this.curCanApplyTaxMny = curCanApplyTaxMny;
    }

    public BigDecimal getCurCanApplyMny() {
        return curCanApplyMny;
    }

    public void setCurCanApplyMny(BigDecimal curCanApplyMny) {
        this.curCanApplyMny = curCanApplyMny;
    }

    public BigDecimal getCurCanApplyTax() {
        return curCanApplyTax;
    }

    public void setCurCanApplyTax(BigDecimal curCanApplyTax) {
        this.curCanApplyTax = curCanApplyTax;
    }

    public BigDecimal getTotalActualPaidTaxMny() {
        return totalActualPaidTaxMny;
    }

    public void setTotalActualPaidTaxMny(BigDecimal totalActualPaidTaxMny) {
        this.totalActualPaidTaxMny = totalActualPaidTaxMny;
    }

    public BigDecimal getTotalActualPaidMny() {
        return totalActualPaidMny;
    }

    public void setTotalActualPaidMny(BigDecimal totalActualPaidMny) {
        this.totalActualPaidMny = totalActualPaidMny;
    }

    public BigDecimal getTotalActualPaidTax() {
        return totalActualPaidTax;
    }

    public void setTotalActualPaidTax(BigDecimal totalActualPaidTax) {
        this.totalActualPaidTax = totalActualPaidTax;
    }

    public BigDecimal getTotalProcessSettleTaxMny() {
        return totalProcessSettleTaxMny;
    }

    public void setTotalProcessSettleTaxMny(BigDecimal totalProcessSettleTaxMny) {
        this.totalProcessSettleTaxMny = totalProcessSettleTaxMny;
    }

    public BigDecimal getTotalProcessSettleMny() {
        return totalProcessSettleMny;
    }

    public void setTotalProcessSettleMny(BigDecimal totalProcessSettleMny) {
        this.totalProcessSettleMny = totalProcessSettleMny;
    }

    public BigDecimal getTotalProcessSettleTax() {
        return totalProcessSettleTax;
    }

    public void setTotalProcessSettleTax(BigDecimal totalProcessSettleTax) {
        this.totalProcessSettleTax = totalProcessSettleTax;
    }

    public BigDecimal getTotalNodeSettleTaxMny() {
        return totalNodeSettleTaxMny;
    }

    public void setTotalNodeSettleTaxMny(BigDecimal totalNodeSettleTaxMny) {
        this.totalNodeSettleTaxMny = totalNodeSettleTaxMny;
    }

    public BigDecimal getTotalNodeSettleMny() {
        return totalNodeSettleMny;
    }

    public void setTotalNodeSettleMny(BigDecimal totalNodeSettleMny) {
        this.totalNodeSettleMny = totalNodeSettleMny;
    }

    public BigDecimal getTotalNodeSettleTax() {
        return totalNodeSettleTax;
    }

    public void setTotalNodeSettleTax(BigDecimal totalNodeSettleTax) {
        this.totalNodeSettleTax = totalNodeSettleTax;
    }

    public BigDecimal getApplyTaxMny() {
        return applyTaxMny;
    }

    public void setApplyTaxMny(BigDecimal applyTaxMny) {
        this.applyTaxMny = applyTaxMny;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getApplyTax() {
        return applyTax;
    }

    public void setApplyTax(BigDecimal applyTax) {
        this.applyTax = applyTax;
    }

    public BigDecimal getActualPaidTaxMny() {
        return actualPaidTaxMny;
    }

    public void setActualPaidTaxMny(BigDecimal actualPaidTaxMny) {
        this.actualPaidTaxMny = actualPaidTaxMny;
    }

    public BigDecimal getActualPaidMny() {
        return actualPaidMny;
    }

    public void setActualPaidMny(BigDecimal actualPaidMny) {
        this.actualPaidMny = actualPaidMny;
    }

    public BigDecimal getActualPaidTax() {
        return actualPaidTax;
    }

    public void setActualPaidTax(BigDecimal actualPaidTax) {
        this.actualPaidTax = actualPaidTax;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<SalaryPayApplyDetailVO> getSalaryList() {
        return salaryList;
    }

    public void setSalaryList(List<SalaryPayApplyDetailVO> salaryList) {
        this.salaryList = salaryList;
    }

    public BigDecimal getContractTotalActualTaxMny() {
        return contractTotalActualTaxMny;
    }

    public void setContractTotalActualTaxMny(BigDecimal contractTotalActualTaxMny) {
        this.contractTotalActualTaxMny = contractTotalActualTaxMny;
    }

    public BigDecimal getContractTotalApproveTaxMny() {
        return contractTotalApproveTaxMny;
    }

    public void setContractTotalApproveTaxMny(BigDecimal contractTotalApproveTaxMny) {
        this.contractTotalApproveTaxMny = contractTotalApproveTaxMny;
    }

    public String getContractSourceType() {
        return contractSourceType;
    }

    public void setContractSourceType(String contractSourceType) {
        this.contractSourceType = contractSourceType;
    }

    public String getContractSourceTypeName() {
        return contractSourceTypeName;
    }

    public void setContractSourceTypeName(String contractSourceTypeName) {
        this.contractSourceTypeName = contractSourceTypeName;
    }
}
