package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 付款登记主实体
 * 
 * @author generator
 * 
 */
public class PaymentRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 付款登记来源单据类型：项目资金计划
     */
    public static Integer SOURCE_BILL_TYPE_PRJFINANCE_PLAN = 0;
    /**
     * 付款登记来源单据类型：项目资金计划
     */
    public static Integer SOURCE_BILL_TYPE_PAYMENT_APPLY = 2;
    /**
     * 付款登记来源单据类型：项目资金计划
     */
    public static Integer SOURCE_BILL_TYPE_SALARY_PAY_APPLY = 3;

    private Long createUserId; // 创建者账号
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long contractCategoryId; // 合同类别id
    private String contractCategoryCode; // 合同类别编码
    private String contractCategoryName; // 合同类别名称
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方名称
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paymentDate; // 支付日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办（申请人）部门id
    private String departmentName; // 经办（申请人）部门名称
    private Integer paymentContractFlag;  // 支出类型 有无合同 0：有合同；1：无合同；2：合同付款；3：零星材料；4：临时机械；5：零星费用
    private Long accountId; // 银行账户id
    private String accountNum; // 银行账号
    private String accountName; // 账户名称
    private String bankAccount; // 开户行
    private Long feeTypeId; // 无合同费用类型：0-正常付款，1-预付款，2-诉讼款,3:零星材料；4：临时机械
    private String feeTypeName; // 无合同费用类型名称
    private String feeTypeCode; //无合同费用类型编码
    private Integer personalPrepaid; // 是否个人垫付 0-否 1-是
    private Long payeeId; // 收款人
    private String payeeName; // 收款人名称
    private BigDecimal alreadyPayMny; // 已付款金额  已支付金额(不含本次)
    private BigDecimal payMny; // 本次付款金额 本次实付金额
    private Long settleTypeId; // 结算方式id
    private String settleTypeName; // 结算方式名称
    private String settleTypeCode; // 结算方式编码
    private String paymentReason; // 付款说明 非必填，0-300字
    private String memo; // 备注  非必填，0-500字
    private String contractLinkUrl; //合同详情页面
    private String billStateName; // 单据状态名称
    private String paymentContractFlagName; // 支出类型名称 有无合同 0：有合同；1：无合同
    private String sourceCategoryType; // 合同大类
    private String sourceCategoryTypeName; // 合同大类名称
    private BigDecimal planPaymentMny;//计划付款金额
    private BigDecimal payableMny; // 本次可支付金额
    private BigDecimal lastPaymentMny; // 已支付金额(不含本次)
    private BigDecimal totalPaymentMny; // 累计支付金额(含本次)
    private Long sourceId; // 来源id
    private String sourceCode; // 来源编码
    private String sourceType; // 项目资金计划 付款申请 工人工资 手动补录
    private Integer sourceBillType; //数据来源单据类型： 1-项目资金计划， 2-付款申请， 3-工人工资
    private String refStatus;//引用状态
    private Long sourceParentId; // 来源结算单父id


    private List<RegisterDetailVO> detailList = new ArrayList<>();
    private Integer purchaseMethod; // 采购方式（1：直采2：代采）


    public Integer getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(Integer purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }
    public Long getSourceParentId() {
        return sourceParentId;
    }

    public void setSourceParentId(Long sourceParentId) {
        this.sourceParentId = sourceParentId;
    }

    public BigDecimal getPlanPaymentMny() {
        return planPaymentMny;
    }

    public void setPlanPaymentMny(BigDecimal planPaymentMny) {
        this.planPaymentMny = planPaymentMny;
    }

    public String getRefStatus() {
        return refStatus;
    }

    public void setRefStatus(String refStatus) {
        this.refStatus = refStatus;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }

    public BigDecimal getLastPaymentMny() {
        return lastPaymentMny;
    }

    public void setLastPaymentMny(BigDecimal lastPaymentMny) {
        this.lastPaymentMny = lastPaymentMny;
    }

    public BigDecimal getTotalPaymentMny() {
        return totalPaymentMny;
    }

    public void setTotalPaymentMny(BigDecimal totalPaymentMny) {
        this.totalPaymentMny = totalPaymentMny;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public List<RegisterDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<RegisterDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferDeserialTransfer
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    @ReferDeserialTransfer
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferDeserialTransfer
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }
    @ReferDeserialTransfer
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferDeserialTransfer
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getPaymentContractFlag() {
        return paymentContractFlag;
    }

    public void setPaymentContractFlag(Integer paymentContractFlag) {
        this.paymentContractFlag = paymentContractFlag;
    }

    @ReferDeserialTransfer
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    @ReferDeserialTransfer
    public Long getFeeTypeId() {
        return feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }
    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getFeeTypeCode() {
        return feeTypeCode;
    }

    public void setFeeTypeCode(String feeTypeCode) {
        this.feeTypeCode = feeTypeCode;
    }

    public Integer getPersonalPrepaid() {
        return personalPrepaid;
    }

    public void setPersonalPrepaid(Integer personalPrepaid) {
        this.personalPrepaid = personalPrepaid;
    }
    @ReferDeserialTransfer
    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }
    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }
    public BigDecimal getAlreadyPayMny() {
        return alreadyPayMny;
    }

    public void setAlreadyPayMny(BigDecimal alreadyPayMny) {
        this.alreadyPayMny = alreadyPayMny;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    @ReferDeserialTransfer
    public Long getSettleTypeId() {
        return settleTypeId;
    }

    public void setSettleTypeId(Long settleTypeId) {
        this.settleTypeId = settleTypeId;
    }
    public String getSettleTypeName() {
        return settleTypeName;
    }

    public void setSettleTypeName(String settleTypeName) {
        this.settleTypeName = settleTypeName;
    }

    public String getSettleTypeCode() {
        return settleTypeCode;
    }

    public void setSettleTypeCode(String settleTypeCode) {
        this.settleTypeCode = settleTypeCode;
    }

    public String getPaymentReason() {
        return paymentReason;
    }

    public void setPaymentReason(String paymentReason) {
        this.paymentReason = paymentReason;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getPaymentContractFlagName() {
        return paymentContractFlagName;
    }

    public void setPaymentContractFlagName(String paymentContractFlagName) {
        this.paymentContractFlagName = paymentContractFlagName;
    }

    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }

    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }

    public Integer getSourceBillType() {
        return sourceBillType;
    }

    public void setSourceBillType(Integer sourceBillType) {
        this.sourceBillType = sourceBillType;
    }
}
