package com.ejianc.business.profinance.api;


import com.ejianc.business.profinance.hystrix.SalaryHystrix;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 工人工资单API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = SalaryHystrix.class)
public interface ISalaryApi {

    /**
     * 通过合同id、结算类型、日期查询相应的工人工资单
     * @param contractId
     * @param settleType
     * @param settleDate
     * @return
     */
    @GetMapping(value = "/api/salaryApi/querySalaryList")
    CommonResponse<List<SalaryVO>> querySalaryList(@RequestParam(value = "contractId") Long contractId, @RequestParam(value = "settleType") Integer settleType, @RequestParam(value = "settleDate") String settleDate);


    /**
     * 结算单引用工人工资单后回写settleId
     * @param salaryIds
     * @param settleId
     * @return
     */
    @PostMapping(value = "/api/salaryApi/writeSalarySettleId")
    CommonResponse<String> writeSalarySettleId(@RequestParam(value = "salaryIds") List<Long> salaryIds, @RequestParam(value = "settleId", required = false) String settleId);

    /**
     * 根据合同给查询合同下对应的工人工资支付申请信息
     *
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/salaryApi/salaryApplyInfoByContractId")
    CommonResponse<ContractPaymentResultVO> querySalaryApplyInfoByContractId(@RequestParam Long contractId);


    /**
     * 通过合同id查询相应的工人工资单
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/salaryApi/querySalaryListByContract")
    CommonResponse<List<SalaryVO>> querySalaryListByContract(@RequestParam(value = "contractId") Long contractId);

}
