package com.ejianc.business.profinance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.hystrix.PaymentApplyHystrix;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款申请API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = PaymentApplyHystrix.class)
public interface IPaymentApplyApi {

    /**
     * 通过合同id查询相应的付款申请单
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/paymentApplyApi/queryListByContractId")
    CommonResponse<List<PaymentApplyVO>> queryListByContractId(@RequestParam(value = "contractId") Long contractId);

    /**
     * 通过结算单id查询相应的付款申请单
     * @param settleId
     * @return
     */
    @GetMapping(value = "/api/paymentApplyApi/queryListBySettleId")
    CommonResponse<List<PaymentApplyVO>> queryListBySettleId(@RequestParam(value = "settleId") Long settleId);

    /**
     * 通过合同id判断能否新增付款申请单
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/paymentApplyApi/queryAddFlagContractId")
    CommonResponse<String> queryAddFlagContractId(@RequestParam(value = "contractId") Long contractId);

    @GetMapping("/api/paymentApplyApi/queryJsonByContractId")
    CommonResponse<ContractPaymentResultVO> queryJsonByContractId(@RequestParam(value = "id") Long contractId);

    /**
     * 通过合同id  供应商id 查询该供应商合同的累计付款
     * @param supplierId
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/paymentApplyApi/querySumApplyMny")
    CommonResponse<JSONObject> querySumApplyMny(@RequestParam(value = "supplierId") Long supplierId,@RequestParam(value = "contractId") Long contractId);

    /**
     * 通过组织ids  供应商ids 查询该供应商累计付款
     * @return
     */
    @PostMapping(value = "/api/paymentApplyApi/querySumMny")
    public CommonResponse<Map<Long, BigDecimal>> querySumMny(@RequestBody Map<String,List<Long>> param);

    /**
     * 按月份查询实付金额
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/paymentApplyApi/queryActualPayGroupByMonth")
    public CommonResponse<List<Map<String, BigDecimal>>> queryActualPayGroupByMonth(@RequestBody QueryParam queryParam);

    /**
     * 按合同类型查询实付金额
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/paymentApplyApi/queryActualPayGroupByContractCategoryType")
    public CommonResponse<List<Map<String, BigDecimal>>> queryActualPayGroupByContractCategoryType(@RequestBody QueryParam queryParam);
}
