package com.ejianc.business.receipt.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
public class ReceiptRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long createUserId; // 创建者账号
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long contractCategoryId; // 合同类别id
    private String contractCategoryCode; // 合同类别编码
    private String contractCategoryName; // 合同类别名称
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long customerId; // 甲方id
    private String customerName; // 甲方名称
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    @JsonFormat(locale="zh", pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiptDate; // 收款日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办（申请人）部门id
    private String departmentName; // 经办（申请人）部门名称
    private String memo; // 备注  非必填，0-500字
    private String receiptReason; // 收款款说明 非必填，0-300字
    private Integer receiptContractFlag; // 收款类型 有无合同 0：有合同；1：无合同
    private String accountNum; // 银行账号
    private String accountName; // 账户名称
    private String bankAccount; // 开户行
    private Long accountId; // 银行账户id
    private BigDecimal totalReceiptMny; // 已付款金额
    private String settleTypeName; // 结算方式
    private BigDecimal sumReceivedMny; // 本次实收金额
    private Long clausePropertyId; // 款项属性id
    private String clausePropertyName; // 款项属性名称
    private Long settleTypeId; // 结算方式id
    private Long feeId; // 无合同费用类型id
    private String feeName; // 无合同费用类型名称
    private String billStateName; //单据状态名称
    private String receiptContractFlagName; //收款类型
    private String warnType;
    private String sourceCategoryType; // 合同大类
    private String sourceCategoryTypeName; // 合同大类名称
    private Long recipetApplyId; // 收款申请单号Id
    private String recipetApplyCode; // 收款申请单号Code
    private String unMny; // 收款节点未核销

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="contractPool")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    @ReferDeserialTransfer
    public Long getProjectId() {
        return projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getReceiptDate() {
        return receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReceiptReason() {
        return receiptReason;
    }

    public void setReceiptReason(String receiptReason) {
        this.receiptReason = receiptReason;
    }
    public Integer getReceiptContractFlag() {
        return receiptContractFlag;
    }
    public void setReceiptContractFlag(Integer receiptContractFlag) {
        this.receiptContractFlag = receiptContractFlag;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    @ReferSerialTransfer(referCode = "support-bank-account")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public BigDecimal getTotalReceiptMny() {
        return totalReceiptMny;
    }

    public void setTotalReceiptMny(BigDecimal totalReceiptMny) {
        this.totalReceiptMny = totalReceiptMny;
    }
    public String getSettleTypeName() {
        return settleTypeName;
    }

    public void setSettleTypeName(String settleTypeName) {
        this.settleTypeName = settleTypeName;
    }
    public BigDecimal getSumReceivedMny() {
        return sumReceivedMny;
    }

    public void setSumReceivedMny(BigDecimal sumReceivedMny) {
        this.sumReceivedMny = sumReceivedMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getClausePropertyId() {
        return clausePropertyId;
    }
    @ReferDeserialTransfer
    public void setClausePropertyId(Long clausePropertyId) {
        this.clausePropertyId = clausePropertyId;
    }
    public String getClausePropertyName() {
        return clausePropertyName;
    }

    public void setClausePropertyName(String clausePropertyName) {
        this.clausePropertyName = clausePropertyName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSettleTypeId() {
        return settleTypeId;
    }
    @ReferDeserialTransfer
    public void setSettleTypeId(Long settleTypeId) {
        this.settleTypeId = settleTypeId;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeId() {
        return feeId;
    }
    @ReferDeserialTransfer
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getReceiptContractFlagName() {
        return receiptContractFlagName;
    }

    public void setReceiptContractFlagName(String receiptContractFlagName) {
        this.receiptContractFlagName = receiptContractFlagName;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }

    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }
    @ReferDeserialTransfer
    public Long getRecipetApplyId() {
        return recipetApplyId;
    }

    public void setRecipetApplyId(Long recipetApplyId) {
        this.recipetApplyId = recipetApplyId;
    }

    public String getRecipetApplyCode() {
        return recipetApplyCode;
    }

    public void setRecipetApplyCode(String recipetApplyCode) {
        this.recipetApplyCode = recipetApplyCode;
    }

    public String getUnMny() {
        return unMny;
    }

    public void setUnMny(String unMny) {
        this.unMny = unMny;
    }
}
