package com.ejianc.business.financial.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.financial.vo.StampDutyDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 印花税管理
 * 
 * @author generator
 * 
 */
public class StampDutyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Long orgId; // 单位id
    private String orgName; // 单位
    private Long projectId; // 项目id
    private String projectName; // 项目
    @JsonFormat(locale="zh", pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billTime; // 单据生成日期
    private String yearmonth; // 年月
    private String cwProjectCode; // 财务项目编号
    private String cwProjectName; // 财务项目名称
    private String cwAccountCode; // 财务账套编号
    private String cwAccountName; // 财务账套名称
    private Long operationUnitId; // 经营单位id
    private String operationUnitName; // 经营单位名称
    private Integer incomeContractNum; // 收入合同份数
    private BigDecimal incomeContractMoney; // 收入印花税金额
    private Integer expendContractNum; // 支出合同份数
    private BigDecimal expendContractMoney; // 支出印花税金额
    private BigDecimal totalContractMoney; // 合计印花税金额
    private String memo; // 备注
    private String billCode; // 单据编码
    private List<StampDutyDetailVO> stampDutyDetailList = new ArrayList<>(); // 印花税管理-明细表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }
    public String getYearmonth() {
        return yearmonth;
    }

    public void setYearmonth(String yearmonth) {
        this.yearmonth = yearmonth;
    }
    public String getCwProjectCode() {
        return cwProjectCode;
    }

    public void setCwProjectCode(String cwProjectCode) {
        this.cwProjectCode = cwProjectCode;
    }
    public String getCwProjectName() {
        return cwProjectName;
    }

    public void setCwProjectName(String cwProjectName) {
        this.cwProjectName = cwProjectName;
    }
    public String getCwAccountCode() {
        return cwAccountCode;
    }

    public void setCwAccountCode(String cwAccountCode) {
        this.cwAccountCode = cwAccountCode;
    }
    public String getCwAccountName() {
        return cwAccountName;
    }

    public void setCwAccountName(String cwAccountName) {
        this.cwAccountName = cwAccountName;
    }
    public Long getOperationUnitId() {
        return operationUnitId;
    }

    public void setOperationUnitId(Long operationUnitId) {
        this.operationUnitId = operationUnitId;
    }
    public String getOperationUnitName() {
        return operationUnitName;
    }

    public void setOperationUnitName(String operationUnitName) {
        this.operationUnitName = operationUnitName;
    }
    public Integer getIncomeContractNum() {
        return incomeContractNum;
    }

    public void setIncomeContractNum(Integer incomeContractNum) {
        this.incomeContractNum = incomeContractNum;
    }
    public BigDecimal getIncomeContractMoney() {
        return incomeContractMoney;
    }

    public void setIncomeContractMoney(BigDecimal incomeContractMoney) {
        this.incomeContractMoney = incomeContractMoney;
    }
    public Integer getExpendContractNum() {
        return expendContractNum;
    }

    public void setExpendContractNum(Integer expendContractNum) {
        this.expendContractNum = expendContractNum;
    }
    public BigDecimal getExpendContractMoney() {
        return expendContractMoney;
    }

    public void setExpendContractMoney(BigDecimal expendContractMoney) {
        this.expendContractMoney = expendContractMoney;
    }
    public BigDecimal getTotalContractMoney() {
        return totalContractMoney;
    }

    public void setTotalContractMoney(BigDecimal totalContractMoney) {
        this.totalContractMoney = totalContractMoney;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<StampDutyDetailVO> getStampDutyDetailList() {
        return stampDutyDetailList;
     }

     public void setStampDutyDetailList(List<StampDutyDetailVO> stampDutyDetailList) {
        this.stampDutyDetailList = stampDutyDetailList;
     }
}
