package com.ejianc.business.performance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 承包合同登记
 * 
 * @author generator
 * 
 */
public class PerformanceContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @JsonFormat(locale="zh", pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 业务日期
    private String billCode; // 单据编号
    private String billName; // 单据名称
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long engineeringTypeId; // 工程类别
    private String engineeringType; // 工程类型
    private Integer planDateNum; // 计划工期
    private BigDecimal projectCost; // 工程造价
    private BigDecimal managerMny; // 管理费金额
    private BigDecimal managerPercent; // 管理费比例
    private Integer payType; // 缴纳方式(0现金,1工程款或预付款,2垫资款,3担保)
    private Integer signState; // 合同签订状态(0已签订,1未签订)
    private Integer deductionTatus; // 扣款状态(0正常,1中止,2取消,3完成)
    private Integer withholdingType; // 扣缴类型(0一次性扣款,1比例收取10%,2固定金额扣款,3其他)
    private Integer performanceBondReturn; // 履约保证金退还情况(0已退还,1未退还)
    private BigDecimal amountDue; // 应缴金额
    private BigDecimal alreadyDeductedAmount; // 已扣金额
    private BigDecimal alreadyDeductedPaidAmount; // 已扣已缴金额
    private BigDecimal remainAmount; // 剩余待缴金额
    private String memo; // 备注
    

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }
    public Integer getPlanDateNum() {
        return planDateNum;
    }

    public void setPlanDateNum(Integer planDateNum) {
        this.planDateNum = planDateNum;
    }
    public BigDecimal getProjectCost() {
        return projectCost;
    }

    public void setProjectCost(BigDecimal projectCost) {
        this.projectCost = projectCost;
    }
    public BigDecimal getManagerMny() {
        return managerMny;
    }

    public void setManagerMny(BigDecimal managerMny) {
        this.managerMny = managerMny;
    }
    public BigDecimal getManagerPercent() {
        return managerPercent;
    }

    public void setManagerPercent(BigDecimal managerPercent) {
        this.managerPercent = managerPercent;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    public Integer getDeductionTatus() {
        return deductionTatus;
    }

    public void setDeductionTatus(Integer deductionTatus) {
        this.deductionTatus = deductionTatus;
    }
    public Integer getWithholdingType() {
        return withholdingType;
    }

    public void setWithholdingType(Integer withholdingType) {
        this.withholdingType = withholdingType;
    }
    public Integer getPerformanceBondReturn() {
        return performanceBondReturn;
    }

    public void setPerformanceBondReturn(Integer performanceBondReturn) {
        this.performanceBondReturn = performanceBondReturn;
    }
    public BigDecimal getAmountDue() {
        return amountDue;
    }

    public void setAmountDue(BigDecimal amountDue) {
        this.amountDue = amountDue;
    }
    public BigDecimal getAlreadyDeductedAmount() {
        return alreadyDeductedAmount;
    }

    public void setAlreadyDeductedAmount(BigDecimal alreadyDeductedAmount) {
        this.alreadyDeductedAmount = alreadyDeductedAmount;
    }
    public BigDecimal getAlreadyDeductedPaidAmount() {
        return alreadyDeductedPaidAmount;
    }

    public void setAlreadyDeductedPaidAmount(BigDecimal alreadyDeductedPaidAmount) {
        this.alreadyDeductedPaidAmount = alreadyDeductedPaidAmount;
    }
    public BigDecimal getRemainAmount() {
        return remainAmount;
    }

    public void setRemainAmount(BigDecimal remainAmount) {
        this.remainAmount = remainAmount;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
