package com.ejianc.business.profinance.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.common.bean.BillHandleResultEntity;
import com.ejianc.business.profinance.common.enums.BillHandleTypeEnum;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.service.ICommonBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/17 17:24
 */
@Component
public class BillHandleResultListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillHandleResultService billHandleResultService;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        //拿到消息队列中的数据，进行处理
        logger.info("监听从消息队列中拿到单据处理结果消息：{}", JSON.toJSONString(mqMessage.getBody()));

        BillHandleResultVO billHandleResultVO = null;
        try {
            billHandleResultVO = JSONObject.parseObject(JSON.toJSONString(mqMessage.getBody()), BillHandleResultVO.class);

            //表示此结果需要调用子实现类去更有针对性的处理
            if(billHandleResultVO.getHandleWithSubService()) {
                //根据处理单据类型，获取处理信息配置
                BillHandleTypeEnum handleTypeEnum = BillHandleTypeEnum.getByCode(billHandleResultVO.getHandleBillType());
                ICommonBillHandleResultService subService = null;
                if(null == handleTypeEnum || StringUtils.isBlank(handleTypeEnum.getHandleServiceName())) {
                    logger.warn("未查询到类型-{}未配置单据处理结果接受服务类，处理结果只做保存操作！", billHandleResultVO.getHandleBillType());
                }  else {
                    subService = ContextUtil.getBean(handleTypeEnum.getHandleServiceName(), ICommonBillHandleResultService.class);
                    if(null != subService) {
                        boolean result = subService.recordBillHandleResult(billHandleResultVO);
                        logger.info("调用服务-{} 处理数据-{},结果-{}",subService.getClass().getName(), JSON.toJSONString(mqMessage.getBody()), result);
                    }else {
                        logger.warn("******** 未查询到类型-{}对应的单据处理结果接受服务类  ******", billHandleResultVO.getHandleBillType());
                    }
                }
            }

        } catch (Exception e) {
            logger.info("单据处理结果数据-[{}]处理异常：", JSON.toJSONString(mqMessage.getBody()), e);
        }

        //将数据处理结果记录入库
        billHandleResultService.saveOrUpdate(BeanMapper.map(billHandleResultVO, BillHandleResultEntity.class), false);
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{BillHandleResultVO.MESSAGE_QUEUE};
    }
}
