package com.ejianc.business.profinance.controller.api;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@RestController
@RequestMapping("/api/receiptAndPaymentRegisterApi/")
public class ReceiptAndPaymentRegisterApi implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IPaymentRegisterService paymentRegisterService;

    @Autowired
    private IReceiptRegisterService receiptRegisterService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    /**
     * 通过根据项目ids查询 收款登记 本次实收金额  付款登记合计 本次付款金额合计
     * @param  queryParam
     * @return
     */
    @PostMapping(value = "/queryReceiptAndPaymentMny")
    CommonResponse<JSONObject> queryReceiptAndPaymentMny(@RequestBody QueryParam queryParam){
        JSONObject jsonObject = new JSONObject();
        QueryWrapper<PaymentRegisterEntity> paymentWrapper = changeToQueryWrapper(queryParam);
        paymentWrapper.select("IFNULL(SUM(pay_mny),0) AS payMny");
        PaymentRegisterEntity paymentRegisterEntity = paymentRegisterService.getOne(paymentWrapper);
        jsonObject.put("payMny",paymentRegisterEntity.getPayMny());
        QueryWrapper<ReceiptRegisterEntity> receiptRegisterWrapper = changeToQueryWrapper(queryParam);
        receiptRegisterWrapper.select("IFNULL(SUM(sum_received_mny),0) AS sumReceivedMny");
        ReceiptRegisterEntity receiptRegisterEntity = receiptRegisterService.getOne(receiptRegisterWrapper);
        jsonObject.put("sumReceivedMny",receiptRegisterEntity.getSumReceivedMny());
        return CommonResponse.success("查询成功！",jsonObject);
    }

    /**
     * 通过根据项目id,合同类型查询付款金额合计
     * @return
     */
    @GetMapping(value = "/queryPayMnyByProjAndContType")
    CommonResponse<JSONObject> queryPayMnyByProjAndContType(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "contractType") String contractType){
        JSONObject jsonObject = new JSONObject();
        BigDecimal payMny = BigDecimal.ZERO;
        QueryWrapper<PaymentRegisterEntity> paymentWrapper = new QueryWrapper<>();
        paymentWrapper.eq("project_id", projectId);
        paymentWrapper.eq("source_category_type", contractType);
        paymentWrapper.eq("payment_contract_flag", 0);
        paymentWrapper.in("bill_state", Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        paymentWrapper.select("IFNULL(SUM(pay_mny),0) AS payMny");
        PaymentRegisterEntity paymentRegisterEntity = paymentRegisterService.getOne(paymentWrapper);
        payMny = ComputeUtil.safeAdd(payMny, paymentRegisterEntity.getPayMny());
        if(ContractTypeEnum.物资采购合同.getTypeCode().equals(contractType)){
            QueryWrapper<PaymentRegisterEntity> noContQuery = new QueryWrapper<>();
            noContQuery.eq("project_id", projectId);
            noContQuery.eq("payment_contract_flag", 1);
            noContQuery.eq("fee_type_code", "sporadic_material_fee");//3-零星材料
            noContQuery.in("bill_state", Arrays.asList(
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()));
            noContQuery.select("IFNULL(SUM(pay_mny),0) AS payMny");
            PaymentRegisterEntity noContEntity = paymentRegisterService.getOne(noContQuery);
            payMny = ComputeUtil.safeAdd(payMny, noContEntity.getPayMny());
        }else if(ContractTypeEnum.临时设备.getTypeCode().equals(contractType)){
            QueryWrapper<PaymentRegisterEntity> noContQuery = new QueryWrapper<>();
            noContQuery.eq("project_id", projectId);
            noContQuery.eq("payment_contract_flag", 1);
            noContQuery.eq("fee_type_code", "temp_equip_fee");//4-临时机械
            noContQuery.in("bill_state", Arrays.asList(
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()));
            noContQuery.select("IFNULL(SUM(pay_mny),0) AS payMny");
            PaymentRegisterEntity noContEntity = paymentRegisterService.getOne(noContQuery);
            payMny = ComputeUtil.safeAdd(payMny, noContEntity.getPayMny());
        }
        jsonObject.put("payMny", payMny);
        return CommonResponse.success("查询成功！",jsonObject);
    }

    /**
     * 查询指定合同
     *  1、在指定范围内产生付款登记的总金额
     *  2、上一年度付款金额
     *  3、合同开工付款登记总金额
     *
     * @return
     */
    @PostMapping(value = "queryContractPayInfo")
    public CommonResponse<List<Map<String, Object>>> queryContractPayInfo(@RequestBody MultiValueMap<String, String> param) {
        return getContractPayInfo(param.get("paramJson").get(0));
    }

    /**
     * 查询指定合同
     *  1、在指定范围内产生付款登记的总金额
     *  2、上一年度付款金额
     *  3、合同开工付款登记总金额
     *
     * @return
     */
    @GetMapping(value = "getContractPayInfo")
    public CommonResponse<List<Map<String, Object>>> getContractPayInfo(@RequestParam String paramJson) {
        List<Map<String, Object>> resp = new ArrayList<>();
        if(StringUtils.isNotBlank(paramJson)) {
            JSONObject param = JSONObject.parseObject(paramJson);
            String curStartDate = param.getString("curStartDate");
            String curEndDate = param.getString("curEndDate");
            String curYear = param.getString("curYear");
            String lastYearStartDate = param.getString("lastYearStartDate");
            String lastYearEndDate = param.getString("lastYearEndDate");
            List<Long> contractIds = null != param.get("contractIds") ? param.getJSONArray("contractIds").toJavaList(Long.class) : new ArrayList<>();
            List<JSONObject> contractTypeMap = null != param.get("contractTypeMap") ? param.getJSONArray("contractTypeMap").toJavaList(JSONObject.class) : null;
            if(CollectionUtils.isNotEmpty(contractTypeMap) && CollectionUtils.isEmpty(contractIds)) {
                contractTypeMap.forEach(item -> {
                    contractIds.add(item.getLong("contractId"));
                });
            }
            resp = paymentRegisterService.getContractPayInfo(curStartDate, curEndDate, lastYearStartDate, lastYearEndDate, contractIds, contractTypeMap, null != param.get("groupByFields") ? param.getString("groupByFields") : null, curYear);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 查询指定合同
     * 1、在指定范围内产生收款登记的总金额
     * 2、上一年度收款金额
     * 3、合同开工收款登记总金额
     *
     * @param param
     * @return
     */
    @PostMapping(value = "queryContractRecInfo")
    CommonResponse<List<Map<String, Object>>> queryContractRecInfo(@RequestBody JSONObject param) {
        List<Map<String, Object>> resp = receiptRegisterService.queryContractRecInfo(param.getString("curStartDate"),
                param.getString("curEndDate"), param.getString("lastYearStartDate"),
                param.getString("lastYearEndDate"),
                param.getJSONArray("contractIds").toJavaList(Long.class),
                null != param.get("groupByFields") ? param.getString("groupByFields") : null,
                param.getString("curYear"));
        return CommonResponse.success(resp);
    }
}
