package com.ejianc.business.profinance.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.odd.bean.OddAllocationDetailEntity;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.mapper.OddFeeMapper;
import com.ejianc.business.profinance.odd.service.IOddAllocationDetailService;
import com.ejianc.business.profinance.odd.vo.ImportOddAllocationVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationDetailVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.odd.mapper.OddAllocationMapper;
import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_EVEN;

/**
 * 零星费用分配主表
 * 
 * @author generator
 * 
 */
@Service("oddAllocationService")
public class OddAllocationServiceImpl extends BaseServiceImpl<OddAllocationMapper, OddAllocationEntity> implements IOddAllocationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OddAllocationMapper oddAllocationMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private OddFeeMapper oddFeeMapper;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private IOddAllocationDetailService oddAllocationDetailService;


    private static final String BILL_CODE = "ODD_ALLOCATION";//此处需要根据实际修改

    private void saveCost(OddAllocationEntity oddAllocationEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<OddAllocationDetailEntity> oddAllocationDetailList = oddAllocationEntity.getOddAllocationDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(oddAllocationDetailList)) {
            for (OddAllocationDetailEntity oddAllocationDetailEntity : oddAllocationDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(oddAllocationEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.零星费用分配单.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-profinance-frontend/#/oddAllocation/card?id=" + oddAllocationEntity.getId());
                costDetailVO.setSubjectId(oddAllocationDetailEntity.getSubjectId());
                costDetailVO.setSubjectId(oddAllocationDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(oddAllocationDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(oddAllocationDetailEntity.getSubjectName());
//                costDetailVO.setNum(oddAllocationDetailEntity.getNum());
                costDetailVO.setWbsId(oddAllocationDetailEntity.getWbsId());
                costDetailVO.setWbsCode(oddAllocationDetailEntity.getWbsCode());
                costDetailVO.setWbsName(oddAllocationDetailEntity.getWbsName());
                costDetailVO.setSourceId(oddAllocationEntity.getId());
                costDetailVO.setSourceDetailId(oddAllocationDetailEntity.getId());
                costDetailVO.setHappenTaxMny(oddAllocationDetailEntity.getDetailAllocatedTaxMny());
                costDetailVO.setHappenMny(oddAllocationDetailEntity.getDetailAllocatedMny());
                costDetailVO.setHappenDate(oddAllocationEntity.getBillDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ODD_ALLOCATION");
                costDetailVO.setSourceTabType("ODD_ALLOCATION_DETAIL");
                costDetailVO.setProjectId(oddAllocationEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    @Override
    public void deleteCost(Long id) {
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(id);
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<OddAllocationEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OddAllocationEntity::getId, id);
        updateWrapper.set(OddAllocationEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public CommonResponse<OddAllocationVO> pushCost(OddAllocationVO oddAllocationVO) {
        OddAllocationEntity entity = baseMapper.selectById(oddAllocationVO.getId());
        if (CollectionUtils.isNotEmpty(oddAllocationVO.getOddAllocationDetailList())) {
            List<OddAllocationDetailEntity> oddAllocationDetailEntityList = BeanMapper.mapList(oddAllocationVO.getOddAllocationDetailList(), OddAllocationDetailEntity.class);
            entity.setOddAllocationDetailList(oddAllocationDetailEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, OddAllocationVO.class));
    }

    @Override
    public void costPush(OddAllocationEntity oddAllocationEntity) {
        logger.info("开始costPush");
        List<OddAllocationDetailEntity> oddAllocationDetailList = oddAllocationEntity.getOddAllocationDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(oddAllocationDetailList)) {
            for (OddAllocationDetailEntity oddAllocationDetailEntity : oddAllocationDetailList) {
                if (null == oddAllocationDetailEntity.getSubjectId() || null == oddAllocationDetailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(oddAllocationDetailList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = oddAllocationEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(oddAllocationEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",oddAllocationEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(oddAllocationEntity.getId());
                logger.info("结果"+ JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(oddAllocationEntity);
            }
        }
        //更新是否关联
        LambdaUpdateWrapper<OddAllocationEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OddAllocationEntity::getId, oddAllocationEntity.getId());
        updateWrapper.set(OddAllocationEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        oddAllocationEntity.setRelationFlag(newRelationFlag);
    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        List<Integer> typeList = new ArrayList<>();
        for (int i = 1; i < 6; i++) {
            typeList.add(i);
        }
        logger.info("零星费用分配导入校验开始：开始时间----------->{}", new Date());

        //成本科目
        //成本科目 可能 查询时间过长
        CommonResponse<List<SubjectOrgVO>> subjectOrgVOData = shareSubjectOrgApi.shareSubjectOrgApi();
//        logger.info("成本科目查询使用时间{}，内容----------->{}", new Date(), JSONObject.toJSONString(subjectOrgVOData));
        if (!subjectOrgVOData.isSuccess()) {
            return CommonResponse.error("导入失败，查询成本科目内容失败，请重试！");
        }
        //成本科目map
        Map<String, SubjectOrgVO> subjectOrgMap = subjectOrgVOData.getData().stream().collect(Collectors.toMap(SubjectOrgVO::getSubjectCode, Function.identity(), (key1, key2) -> key2));
//        Map<String, SubjectOrgVO> subjectOrgMap = new HashMap<>();

        //项目id集合
        LinkedList<Long> projectIdList = new LinkedList<>();
        //经办人OA账号集合
        List<String> employeeOAAccountList = new ArrayList<>();

        Map<String, ProjectPoolSetVO> projectPoolSetVOMap = new HashMap<>();
        List<String> billCodeList = new ArrayList<>();
        //零星费用单map key：billCode value：OddFeeEntity
        Map<String, OddFeeEntity> oddFeeEntityMap = new HashMap<>();
        //不可使用的零星费用单（有未生效的分配单）
        Map<String, OddFeeEntity> noUseOddFeeEntityMap = new HashMap<>();

        //查询已提交的零星费用单
        List<OddFeeEntity> oddFeeEntityList = oddFeeMapper.queryCommitData();
        if (CollectionUtils.isNotEmpty(oddFeeEntityList)){
            oddFeeEntityMap = oddFeeEntityList.stream().collect(Collectors.toMap(OddFeeEntity::getBillCode, Function.identity(), (key1, key2) -> key2));
        }
        //查询所有的零星分配单
        List<OddAllocationEntity> oddAllocationEntityList = oddAllocationMapper.queryAllData();
        if (CollectionUtils.isNotEmpty(oddAllocationEntityList)){
            billCodeList = oddAllocationEntityList.stream().map(OddAllocationEntity::getBillCode).collect(Collectors.toList());
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportOddAllocationVO> successList = new ArrayList<>();
            List<ImportOddAllocationVO> errorList = new ArrayList<>();
            List<ImportOddAllocationVO> reDataList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportOddAllocationVO importAllocationVO = new ImportOddAllocationVO();

                    //项目名称
                    if (StringUtils.isNotBlank(datas.get(0))) {
                        importAllocationVO.setProjectCode(datas.get(0));
                        if (datas.get(0).length() > 64) {
                            errorMessage.append("[填写项目编码长度为1~64字]");
                        } else {
                            if (projectPoolSetVOMap.get(datas.get(0)) != null) {
                                importAllocationVO.setProjectId(projectPoolSetVOMap.get(datas.get(0)).getId());
                                importAllocationVO.setProjectName(projectPoolSetVOMap.get(datas.get(0)).getName());
                                importAllocationVO.setOrgId(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentId());
                                importAllocationVO.setOrgName(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentName());
                                importAllocationVO.setOrgCode(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentCode());
                                importAllocationVO.setParentOrgName(projectPoolSetVOMap.get(datas.get(0)).getOrgName());
                                importAllocationVO.setParentOrgId(projectPoolSetVOMap.get(datas.get(0)).getOrgId());
                                importAllocationVO.setParentOrgCode(projectPoolSetVOMap.get(datas.get(0)).getOrgCode());
                            } else {
                                CommonResponse<List<ProjectPoolSetVO>> projectData = projectPoolApi.queryProjectListByCodeAndTenantId(datas.get(0), tenantId);
                                if (!projectData.isSuccess()) {
                                    errorMessage.append("[项目池不存在当前项目编码的项目]");
                                } else {
                                    if (CollectionUtils.isNotEmpty(projectData.getData()) && null != projectData.getData().get(0)) {
                                        projectPoolSetVOMap.put(datas.get(0), projectData.getData().get(0));
                                        projectIdList.add(projectPoolSetVOMap.get(datas.get(0)).getId());
                                        importAllocationVO.setProjectId(projectPoolSetVOMap.get(datas.get(0)).getId());
                                        importAllocationVO.setProjectName(projectPoolSetVOMap.get(datas.get(0)).getName());
                                        importAllocationVO.setOrgId(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentId());
                                        importAllocationVO.setOrgCode(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentCode());
                                        importAllocationVO.setOrgName(projectPoolSetVOMap.get(datas.get(0)).getProjectDepartmentName());
                                        importAllocationVO.setParentOrgId(projectPoolSetVOMap.get(datas.get(0)).getOrgId());
                                        importAllocationVO.setParentOrgName(projectPoolSetVOMap.get(datas.get(0)).getOrgName());
                                        importAllocationVO.setParentOrgCode(projectPoolSetVOMap.get(datas.get(0)).getOrgCode());
                                    } else {
                                        errorMessage.append("[项目池不存在当前项目编码的项目]");
                                    }
                                }
                            }
                        }
                    } else {
                        errorMessage.append("[项目编码为必填项]");
                    }


                    //* 零星费用单据编号-oddFeeCode
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        importAllocationVO.setOddFeeCode(datas.get(2));
                        if (datas.get(2).length() > 64) {
                            errorMessage.append("[填写零星费用单据编号长度为1~64字]");
                        } else {
                            if (!oddFeeEntityMap.containsKey(datas.get(2))) {
                                errorMessage.append("[当前零星费用单"+ datas.get(2) +"未提交，请更换]");
                            }else {
                                OddFeeEntity oddFeeEntity = oddFeeEntityMap.get(datas.get(2));
                                LambdaQueryWrapper<OddAllocationEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                                lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, oddFeeEntity.getId());
                                lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                                List<OddAllocationEntity> list = super.list(lambdaQueryWrapper);
                                //不可使用的零星费用单有当前零星费用单据编号 或 零星费用单下有未生效的分配单 则添加错误信息
                                if(noUseOddFeeEntityMap.containsKey(oddFeeEntity.getBillCode()) || CollectionUtils.isNotEmpty(list)){
                                    noUseOddFeeEntityMap.put(oddFeeEntity.getBillCode(), oddFeeEntity);
                                    errorMessage.append("[当前零星费用单"+ datas.get(2) +"下有未生效的零星费用分配，请更换]");
                                }else {
                                    importAllocationVO.setOddFeeCode(oddFeeEntity.getBillCode());
                                    importAllocationVO.setOddFeeId(oddFeeEntity.getId());
                                    importAllocationVO.setNoContractFeeTypeId(oddFeeEntity.getNoContractFeeTypeId());
                                    importAllocationVO.setNoContractFeeTypeCode(oddFeeEntity.getNoContractFeeTypeCode());
                                    importAllocationVO.setNoContractFeeTypeName(oddFeeEntity.getNoContractFeeTypeName());
                                    importAllocationVO.setHappenDate(oddFeeEntity.getHappenDate());
                                    importAllocationVO.setBusinessExplain(oddFeeEntity.getBusinessExplain());
                                    importAllocationVO.setTaxRate(oddFeeEntity.getTaxRate());
                                    importAllocationVO.setFeeTaxMny(oddFeeEntity.getFeeTaxMny());
                                    importAllocationVO.setFeeMny(oddFeeEntity.getFeeMny());
                                    importAllocationVO.setTax(oddFeeEntity.getTax());
                                    importAllocationVO.setHaveAllocatedMny(oddFeeEntity.getHaveAllocatedMny() == null ? BigDecimal.ZERO : oddFeeEntity.getHaveAllocatedMny());
                                    importAllocationVO.setHaveAllocatedTaxMny(oddFeeEntity.getHaveAllocatedTaxMny() == null ? BigDecimal.ZERO : oddFeeEntity.getHaveAllocatedTaxMny());
                                    importAllocationVO.setSurplusAllocatedMny(oddFeeEntity.getSurplusAllocatedMny());
                                    importAllocationVO.setSurplusAllocatedTaxMny(oddFeeEntity.getSurplusAllocatedTaxMny());
                                }
                            }
                        }
                    } else {
                        errorMessage.append("[零星费用单据编号为必填项]");
                    }

                    //零星分配单据编号-billCode
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        importAllocationVO.setBillCode(datas.get(3));
                        if (datas.get(3).length() > 64) {
                            errorMessage.append("[填写零星分配单据编号长度为1~64字]");
                        } else {
                            if (billCodeList.contains(datas.get(3))) {
                                errorMessage.append("[当前零星分配单据编号"+ datas.get(3) +"已存在，请更换]");
                            }
                        }
                    } else {
                        errorMessage.append("[零星分配单据编号为必填项]");
                    }

                    //无合同费用类型
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        importAllocationVO.setNoContractFeeTypeName(datas.get(4));
                    }

                    //发生日期
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        importAllocationVO.setHappenDateStr(datas.get(5));
                    }

                    //不含税金额--分摊金额(无税)
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importAllocationVO.setDetailAllocatedMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[不含税金额必须为数字]");
                        }
                    } else {
                        errorMessage.append("[不含税金额为必填项]");
                    }

                    //税率不保存
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importAllocationVO.setTaxRate(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            errorMessage.append("[税率必须为数字]");
                        }
                    }


                    //含税金额--分摊金额(含税)
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            importAllocationVO.setDetailAllocatedTaxMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            errorMessage.append("[含税金额必须为数字]");
                        }
                    } else {
                        errorMessage.append("[含税金额为必填项]");
                    }


                    //* 成本科目编码
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        importAllocationVO.setSubjectCode(datas.get(9));
                        if (!subjectOrgMap.containsKey(datas.get(9))) {
                            errorMessage.append("[未查询到当前成本科目编码"+ datas.get(9) +"，请更换]");
                        }else {
                            importAllocationVO.setSubjectId(subjectOrgMap.get(datas.get(9)).getId());
                            importAllocationVO.setSubjectName(subjectOrgMap.get(datas.get(9)).getSubjectName());
                        }
                    } else {
                        errorMessage.append("[成本科目编码为必填项]");
                    }


                    //成本科目
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        importAllocationVO.setSubjectName(datas.get(10));
                    }


                    //经办人OA账号
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        importAllocationVO.setEmployOAAccount(datas.get(11));
                        employeeOAAccountList.add(datas.get(11));
                    } else {
                        errorMessage.append("[经办人OA账号为必填项]");
                    }

                    //经办人
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        importAllocationVO.setEmployeeName(datas.get(12));
                    }
                    //经办部门
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        importAllocationVO.setDepartmentName(datas.get(13));
                    }

                    //单据日期-billDate
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        importAllocationVO.setBillDateStr(datas.get(14));
                        try {
                            importAllocationVO.setBillDate(DateUtils.parseDate(datas.get(14), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[单据日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //制单日期-createDate
                    if (StringUtils.isNotBlank(datas.get(15))) {
                        importAllocationVO.setCreateDateStr(datas.get(15));
                    }


                    if (StringUtils.isNotBlank(errorMessage)){
                        importAllocationVO.setErrorMessage(String.valueOf(errorMessage));
                    }
                    importAllocationVO.setId(IdWorker.getId());
                    reDataList.add(importAllocationVO);
                }

                //项目id集获取核算对象信息
                logger.info("项目id集：{}", JSONObject.toJSONString(projectIdList));
                CommonResponse<Map<Long, ProjectWbsVO>> projectWbsData = shareProjectWbsApi.queryByProjectIds(projectIdList);
                if (!projectWbsData.isSuccess() || null == projectWbsData.getData()) {
                    reDataList.forEach(item -> {
                        if (item.getErrorMessage() != null && !item.getErrorMessage().contains("项目池不存在当前项目编码的项目")){
                            item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[当前项目未获取到核算对象信息]" : "[当前项目未获取到核算对象信息]");
                        }
                    });
                } else {
                    Map<Long, ProjectWbsVO> projectWbsMap = projectWbsData.getData();
                    for (ImportOddAllocationVO importAllocationVO : reDataList) {
                        if (projectWbsMap.containsKey(importAllocationVO.getProjectId())){
                            importAllocationVO.setWbsId(projectWbsMap.get(importAllocationVO.getProjectId()).getId());
                            importAllocationVO.setWbsCode(projectWbsMap.get(importAllocationVO.getProjectId()).getCode());
                            importAllocationVO.setWbsName(projectWbsMap.get(importAllocationVO.getProjectId()).getName());
                        }else {
                            if (importAllocationVO.getErrorMessage() != null && !importAllocationVO.getErrorMessage().contains("项目池不存在当前项目编码的项目")){
                                importAllocationVO.setErrorMessage(importAllocationVO.getErrorMessage() != null ? importAllocationVO.getErrorMessage() + "[当前项目未获取到核算对象信息]" : "[当前项目未获取到核算对象信息]");
                            }
                        }
                    }
                }

                //设置经办人
                CommonResponse<List<EmployeeVO>> employeeData = iEmployeeApi.getByCodeOrIdcard(employeeOAAccountList);
                if (!employeeData.isSuccess() || CollectionUtils.isEmpty(employeeData.getData())) {
                    reDataList.forEach(item -> {
                        item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[内部员工档案数据不存在该经办人信息]" : "[内部员工档案数据不存在该经办人信息]");
                    });
                } else {
                    List<EmployeeVO> employeeVOList = employeeData.getData();
                    Map<String, EmployeeVO> oAAccountMap = employeeVOList.stream().filter(item -> item.getCode() != null).collect(Collectors.toMap(EmployeeVO::getCode, Function.identity(), (key1, key2) -> key2));
                    for (ImportOddAllocationVO importAllocationVO : reDataList) {
                        //设置经办人
                        if (oAAccountMap.containsKey(importAllocationVO.getEmployOAAccount())){
                            importAllocationVO.setEmployeeId(oAAccountMap.get(importAllocationVO.getEmployOAAccount()).getUserId());
                            importAllocationVO.setEmployeeName(oAAccountMap.get(importAllocationVO.getEmployOAAccount()).getName());
                            importAllocationVO.setDepartmentId(oAAccountMap.get(importAllocationVO.getEmployOAAccount()).getDeptId());
                            importAllocationVO.setDepartmentName(oAAccountMap.get(importAllocationVO.getEmployOAAccount()).getDeptName());
                            importAllocationVO.setEmployeeDate(new Date());
                        }else {
                            importAllocationVO.setErrorMessage(importAllocationVO.getErrorMessage() != null ? importAllocationVO.getErrorMessage() + "[内部员工档案数据不存在该经办人信息]" : "[内部员工档案数据不存在该经办人信息]");
                        }
                    }
                }

                for (ImportOddAllocationVO importAllocationVO : reDataList) {
                    if (StringUtils.isBlank(importAllocationVO.getErrorMessage())) {
                        successList.add(importAllocationVO);
                    } else {
                        errorList.add(importAllocationVO);
                    }
                }
            }
            logger.info("导入结束时间----------->{}", new Date());
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ImportOddAllocationVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        //将导入数据进行组装
        //key：billCode
        Map<String, OddAllocationVO> oddAllocationVOMap = new LinkedHashMap<>();
        
        if (CollectionUtils.isNotEmpty(importVOS)){
            for (ImportOddAllocationVO importVO : importVOS) {
                if (oddAllocationVOMap.containsKey(importVO.getBillCode())){
                    //子表添加一条信息
                    OddAllocationDetailVO oddAllocationDetailVO = new OddAllocationDetailVO();
                    oddAllocationDetailVO.setId(IdWorker.getId());
                    oddAllocationDetailVO.setPid(oddAllocationVOMap.get(importVO.getBillCode()).getId());
                    oddAllocationDetailVO.setWbsId(importVO.getWbsId());
                    oddAllocationDetailVO.setWbsCode(importVO.getWbsCode());
                    oddAllocationDetailVO.setWbsName(importVO.getWbsName());
                    oddAllocationDetailVO.setSubjectId(importVO.getSubjectId());
                    oddAllocationDetailVO.setSubjectCode(importVO.getSubjectCode());
                    oddAllocationDetailVO.setSubjectName(importVO.getSubjectName());
                    oddAllocationDetailVO.setDetailAllocatedMny(importVO.getDetailAllocatedMny());
                    oddAllocationDetailVO.setDetailAllocatedTaxMny(importVO.getDetailAllocatedTaxMny());
                    //设置分摊比例
                    if (null != oddAllocationDetailVO.getDetailAllocatedMny() && null != oddAllocationDetailVO.getDetailAllocatedTaxMny()){
                        oddAllocationDetailVO.setDetailAllocatedRatio(oddAllocationDetailVO.getDetailAllocatedTaxMny().divide(oddAllocationVOMap.get(importVO.getBillCode()).getFeeTaxMny(), 8, ROUND_HALF_EVEN).multiply(new BigDecimal(100)));
                    }
                    oddAllocationVOMap.get(importVO.getBillCode()).getOddAllocationDetailList().add(oddAllocationDetailVO);
                }else {
                    //主表添加一条信息
                    OddAllocationVO oddAllocationVO = BeanMapper.map(importVO, OddAllocationVO.class);
                    oddAllocationVO.setId(IdWorker.getId());
                    oddAllocationVO.setRelationFlag("0");//关联状态初始化
                    oddAllocationVO.setProportionFlag("0");//分摊状态初始化

                    //子表添加一条信息
                    OddAllocationDetailVO oddAllocationDetailVO = new OddAllocationDetailVO();
                    oddAllocationDetailVO.setId(IdWorker.getId());
                    oddAllocationDetailVO.setPid(oddAllocationVO.getId());
                    oddAllocationDetailVO.setWbsId(importVO.getWbsId());
                    oddAllocationDetailVO.setWbsCode(importVO.getWbsCode());
                    oddAllocationDetailVO.setWbsName(importVO.getWbsName());
                    oddAllocationDetailVO.setSubjectId(importVO.getSubjectId());
                    oddAllocationDetailVO.setSubjectCode(importVO.getSubjectCode());
                    oddAllocationDetailVO.setSubjectName(importVO.getSubjectName());
                    oddAllocationDetailVO.setDetailAllocatedMny(importVO.getDetailAllocatedMny());
                    oddAllocationDetailVO.setDetailAllocatedTaxMny(importVO.getDetailAllocatedTaxMny());
                    //设置分摊比例
                    if (null != oddAllocationDetailVO.getDetailAllocatedMny() && null != oddAllocationDetailVO.getDetailAllocatedTaxMny()){
                        oddAllocationDetailVO.setDetailAllocatedRatio(oddAllocationDetailVO.getDetailAllocatedTaxMny().divide(oddAllocationVO.getFeeTaxMny(), 8, ROUND_HALF_EVEN).multiply(new BigDecimal(100)));
                    }
                    oddAllocationVO.getOddAllocationDetailList().add(oddAllocationDetailVO);
                    
                    oddAllocationVOMap.put(oddAllocationVO.getBillCode(), oddAllocationVO);
                }
            }
        }
        List<OddAllocationEntity> entityList = new ArrayList<>();
        List<OddAllocationDetailEntity> detailEntityList = new ArrayList<>();
        if (null != oddAllocationVOMap){
            for (Map.Entry<String, OddAllocationVO> oddAllocationVOEntry : oddAllocationVOMap.entrySet()) {
                OddAllocationVO oddAllocationVO = oddAllocationVOEntry.getValue();
                //计算本次子表分摊金额之和
                BigDecimal allocatedMny = oddAllocationVO.getOddAllocationDetailList().stream().map(OddAllocationDetailVO::getDetailAllocatedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allocatedTaxMny = oddAllocationVO.getOddAllocationDetailList().stream().map(OddAllocationDetailVO::getDetailAllocatedTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                //设置本次分摊金额
                oddAllocationVO.setAllocatedMny(allocatedMny);
                oddAllocationVO.setAllocatedTaxMny(allocatedTaxMny);
                oddAllocationVO.setAllocatedRatio(oddAllocationVO.getAllocatedMny().divide(oddAllocationVO.getFeeMny(),  8, ROUND_HALF_EVEN).multiply(new BigDecimal(100)));
                //设置累计分摊金额（含本次）
                oddAllocationVO.setTotalAllocatedMny(allocatedMny.add(oddAllocationVO.getHaveAllocatedMny()));
                oddAllocationVO.setTotalAllocatedTaxMny(allocatedTaxMny.add(oddAllocationVO.getHaveAllocatedTaxMny()));
                oddAllocationVO.setTotalAllocatedRatio(oddAllocationVO.getTotalAllocatedMny().divide(oddAllocationVO.getFeeMny(),  8, ROUND_HALF_EVEN).multiply(new BigDecimal(100)));

                entityList.add(BeanMapper.map(oddAllocationVOEntry.getValue(), OddAllocationEntity.class));
                detailEntityList.addAll(BeanMapper.mapList(oddAllocationVO.getOddAllocationDetailList(), OddAllocationDetailEntity.class));
            }
        }

        for (OddAllocationEntity entity : entityList) {
            entity.setSourceType(1);
            if (null == entity.getBillCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, OddAllocationVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    logger.error("保存零星费用失败，自动生成零星费用编码失败: {}", billCode.getMsg());
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                entity.setBillCode(billCode.getData());
            }
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        oddAllocationDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        return "保存成功";
    }


}
