package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目资金计划-临时机械租赁
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan_temporary")
public class PlanTemporaryEntity extends BaseEntity {
	private static final long serialVersionUID = -7370106261494715713L;

	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "temporary_settle_type")
	private String temporarySettleType; // 结算单类型
	@TableField(value = "temporary_settle_type_name")
	private String temporarySettleTypeName; // 结算单类型名称
	@TableField(value = "temporary_settle_id")
	private Long temporarySettleId; // 结算单Id
	@TableField(value = "temporary_settle_code")
	private String temporarySettleCode; // 结算单编码
	@TableField(value = "temporary_settle_date")
	private Date temporarySettleDate; // 结算日期
	@TableField(value = "temporary_settle_route_url")
	private String temporarySettleRouteUrl; // 临时机械租赁路由地址
	@TableField(value = "temporary_pay_type_no_contract_id")
	private Long temporaryPayTypeNoContractId; // 无合同费用类型id
	@TableField(value = "temporary_pay_type_no_contract_code")
	private String temporaryPayTypeNoContractCode; // 无合同费用类型编码
	@TableField(value = "temporary_pay_type_no_contract_name")
	private String temporaryPayTypeNoContractName; // 无合同费用类型名称
	@TableField(value = "temporary_partyb_id")
	private Long temporaryPartybId; // 结算乙方Id
	@TableField(value = "temporary_partyb_name")
	private String temporaryPartybName; // 收款单位 =结算乙方名称
	@TableField(value = "temporary_settle_mny")
	private BigDecimal temporarySettleMny; // 结算金额
	@TableField(value = "temporary_payment_content")
	private String temporaryPaymentContent; // 付款内容
	@TableField(value = "temporary_settle_mode_id")
	private Long temporarySettleModeId; // 结算方式id =自定义档案【大企业收付款登记-结算方式】
	@TableField(value = "temporary_settle_mode_code")
	private String temporarySettleModeCode; // 结算方式编码
	@TableField(value = "temporary_settle_mode_name")
	private String temporarySettleModeName; // 结算方式名称
	@TableField(value = "temporary_applied_mny")
	private BigDecimal temporaryAppliedMny; // 已申请金额(不含本次)
	@TableField(value = "temporary_can_apply_mny")
	private BigDecimal temporaryCanApplyMny; // 本次可申请金额
	@TableField(value = "temporary_plan_payment_mny")
	private BigDecimal temporaryPlanPaymentMny; // 本次计划付款金额
	@TableField(value = "temporary_total_apply_payment_mny")
	private BigDecimal temporaryTotalApplyPaymentMny; // 累计申请付款金额(含本次)
	@TableField(value = "temporary_paid_scale")
	private BigDecimal temporaryPaidScale; // 已付款比例%（含本次）
	@TableField(value = "temporary_memo")
	private String temporaryMemo; // 备注
	@TableField(value = "total_actual_payment_mny")
	private BigDecimal totalActualPaymentMny; // 本次累计实付金额
	@TableField(value = "unpaid_mny")
	private BigDecimal unpaidMny; // 本次未支付金额
	@TableField(value = "release_apply_mny")
	private BigDecimal releaseApplyMny; // 本次释放申请金额
	@TableField(value = "close_state")
	private String closeState; // 关闭状态 已关闭 未关闭
	@TableField(value = "close_date_time")
	private Date closeDateTime; // 关闭时间
	@TableField(value = "close_user_id")
	private Long closeUserId; // 关闭人
	@TableField(value = "close_user_name")
	private String closeUserName; // 关闭人名称
	@TableField(value = "close_user_code")
	private String closeUserCode; // 关闭人编码
	@TableField(value = "plan_id")
	private Long planId; // 项目资金计划id


	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public String getTemporarySettleType() {
		return temporarySettleType;
	}

	public void setTemporarySettleType(String temporarySettleType) {
		this.temporarySettleType = temporarySettleType;
	}

	public String getTemporarySettleTypeName() {
		return temporarySettleTypeName;
	}

	public void setTemporarySettleTypeName(String temporarySettleTypeName) {
		this.temporarySettleTypeName = temporarySettleTypeName;
	}

	public Long getTemporarySettleId() {
		return temporarySettleId;
	}

	public void setTemporarySettleId(Long temporarySettleId) {
		this.temporarySettleId = temporarySettleId;
	}

	public String getTemporarySettleCode() {
		return temporarySettleCode;
	}

	public void setTemporarySettleCode(String temporarySettleCode) {
		this.temporarySettleCode = temporarySettleCode;
	}

	public Date getTemporarySettleDate() {
		return temporarySettleDate;
	}

	public void setTemporarySettleDate(Date temporarySettleDate) {
		this.temporarySettleDate = temporarySettleDate;
	}

	public String getTemporarySettleRouteUrl() {
		return temporarySettleRouteUrl;
	}

	public void setTemporarySettleRouteUrl(String temporarySettleRouteUrl) {
		this.temporarySettleRouteUrl = temporarySettleRouteUrl;
	}

	public Long getTemporaryPayTypeNoContractId() {
		return temporaryPayTypeNoContractId;
	}

	public void setTemporaryPayTypeNoContractId(Long temporaryPayTypeNoContractId) {
		this.temporaryPayTypeNoContractId = temporaryPayTypeNoContractId;
	}

	public String getTemporaryPayTypeNoContractCode() {
		return temporaryPayTypeNoContractCode;
	}

	public void setTemporaryPayTypeNoContractCode(String temporaryPayTypeNoContractCode) {
		this.temporaryPayTypeNoContractCode = temporaryPayTypeNoContractCode;
	}

	public String getTemporaryPayTypeNoContractName() {
		return temporaryPayTypeNoContractName;
	}

	public void setTemporaryPayTypeNoContractName(String temporaryPayTypeNoContractName) {
		this.temporaryPayTypeNoContractName = temporaryPayTypeNoContractName;
	}

	public Long getTemporaryPartybId() {
		return temporaryPartybId;
	}

	public void setTemporaryPartybId(Long temporaryPartybId) {
		this.temporaryPartybId = temporaryPartybId;
	}

	public String getTemporaryPartybName() {
		return temporaryPartybName;
	}

	public void setTemporaryPartybName(String temporaryPartybName) {
		this.temporaryPartybName = temporaryPartybName;
	}

	public BigDecimal getTemporarySettleMny() {
		return temporarySettleMny;
	}

	public void setTemporarySettleMny(BigDecimal temporarySettleMny) {
		this.temporarySettleMny = temporarySettleMny;
	}

	public String getTemporaryPaymentContent() {
		return temporaryPaymentContent;
	}

	public void setTemporaryPaymentContent(String temporaryPaymentContent) {
		this.temporaryPaymentContent = temporaryPaymentContent;
	}

	public Long getTemporarySettleModeId() {
		return temporarySettleModeId;
	}

	public void setTemporarySettleModeId(Long temporarySettleModeId) {
		this.temporarySettleModeId = temporarySettleModeId;
	}

	public String getTemporarySettleModeCode() {
		return temporarySettleModeCode;
	}

	public void setTemporarySettleModeCode(String temporarySettleModeCode) {
		this.temporarySettleModeCode = temporarySettleModeCode;
	}

	public String getTemporarySettleModeName() {
		return temporarySettleModeName;
	}

	public void setTemporarySettleModeName(String temporarySettleModeName) {
		this.temporarySettleModeName = temporarySettleModeName;
	}

	public BigDecimal getTemporaryAppliedMny() {
		return temporaryAppliedMny;
	}

	public void setTemporaryAppliedMny(BigDecimal temporaryAppliedMny) {
		this.temporaryAppliedMny = temporaryAppliedMny;
	}

	public BigDecimal getTemporaryCanApplyMny() {
		return temporaryCanApplyMny;
	}

	public void setTemporaryCanApplyMny(BigDecimal temporaryCanApplyMny) {
		this.temporaryCanApplyMny = temporaryCanApplyMny;
	}

	public BigDecimal getTemporaryPlanPaymentMny() {
		return temporaryPlanPaymentMny;
	}

	public void setTemporaryPlanPaymentMny(BigDecimal temporaryPlanPaymentMny) {
		this.temporaryPlanPaymentMny = temporaryPlanPaymentMny;
	}

	public BigDecimal getTemporaryTotalApplyPaymentMny() {
		return temporaryTotalApplyPaymentMny;
	}

	public void setTemporaryTotalApplyPaymentMny(BigDecimal temporaryTotalApplyPaymentMny) {
		this.temporaryTotalApplyPaymentMny = temporaryTotalApplyPaymentMny;
	}

	public BigDecimal getTemporaryPaidScale() {
		return temporaryPaidScale;
	}

	public void setTemporaryPaidScale(BigDecimal temporaryPaidScale) {
		this.temporaryPaidScale = temporaryPaidScale;
	}

	public String getTemporaryMemo() {
		return temporaryMemo;
	}

	public void setTemporaryMemo(String temporaryMemo) {
		this.temporaryMemo = temporaryMemo;
	}

	public BigDecimal getTotalActualPaymentMny() {
		return totalActualPaymentMny;
	}

	public void setTotalActualPaymentMny(BigDecimal totalActualPaymentMny) {
		this.totalActualPaymentMny = totalActualPaymentMny;
	}

	public BigDecimal getUnpaidMny() {
		return unpaidMny;
	}

	public void setUnpaidMny(BigDecimal unpaidMny) {
		this.unpaidMny = unpaidMny;
	}

	public BigDecimal getReleaseApplyMny() {
		return releaseApplyMny;
	}

	public void setReleaseApplyMny(BigDecimal releaseApplyMny) {
		this.releaseApplyMny = releaseApplyMny;
	}

	public String getCloseState() {
		return closeState;
	}

	public void setCloseState(String closeState) {
		this.closeState = closeState;
	}

	public Date getCloseDateTime() {
		return closeDateTime;
	}

	public void setCloseDateTime(Date closeDateTime) {
		this.closeDateTime = closeDateTime;
	}

	public Long getCloseUserId() {
		return closeUserId;
	}

	public void setCloseUserId(Long closeUserId) {
		this.closeUserId = closeUserId;
	}

	public String getCloseUserName() {
		return closeUserName;
	}

	public void setCloseUserName(String closeUserName) {
		this.closeUserName = closeUserName;
	}

	public String getCloseUserCode() {
		return closeUserCode;
	}

	public void setCloseUserCode(String closeUserCode) {
		this.closeUserCode = closeUserCode;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

}
