package com.ejianc.business.profinance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;

import java.util.Date;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款申请主实体
 * 
 * @author generator
 * 
 */
public interface IPaymentApplyService extends IBaseService<PaymentApplyEntity> {

    boolean saveOrUpdatePaymentApply(PaymentApplyEntity entity, boolean syncEs);

    CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate);
    /**
     * 批量修改
     * @param sourceIdS
     * @return
     */
    CommonResponse updateSettlePool(List<Long> sourceIdS);
    /**
     * 查询当前合同是否存在未生效的的付款申请
     * @param vo
     * @return
     */
    CommonResponse<PaymentApplyVO> checkPayApply(PaymentApplyVO vo);

    /**
     * 根据合同和项目 查询 类型是预付 的已申请金额的汇总
     * 如何该合同是劳务分包合同  待扣回预付款”=该合同累计预付款金额+该合同的累计工人工资支付金额
     * @param vo
     * @return 预付已申请金额
     */
    BigDecimal queryAdvanceApplyMny(PaymentApplyVO vo);


    /**
     * 根据合同和项目 查询 类型是正常付款 的累计实付金额的汇总
     * @param vo
     * @return  累计实付金额
     */
    BigDecimal queryTotalPayMny(PaymentApplyVO vo);

    /**
     * 根据项目+合同获取已申请金额（付款类型是正常付款）
     * @param vo
     * @return 截至上期已申请金额
     */
    BigDecimal queryLastApplyMny(PaymentApplyVO vo);

    /**
     * 根据项目+合同获取已申请金额（付款类型是正常付款）
     * @param vo
     * @return 返回待口回预付款
     */
    BigDecimal queryPendDeduct(PaymentApplyVO vo);


    /**
     * 累计诉讼结算金额
     * @param vo
     * @return
     */
    BigDecimal queryTotalLitigationMny(PaymentApplyVO vo);

    /**
     * 诉讼已申请金额
     * @param vo
     * @return
     */
    BigDecimal queryLastLitigationMny(PaymentApplyVO vo);

    /**
     * 查询当前结算单的 已申请金额
     * @param sourceId
     * @return 返回已申请金额
     */
    BigDecimal queryAlreadyApplyMny(String sourceId);

    Map<String, Object> countSumMny(QueryParam param);


    /**
     * 查询当前合同下已生效的诉讼结算单 中的 诉讼工程款的合计
     * @param vo
     * @return
     */
    BigDecimal queryTotalLawsuitMny(PaymentApplyVO vo);

    /**
     * 通过合同id查询对应的付款申请单
     * @param contractId
     * @return
     */
    List<PaymentApplyVO> queryListByContractId(Long contractId);

    /**
     * 通过合同id查询对应的付款申请单 包含付款信息
     * @param contractId
     * @return
     */
    CommonResponse<ContractPaymentResultVO> queryJsonByContractId(Long contractId);

    /**
     * 查询合同履约金额
     * @param vo
     * @return
     */
    BigDecimal queryContractHonourMny(PaymentApplyVO vo);

    /**
     *  关闭接口
     * @param entity
     * @param type
     * @return
     */
    CommonResponse<PaymentApplyVO> updateCloseState(PaymentApplyEntity entity,String type);

    /**
     *  对接中间表
     * @param entity 当付款实体
     * @param type 关闭 还是弃审
     * @return
     */
    String abandonOrClose(PaymentApplyEntity entity,String type);

    Map<Long,BigDecimal> querySumMny(Map<String,List<Long>> map);

    /**
     * 结算单批量删除
     *
     * @param vos
     */
    void batchDel(List<PaymentApplyVO> vos);

    PaymentApplyVO savePaymentApply(PaymentApplyVO saveOrUpdateVO);

    /**
     * 按照项目+供应商维度查看，零星材料+临时机械的累计履约、结算、实付（含本期）
     *
     * @param projectId
     * @return
     */
    JSONObject queryDataModelInfo(Long projectId);

    List<JSONObject> queryDataModelMaterial(Long projectId);
    List<JSONObject> queryDataModelEquip(Long projectId);

    /**
     * 设置合同累计批复金额、累计实付金额
     * @param paymentApplyVO
     */
    void setTotalContractRelateMny(PaymentApplyVO paymentApplyVO);


    String  sendPayToNC(PaymentApplyEntity sourceEntity);
}
