package com.ejianc.business.profinance.utils;

import javax.sql.DataSource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

public class DBUtil2 {
	
	private DataSource dataSource;
	
	public DBUtil2(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public Connection getConnection() throws Exception {
		try {
			return dataSource.getConnection();
		} catch (Exception e) {
			throw new Exception("数据库连接出错 ");
		}
	}

	public Connection getConnectionForQuartzJob() throws Exception {
		try {
			return dataSource.getConnection();
		} catch (Exception e) {
			throw new Exception("数据库连接出错 ");
		}
	}

	

	public int setupdateData(String sql) throws Exception {
		Connection conn = getConnection();
		PreparedStatement preStatement = null;
		try {
			preStatement = conn.prepareStatement(sql);
			return preStatement.executeUpdate();
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		} finally {
			try {
				preStatement.close();
				conn.close();
			} catch (SQLException e) {
				throw new Exception(e.getMessage());
			}
		}
	}

	public Map<String, Object> executeSqlForProcedure(String sql) throws Exception {
		Connection conn = getConnection();
		CallableStatement cs = null;
		Map<String, Object> map = new HashMap<>();
		try {
			cs = conn.prepareCall("{" + sql + "}");
			cs.executeQuery();

			return map;
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		} finally {
			try {
				cs.close();
				conn.close();
			} catch (SQLException e) {
				throw new Exception(e.getMessage());
			}
		}
	}

	public int updateExecuteBatch(List<String> sqlList) throws Exception {
		Connection conn = getConnectionForQuartzJob();
		Statement stmt = null;
		try {
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			String sql = "";
			for (int i = 0; i < sqlList.size(); i++) {
				sql = (String) sqlList.get(i);
				if (sql.endsWith(";")) {
					sql = sql.substring(0, sql.length() - 1);
				}
				stmt.addBatch(sql);
				if ((i > 1) && ((i + 1) % 1000 == 0)) {
					stmt.executeBatch();
					conn.commit();
					stmt.clearBatch();
				}
			}
			stmt.executeBatch();
			conn.commit();
			return sqlList.size();
		} catch (Exception e) {
			conn.rollback();
			throw new Exception(e.getMessage());
		} finally {
			try {
				stmt.close();
				conn.close();
			} catch (SQLException e) {
				throw new Exception(e.getMessage());
			}
		}
	}

	public int updateExecuteBatchForCK(List<Map<String, Object>> dataList, String databaseName, String tableName)
			throws Exception {
		Connection conn = getConnectionForQuartzJob();
		PreparedStatement stmt = null;
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String colums = " ";
			String values = " ";
			String insertSQL = " insert into " + tableName;

			Map<String, Object> mapTemp = dataList.get(0);
			for (Map.Entry<String, Object> entry : mapTemp.entrySet()) {
				colums = colums + (String) entry.getKey() + ",";
				values = values + " ?,";
			}
			colums = colums.substring(0, colums.length() - 1);
			values = values.substring(0, values.length() - 1);
			insertSQL = insertSQL + " ( " + colums + ") VALUES (" + values + " ) ";

			stmt = conn.prepareStatement(insertSQL);
			for (int i = 0; i < dataList.size(); i++) {
				Map<String, Object> map4 = dataList.get(i);
				int z = 1;
				for (Map.Entry<String, Object> entry : map4.entrySet()) {
					if (entry.getValue() == null) {
						stmt.setString(z, null);
					} else if ((entry.getValue() instanceof Date)) {
						stmt.setString(z, sdf.format(entry.getValue()));
					} else if (((entry.getValue() instanceof Time)) || ((entry.getValue() instanceof Timestamp))) {
						stmt.setString(z, sdf2.format(entry.getValue()));
					} else if ((entry.getValue() instanceof Integer)) {
						stmt.setInt(z, Integer.parseInt(entry.getValue().toString()));
					} else if (((entry.getValue() instanceof Float)) || ((entry.getValue() instanceof Long))
							|| ((entry.getValue() instanceof BigInteger)) || ((entry.getValue() instanceof Double))
							|| ((entry.getValue() instanceof BigDecimal))) {
						stmt.setString(z, entry.getValue()+"");
					} else if ((entry.getValue() instanceof Boolean)) {
						stmt.setString(z, entry.getValue()+"");
					} else if ((entry.getValue() instanceof Byte)) {
						stmt.setString(z, entry.getValue()+"");
					} else if ((entry.getValue() instanceof ArrayList)) {
						stmt.setString(z, entry.getValue().toString());
					} else {
						stmt.setString(z, entry.getValue().toString());
					}
					z++;
				}
				stmt.addBatch();
				if ((i > 1) && ((i + 1) % 1000 == 0)) {
					stmt.executeBatch();
					stmt.clearBatch();
				}
			}
			stmt.executeBatch();
			return 0;
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		} finally {
			try {
				stmt.close();
				conn.close();
			} catch (SQLException e) {
				throw new Exception(e.getMessage());
			}
		}
	}

	public List<Map<String, Object>> queryForListForOracle(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> clob = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();

		int endNum = limitFrom + pageSize;
		String sql2 = "SELECT * FROM (SELECT A.*, ROWNUM RN  FROM (  " + sql + " ) A  WHERE ROWNUM <= " + endNum
				+ "  ) \tWHERE RN >= " + limitFrom;
		if ((sql.toLowerCase().indexOf("show") == 0) || (sql.toLowerCase().indexOf("explain") == 0)) {
			sql2 = sql;
		}
		pstmt = conn.prepareStatement(sql2);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if (("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1)))) {
				times.add(fields[i]);
			}
			if (("oracle.jdbc.OracleClob".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.jdbc.OracleBlob".equals(rsmd.getColumnClassName(i + 1)))) {
				clob.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				if ((clob.contains(fields[i])) && (value != null)) {
					value = "(Blob)";
				}
				if ((binary.contains(fields[i])) && (value != null)) {
					value = new String((byte[]) value);
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取Oracle数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForOracleForExport(String sql, int limitFrom, int pageSize)
			throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> clob = new ArrayList<>();
		List<String> blob = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();

		int endNum = limitFrom + pageSize;
		String sql2 = "SELECT * FROM (SELECT A.*, ROWNUM RN  FROM ( " + sql + " ) A  WHERE ROWNUM <= " + endNum
				+ "  ) \tWHERE RN >= " + limitFrom;

		pstmt = conn.prepareStatement(sql2);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if (("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1)))) {
				times.add(fields[i]);
			}
			if (("oracle.jdbc.OracleClob".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.jdbc.OracleBlob".equals(rsmd.getColumnClassName(i + 1)))) {
				clob.add(fields[i]);
			}
			if ("oracle.sql.BLOB".equals(rsmd.getColumnClassName(i + 1))) {
				blob.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				if (!fields[i].equals("RN")) {
					Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
					if ((times.contains(fields[i])) && (value != null)) {
						value = sdf.format(value);
					}
					try {
						if ((clob.contains(fields[i])) && (value != null)) {
							value = byteToHex((byte[]) value);
						}
						if ((blob.contains(fields[i])) && (value != null)) {
							value = new String("");
						}
						if ((binary.contains(fields[i])) && (value != null)) {
							value = byteToHex((byte[]) value);
						}
					} catch (Exception e) {
						value = new String("");
					}
					row.put(fields[i], value);
				}
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForHive2(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		pstmt = conn.prepareStatement(sql);

		int maxRow = limitFrom + pageSize;
		pstmt.setMaxRows(maxRow);

		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListCommonMethod(String sql) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map<String, Object> resultMap = null;
		List<Map<String, Object>> resultList = new ArrayList<>();
		try {
			conn = getConnection();
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				resultMap = new LinkedHashMap<>();
				ResultSetMetaData metaData = rs.getMetaData();
				int columnCount = metaData.getColumnCount();
				for (int i = 0; i < columnCount; i++) {
					resultMap.put(metaData.getColumnLabel(i + 1), rs.getObject(i + 1));
				}
				resultList.add(resultMap);
			}
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return resultList;
	}

	public List<Map<String, Object>> queryForListForMySql(String sql) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();
		List<String> bigInt = new ArrayList<>();
		List<String> longType = new ArrayList<>();
		List<String> stringType = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
			if ("java.lang.Long".equals(rsmd.getColumnClassName(i + 1))) {
				longType.add(fields[i]);
			}
			if ("java.math.BigInteger".equals(rsmd.getColumnClassName(i + 1))) {
				bigInt.add(fields[i]);
			}
			if ("java.lang.String".equals(rsmd.getColumnClassName(i + 1))) {
				stringType.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = "(BLOB)";
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
					if ((longType.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
					if ((bigInt.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
					if ((stringType.contains(fields[i])) && (value != null)) {
						value = value.toString();
						if (value.toString().length() > 501) {
							value = value.toString().substring(0, 500) + "......";
						}
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForMySqlForExport(String sql, int limitFrom, int pageSize)
			throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();
		sql = "select * from (" + sql + ") tab limit " + limitFrom + "," + pageSize;

		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = byteToHex((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e);
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForDb2(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		sql = " SELECT * FROM ( SELECT B.*, ROWNUMBER() OVER() AS ROWNUMBER FROM (" + sql
				+ ") AS B ) AS A WHERE A.ROWNUMBER BETWEEN " + (limitFrom + 1) + " AND " + (limitFrom + pageSize);
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				if (!fields[i].equals("ROWNUMBER")) {
					Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
					if ((times.contains(fields[i])) && (value != null)) {
						value = sdf.format(value);
					}
					try {
						if ((binary.contains(fields[i])) && (value != null)) {
							value = "(BLOB)";
						}
						if ((object.contains(fields[i])) && (value != null)) {
							value = value.toString();
						}
					} catch (Exception e) {
						value = "(Object)";
					}
					row.put(fields[i], value);
				}
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForDm7(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();
		sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = byteToHex((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e);
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForShenTong(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();
		sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = byteToHex((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e);
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForKingbase(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();
		sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = byteToHex((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e);
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForPostgreSQL(String sql) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if (("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1)))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = new String((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForPostgreSQLForExport(String sql, int limitFrom, int pageSize)
			throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		String sql2 = "select  *  from  (" + sql + ") t  limit " + pageSize + " offset  " + limitFrom;
		pstmt = conn.prepareStatement(sql2);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if (("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)))
					|| ("oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1)))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = new String((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForHana2(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map<String, Object> resultMap = null;
		List<Map<String, Object>> resultList = new ArrayList<>();
		try {
			conn = getConnection();
			String sql2 = sql + "  LIMIT " + pageSize + " OFFSET  " + limitFrom;
			pstmt = conn.prepareStatement(sql2);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				resultMap = new LinkedHashMap<>();
				ResultSetMetaData metaData = rs.getMetaData();
				int columnCount = metaData.getColumnCount();
				for (int i = 0; i < columnCount; i++) {
					resultMap.put(metaData.getColumnLabel(i + 1), rs.getObject(i + 1));
				}
				resultList.add(resultMap);
			}
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return resultList;
	}

	public List<Map<String, Object>> queryForListForCache(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		String sql2 = "select top " + pageSize + " * from (" + sql + ") tab ";
		pstmt = conn.prepareStatement(sql2);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = new String((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListForMSSQL(String sql, int limitFrom, int pageSize) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;
		conn = getConnection();

		pstmt = conn.prepareStatement(sql, 1005, 1008);

		pstmt.setMaxRows(limitFrom + pageSize);

		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		rs.absolute(limitFrom);
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = "0x" + bytesToHexString((byte[]) value);
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = value.toString();
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception("取数据出错，" + e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListPageForMSSQL(String sql, int maxRow, int beginIndex) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<String> binary = new ArrayList<>();
		List<String> object = new ArrayList<>();

		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();

		pstmt = conn.prepareStatement(sql, 1005, 1008);

		pstmt.setMaxRows(maxRow);

		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
			if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
				object.add(fields[i]);
			}
			if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
				binary.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		rs.absolute(beginIndex);
		while (rs.next()) {
			row = new HashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				try {
					if ((binary.contains(fields[i])) && (value != null)) {
						value = "(Object)";
					}
					if ((object.contains(fields[i])) && (value != null)) {
						value = "(Object)";
					}
				} catch (Exception e) {
					value = "(Object)";
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> executeSqlProcedureForMSSQL(String sql, int maxRow, int beginIndex)
			throws Exception {
		Connection conn = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;

		int maxSize = -1;
		String[] fields = (String[]) null;

		List<String> times = new ArrayList<>();
		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();

		CallableStatement callS = conn.prepareCall(sql, 1005, 1008);
		try {
			callS.setMaxRows(maxRow);

			rs = callS.executeQuery();
			rsmd = rs.getMetaData();
			maxSize = rsmd.getColumnCount();
			fields = new String[maxSize];
			for (int i = 0; i < maxSize; i++) {
				fields[i] = rsmd.getColumnLabel(i + 1);
				if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
					times.add(fields[i]);
				}
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

			rs.absolute(beginIndex);
			while (rs.next()) {
				row = new HashMap<>();
				for (int i = 0; i < maxSize; i++) {
					Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
					if ((times.contains(fields[i])) && (value != null)) {
						value = sdf.format(value);
					}
					row.put(fields[i], value);
				}
				rows.add(row);
			}
			rs.close();
		} catch (Exception e) {
			throw new Exception("存储过程执行出错，" + e.getMessage());
		}
		try {
			callS.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> executeSqlProcedureForColumnsForMSSQL(String sql) throws Exception {
		Connection conn = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;

		int maxSize = -1;
		String[] fields = (String[]) null;

		List<Map<String, Object>> columnRows = new ArrayList<>();

		conn = getConnection();

		CallableStatement callS = conn.prepareCall(sql, 1005, 1008);

		callS.setMaxRows(1);

		rs = callS.executeQuery();

		rsmd = rs.getMetaData();
		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			Map<String, Object> map = new HashMap<>();
			map.put("column_name", fields[i]);
			columnRows.add(map);
		}
		try {
			rs.close();
			callS.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return columnRows;
	}

	public int executeQueryForCountProcedureForMSSQL(String sql) throws Exception {
		Connection conn = null;
		ResultSet rs = null;
		conn = getConnection();

		CallableStatement callS = conn.prepareCall(sql);

		rs = callS.executeQuery();
		int countNum = 0;
		while (rs.next()) {
			countNum++;
		}
		try {
			rs.close();
			callS.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return countNum;
	}

	public List<Map<String, Object>> queryForListPageForHive2(String sql, int maxRow, int beginIndex) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		String[] fields = (String[]) null;
		List<String> times = new ArrayList<>();
		List<Map<String, Object>> rows = new ArrayList<>();
		Map<String, Object> row = null;

		conn = getConnection();
		pstmt = conn.prepareStatement(sql);

		pstmt.setMaxRows(maxRow);

		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();

		maxSize = rsmd.getColumnCount();
		fields = new String[maxSize];
		for (int i = 0; i < maxSize; i++) {
			fields[i] = rsmd.getColumnLabel(i + 1);
			if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
				times.add(fields[i]);
			}
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		while (rs.next()) {
			row = new LinkedHashMap<>();
			for (int i = 0; i < maxSize; i++) {
				Object value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
				if ((times.contains(fields[i])) && (value != null)) {
					value = sdf.format(value);
				}
				row.put(fields[i], value);
			}
			rows.add(row);
		}
		try {
			rs.close();
			pstmt.close();
			conn.close();
		} catch (SQLException e) {
			throw new Exception(e.getMessage());
		}
		return rows;
	}

	public List<Map<String, Object>> queryForListWithType(String sql) {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		List<Map<String, Object>> rows2 = new ArrayList<>();
		try {
			conn = getConnection();
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsme = rs.getMetaData();
			int columnCount = rsme.getColumnCount();

			rs.next();
			for (int i = 1; i < columnCount + 1; i++) {
				Map<String, Object> map = new HashMap<>();

				map.put("column_name", rsme.getColumnName(i));
				map.put("column_value", rs.getObject(rsme.getColumnName(i)));
				map.put("data_type", rsme.getColumnTypeName(i));
				map.put("precision", Integer.valueOf(rsme.getPrecision(i)));
				map.put("isAutoIncrement", Boolean.valueOf(rsme.isAutoIncrement(i)));
				map.put("is_nullable", Integer.valueOf(rsme.isNullable(i)));
				map.put("isReadOnly", Boolean.valueOf(rsme.isReadOnly(i)));
				rows2.add(map);
			}
		} catch (Exception e) {
			System.out.println("queryForListWithType  " + e.getMessage());
			try {
				rs.close();
				pstmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				pstmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rows2;
	}

	public List<Map<String, Object>> queryForColumnOnly(String sql) {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		List<Map<String, Object>> rows2 = new ArrayList<>();
		try {
			conn = getConnection();
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsme = rs.getMetaData();
			int columnCount = rsme.getColumnCount();
			for (int i = 1; i < columnCount + 1; i++) {
				Map<String, Object> map = new HashMap<>();

				map.put("column_name", rsme.getColumnName(i));
				map.put("data_type", rsme.getColumnTypeName(i));
				map.put("precision", Integer.valueOf(rsme.getPrecision(i)));
				map.put("isAutoIncrement", Boolean.valueOf(rsme.isAutoIncrement(i)));
				map.put("is_nullable", Integer.valueOf(rsme.isNullable(i)));
				map.put("isReadOnly", Boolean.valueOf(rsme.isReadOnly(i)));

				rows2.add(map);
			}
		} catch (Exception e) {
			try {
				rs.close();
				pstmt.close();
				conn.close();
			} catch (SQLException e1) {
			}
		} finally {
			try {
				rs.close();
				pstmt.close();
				conn.close();
			} catch (SQLException e) {
			}
		}
		return rows2;
	}

	public List<Map<String, Object>> executeSqlForColumns(String sql) throws Exception {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int maxSize = -1;
		List<Map<String, Object>> rows = new ArrayList<>();

		conn = getConnection();
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		rsmd = rs.getMetaData();
		maxSize = rsmd.getColumnCount();
		for (int i = 0; i < maxSize; i++) {
			Map<String, Object> map = new HashMap<>();

			map.put("column_name", rsmd.getColumnLabel(i + 1));
			map.put("data_type", rsmd.getColumnTypeName(i + 1));

			rows.add(map);
		}
		rs.close();
		pstmt.close();
		conn.close();
		return rows;
	}

	public int executeQueryForCount(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				Object count = rs.getObject("count(*)");
				rowCount = Integer.parseInt(count.toString());
			}
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForPostgesSQL(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				Object count = rs.getObject("count");
				rowCount = Integer.parseInt(count.toString());
			}
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForMySQL(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			sql = "select count(*) as TOTALS from (" + sql + ") tab ";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			rs.next();
			rowCount = rs.getInt("TOTALS");
		} catch (Exception e) {
			throw new Exception("取得表行数出错，" + e.getMessage());
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException e) {
				throw new Exception("取得表行数出错，" + e.getMessage());
			}
		}
		return rowCount;
	}

	public boolean executeQuery(String sql) throws Exception {
		boolean bl = false;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next()) {
				bl = true;
			}
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return bl;
	}

	public boolean executeQueryForQuartzJob(String sql) throws Exception {
		boolean bl = false;
		Connection conn = getConnectionForQuartzJob();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next()) {
				bl = true;
			}
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return bl;
	}

	public boolean testConn() {
		boolean bl = false;
		try {
			Connection conn = getConnection();
			if (conn != null) {
				bl = true;
			}
			conn.close();
		} catch (Exception e) {
		}
		return bl;
	}

	public String getPrimaryKeys(String databaseName, String tableName) {
		Connection conn = null;

		try {
			conn = getConnection();
			DatabaseMetaData metadata = conn.getMetaData();

			ResultSet rs2 = metadata.getPrimaryKeys(databaseName, null, tableName);
			if (rs2.next()) {
				System.out.println("主键名称: " + rs2.getString(4));
				return rs2.getString(4);
			}
		} catch (Exception e) {
		} finally {
			try {
				conn.close();
			} catch (SQLException localSQLException2) {
			}
		}
		try {
			conn.close();
		} catch (SQLException localSQLException3) {
		}
		return "";
	}

	public List<String> getPrimaryKeyss(String databaseName, String tableName) {
		Connection conn = null;

		List<String> rows2 = new ArrayList<>();
		try {
			conn = getConnection();
			DatabaseMetaData metadata = conn.getMetaData();

			ResultSet rs2 = metadata.getPrimaryKeys(databaseName, null, tableName);
			while (rs2.next()) {
				rows2.add(rs2.getString(4));
			}
		} catch (Exception e) {
			try {
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rows2;
	}

	public int executeQueryForCountForOracle(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		String sql3 = " select count(*) as count from  (" + sql + ")";
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql3);
			rs.next();

			rowCount = rs.getInt("count");
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForPostgreSQL(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		String sql3 = " select count(*) as totals from  (" + sql + ") t ";
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql3);
			rs.next();
			rowCount = rs.getInt("totals");
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForMSSqlWith(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				rowCount++;
			}
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForHana2(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		String sql3 = " select count(*) as COUNT from  (" + sql + ") t ";
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql3);
			rs.next();
			rowCount = rs.getInt("COUNT");
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public int executeQueryForCountForCache(String sql) throws Exception {
		int rowCount = 0;
		Connection conn = getConnection();
		Statement stmt = null;
		ResultSet rs = null;
		String sql3 = " select count(*) as TOTALS from  (" + sql + ") t ";
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql3);
			rs.next();
			rowCount = rs.getInt("TOTALS");
		} catch (Exception e) {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException) {
			}
		} finally {
			try {
				rs.close();
				stmt.close();
				conn.close();
			} catch (SQLException localSQLException1) {
			}
		}
		return rowCount;
	}

	public static String byteToHex(byte[] bytes) {
		String strHex = "";
		StringBuilder sb = new StringBuilder("");
		for (int n = 0; n < bytes.length; n++) {
			strHex = Integer.toHexString(bytes[n] & 0xFF);

			sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
		}
		return "0x" + sb.toString().toUpperCase().trim();
	}

	public String bytesToHexString(byte[] src) {
		StringBuilder stringBuilder = new StringBuilder("");
		if ((src == null) || (src.length <= 0)) {
			return null;
		}
		for (int i = 0; i < src.length; i++) {
			int v = src[i] & 0xFF;
			String hv = Integer.toHexString(v);
			if (hv.length() < 2) {
				stringBuilder.append(0);
			}
			stringBuilder.append(hv);
		}
		return stringBuilder.toString();
	}
}
