/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.utils.DBUtil2;
import com.ejianc.business.profinance.utils.DynamicDataSourceDruidUtil;
import com.ejianc.business.profinance.utils.ResultAsTreeNew;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nccData/"})
public class NccDataController {
    private static final String IP = "10.70.2.127";
    private static final String PORT = "1521";
    private static final String DBNAME = "orcl";
    private static final String USERNAME = "sjxmgl";
    private static final String DRIVER = "oracle.jdbc.OracleDriver";
    private static final String DATABASETYPE = "Oracle";
    private static final String PASSWORD = "Sj#2j#xmGl";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @GetMapping(value={"getNCCPayBankTypeList"})
    public List<Map<String, Object>> getNCCPayBankTypeList() {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_BANKTYPE AS \"id\", PK_BANKTYPE AS \"key\", BANKTYPECODE AS \"code\", BANKTYPENAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PAYACCOUNT ORDER BY TO_NUMBER(\"code\")");
        return this.queryBySql(sql.toString());
    }

    @GetMapping(value={"getNCCPayBankList"})
    public CommonResponse<JSONObject> getNCCPayBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText) {
        JSONObject resp = new JSONObject();
        int startLine = pageNumber - 1 < 0 ? 0 : pageNumber - 1;
        StringBuilder querySql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        querySql.append(" FROM (").append("   SELECT").append("       PK_BANKACCSUB AS \"nccPK\",").append("       BANKACCSUBCODE AS \"code\",").append("       BANKACCSUBNAME AS \"name\",").append("       PK_BANKDOC AS \"bankPK\",").append("       BANKCODE AS \"bankCode\",").append("       BANKNAME AS \"bankName\"").append("   FROM NCC2105.V_ERJIAN_PAYACCOUNT").append("   WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            querySql.append(" AND PK_BANKTYPE =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            querySql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'").append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKCODE LIKE '%").append(searchText).append("%' ").append(" OR BANKNAME LIKE '%").append(searchText).append("%' ) ");
        }
        querySql.append(" ) t ) ").append("  WHERE \"id\" BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine + 1) * pageSize).append(" ORDER BY \"id\" ");
        this.logger.info("sql: {}", (Object)querySql.toString());
        List<Map<String, Object>> dataList = this.queryBySql(querySql.toString());
        if (!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> item.put("id", Long.valueOf(item.get("id").toString())));
        }
        resp.put("records", dataList);
        if (CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", (Object)0);
            resp.put("total", (Object)0);
            resp.put("current", (Object)pageNumber);
            resp.put("pageSize", (Object)pageSize);
            return CommonResponse.success((Object)resp);
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        countSql.append(" FROM (").append("   SELECT").append("       PK_BANKACCSUB AS \"nccPK\",").append("       BANKACCSUBCODE AS \"code\",").append("       BANKACCSUBNAME AS \"name\",").append("       PK_BANKDOC AS \"bankPK\",").append("       BANKCODE AS \"bankCode\",").append("       BANKNAME AS \"bankName\"").append("   FROM NCC2105.V_ERJIAN_PAYACCOUNT").append("   WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            countSql.append(" AND PK_BANKTYPE =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'").append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKCODE LIKE '%").append(searchText).append("%' ").append(" OR BANKNAME LIKE '%").append(searchText).append("%' ) ");
        }
        countSql.append(" ) t ) ");
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("total");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        resp.put("current", (Object)pageNumber);
        resp.put("pageSize", (Object)pageSize);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"getNCCRecBankList"})
    public CommonResponse<JSONObject> getNCCRecBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        JSONObject param;
        JSONObject param2;
        JSONObject resp = new JSONObject();
        int startLine = pageNumber - 1 < 0 ? 0 : pageNumber - 1;
        StringBuilder querySql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        querySql.append(" FROM (").append("   SELECT").append("       PK_BANKACCSUB AS \"nccPK\",").append("       BANKACCSUBCODE AS \"code\",").append("       BANKACCSUBNAME AS \"name\",").append("       PK_BANKDOC AS \"bankPK\",").append("       BANKCODE AS \"bankCode\",").append("       BANKNAME AS \"bankName\",").append("       PK_BANKTYPE AS \"bankTypePK\",").append("       BANKTYPECODE AS \"bankTypeCode\",").append("       BANKTYPENAME AS \"bankTypeName\"").append("   FROM NCC2105.V_ERJIAN_RECACCOUNT").append("   WHERE 1 = 1");
        SupplierDTO supplier = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (param2 = JSONObject.parseObject((String)condition)).get((Object)"supplierId")) {
            CommonResponse supplierResp = this.shareSupplierApi.queryById(param2.getLong("supplierId"));
            if (!supplierResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546Id-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff0c{} ", param2.get((Object)"supplierId"), (Object)JSONObject.toJSONString((Object)supplierResp));
            }
            supplier = (SupplierDTO)supplierResp.getData();
            querySql.append(" AND SUPPLIERCODE =").append(" '").append(supplier.getCode()).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            querySql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'").append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKTYPENAME LIKE '%").append(searchText).append("%' ) ");
        }
        querySql.append(" ) t ) ").append("  WHERE \"id\" BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine + 1) * pageSize).append(" ORDER BY \"id\" ");
        this.logger.info("sql: {}", (Object)querySql.toString());
        List<Map<String, Object>> dataList = this.queryBySql(querySql.toString());
        if (!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> item.put("id", Long.valueOf(item.get("id").toString())));
        }
        resp.put("records", dataList);
        if (CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", (Object)0);
            resp.put("total", (Object)0);
            resp.put("current", (Object)pageNumber);
            resp.put("pageSize", (Object)pageSize);
            return CommonResponse.success((Object)resp);
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        countSql.append(" FROM (").append("   SELECT").append("       PK_BANKACCSUB AS \"nccPK\",").append("       BANKACCSUBCODE AS \"code\",").append("       BANKACCSUBNAME AS \"name\",").append("       PK_BANKDOC AS \"bankPK\",").append("       BANKCODE AS \"bankCode\",").append("       BANKNAME AS \"bankName\",").append("       PK_BANKTYPE AS \"bankTypePK\",").append("       BANKTYPECODE AS \"bankTypeCode\",").append("       BANKTYPENAME AS \"bankTypeName\"").append("   FROM NCC2105.V_ERJIAN_RECACCOUNT").append("   WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (param = JSONObject.parseObject((String)condition)).get((Object)"supplierCode")) {
            countSql.append(" AND SUPPLIERCODE =").append(" '").append(supplier.getCode()).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'").append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKNAME LIKE '%").append(searchText).append("%' ").append(" OR BANKTYPENAME LIKE '%").append(searchText).append("%' ) ");
        }
        countSql.append(" ) t ) ");
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("total");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        resp.put("current", (Object)pageNumber);
        resp.put("pageSize", (Object)pageSize);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"getNCCUserList"})
    public CommonResponse<JSONObject> getNCCUserList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageNumber);
        resp.put("size", (Object)pageSize);
        resp.put("pages", (Object)1);
        resp.put("total", (Object)0);
        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT t.*,ROW_NUMBER() OVER ( ORDER BY USER_CODE ) rn FROM NCC2105.V_ERJIAN_USER t WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'").append("OR USER_CODE like '%").append(searchText).append("%'").append("OR ORGCODE like '%").append(searchText).append("%'").append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        sql.append(")WHERE rn BETWEEN (" + pageNumber + "-1)*" + pageSize + "+1 and " + pageNumber + "*" + pageSize).append(" ORDER BY rn");
        List<Map<String, Object>> list = this.queryBySql(sql.toString());
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.success((String)"", (Object)resp);
        }
        ArrayList<JSONObject> record = new ArrayList<JSONObject>();
        for (Map<String, Object> m : list) {
            JSONObject j = new JSONObject();
            j.put("id", m.get("USER_CODE"));
            j.put("name", m.get("USER_NAME"));
            j.put("code", m.get("USER_CODE"));
            j.put("orgId", m.get("ORGCODE"));
            j.put("orgCode", m.get("ORGCODE"));
            j.put("orgName", m.get("ORGNAME"));
            record.add(j);
        }
        resp.put("records", record);
        StringBuilder countSql = new StringBuilder("select COUNT(CUSERID) from NCC2105. V_ERJIAN_USER WHERE 1=1  AND (ORGCODE like '101021%' OR ORGCODE = '10102Z')");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'").append("OR USER_CODE like '%").append(searchText).append("%'").append("OR ORGCODE like '%").append(searchText).append("%'").append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("COUNT(CUSERID)");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"getNCCProjectTypeTree"})
    public List<Map<String, Object>> getNCCProjectTypeTree() {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_EPS AS \"id\", PK_EPS AS \"key\", EPS_CODE AS \"code\", EPS_NAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PROJECT ORDER BY LENGTH(\"code\"), \"code\" ASC");
        return this.queryBySql(sql.toString());
    }

    @GetMapping(value={"getNCCFinancialOrgProjectList"})
    public CommonResponse<JSONObject> getNCCFinancialOrgProjectList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText) {
        int startLine = pageNumber - 1 < 0 ? 0 : pageNumber - 1;
        JSONObject resp = new JSONObject();
        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        sql.append(" FROM (").append("    SELECT ").append("        PK_PROJECT AS \"nccPK\",").append("        PROJECT_CODE AS \"code\",").append("        PROJECT_NAME AS \"name\",").append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ").append("    FROM NCC2105.V_ERJIAN_PROJECT ").append("    WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            sql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'").append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
        }
        sql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ").append("  WHERE rn BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine + 1) * pageSize).append(" ORDER BY rn ");
        this.logger.info("sql: {}", (Object)sql.toString());
        List<Map<String, Object>> dataList = this.queryBySql(sql.toString());
        if (!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> item.put("id", Long.valueOf(item.get("id").toString())));
        }
        resp.put("records", dataList);
        if (CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", (Object)0);
            resp.put("total", (Object)0);
            resp.put("current", (Object)pageNumber);
            resp.put("pageSize", (Object)pageSize);
            return CommonResponse.success((Object)resp);
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        countSql.append(" FROM (").append("    SELECT ").append("        PK_PROJECT AS \"nccPK\",").append("        PROJECT_CODE AS \"code\",").append("        PROJECT_NAME AS \"name\",").append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ").append("    FROM NCC2105.V_ERJIAN_PROJECT ").append("    WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            countSql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'").append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
        }
        countSql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ");
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("total");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        resp.put("current", (Object)pageNumber);
        resp.put("pageSize", (Object)pageSize);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"getNCCFinancialOrgTree"})
    public List<Map<String, Object>> getNCCFinancialOrgTree(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        StringBuilder sql = new StringBuilder("SELECT SUBSTR(code, 0, LENGTH(CODE)-1) AS \"id\", PK_ORG AS \"nccPK\", CODE AS \"code\", CODE || ' ' || NAME AS \"name\",PK_FATHERORG AS \"nccPid\"");
        sql.append(" FROM NCC2105.V_ERJIAN_ORG").append(" WHERE (CODE like '101021%' OR CODE = '10102Z')").append(" START WITH CODE = '10102Z'").append(" CONNECT BY PRIOR PK_ORG = PK_FATHERORG").append(" ORDER BY LENGTH(CODE),CODE");
        List<Map<String, Object>> orgList = this.queryBySql(sql.toString());
        return ResultAsTreeNew.createTreeData(orgList, "nccPid", "nccPK");
    }

    public List<Map<String, Object>> queryBySql(String sql) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ip", IP);
        map.put("port", PORT);
        map.put("dbName", DBNAME);
        map.put("userName", USERNAME);
        map.put("driver", DRIVER);
        map.put("databaseType", DATABASETYPE);
        map.put("password", PASSWORD);
        DataSource dataSource = DynamicDataSourceDruidUtil.getDataSource(map);
        DBUtil2 db = new DBUtil2(dataSource);
        try {
            list = db.queryForListCommonMethod(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

