package com.ejianc.business.profinance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PMPayStateEnum {
    /*
        0-待支付、1-银行支付中、2-支付成功、3-支付失败
        PM系统新增中间表数据时，设置初始状态为“待支付”
     */
    待支付("0", "待支付"),
    银行支付中("1", "银行支付中"),
    支付成功("2", "支付成功"),
    支付失败("3", "支付失败");

    private String code;
    private String description;

    PMPayStateEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private static Map<String, PMPayStateEnum> enumMap = new HashMap<>();

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(PMPayStateEnum.class).stream().collect(Collectors.toMap(PMPayStateEnum::getCode, Function.identity(), (k1, k2) -> k2));

    }

    public static PMPayStateEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }

}
