package com.ejianc.business.profinance.odd.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.profinance.odd.vo.ImportOddAllocationVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;

/**
 * 零星费用分配主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("oddAllocation")
@Api(value = "零星费用分配主表", tags = {"零星费用分配主表"})
public class OddAllocationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IExecutionApi executionApi;

    private static final String BILL_CODE = "ODD_ALLOCATION";//此处需要根据实际修改

    @Autowired
    private IOddAllocationService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddAllocationVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OddAllocationVO saveOrUpdateVO) {
    	OddAllocationEntity entity = BeanMapper.map(saveOrUpdateVO, OddAllocationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            LambdaQueryWrapper<OddAllocationEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, entity.getOddFeeId());
            lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            List<OddAllocationEntity> list = service.list(lambdaQueryWrapper);
            if(CollectionUtils.isNotEmpty(list)){
                throw new BusinessException("该零星费用单号下有未生效的零星费用分配，不允许新增!");
            }
        }
        entity.setRelationFlag("0");//关联状态初始化
        entity.setProportionFlag("0");//分摊状态初始化
    	service.saveOrUpdate(entity, false);
        // 推送 实际成本
        service.saveCost(entity,0);
    	OddAllocationVO vo = BeanMapper.map(entity, OddAllocationVO.class);
        // 推送 目标成本
        service.pushSettleToCost(vo);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddAllocationVO> queryDetail(@RequestParam Long id) {
    	OddAllocationEntity entity = service.selectById(id);
    	OddAllocationVO vo = BeanMapper.map(entity, OddAllocationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("关联保存接口")
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddAllocationVO> pushCost(@RequestBody OddAllocationVO OddAllocationVO) {
        return service.pushCost(OddAllocationVO);
    }

    @ApiOperation("校验唯一")
    @RequestMapping(value = "/checkOddFee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkOddFee(@RequestParam Long oddFeeId,Long id) {
        Boolean flag = true;
        LambdaQueryWrapper<OddAllocationEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, oddFeeId);
        lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        if(null!=id){
            lambdaQueryWrapper.ne(OddAllocationEntity::getId, id);
        }
        List<OddAllocationEntity> list = service.list(lambdaQueryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            flag = false;
        }
        return CommonResponse.success("查询详情数据成功！",flag);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddAllocationVO> vos) {
        List<Long> ids = vos.stream().map(OddAllocationVO::getId).collect(Collectors.toList());
        List<OddAllocationEntity> oddAllocationEntities = service.list(new QueryWrapper<OddAllocationEntity>().in("id",ids));
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        for (OddAllocationEntity entity : oddAllocationEntities) {
            OddAllocationVO oddAllocationVO = BeanMapper.map(service.selectById(entity.getId()), OddAllocationVO.class);
            ExecutionVO executionVO = service.settleCost(oddAllocationVO,"");
            totalExecutionVOList.add(executionVO.getTotalVO());
            logger.info("目标成本删除数据" + JSON.toJSONString(executionVO));
            //删除实际成本
            CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(oddAllocationVO.getId());
            logger.info("删除实际成本结果"+ JSONObject.toJSONString(stringCommonResponse));
            if(!stringCommonResponse.isSuccess()){
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        if (ListUtil.isNotEmpty(totalExecutionVOList)) {
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            logger.info("目标成本删除数据结果---:{}", JSONObject.toJSONString(response));
            if (!response.isSuccess()){
                throw new BusinessException("目标成本删除失败,"+response.getMsg());
            }
        }
        service.removeByIds(vos.stream().map(OddAllocationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddAllocationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("oddFeeCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("noContractFeeTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OddAllocationEntity> page = service.queryPage(param,false);
        IPage<OddAllocationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddAllocationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("oddFeeCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("noContractFeeTypeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OddAllocationEntity> list = service.queryList(param);
        List<OddAllocationVO> oddAllocationVOS = new ArrayList<>();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            oddAllocationVOS = BeanMapper.mapList(list, OddAllocationVO.class);
            for (OddAllocationVO oddAllocationVO : oddAllocationVOS) {
                if(null!=oddAllocationVO.getBillDate()){
                    oddAllocationVO.setBillDateStr(DateFormatUtil.formatDate("yyyy-MM-dd",oddAllocationVO.getBillDate()));
                }
                if(null!=oddAllocationVO.getEmployeeDate()){
                    oddAllocationVO.setEmployeeDateStr(DateFormatUtil.formatDate("yyyy-MM-dd",oddAllocationVO.getEmployeeDate()));
                }
                if(null!=oddAllocationVO.getHappenDate()){
                    oddAllocationVO.setHappenDateStr(DateFormatUtil.formatDate("yyyy-MM-dd",oddAllocationVO.getHappenDate()));
                }
                oddAllocationVO.setBillStateName(BillStateEnum.getEnumByStateCode(oddAllocationVO.getBillState()).getDescription());
            }
        }
        beans.put("records", oddAllocationVOS);
        ExcelExport.getInstance().export("OddAllocation-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOddAllocationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OddAllocationVO>> refOddAllocationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OddAllocationEntity> page = service.queryPage(param,false);
        IPage<OddAllocationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddAllocationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "OddAllocation-import.xlsx", "零星费用分配-导入模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }

    /**
     * 导入数据保存
     * @param request
     * @param importVOS
     * @return
     */
    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ImportOddAllocationVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OddAllocationVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }


    /**
     * 零星费用分配推送目标成本数据
     *
     * @param projectId 项目id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/allOddAllocationPushTargetCost")
    @ResponseBody
    public CommonResponse<String> allOddAllocationPushTargetCost(@RequestParam(value = "projectId", required = false) Long projectId) {
        QueryWrapper<OddAllocationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        List<OddAllocationEntity> oddAllocationEntityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(oddAllocationEntityList)){
            for (OddAllocationVO oddAllocationVO : BeanMapper.mapList(oddAllocationEntityList, OddAllocationVO.class)) {
                service.pushSettleToCost(oddAllocationVO);
            }
        }
        logger.info("零星费用分配推送目标成本数据{}条", oddAllocationEntityList.size());
        return CommonResponse.success("零星费用分配推送目标成本数据成功！");
    }

}
