package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.mapper.RegisterDetailMapper;
import com.ejianc.business.profinance.bean.RegisterDetailEntity;
import com.ejianc.business.profinance.service.IRegisterDetailService;

/**
 * 付款管理 详情表
 * 
 * @author generator
 * 
 */
@Service("registerDetailService")
public class RegisterDetailServiceImpl extends BaseServiceImpl<RegisterDetailMapper, RegisterDetailEntity> implements IRegisterDetailService{




    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper<RegisterDetailEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(RegisterDetailEntity::getRegisterId, planId);
        updateWrapper.set(RegisterDetailEntity::getBillState, billStateCode);
        super.update(updateWrapper);
    }
}
