/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"paymentApply"})
public class PaymentApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPaymentApplyService service;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<PaymentApplyVO> saveOrUpdate(@RequestBody PaymentApplyVO saveOrUpdateVO) {
        CommonResponse<PaymentApplyVO> unusedResult;
        if (null != saveOrUpdateVO.getDeductAdvancePayment() && null != saveOrUpdateVO.getPendDeductAdvancePayment() && saveOrUpdateVO.getDeductAdvancePayment().compareTo(saveOrUpdateVO.getPendDeductAdvancePayment()) > 0) {
            return CommonResponse.error((String)"\u6263\u51cf\u9884\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f85\u6263\u56de\u4ed8\u6b3e\u91d1\u989d!");
        }
        Integer paymentContractFlag = saveOrUpdateVO.getPaymentContractFlag();
        Integer personalPrepaid = saveOrUpdateVO.getPersonalPrepaid();
        if (paymentContractFlag == 0) {
            saveOrUpdateVO.setPayeeId(saveOrUpdateVO.getSupplierId());
            saveOrUpdateVO.setPayeeName(saveOrUpdateVO.getSupplierName());
        } else if (personalPrepaid == 0) {
            saveOrUpdateVO.setPayeeId(saveOrUpdateVO.getSupplierId());
            saveOrUpdateVO.setPayeeName(saveOrUpdateVO.getSupplierName());
        }
        if (null == saveOrUpdateVO.getId() && saveOrUpdateVO.getPaymentContractFlag() == 1 && !(unusedResult = this.service.queryUnusedPaymentApply(saveOrUpdateVO.getPaymentType(), saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getSupplierId(), saveOrUpdateVO.getApplyDate())).isSuccess()) {
            return CommonResponse.error((String)unusedResult.getMsg());
        }
        if (null == saveOrUpdateVO.getId() && null != saveOrUpdateVO.getContractId()) {
            CommonResponse contractResp = this.contractPoolApi.queryById(saveOrUpdateVO.getContractId());
            if (!contractResp.isSuccess()) {
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            saveOrUpdateVO.setContractPerformanceStatus(((ContractPoolVO)contractResp.getData()).getPerformanceStatus());
        }
        PaymentApplyVO vo = this.service.savePaymentApply(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<PaymentApplyVO> queryDetail(Long id) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)this.service.selectById(id));
        PaymentApplyVO vo = (PaymentApplyVO)BeanMapper.map((Object)((Object)entity), PaymentApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentApplyVO> vos) {
        this.service.batchDel(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage pageData = this.service.queryPage(param, false);
        List paymentApplyVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), PaymentApplyVO.class);
        for (PaymentApplyVO item : paymentApplyVOS) {
            item.setApplyDateTime(item.getApplyDate());
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)paymentApplyVOS);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        Map<String, Object> sumMnyMap = this.service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"/countTotalPayApplyMny"})
    public CommonResponse<Map<String, Object>> countTotalPayApplyMny(@RequestBody PaymentApplyVO paymentApplyVO) {
        QueryParam param = new QueryParam();
        if (null != paymentApplyVO.getProjectId()) {
            param.getParams().put("projectId", new Parameter("eq", (Object)paymentApplyVO.getProjectId()));
        }
        if (null != paymentApplyVO.getContractId()) {
            param.getParams().put("contractId", new Parameter("eq", (Object)paymentApplyVO.getContractId()));
        }
        if (null != paymentApplyVO.getSourceCategoryType()) {
            param.getParams().put("sourceCategoryType", new Parameter("eq", (Object)paymentApplyVO.getSourceCategoryType()));
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter("in", billStates));
        return CommonResponse.success(this.service.countSumMny(param));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryLastApply"}, method={RequestMethod.POST})
    public CommonResponse<PaymentApplyVO> queryLastApply(@RequestBody PaymentApplyVO entity) {
        if (entity.getContractId() == null || entity.getProjectId() == null) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u5408\u540cid\u6216\u9879\u76ee\u662f\u5426\u4e3a\u7a7a\uff01");
        }
        CommonResponse<PaymentApplyVO> paymentApplyVOCommonResponse = this.service.checkPayApply(entity);
        if (paymentApplyVOCommonResponse.isSuccess()) {
            entity.setApplyDate(((PaymentApplyVO)paymentApplyVOCommonResponse.getData()).getApplyDate());
            entity.setMinApplyDate(((PaymentApplyVO)paymentApplyVOCommonResponse.getData()).getMinApplyDate());
            if (entity.getPaymentType() == 1) {
                entity.setAdvanceApplyMny(this.service.queryAdvanceApplyMny(entity));
            } else if (entity.getPaymentType() == 0) {
                entity.setPendDeductAdvancePayment(this.service.queryPendDeduct(entity));
            } else if (entity.getPaymentType() == 2) {
                entity.setTotalLitigationMny(this.service.queryTotalLitigationMny(entity));
                entity.setLastLitigationMny(this.service.queryLastLitigationMny(entity));
            }
            entity.setTotalLawsuitMny(this.service.queryTotalLawsuitMny(entity));
            entity.setLastApplyMny(this.service.queryLastApplyMny(entity));
            entity.setTotalPayMny(this.service.queryTotalPayMny(entity));
            entity.setTotalPerformanceMny(this.service.queryContractHonourMny(entity));
            if (null != entity.getSourceCategoryType() && (ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(entity.getSourceCategoryType()) || ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(entity.getSourceCategoryType()))) {
                this.service.setTotalContractRelateMny(entity);
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)entity);
        }
        return paymentApplyVOCommonResponse;
    }

    @RequestMapping(value={"/queryAlreadyApplyMny"}, method={RequestMethod.POST})
    public CommonResponse<Map<String, BigDecimal>> queryAlreadyApplyMny(@RequestBody List<String> idList) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (String id : idList) {
            BigDecimal bigDecimal = this.service.queryAlreadyApplyMny(id);
            map.put(id, bigDecimal);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", map);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List paymentApplyVOList = new ArrayList();
        if (null != commonResponse.getData()) {
            paymentApplyVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (null != paymentApplyVOList && paymentApplyVOList.size() > 0) {
                paymentApplyVOList.forEach(c -> {
                    c.setApplyDateStr(sdf.format(c.getApplyDate()));
                    if (null != c.getPaymentType()) {
                        if (c.getPaymentType().equals(0)) {
                            c.setPaymentTypeName("\u8fdb\u5ea6\u6b3e");
                        } else if (c.getPaymentType().equals(1)) {
                            c.setPaymentTypeName("\u9884\u4ed8\u6b3e");
                        } else if (c.getPaymentType().equals(2)) {
                            c.setPaymentTypeName("\u8bc9\u8bbc\u6b3e");
                        } else if (c.getPaymentType().equals(3)) {
                            c.setPaymentTypeName("\u96f6\u661f\u6750\u6599");
                        } else if (c.getPaymentType().equals(4)) {
                            c.setPaymentTypeName("\u4e34\u65f6\u673a\u68b0");
                        }
                    }
                    c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
                });
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", paymentApplyVOList);
        if (null != param.getParams().get("paymentContractFlag")) {
            if (((Parameter)param.getParams().get("paymentContractFlag")).getValue().equals(1)) {
                ExcelExport.getInstance().export("noContractPaymentApply-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("contractPaymentApply-export.xlsx", beans, response);
            }
        }
    }

    @RequestMapping(value={"/refPaymentApplyData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<PaymentApplyVO>> refPaymentApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            String paymentContractFlag = conditionJson.getString("paymentContractFlag");
            if (StringUtils.isBlank((CharSequence)projectId) && StringUtils.isBlank((CharSequence)orgId) && StringUtils.isBlank((CharSequence)orgType)) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570projectId\u6216\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId,orgType\uff01");
            }
            if (!StringUtils.isNotBlank((CharSequence)paymentContractFlag)) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u67e5\u8be2\u5408\u540c\u7c7b\u578b \u662f\u5426\u6709\u5408\u540c");
            }
            param.getParams().put("paymentContractFlag", new Parameter("eq", (Object)paymentContractFlag));
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                this.logger.info("condition\u4e2dprojectId\uff1a{}", (Object)projectId);
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.valueOf(projectId)));
            } else {
                if (StringUtils.isBlank((CharSequence)orgId)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId\uff01");
                }
                if (StringUtils.isBlank((CharSequence)orgType)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgType\uff01");
                }
                if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    param.getParams().put("orgId", new Parameter("eq", (Object)Long.valueOf(orgId)));
                } else {
                    CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if (!orgResp.isSuccess()) {
                        this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
        } else {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570projectId\u6216\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId,orgType\uff01");
        }
        param.getParams().put("close_state", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List paymentApplyVOS = BeanMapper.mapList((Iterable)page.getRecords(), PaymentApplyVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        paymentApplyVOS.forEach(c -> {
            c.setApplyDateStr(sdf.format(c.getApplyDate()));
            if (null != c.getPaymentType()) {
                if (c.getPaymentType().equals(0)) {
                    c.setPaymentTypeName("\u8fdb\u5ea6\u6b3e");
                } else if (c.getPaymentType().equals(1)) {
                    c.setPaymentTypeName("\u9884\u4ed8\u6b3e");
                } else if (c.getPaymentType().equals(2)) {
                    c.setPaymentTypeName("\u8bc9\u8bbc\u6b3e");
                } else if (c.getPaymentType().equals(3)) {
                    c.setPaymentTypeName("\u96f6\u661f\u6750\u6599");
                } else if (c.getPaymentType().equals(4)) {
                    c.setPaymentTypeName("\u4e34\u65f6\u673a\u68b0");
                }
            }
        });
        pageData.setRecords(paymentApplyVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUnusedPaymentApply"}, method={RequestMethod.GET})
    public CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate) {
        return this.service.queryUnusedPaymentApply(paymentType, projectId, supplierId, applyDate);
    }

    @PostMapping(value={"/queryDataModelInfo"})
    public CommonResponse<List<JSONObject>> queryDataModelInfo(@RequestBody JSONObject jsonParam) {
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        this.logger.info("\u67e5\u8be2\u65e0\u5408\u540c\u4ed8\u6b3e\u6570\u636e\u6a21\u578b\u53c2\u6570-{},", (Object)jsonParam.toJSONString());
        if (null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if (null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject projectInfo = billJson.getJSONObject("projectId");
        if (null == projectInfo || projectInfo.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject data = this.service.queryDataModelInfo(projectInfo.getLong("id"));
        data.put("projectName", (Object)projectInfo.getString("name"));
        resp.add(data);
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"/queryDataModelEquip"})
    public CommonResponse<List<JSONObject>> queryDataModelEquip(@RequestBody JSONObject jsonParam) {
        ArrayList resp = new ArrayList();
        this.logger.info("\u67e5\u8be2\u65e0\u5408\u540c\u4ed8\u6b3e\u6570\u636e\u6a21\u578b\u53c2\u6570-{},", (Object)jsonParam.toJSONString());
        if (null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if (null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject projectInfo = billJson.getJSONObject("projectId");
        if (null == projectInfo || projectInfo.isEmpty()) {
            return CommonResponse.success(resp);
        }
        List<JSONObject> data = this.service.queryDataModelEquip(projectInfo.getLong("id"));
        return CommonResponse.success(data);
    }

    @PostMapping(value={"/queryDataModelMaterial"})
    public CommonResponse<List<JSONObject>> queryDataModelMaterial(@RequestBody JSONObject jsonParam) {
        ArrayList resp = new ArrayList();
        this.logger.info("\u67e5\u8be2\u65e0\u5408\u540c\u4ed8\u6b3e\u6570\u636e\u6a21\u578b\u53c2\u6570-{},", (Object)jsonParam.toJSONString());
        if (null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if (null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject projectInfo = billJson.getJSONObject("projectId");
        if (null == projectInfo || projectInfo.isEmpty()) {
            return CommonResponse.success(resp);
        }
        List<JSONObject> data = this.service.queryDataModelMaterial(projectInfo.getLong("id"));
        return CommonResponse.success(data);
    }

    @RequestMapping(value={"/updateCloseState"}, method={RequestMethod.POST})
    public CommonResponse<PaymentApplyVO> updateCloseState(@RequestBody PaymentApplyVO saveOrUpdateVO) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        if (null != entity) {
            entity.setCloseState(saveOrUpdateVO.getCloseState());
        }
        if (!BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u751f\u6548\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return this.service.updateCloseState(entity, "\u5173\u95ed");
    }
}

