/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.odd.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.odd.bean.OddAllocationDetailEntity;
import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.mapper.OddAllocationMapper;
import com.ejianc.business.profinance.odd.mapper.OddFeeMapper;
import com.ejianc.business.profinance.odd.service.IOddAllocationDetailService;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import com.ejianc.business.profinance.odd.vo.ImportOddAllocationVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationDetailVO;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="oddAllocationService")
public class OddAllocationServiceImpl
extends BaseServiceImpl<OddAllocationMapper, OddAllocationEntity>
implements IOddAllocationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OddAllocationMapper oddAllocationMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private OddFeeMapper oddFeeMapper;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private IOddAllocationDetailService oddAllocationDetailService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private static final String BILL_CODE = "ODD_ALLOCATION";
    private static final String BILL_TYPE = "EJCBT202207000035";

    @Override
    public void saveCost(OddAllocationEntity oddAllocationEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<OddAllocationDetailEntity> oddAllocationDetailList = oddAllocationEntity.getOddAllocationDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(oddAllocationDetailList)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String happenDateStr = sdf.format(oddAllocationEntity.getHappenDate()).substring(0, 7);
            for (OddAllocationDetailEntity oddAllocationDetailEntity : oddAllocationDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(oddAllocationEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u96f6\u661f\u8d39\u7528\u5206\u914d\u5355.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-profinance-frontend/#/oddAllocation/card?id=" + oddAllocationEntity.getId());
                costDetailVO.setSubjectId(oddAllocationDetailEntity.getSubjectId());
                costDetailVO.setSubjectId(oddAllocationDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(oddAllocationDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(oddAllocationDetailEntity.getSubjectName());
                costDetailVO.setWbsId(oddAllocationDetailEntity.getWbsId());
                costDetailVO.setPeriod(happenDateStr);
                costDetailVO.setProportionFlag("1");
                costDetailVO.setWbsCode(oddAllocationDetailEntity.getWbsCode());
                costDetailVO.setWbsName(oddAllocationDetailEntity.getWbsName());
                costDetailVO.setSourceId(oddAllocationEntity.getId());
                costDetailVO.setSourceDetailId(oddAllocationDetailEntity.getId());
                costDetailVO.setHappenTaxMny(oddAllocationDetailEntity.getDetailAllocatedTaxMny());
                costDetailVO.setHappenMny(oddAllocationDetailEntity.getDetailAllocatedMny());
                costDetailVO.setHappenDate(oddAllocationEntity.getBillDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(BILL_CODE);
                costDetailVO.setSourceTabType("ODD_ALLOCATION_DETAIL");
                costDetailVO.setProjectId(oddAllocationEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(OddAllocationVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null == vo.getId()) {
            vo.setId(Long.valueOf(IdWorker.getId()));
        }
        List oddAllocationDetailVOList = vo.getOddAllocationDetailList();
        ArrayList<OddAllocationDetailVO> oddAllocationDetailVOListNew = new ArrayList<OddAllocationDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)oddAllocationDetailVOList)) {
            for (OddAllocationDetailVO detailVO : oddAllocationDetailVOList) {
                if (detailVO.getId() == null) {
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    detailVO.setPid(vo.getId());
                }
                if ("del".equals(detailVO.getRowState())) continue;
                oddAllocationDetailVOListNew.add(detailVO);
            }
            vo.setOddAllocationDetailList(oddAllocationDetailVOListNew);
        }
        vo.setOddAllocationDetailList(oddAllocationDetailVOList);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-profinance-frontend/#/oddAllocation/card?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo, linkUrl);
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a7\u5236\u5931\u8d25," + response.getMsg());
        }
        ParamsCheckVO tarRes = (ParamsCheckVO)response.getData();
        if (null != tarRes) {
            paramsCheckVOS.add(tarRes);
        }
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236costCtrlVO---" + JSONObject.toJSONString((Object)costCtrlVO));
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236costResponse---" + JSONObject.toJSONString((Object)costResponse));
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
            this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u7ed3\u679c---" + JSONObject.toJSONString(paramsCheckVOS));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushSettleToCost(OddAllocationVO oddAllocationVO) {
        OddAllocationEntity oddAllocationEntity = (OddAllocationEntity)((Object)this.selectById(oddAllocationVO.getId()));
        OddAllocationVO vo = (OddAllocationVO)BeanMapper.map((Object)((Object)oddAllocationEntity), OddAllocationVO.class);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-prfinance-frontend/#/oddAllocation/card?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo, linkUrl);
        this.logger.info("\u624b\u52a8\u63a8\u9001 \u96f6\u661f\u8d39\u7528\u6210\u672c\u5206\u914d\u5355\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u624b\u52a8\u63a8\u9001 \u96f6\u661f\u8d39\u7528\u6210\u672c\u5206\u914d\u5355\u76ee\u6807\u6210\u672c\u63a8\u9001\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    @Override
    public ExecutionVO settleCost(OddAllocationVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setProjectId(settleVO.getProjectId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settleVO.getBillDate()));
        totalVO.setMoney(settleVO.getFeeMny());
        totalVO.setTaxMoney(settleVO.getFeeTaxMny());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u8d39\u7528\u6210\u672c\u5206\u914d\u5355.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5176\u4ed6.getCode());
        List detailVOList = settleVO.getOddAllocationDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            for (OddAllocationDetailVO detailVO : detailVOList) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(detailVO.getId() == null ? com.ejianc.support.idworker.util.IdWorker.getId() : detailVO.getId()));
                detailExecutionVO.setSourceBillId(detailVO.getPid());
                detailExecutionVO.setContractDetailId(detailVO.getId());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(detailVO.getSubjectId());
                detailExecutionVO.setCode(detailVO.getSubjectCode());
                detailExecutionVO.setName(detailVO.getSubjectName());
                detailExecutionVO.setMoney(detailVO.getDetailAllocatedMny());
                detailExecutionVO.setTaxMoney(detailVO.getDetailAllocatedTaxMny());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setCategoryId(detailVO.getSubjectId());
                detailExecutionVO.setDocType(DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode());
                detailList.add(detailExecutionVO);
            }
        }
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public CostCtrlVO sjCost(OddAllocationVO vo) {
        List detailVOList = vo.getOddAllocationDetailList();
        this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236detailVOList---" + JSONObject.toJSONString((Object)detailVOList));
        HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            for (OddAllocationDetailVO detailVO : detailVOList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal taxMny;
                if (null == detailVO.getSubjectId() || "del".equals(detailVO.getRowState())) continue;
                BigDecimal mny = detailVO.getDetailAllocatedMny() == null ? BigDecimal.ZERO : detailVO.getDetailAllocatedMny();
                BigDecimal bigDecimal = taxMny = detailVO.getDetailAllocatedTaxMny() == null ? BigDecimal.ZERO : detailVO.getDetailAllocatedTaxMny();
                if (map.containsKey(detailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(detailVO.getSubjectId());
                    costCtrlDetailVO.setMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getMny(), (BigDecimal)mny));
                    costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getTaxMny(), (BigDecimal)taxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(detailVO.getSubjectId());
                costCtrlDetailVO.setMny(mny);
                costCtrlDetailVO.setTaxMny(taxMny);
                map.put(detailVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236map---" + JSONObject.toJSONString(map));
        if (null != map && map.size() > 0) {
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (vo.getId() != null) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList(map.values()));
            this.logger.info("\u6210\u672c\u79d1\u76ee\u63a7\u5236ctrlVO---" + JSONObject.toJSONString((Object)ctrlVO));
            return ctrlVO;
        }
        return null;
    }

    @Override
    public void deleteCost(Long id) {
        CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(id, Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(OddAllocationEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public CommonResponse<OddAllocationVO> pushCost(OddAllocationVO oddAllocationVO) {
        OddAllocationEntity entity = (OddAllocationEntity)((Object)((OddAllocationMapper)this.baseMapper).selectById(oddAllocationVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)oddAllocationVO.getOddAllocationDetailList())) {
            List oddAllocationDetailEntityList = BeanMapper.mapList((Iterable)oddAllocationVO.getOddAllocationDetailList(), OddAllocationDetailEntity.class);
            entity.setOddAllocationDetailList(oddAllocationDetailEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), OddAllocationVO.class));
    }

    @Override
    public void costPush(OddAllocationEntity oddAllocationEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<OddAllocationDetailEntity> oddAllocationDetailList = oddAllocationEntity.getOddAllocationDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(oddAllocationDetailList)) {
            for (OddAllocationDetailEntity oddAllocationDetailEntity : oddAllocationDetailList) {
                if (null != oddAllocationDetailEntity.getSubjectId() && null != oddAllocationDetailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(oddAllocationDetailList)) {
            newRelationFlag = "0";
        }
        this.saveCost(oddAllocationEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{oddAllocationEntity.getId()});
        updateWrapper.set(OddAllocationEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        oddAllocationEntity.setRelationFlag(newRelationFlag);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        List<OddAllocationEntity> oddAllocationEntityList;
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        for (int i = 1; i < 6; ++i) {
            typeList.add(i);
        }
        this.logger.info("\u96f6\u661f\u8d39\u7528\u5206\u914d\u5bfc\u5165\u6821\u9a8c\u5f00\u59cb\uff1a\u5f00\u59cb\u65f6\u95f4----------->{}", (Object)new Date());
        CommonResponse subjectOrgVOData = this.shareSubjectOrgApi.shareSubjectOrgApi();
        if (!subjectOrgVOData.isSuccess()) {
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u6210\u672c\u79d1\u76ee\u5185\u5bb9\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        Map subjectOrgMap = ((List)subjectOrgVOData.getData()).stream().collect(Collectors.toMap(SubjectOrgVO::getSubjectCode, Function.identity(), (key1, key2) -> key2));
        LinkedList<Long> projectIdList = new LinkedList<Long>();
        ArrayList employeeOAAccountList = new ArrayList();
        HashMap projectPoolSetVOMap = new HashMap();
        List<Object> billCodeList = new ArrayList();
        Map<Object, Object> oddFeeEntityMap = new HashMap();
        HashMap<String, OddFeeEntity> noUseOddFeeEntityMap = new HashMap<String, OddFeeEntity>();
        List<OddFeeEntity> oddFeeEntityList = this.oddFeeMapper.queryCommitData();
        if (CollectionUtils.isNotEmpty(oddFeeEntityList)) {
            oddFeeEntityMap = oddFeeEntityList.stream().collect(Collectors.toMap(OddFeeEntity::getBillCode, Function.identity(), (key1, key2) -> key2));
        }
        if (CollectionUtils.isNotEmpty(oddAllocationEntityList = this.oddAllocationMapper.queryAllData())) {
            billCodeList = oddAllocationEntityList.stream().map(OddAllocationEntity::getBillCode).collect(Collectors.toList());
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<ImportOddAllocationVO> successList = new ArrayList<ImportOddAllocationVO>();
        ArrayList<ImportOddAllocationVO> errorList = new ArrayList<ImportOddAllocationVO>();
        ArrayList<ImportOddAllocationVO> reDataList = new ArrayList<ImportOddAllocationVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 16) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                ImportOddAllocationVO importAllocationVO = new ImportOddAllocationVO();
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importAllocationVO.setProjectCode((String)datas.get(0));
                    if (((String)datas.get(0)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u9879\u76ee\u7f16\u7801\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (projectPoolSetVOMap.get(datas.get(0)) != null) {
                        importAllocationVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getId());
                        importAllocationVO.setProjectName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getName());
                        importAllocationVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentId());
                        importAllocationVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentName());
                        importAllocationVO.setOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentCode());
                        importAllocationVO.setParentOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgName());
                        importAllocationVO.setParentOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgId());
                        importAllocationVO.setParentOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgCode());
                    } else {
                        CommonResponse projectData = this.projectPoolApi.queryProjectListByCodeAndTenantId((String)datas.get(0), tenantId);
                        if (!projectData.isSuccess()) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee]");
                        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)projectData.getData())) && null != ((List)projectData.getData()).get(0)) {
                            projectPoolSetVOMap.put(datas.get(0), ((List)projectData.getData()).get(0));
                            projectIdList.add(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getId());
                            importAllocationVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getId());
                            importAllocationVO.setProjectName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getName());
                            importAllocationVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentId());
                            importAllocationVO.setOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentCode());
                            importAllocationVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentName());
                            importAllocationVO.setParentOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgId());
                            importAllocationVO.setParentOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgName());
                            importAllocationVO.setParentOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgCode());
                        } else {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee]");
                        }
                    }
                } else {
                    errorMessage.append("[\u9879\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importAllocationVO.setOddFeeCode((String)datas.get(2));
                    if (((String)datas.get(2)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u96f6\u661f\u8d39\u7528\u5355\u636e\u7f16\u53f7\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (!oddFeeEntityMap.containsKey(datas.get(2))) {
                        errorMessage.append("[\u5f53\u524d\u96f6\u661f\u8d39\u7528\u5355" + (String)datas.get(2) + "\u672a\u63d0\u4ea4\uff0c\u8bf7\u66f4\u6362]");
                    } else {
                        OddFeeEntity oddFeeEntity = (OddFeeEntity)((Object)oddFeeEntityMap.get(datas.get(2)));
                        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                        lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, (Object)oddFeeEntity.getId());
                        lambdaQueryWrapper.notIn(OddAllocationEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
                        List list = super.list((Wrapper)lambdaQueryWrapper);
                        if (noUseOddFeeEntityMap.containsKey(oddFeeEntity.getBillCode()) || CollectionUtils.isNotEmpty((Collection)list)) {
                            noUseOddFeeEntityMap.put(oddFeeEntity.getBillCode(), oddFeeEntity);
                            errorMessage.append("[\u5f53\u524d\u96f6\u661f\u8d39\u7528\u5355" + (String)datas.get(2) + "\u4e0b\u6709\u672a\u751f\u6548\u7684\u96f6\u661f\u8d39\u7528\u5206\u914d\uff0c\u8bf7\u66f4\u6362]");
                        } else {
                            importAllocationVO.setOddFeeCode(oddFeeEntity.getBillCode());
                            importAllocationVO.setOddFeeId(oddFeeEntity.getId());
                            importAllocationVO.setNoContractFeeTypeId(oddFeeEntity.getNoContractFeeTypeId());
                            importAllocationVO.setNoContractFeeTypeCode(oddFeeEntity.getNoContractFeeTypeCode());
                            importAllocationVO.setNoContractFeeTypeName(oddFeeEntity.getNoContractFeeTypeName());
                            importAllocationVO.setHappenDate(oddFeeEntity.getHappenDate());
                            importAllocationVO.setBusinessExplain(oddFeeEntity.getBusinessExplain());
                            importAllocationVO.setTaxRate(oddFeeEntity.getTaxRate());
                            importAllocationVO.setFeeTaxMny(oddFeeEntity.getFeeTaxMny());
                            importAllocationVO.setFeeMny(oddFeeEntity.getFeeMny());
                            importAllocationVO.setTax(oddFeeEntity.getTax());
                            importAllocationVO.setHaveAllocatedMny(oddFeeEntity.getHaveAllocatedMny() == null ? BigDecimal.ZERO : oddFeeEntity.getHaveAllocatedMny());
                            importAllocationVO.setHaveAllocatedTaxMny(oddFeeEntity.getHaveAllocatedTaxMny() == null ? BigDecimal.ZERO : oddFeeEntity.getHaveAllocatedTaxMny());
                            importAllocationVO.setSurplusAllocatedMny(oddFeeEntity.getSurplusAllocatedMny());
                            importAllocationVO.setSurplusAllocatedTaxMny(oddFeeEntity.getSurplusAllocatedTaxMny());
                        }
                    }
                } else {
                    errorMessage.append("[\u96f6\u661f\u8d39\u7528\u5355\u636e\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    importAllocationVO.setBillCode((String)datas.get(3));
                    if (((String)datas.get(3)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u96f6\u661f\u5206\u914d\u5355\u636e\u7f16\u53f7\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (billCodeList.contains(datas.get(3))) {
                        errorMessage.append("[\u5f53\u524d\u96f6\u661f\u5206\u914d\u5355\u636e\u7f16\u53f7" + (String)datas.get(3) + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362]");
                    }
                } else {
                    errorMessage.append("[\u96f6\u661f\u5206\u914d\u5355\u636e\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    importAllocationVO.setNoContractFeeTypeName((String)datas.get(4));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    importAllocationVO.setHappenDateStr((String)datas.get(5));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importAllocationVO.setDetailAllocatedMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u4e0d\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        importAllocationVO.setTaxRate(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        importAllocationVO.setDetailAllocatedTaxMny(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u542b\u7a0e\u91d1\u989d\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    importAllocationVO.setSubjectCode((String)datas.get(9));
                    if (!subjectOrgMap.containsKey(datas.get(9))) {
                        errorMessage.append("[\u672a\u67e5\u8be2\u5230\u5f53\u524d\u6210\u672c\u79d1\u76ee\u7f16\u7801" + (String)datas.get(9) + "\uff0c\u8bf7\u66f4\u6362]");
                    } else {
                        importAllocationVO.setSubjectId(((SubjectOrgVO)subjectOrgMap.get(datas.get(9))).getId());
                        importAllocationVO.setSubjectName(((SubjectOrgVO)subjectOrgMap.get(datas.get(9))).getSubjectName());
                    }
                } else {
                    errorMessage.append("[\u6210\u672c\u79d1\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    importAllocationVO.setSubjectName((String)datas.get(10));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    importAllocationVO.setEmployOAAccount((String)datas.get(11));
                    employeeOAAccountList.add(datas.get(11));
                } else {
                    errorMessage.append("[\u7ecf\u529e\u4ebaOA\u8d26\u53f7\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    importAllocationVO.setEmployeeName((String)datas.get(12));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    importAllocationVO.setDepartmentName((String)datas.get(13));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    importAllocationVO.setBillDateStr((String)datas.get(14));
                    try {
                        importAllocationVO.setBillDate(DateUtils.parseDate((String)((String)datas.get(14)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u5355\u636e\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15)))) {
                    importAllocationVO.setCreateDateStr((String)datas.get(15));
                }
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    importAllocationVO.setErrorMessage(String.valueOf(errorMessage));
                }
                importAllocationVO.setId(Long.valueOf(IdWorker.getId()));
                reDataList.add(importAllocationVO);
            }
            this.logger.info("\u9879\u76eeid\u96c6\uff1a{}", (Object)JSONObject.toJSONString(projectIdList));
            CommonResponse projectWbsData = this.shareProjectWbsApi.queryByProjectIds(projectIdList);
            if (!projectWbsData.isSuccess() || null == projectWbsData.getData()) {
                reDataList.forEach(item -> {
                    if (item.getErrorMessage() != null && !item.getErrorMessage().contains("\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee")) {
                        item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[\u5f53\u524d\u9879\u76ee\u672a\u83b7\u53d6\u5230\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f]" : "[\u5f53\u524d\u9879\u76ee\u672a\u83b7\u53d6\u5230\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f]");
                    }
                });
            } else {
                Map projectWbsMap = (Map)projectWbsData.getData();
                for (ImportOddAllocationVO importAllocationVO : reDataList) {
                    if (projectWbsMap.containsKey(importAllocationVO.getProjectId())) {
                        importAllocationVO.setWbsId(((ProjectWbsVO)projectWbsMap.get(importAllocationVO.getProjectId())).getId());
                        importAllocationVO.setWbsCode(((ProjectWbsVO)projectWbsMap.get(importAllocationVO.getProjectId())).getCode());
                        importAllocationVO.setWbsName(((ProjectWbsVO)projectWbsMap.get(importAllocationVO.getProjectId())).getName());
                        continue;
                    }
                    if (importAllocationVO.getErrorMessage() == null || importAllocationVO.getErrorMessage().contains("\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee")) continue;
                    importAllocationVO.setErrorMessage(importAllocationVO.getErrorMessage() != null ? importAllocationVO.getErrorMessage() + "[\u5f53\u524d\u9879\u76ee\u672a\u83b7\u53d6\u5230\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f]" : "[\u5f53\u524d\u9879\u76ee\u672a\u83b7\u53d6\u5230\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f]");
                }
            }
            CommonResponse employeeData = this.iEmployeeApi.getByCodeOrIdcard(employeeOAAccountList);
            if (!employeeData.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)employeeData.getData()))) {
                reDataList.forEach(item -> item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]" : "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]"));
            } else {
                List employeeVOList = (List)employeeData.getData();
                Map oAAccountMap = employeeVOList.stream().filter(item -> item.getCode() != null).collect(Collectors.toMap(EmployeeVO::getCode, Function.identity(), (key1, key2) -> key2));
                for (ImportOddAllocationVO importAllocationVO : reDataList) {
                    if (oAAccountMap.containsKey(importAllocationVO.getEmployOAAccount())) {
                        importAllocationVO.setEmployeeId(((EmployeeVO)oAAccountMap.get(importAllocationVO.getEmployOAAccount())).getUserId());
                        importAllocationVO.setEmployeeName(((EmployeeVO)oAAccountMap.get(importAllocationVO.getEmployOAAccount())).getName());
                        importAllocationVO.setDepartmentId(((EmployeeVO)oAAccountMap.get(importAllocationVO.getEmployOAAccount())).getDeptId());
                        importAllocationVO.setDepartmentName(((EmployeeVO)oAAccountMap.get(importAllocationVO.getEmployOAAccount())).getDeptName());
                        importAllocationVO.setEmployeeDate(new Date());
                        continue;
                    }
                    importAllocationVO.setErrorMessage(importAllocationVO.getErrorMessage() != null ? importAllocationVO.getErrorMessage() + "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]" : "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]");
                }
            }
            for (ImportOddAllocationVO importAllocationVO : reDataList) {
                if (StringUtils.isBlank((CharSequence)importAllocationVO.getErrorMessage())) {
                    successList.add(importAllocationVO);
                    continue;
                }
                errorList.add(importAllocationVO);
            }
        }
        this.logger.info("\u5bfc\u5165\u7ed3\u675f\u65f6\u95f4----------->{}", (Object)new Date());
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ImportOddAllocationVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, OddAllocationVO> oddAllocationVOMap = new LinkedHashMap<String, OddAllocationVO>();
        if (CollectionUtils.isNotEmpty(importVOS)) {
            for (ImportOddAllocationVO importVO : importVOS) {
                if (oddAllocationVOMap.containsKey(importVO.getBillCode())) {
                    OddAllocationDetailVO oddAllocationDetailVO = new OddAllocationDetailVO();
                    oddAllocationDetailVO.setId(Long.valueOf(IdWorker.getId()));
                    oddAllocationDetailVO.setPid(((OddAllocationVO)oddAllocationVOMap.get(importVO.getBillCode())).getId());
                    oddAllocationDetailVO.setWbsId(importVO.getWbsId());
                    oddAllocationDetailVO.setWbsCode(importVO.getWbsCode());
                    oddAllocationDetailVO.setWbsName(importVO.getWbsName());
                    oddAllocationDetailVO.setSubjectId(importVO.getSubjectId());
                    oddAllocationDetailVO.setSubjectCode(importVO.getSubjectCode());
                    oddAllocationDetailVO.setSubjectName(importVO.getSubjectName());
                    oddAllocationDetailVO.setDetailAllocatedMny(importVO.getDetailAllocatedMny());
                    oddAllocationDetailVO.setDetailAllocatedTaxMny(importVO.getDetailAllocatedTaxMny());
                    if (null != oddAllocationDetailVO.getDetailAllocatedMny() && null != oddAllocationDetailVO.getDetailAllocatedTaxMny()) {
                        oddAllocationDetailVO.setDetailAllocatedRatio(oddAllocationDetailVO.getDetailAllocatedTaxMny().divide(((OddAllocationVO)oddAllocationVOMap.get(importVO.getBillCode())).getFeeTaxMny(), 8, 6).multiply(new BigDecimal(100)));
                    }
                    ((OddAllocationVO)oddAllocationVOMap.get(importVO.getBillCode())).getOddAllocationDetailList().add(oddAllocationDetailVO);
                    continue;
                }
                OddAllocationVO oddAllocationVO = (OddAllocationVO)BeanMapper.map((Object)importVO, OddAllocationVO.class);
                oddAllocationVO.setId(Long.valueOf(IdWorker.getId()));
                oddAllocationVO.setRelationFlag("0");
                oddAllocationVO.setProportionFlag("0");
                OddAllocationDetailVO oddAllocationDetailVO = new OddAllocationDetailVO();
                oddAllocationDetailVO.setId(Long.valueOf(IdWorker.getId()));
                oddAllocationDetailVO.setPid(oddAllocationVO.getId());
                oddAllocationDetailVO.setWbsId(importVO.getWbsId());
                oddAllocationDetailVO.setWbsCode(importVO.getWbsCode());
                oddAllocationDetailVO.setWbsName(importVO.getWbsName());
                oddAllocationDetailVO.setSubjectId(importVO.getSubjectId());
                oddAllocationDetailVO.setSubjectCode(importVO.getSubjectCode());
                oddAllocationDetailVO.setSubjectName(importVO.getSubjectName());
                oddAllocationDetailVO.setDetailAllocatedMny(importVO.getDetailAllocatedMny());
                oddAllocationDetailVO.setDetailAllocatedTaxMny(importVO.getDetailAllocatedTaxMny());
                if (null != oddAllocationDetailVO.getDetailAllocatedMny() && null != oddAllocationDetailVO.getDetailAllocatedTaxMny()) {
                    oddAllocationDetailVO.setDetailAllocatedRatio(oddAllocationDetailVO.getDetailAllocatedTaxMny().divide(oddAllocationVO.getFeeTaxMny(), 8, 6).multiply(new BigDecimal(100)));
                }
                oddAllocationVO.getOddAllocationDetailList().add(oddAllocationDetailVO);
                oddAllocationVOMap.put(oddAllocationVO.getBillCode(), oddAllocationVO);
            }
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        ArrayList detailEntityList = new ArrayList();
        if (null != oddAllocationVOMap) {
            for (Map.Entry entry : oddAllocationVOMap.entrySet()) {
                OddAllocationVO oddAllocationVO = (OddAllocationVO)entry.getValue();
                BigDecimal allocatedMny = oddAllocationVO.getOddAllocationDetailList().stream().map(OddAllocationDetailVO::getDetailAllocatedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allocatedTaxMny = oddAllocationVO.getOddAllocationDetailList().stream().map(OddAllocationDetailVO::getDetailAllocatedTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                oddAllocationVO.setAllocatedMny(allocatedMny);
                oddAllocationVO.setAllocatedTaxMny(allocatedTaxMny);
                oddAllocationVO.setAllocatedRatio(oddAllocationVO.getAllocatedMny().divide(oddAllocationVO.getFeeMny(), 8, 6).multiply(new BigDecimal(100)));
                oddAllocationVO.setTotalAllocatedMny(allocatedMny.add(oddAllocationVO.getHaveAllocatedMny()));
                oddAllocationVO.setTotalAllocatedTaxMny(allocatedTaxMny.add(oddAllocationVO.getHaveAllocatedTaxMny()));
                oddAllocationVO.setTotalAllocatedRatio(oddAllocationVO.getTotalAllocatedMny().divide(oddAllocationVO.getFeeMny(), 8, 6).multiply(new BigDecimal(100)));
                entityList.add(BeanMapper.map(entry.getValue(), OddAllocationEntity.class));
                detailEntityList.addAll(BeanMapper.mapList((Iterable)oddAllocationVO.getOddAllocationDetailList(), OddAllocationDetailEntity.class));
            }
        }
        for (OddAllocationEntity oddAllocationEntity : entityList) {
            oddAllocationEntity.setSourceType(1);
            if (null != oddAllocationEntity.getBillCode()) continue;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)oddAllocationEntity), OddAllocationVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u96f6\u661f\u8d39\u7528\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u96f6\u661f\u8d39\u7528\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            oddAllocationEntity.setBillCode((String)billCode.getData());
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        this.oddAllocationDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        return "\u4fdd\u5b58\u6210\u529f";
    }
}

