package com.ejianc.business.profinance.controller;

import java.io.Serializable;

import com.ejianc.business.profinance.bean.GlodonProjectRelateDetailEntity;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.GlodonProjectRelateDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.profinance.bean.GlodonProjectRelateEntity;
import com.ejianc.business.profinance.service.IGlodonProjectRelateService;
import com.ejianc.business.profinance.vo.GlodonProjectRelateVO;

/**
 * 一建广联达项目对应实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("glodonProjectRelate")
public class GlodonProjectRelateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_RELATE";//此处需要根据实际修改

    @Autowired
    private IGlodonProjectRelateService service;

    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISalaryService salaryService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GlodonProjectRelateVO> saveOrUpdate(@RequestBody GlodonProjectRelateVO saveOrUpdateVO) {
        GlodonProjectRelateEntity entity = BeanMapper.map(saveOrUpdateVO, GlodonProjectRelateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存项目对照失败，自动生成项目对照编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
        }
    	service.saveOrUpdate(entity, false);
    	GlodonProjectRelateVO vo = BeanMapper.map(entity, GlodonProjectRelateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GlodonProjectRelateVO> queryDetail(Long id) {
    	GlodonProjectRelateEntity entity = service.selectById(id);
    	GlodonProjectRelateVO vo = BeanMapper.map(entity, GlodonProjectRelateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GlodonProjectRelateVO> vos) {

        if(ListUtil.isNotEmpty(vos)){
            List<Long> ids = vos.stream().map(item -> item.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter(QueryParam.IN , ids));
            List<GlodonProjectRelateEntity> glodonProjectRelateEntityList = service.queryList(param);
            Map<Long, GlodonProjectRelateEntity> projectRelateEntityMap = glodonProjectRelateEntityList.stream().collect(Collectors.toMap(GlodonProjectRelateEntity::getProjectId, Function.identity(), (key1, key2) -> key2));
            List<Long> projectIds = glodonProjectRelateEntityList.stream().map(item -> item.getProjectId()).collect(Collectors.toList());
            QueryParam salaryQueryParam = new QueryParam();
            salaryQueryParam.getParams().put("project_id", new Parameter(QueryParam.IN , projectIds));
            salaryQueryParam.getParams().put("salary_detail_source_type", new Parameter(QueryParam.EQ, 0));
            List<SalaryEntity> salaryEntityList = salaryService.queryList(salaryQueryParam);
            if (CollectionUtils.isNotEmpty(salaryEntityList) && null != salaryEntityList.get(0)){
                if (projectRelateEntityMap.containsKey(salaryEntityList.get(0).getProjectId())){
                    String projectName = projectRelateEntityMap.get(salaryEntityList.get(0).getProjectId()).getProjectName();
                    return CommonResponse.error("项目<" + projectName + ">下已有工人工资单，不可删除！");
                }
            }
        }
        service.removeByIds(vos.stream().map(GlodonProjectRelateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GlodonProjectRelateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        IPage<GlodonProjectRelateEntity> page = service.queryPage(param,false);
        IPage<GlodonProjectRelateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GlodonProjectRelateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 查询当前项目是否已经和广联达项目进行过项目对照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/querySynchronizeFlagByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<GlodonProjectRelateVO>> querySynchronizeFlagByProjectId(@RequestParam String projectId) {
        List<GlodonProjectRelateEntity> glodonProjectRelateVOList = service.querySynchronizeFlagByProjectId(projectId);
        return CommonResponse.success("查询工人工资详情成功！", BeanMapper.mapList(glodonProjectRelateVOList, GlodonProjectRelateVO.class));
    }

    /**
     * @Description 参照 广联达项目列表详情参照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refGlodonProjectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refGlodonProjectList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) {
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);

        String projectId = conditionMap.get("projectId");
        if(StringUtils.isBlank(projectId)) {
            return CommonResponse.error("查询失败，缺少参数项目id-projectId！");
        }

        JSONObject page = service.getGlodonProjectList(Long.valueOf(projectId), pageNumber, pageSize, searchText);

        return CommonResponse.success("查询参照数据成功！", page);
    }


    /**
     * 获取广联达项目对照项目列表
     * @param condition
     * @return
     */
    @GetMapping("/glodonProjectTree")
    @ResponseBody
    public List<Map<String, Object>> glodonProjectTree(@RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")){
                Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        List<GlodonProjectRelateEntity> glodonProjectRelateEntityList = service.queryList(queryParam, false);
        List<GlodonProjectRelateDetailVO> relateDetailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(glodonProjectRelateEntityList) && null != glodonProjectRelateEntityList.get(0)){
            Long relateId = glodonProjectRelateEntityList.get(0).getId();
            GlodonProjectRelateEntity glodonProjectRelateEntity = service.selectById(relateId);
            if (CollectionUtils.isNotEmpty(glodonProjectRelateEntity.getDetailList())){
                relateDetailVOList = BeanMapper.mapList(glodonProjectRelateEntity.getDetailList(), GlodonProjectRelateDetailVO.class);
            }
        }

        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        if (CollectionUtils.isNotEmpty(relateDetailVOList)){
            for (GlodonProjectRelateDetailVO detailVO : relateDetailVOList) {
                map = new HashMap<>();
                map.put("id", detailVO.getGlodonProjectId());
                map.put("key", detailVO.getGlodonProjectId());
                map.put("name", detailVO.getGlodonProjectName());
                map.put("code", detailVO.getGlodonProjectCode());
                map.put("parentId", null);
                map.put("isTop", 1);
                map.put("glodonProjectId", detailVO.getGlodonProjectId());
                map.put("glodonProjectName", detailVO.getGlodonProjectName());
                map.put("glodonProjectCode", detailVO.getGlodonProjectCode());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

}
