package com.ejianc.business.profinance.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.service.IGlodonSalaryService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.utils.ReferTool;
import com.ejianc.business.profinance.vo.*;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.ISalaryService;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工人工资单主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salary")
public class SalaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISalaryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISalaryDetailService salaryDetailService;

    @Autowired
    private ISalaryPayApplyDetailService salaryPayApplyDetailService;

    @Autowired
    private IGlodonSalaryService glodonSalaryService;

    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;


    //工人工资单据
    private static final String SALARY = "/salaryV2/pageV2";

    //工人工资详情
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO salaryVO) {
        SalaryVO vo = service.insertOrUpdate(salaryVO);
        return CommonResponse.success("保存成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
    	SalaryEntity entity = service.selectById(id);
    	SalaryVO vo = BeanMapper.map(entity, SalaryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
//        for (SalaryVO vo : vos) {
//            QueryParam param = new QueryParam();
//            param.getParams().put("salaryId", new Parameter(QueryParam.EQ,vo.getId()));
//            List<SalaryPayApplyDetailEntity> list = salaryPayApplyDetailService.queryList(param);
//            if (CollectionUtils.isNotEmpty(list)){
//                return CommonResponse.error("单据编号-" + vo.getBillCode() + "工人工资单已被工资支付申请引用，不能删除！");
//            }
//        }
        service.removeByIds(vos.stream().map(SalaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("salaryDetailSourceType");
        //搜索：单据编号，项目名称，合同名称，乙方，经办人

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        logger.info("输出orgType:{},输出orgId:{}",InvocationInfoProxy.getOrgType(),orgId);
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SalaryEntity> page = service.queryPage(param,false);
        IPage<SalaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SalaryVO>> commonResponse = queryList(param);
        List<SalaryVO> salaryVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            salaryVOList = (List<SalaryVO>) commonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", salaryVOList);
        ExcelExport.getInstance().export("salary-export.xlsx", beans, response);
    }



    /**
     * @Description 获取工资汇总
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryTotalMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalaryVO> queryTotalMny(@RequestBody QueryParam param) {


        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        //搜索：单据编号，项目名称，合同名称，乙方，经办人

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        QueryWrapper<SalaryEntity> wrapper = changeToQueryWrapper(param);
        List<SalaryEntity> list = service.list(wrapper);
        BigDecimal reduce = list.stream().filter(s -> s.getTotalSalaryMny() != null).map(SalaryEntity::getTotalSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        SalaryVO salaryVO = new SalaryVO();
        salaryVO.setSumMny(reduce);
        return CommonResponse.success("获取工资汇总成功！",salaryVO);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "salaryDetail-import.xlsx", "工人工资单-导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }



    /**
     * @Description 导出工人工资单子表信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/salaryDetailExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void salaryDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response) {

        String salaryId = String.valueOf(paramMap.get("salaryId"));
        SalaryEntity salaryEntity = service.selectById(salaryId);
        List<SalaryDetailVO> salaryDetailVOList = new ArrayList<>();
        if (null != salaryEntity && CollectionUtils.isNotEmpty(salaryEntity.getSalaryDetailList())){
            salaryDetailVOList = BeanMapper.mapList(salaryEntity.getSalaryDetailList(), SalaryDetailVO.class);
        }

        if (CollectionUtils.isNotEmpty(salaryDetailVOList)) {
            salaryDetailVOList.forEach(salaryDetailVO -> {
                //设置计量方式
                //（0:计日，1计件 2：按小时 3：按月）
                if (salaryDetailVO.getMeasureType() != null){
                    switch (salaryDetailVO.getMeasureType()){
                        case 0 :
                            salaryDetailVO.setMeasureTypeName("按天");
                            break;
                        case 1 :
                            salaryDetailVO.setMeasureTypeName("计件");
                            break;
                        case 2 :
                            salaryDetailVO.setMeasureTypeName("按小时");
                            break;
                        case 3 :
                            salaryDetailVO.setMeasureTypeName("按月");
                            break;
                    }
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();

        beans.put("records", salaryDetailVOList);
        if (salaryEntity.getSalaryDetailSourceType().equals(1)){
            ExcelExport.getInstance().export("salaryDetail-export.xlsx", beans, response);
        }else {
            ExcelExport.getInstance().export("synchronizeSalaryDetail-export.xlsx", beans, response);
        }
    }



    /**
     * @Description 参照 广联达工人工资单参照 劳务实名制
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refGlodonSalaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refGlodonSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText,
                                                             String relyCondition) {

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);

        String year = conditionMap.get("year");
        String month = conditionMap.get("month");
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        Map<String, String> projectMap = new HashMap<>();
        parameterMap.keySet().forEach(key -> projectMap.put(key, String.valueOf(parameterMap.get(key).getValue())));
        String projectId = projectMap.get("glodonProjectId");
        if(StringUtils.isBlank(projectId)) {
            return CommonResponse.error("查询失败，缺少参数项目id-glodonProjectId！");
        }
        if(StringUtils.isBlank(year)) {
            return CommonResponse.error("查询失败，缺少参数年份-year！");
        }
        if(StringUtils.isBlank(month)) {
            return CommonResponse.error("查询失败，缺少参数月份-month！");
        }

        JSONObject page = glodonSalaryService.getSalary(projectId, year, month);

        return CommonResponse.success("查询参照数据成功！", page);
    }


    /**
     * @Description 参照 广联达工人工资详情参照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/getGlodonSalaryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SalaryDetailVO>> getGlodonSalaryDetail(String projectId, String year, String month, String ids) {
        List<SalaryDetailVO> salaryDetailVOList = glodonSalaryService.getSalaryDetail(projectId, null, year, month, ids);
        return CommonResponse.success("查询工人工资详情成功！", salaryDetailVOList);
    }


    /**
     * @Description 通过合同id获取工人工资单参照
     * 获取相同合同、欠发金额大于0、已提交或已审批的单据
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refSalaryDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalaryDetailVO>> refSalaryDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);

        String contractId = conditionMap.get("contractId");
        if(StringUtils.isBlank(contractId)) {
            return CommonResponse.error("查询失败，缺少参数合同id-contractId！");
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));

        IPage<SalaryDetailVO> pageData = new Page<>();

        List<SalaryEntity> salaryEntityList = service.queryList(param,false);
        List<Long> ids = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(salaryEntityList)){
            for (SalaryEntity salaryEntity : salaryEntityList) {
                ids.add(salaryEntity.getId());
                //todo：设置belongMonth为 yyyy-MM
            }
            if (CollectionUtils.isNotEmpty(ids)){
                QueryParam detailParam = new QueryParam();

                /** 模糊搜索配置字段示例 */
                List<String> fuzzyFields = detailParam.getFuzzyFields();
                fuzzyFields.add("salaryBillCode");
                fuzzyFields.add("belongMonth");
                fuzzyFields.add("workerName");
                fuzzyFields.add("teamName");
                fuzzyFields.add("groupName");
                fuzzyFields.add("bankName");
                fuzzyFields.add("workerIdCard");
                fuzzyFields.add("accountNum");

                detailParam.setPageSize(pageSize);
                detailParam.setPageIndex(pageNumber);
                detailParam.setSearchText(searchText);
                detailParam.setSearchObject(searchObject);
                detailParam.getParams().put("salary_id", new Parameter(QueryParam.IN, ids));
                detailParam.getParams().put("worker_remainder_tax_mny", new Parameter(QueryParam.GT, 0));
                IPage<SalaryDetailEntity> detailPage = salaryDetailService.queryPage(detailParam,false);
                pageData = new Page<>(detailPage.getCurrent(), detailPage.getSize(), detailPage.getTotal());
                pageData.setRecords(BeanMapper.mapList(detailPage.getRecords(), SalaryDetailVO.class));
            }
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description 通过合同id、日期获取工人工资单参照
     * @Return void
     * @return
     */
    @RequestMapping(value = "/refSalaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalarySettleVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        JSONObject _con = JSONObject.parseObject(condition);

        String contractId = _con.getString("contractId");
        if(StringUtils.isBlank(contractId)) {
            return CommonResponse.error("查询失败，缺少参数合同id-contractId！");
        }

        String settleDate = _con.getString("settleDate");
        if(StringUtils.isBlank(settleDate)) {
            return CommonResponse.error("查询失败，缺少参数结算时间-settleDate！");
        }

        String settleType = _con.getString("settleType");
        if(StringUtils.isBlank(settleType)) {
            return CommonResponse.error("查询失败，缺少参数结算类型-settleType！");
        }
        String settleId = _con.getString("settleId");

        /** 租户隔离 */

        LambdaQueryWrapper<SalaryEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SalaryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(SalaryEntity::getContractId, contractId);
        lambda.in(SalaryEntity::getBillState, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambda.le(SalaryEntity::getBelongMonth, settleDate);
        if ("0".equals(settleType)){//如果是过程结算,则查没有settleId的
            if (StringUtils.isNotBlank(settleId)){
                //如果有
                lambda.and(l -> l.isNull(SalaryEntity::getSettleId).or(c -> c.eq(SalaryEntity::getSettleId, settleId)));
            }else {
                lambda.isNull(SalaryEntity::getSettleId);
            }
        }
        lambda.orderByDesc(SalaryEntity::getBelongMonth);

        IPage<SalaryEntity> salaryEntityIPage = service.page(new Page<>(pageNumber,pageSize), lambda);
        IPage<SalarySettleVO> pageData = new Page<>(salaryEntityIPage.getCurrent(), salaryEntityIPage.getSize(), salaryEntityIPage.getTotal());
        List<SalaryEntity> salaryEntityList = salaryEntityIPage.getRecords();
        List<SalarySettleVO> salarySettleVOList = new ArrayList<>();
        //返回结算参照专用vo
        if (CollectionUtils.isNotEmpty(salaryEntityList)){
            for (SalaryEntity salaryEntity : salaryEntityList) {
                SalarySettleVO salarySettleVO = new SalarySettleVO();
                salarySettleVO.setBelongMonth(salaryEntity.getBelongMonth());
                salarySettleVO.setContractId(salaryEntity.getContractId());
                salarySettleVO.setSalaryMny(salaryEntity.getTotalSalaryMny());
                salarySettleVO.setSumSalaryMny(salaryEntity.getTotalSalaryMny());
                salarySettleVO.setSourceId(salaryEntity.getId());
                salarySettleVO.setSourceBillCode(salaryEntity.getBillCode());
                salarySettleVOList.add(salarySettleVO);
            }
        }

        pageData.setRecords(salarySettleVOList);
        return CommonResponse.success("查询参照数据成功！",pageData);
    }



    /**
     * 查看引用代码开始------------------
     */

    @GetMapping(value = "/getReferenceMap")
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type,
                                                                @RequestParam Long id) {
        //准备查询参数
//      Map<billTypeCode, selectSql>
        Map<String, String> queryParam = getQueryDataParam(id.toString());

        //查询匹配的数据
        CommonResponse<Map<String, List<JSONObject>>> dataResp = mdApi.queryDataList(queryParam);
        if(!dataResp.isSuccess()) {
            logger.error("根据合同id-{}获取引用单据信息列表失败{}", id, dataResp.getMsg());
            return CommonResponse.error("查询引用结算单的单据信息列表失败！");
        }

        //匹配数据转换
        List<ReferenceMapVO> resp = getReferenceMapData(dataResp.getData());

        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        Map<String, String> queryParam = new HashMap<>();
        StringBuilder sp = new StringBuilder();

        //查询引用合同的月度结算    结算类型：0-月度，1-完工，2-节点
        sp = new StringBuilder();
        sp.append("select  id, create_user_code, create_time, bill_code, org_name,bill_state,tax_mny as mny  from ejc_prosub_settle ")
                .append("where id in (select DISTINCT settle_id from ejc_prosub_settle_salary where source_id = ")
                .append(id).append(" and dr =0 ) and dr = 0 and settle_type = 0");
        queryParam.put("BT220114000000002", sp.toString());

        //查询引用合同的最终结算    结算类型：0-月度，1-完工，2-节点
        sp = new StringBuilder();
        sp.append("select  id, create_user_code, create_time, bill_code, org_name,bill_state,tax_mny as mny  from ejc_prosub_settle ")
                .append("where id in (select DISTINCT settle_id from ejc_prosub_settle_salary where source_id = ")
                .append(id).append(" and dr =0 ) and dr = 0 and settle_type = 1");
        queryParam.put("BT220114000000004", sp.toString());



        //查询引用合同的工人工资付款申请
        sp = new StringBuilder();
        sp.append("select  id, create_user_code, create_time, bill_code, org_name,bill_state,apply_mny as mny  from ejc_profinance_salary_pay_apply ")
                .append("where id in (select DISTINCT pid from ejc_profinance_salary_pay_apply_detail where salary_id = ")
                .append(id).append(" and dr =0 ) and dr = 0");
        queryParam.put("EJCBT202204000000010", sp.toString());


        return queryParam;
    }



    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        List<ReferenceMapVO> resp = new ArrayList<>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;

        Set<String> userCodes = new HashSet<>();
        for(String billType : data.keySet()) {
            dataList = data.get(billType);
            if(CollectionUtils.isNotEmpty(dataList)) {
                String billName = "";
                String billUrl = "";
                switch (billType){
                    case "BT220114000000002":
                        billName = "月度结算";
                        billUrl = "ejc-prosub-frontend/#/processSettle/laborsub/card?id=";
                        break;
                    case "BT220114000000004":
                        billName = "最终结算";
                        billUrl = "ejc-prosub-frontend/#/finishSettle/laborsub/card?id=";
                        break;
                    case "EJCBT202204000000010":
                        billName = "工人工资付款申请";
                        billUrl = "ejc-profinance-frontend/#/salaryPayApplyList/salaryPayApplyCard?id=";
                        break;
                }

                tmp = new ReferenceMapVO();
                tmp.setId(billType); //数据唯一标识
                tmp.setModuleName(billName); //模块名称
                tmp.setReferenceNum(dataList.size()); //引用单据数量
                BigDecimal sumMny = new BigDecimal(0);
                for(JSONObject dataRow : dataList) {
                    tmpDetail = new ReferenceDetailVO();
                    tmpDetail.setId(dataRow.getString("id")); //数据唯一标识
                    tmpDetail.setBillCode(dataRow.getString("bill_code")); //单据编码
                    tmpDetail.setBillState(BillStateEnum.getEnumByStateCode(dataRow.getInteger("bill_state")).getDescription()); //单据审批状态
                    tmpDetail.setCreateTime(dataRow.getDate("create_time")); //制单时间
                    tmpDetail.setEmployeeName(dataRow.getString("create_user_code")); //制单人
                    tmpDetail.setModuleName(tmp.getModuleName()); //节点名称
                    tmpDetail.setOrgName(dataRow.getString("org_name")); //制单机构
                    tmpDetail.setMny(dataRow.getBigDecimal("mny")); //金额
                    //穿透详情页地址
                    tmpDetail.setDetailPcUrl(BaseHost + billUrl + tmpDetail.getId());
                    tmp.getDetailList().add(tmpDetail);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(tmpDetail.getEmployeeName())) {
                        userCodes.add(tmpDetail.getEmployeeName());
                    }

                    if (tmpDetail.getMny() != null) {
                        sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
                    }

                }
                //单据的总金额
                tmp.setSumMny(sumMny);

                resp.add(tmp);
            }
        }

        //根据制单人编码查询制单人信息
        if(CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse<List<UserVO>> userResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if(!userResp.isSuccess()) {
                logger.error("根据用户编码获取用户信息失败：{}", userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = userResp.getData().stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> {
                    item.getDetailList().stream().forEach(detail -> {
                        if(userMap.containsKey(detail.getEmployeeName())) {
                            detail.setEmployeeName(userMap.get(detail.getEmployeeName()).getUserName());
                        }
                    });
                });
            }
        }

        return resp;
    }

    /**
     * 查看引用代码结束------------------
     */

}
