/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailWorkerEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.enums.PMPayStateEnum;
import com.ejianc.business.profinance.enums.SalaryDetailWorkerPayStateEnum;
import com.ejianc.business.profinance.enums.SalaryPayStateEnum;
import com.ejianc.business.profinance.mapper.PaymentApplyMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailWorkerMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyMapper;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailWorkerService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="salaryPayApplyService")
public class SalaryPayApplyServiceImpl
extends BaseServiceImpl<SalaryPayApplyMapper, SalaryPayApplyEntity>
implements ISalaryPayApplyService {
    @Autowired
    private PaymentApplyMapper paymentApplyMapper;
    @Autowired
    private IPaymentApplyService paymentApplyService;
    @Autowired
    private SalaryPayApplyDetailMapper salaryPayApplyDetailMapper;
    @Autowired
    private SalaryPayApplyDetailWorkerMapper salaryPayApplyDetailWorkerMapper;
    @Autowired
    private SalaryPayApplyMapper salaryPayApplyMapper;
    @Autowired
    private ISalaryPayApplyDetailService salaryPayApplyDetailService;
    @Autowired
    private ISalaryPayApplyDetailWorkerService salaryPayApplyDetailWorkerService;
    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private ISettlePoolApi iSettlePoolApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalaryService salaryService;
    @Autowired
    private IPayrollRegisterService payrollRegisterService;

    @Override
    public List<PaymentApplyVO> queryPaymentByContractIdAndBillState(Long id, Long tenantId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"bill_state", (Object)0)).eq((Object)"payment_contract_flag", (Object)0)).eq((Object)"contract_id", (Object)id)).eq((Object)"tenant_id", (Object)tenantId);
        return BeanMapper.mapList((Iterable)this.paymentApplyMapper.selectList((Wrapper)wrapper), PaymentApplyVO.class);
    }

    @Override
    public SalaryPayApplyEntity selectById2(Serializable id) {
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)super.selectById(id));
        if (salaryPayApplyEntity == null) {
            return null;
        }
        if (salaryPayApplyEntity.getBillState() == 0) {
            return salaryPayApplyEntity;
        }
        QueryWrapper adjustWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)adjustWrapper.eq((Object)"bill_code_old", (Object)salaryPayApplyEntity.getBillCode())).eq((Object)"is_repeat_bill", (Object)1)).eq((Object)"tenant_id", (Object)salaryPayApplyEntity.getTenantId());
        adjustWrapper.orderByDesc((Object)"create_time");
        List adjustDetailEntityList = this.salaryPayApplyMapper.selectList((Wrapper)adjustWrapper);
        List<SalaryPayApplyDetailEntity> salaryList = salaryPayApplyEntity.getSalaryList();
        if (!this.repeatCheck(salaryPayApplyEntity) || salaryPayApplyEntity.getIsClose() == 1) {
            salaryPayApplyEntity.setRepeatState(0);
        } else if (CollectionUtils.isEmpty((Collection)adjustDetailEntityList)) {
            salaryPayApplyEntity.setRepeatState(2);
        } else {
            SalaryPayApplyEntity adjustEntity = (SalaryPayApplyEntity)((Object)super.selectById((Serializable)((SalaryPayApplyEntity)((Object)adjustDetailEntityList.get(0))).getId()));
            if (null != adjustEntity && !this.repeatCheck(adjustEntity)) {
                salaryPayApplyEntity.setRepeatState(1);
            } else {
                salaryPayApplyEntity.setRepeatState(2);
            }
        }
        return salaryPayApplyEntity;
    }

    public boolean repeatCheck(SalaryPayApplyEntity salaryPayApplyEntity) {
        Boolean repeatFlag = false;
        if (SalaryPayStateEnum.\u5f85\u652f\u4ed8.getCode().equals(salaryPayApplyEntity.getPayState().toString()) || SalaryPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(salaryPayApplyEntity.getPayState().toString()) || SalaryPayStateEnum.\u652f\u4ed8\u4e2d.getCode().equals(salaryPayApplyEntity.getPayState().toString())) {
            return false;
        }
        if (SalaryPayStateEnum.\u90e8\u5206\u652f\u4ed8.getCode().equals(salaryPayApplyEntity.getPayState().toString())) {
            List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = salaryPayApplyEntity.getSalaryList();
            if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)) {
                int successNum = 0;
                int fileNum = 0;
                for (SalaryPayApplyDetailEntity detailEntity : salaryPayApplyDetailEntityList) {
                    if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(detailEntity.getWorkerPayState().toString())) {
                        ++successNum;
                        continue;
                    }
                    if (!SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(detailEntity.getWorkerPayState().toString())) continue;
                    ++fileNum;
                }
                if (salaryPayApplyDetailEntityList.size() == successNum + fileNum) {
                    repeatFlag = true;
                }
            }
        } else if (SalaryPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(salaryPayApplyEntity.getPayState().toString())) {
            repeatFlag = true;
        }
        return repeatFlag;
    }

    @Override
    public boolean queryAdjustByContractId(String billCode) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"is_repeat_bill", (Object)1)).eq((Object)"bill_code_old", (Object)billCode)).in((Object)"bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode()));
        List detailEntityList = this.salaryPayApplyMapper.selectList((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)detailEntityList);
    }

    @Override
    public Map<String, Object> queryIsCompleteApply(Long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("state", 0);
        result.put("entity", null);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)id);
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)super.selectById((Serializable)id));
        if (salaryPayApplyEntity == null) {
            return result;
        }
        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = salaryPayApplyEntity.getSalaryList();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)) {
            List sucList = salaryPayApplyDetailEntityList.stream().filter(item -> item.getWorkerPayState() == 1).collect(Collectors.toList());
            List falList = salaryPayApplyDetailEntityList.stream().filter(item -> item.getWorkerPayState() == 3).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sucList) && sucList.size() == salaryPayApplyDetailEntityList.size()) {
                result.put("state", 1);
            } else if (CollectionUtils.isNotEmpty(falList) && falList.size() == salaryPayApplyDetailEntityList.size()) {
                result.put("state", 3);
            } else {
                result.put("state", 2);
            }
            result.put("entity", (Object)salaryPayApplyEntity);
        }
        return result;
    }

    @Override
    public List<SalaryPayApplyEntity> queryApplyByContractId(Long contractId) {
        QueryWrapper salaryPayApplyEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)salaryPayApplyEntityQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"dr", (Object)0)).eq((Object)"contract_id", (Object)contractId)).notIn((Object)"bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        return this.salaryPayApplyMapper.selectList((Wrapper)salaryPayApplyEntityQueryWrapper);
    }

    @Override
    public void deleteData(List<SalaryPayApplyVO> vos) {
        List detailIds;
        List billCodeList = vos.stream().map(SalaryPayApplyVO::getBillCode).collect(Collectors.toList());
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper salaryPayApplyEntityQueryWrapper = new QueryWrapper();
        salaryPayApplyEntityQueryWrapper.in((Object)"bill_code_old", billCodeList);
        List<Object> adjustIds = new ArrayList();
        ArrayList allIds = new ArrayList(idList);
        List salaryPayApplyEntities = this.salaryPayApplyMapper.selectList((Wrapper)salaryPayApplyEntityQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyEntities)) {
            adjustIds = salaryPayApplyEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            allIds.addAll(adjustIds);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"pid", allIds);
        List salaryPayApplyDetailEntityList = this.salaryPayApplyDetailMapper.selectList((Wrapper)wrapper);
        QueryWrapper wrapperDetail = new QueryWrapper();
        wrapper.in((Object)"pid", allIds);
        List salaryPayApplyDetailDetailEntityList = this.salaryPayApplyDetailWorkerMapper.selectList((Wrapper)wrapperDetail);
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailEntityList) && CollectionUtils.isEmpty((Collection)salaryPayApplyDetailDetailEntityList)) {
            this.salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList((Iterable)salaryPayApplyDetailEntityList, SalaryPayApplyDetailVO.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailDetailEntityList)) {
            this.salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList((Iterable)salaryPayApplyDetailDetailEntityList, SalaryPayApplyDetailVO.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailEntityList)) {
            detailIds = salaryPayApplyDetailEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.salaryPayApplyDetailService.removeByIds(detailIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailDetailEntityList)) {
            detailIds = salaryPayApplyDetailDetailEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.salaryPayApplyDetailWorkerService.removeByIds(detailIds);
        }
        super.removeByIds(allIds);
    }

    @Override
    public Map<String, BigDecimal> getContractSalaryApplyInfo(Long contractId) {
        HashMap<String, BigDecimal> info = new HashMap<String, BigDecimal>();
        QueryWrapper applyQuery = new QueryWrapper();
        applyQuery.select(new String[]{"sum( actual_paid_tax_mny ) AS totalActualPaidTaxMny, sum( apply_tax_mny ) as lastApplyTaxMny"});
        applyQuery.eq((Object)"contract_id", (Object)contractId);
        applyQuery.eq((Object)"is_repeat_bill", (Object)"0");
        Map applyResult = super.getMap((Wrapper)applyQuery);
        info.put("totalActualPaidTaxMny", null != applyResult && null != applyResult.get("totalActualPaidTaxMny") ? new BigDecimal(applyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("lastApplyTaxMny", null != applyResult && null != applyResult.get("lastApplyTaxMny") ? new BigDecimal(applyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);
        applyQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        Map validApplyResult = super.getMap((Wrapper)applyQuery);
        QueryWrapper payApplyQuery = new QueryWrapper();
        payApplyQuery.select(new String[]{"sum( actual_mny ) AS totalActualPaidTaxMny, sum( approval_mny ) as totalApproveTaxMny"});
        payApplyQuery.eq((Object)"contract_id", (Object)contractId);
        payApplyQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        Map validPayApplyResult = this.paymentApplyService.getMap((Wrapper)payApplyQuery);
        info.put("totalContractActualPaidTaxMny", null != validApplyResult && null != validApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractApproveTaxMny", null != validApplyResult && null != validApplyResult.get("lastApplyTaxMny") ? new BigDecimal(validApplyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractActualPaidTaxMny", ((BigDecimal)info.get("totalContractActualPaidTaxMny")).add(null != validPayApplyResult && null != validPayApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validPayApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO));
        info.put("totalContractApproveTaxMny", ((BigDecimal)info.get("totalContractApproveTaxMny")).add(null != validPayApplyResult && null != validPayApplyResult.get("totalApproveTaxMny") ? new BigDecimal(validPayApplyResult.get("totalApproveTaxMny").toString()) : BigDecimal.ZERO));
        QueryWrapper salaryQuery = new QueryWrapper();
        salaryQuery.select(new String[]{"sum(total_salary_mny) AS totalShouldPayTaxMny"});
        salaryQuery.eq((Object)"contract_id", (Object)contractId);
        salaryQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map salaryResult = this.salaryService.getMap((Wrapper)salaryQuery);
        info.put("totalShouldPayTaxMny", null != salaryResult && null != salaryResult.get("totalShouldPayTaxMny") ? new BigDecimal(salaryResult.get("totalShouldPayTaxMny").toString()) : BigDecimal.ZERO);
        info.put("curCanApplyTaxMny", ((BigDecimal)info.get("totalShouldPayTaxMny")).subtract((BigDecimal)info.get("lastApplyTaxMny")));
        return info;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessage(String salaryPayApplyResultMsg) {
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u7533\u8bf7\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--begin\uff01");
        this.logger.info("\u4ece\u6d88\u606f\u961f\u5217\u4e2d\u83b7\u53d6\u5230\u5f85\u5904\u7406\u7684\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank((CharSequence)salaryPayApplyResultMsg)) {
            List resultList = JSONObject.parseArray((String)salaryPayApplyResultMsg, PMSalaryPayApplyDetailVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5de5\u8d44\u652f\u4ed8\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            List salaryPayApplyDetailList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                List payApplyDetailIds = resultList.stream().map(PMSalaryPayApplyDetailVO::getId).distinct().collect(Collectors.toList());
                Map<String, String> payStateResultMap = resultList.stream().collect(Collectors.toMap(PMSalaryPayApplyDetailVO::getId, PMSalaryPayApplyDetailVO::getPayState, (key1, key2) -> key2));
                if (CollectionUtils.isNotEmpty(payApplyDetailIds)) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("pm_pay_apply_detail_id", new Parameter("in", payApplyDetailIds));
                    salaryPayApplyDetailList = this.salaryPayApplyDetailService.queryList(param);
                }
                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailList)) {
                    this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u9700\u8981\u66f4\u65b0\u72b6\u6001\u7684\u5b50\u8868\u4fe1\u606f-\u66f4\u65b0\u524d\uff1a{}", (Object)JSONObject.toJSONString(salaryPayApplyDetailList));
                    ArrayList<SalaryPayApplyDetailEntity> noRepeatDetailList = new ArrayList<SalaryPayApplyDetailEntity>();
                    ArrayList noRepeatDetailWorkerList = new ArrayList();
                    for (SalaryPayApplyDetailEntity detailEntity : salaryPayApplyDetailList) {
                        List salaryPayApplyDetailWorkerEntities = null;
                        if (detailEntity.getSalaryIds() != null) {
                            QueryParam oldDetailDataQuery = new QueryParam();
                            oldDetailDataQuery.getParams().put("id", new Parameter("in", Arrays.asList(detailEntity.getSalaryIds().split(","))));
                            salaryPayApplyDetailWorkerEntities = this.salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                        }
                        String curState = null;
                        if (!payStateResultMap.containsKey(detailEntity.getPmPayApplyDetailId())) continue;
                        curState = payStateResultMap.get(detailEntity.getPmPayApplyDetailId());
                        if (null != curState && this.checkPayState(curState, detailEntity.getWorkerPayState())) {
                            this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4e0d\u9700\u8981\u66f4\u65b0\u72b6\u6001\u7684\u5b50\u8868\u4fe1\u606f\uff08\u652f\u4ed8\u72b6\u6001\u548c\u4e4b\u524d\u4e00\u6837\uff09\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)detailEntity)));
                            continue;
                        }
                        switch (PMPayStateEnum.getEnumByCode(curState)) {
                            case \u5f85\u652f\u4ed8: {
                                detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u5f85\u652f\u4ed8.getCode()));
                                if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) break;
                                for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u5f85\u652f\u4ed8.getCode()));
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());
                                }
                                break;
                            }
                            case \u652f\u4ed8\u6210\u529f: {
                                this.logger.info("\u5de5\u8d44\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\uff1a\u5b50\u8868[id-{}]\u73b0\u53d8\u66f4\u4e3a\u6210\u529f", (Object)detailEntity.getId());
                                detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode()));
                                detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                                detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                                detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                detailEntity.setRecordRegister(true);
                                if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) break;
                                for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode()));
                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTaxMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                    salaryPayApplyDetailWorkerEntity.setRecordRegister(true);
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());
                                }
                                break;
                            }
                            case \u652f\u4ed8\u5931\u8d25: {
                                if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(detailEntity.getWorkerPayState().toString())) {
                                    this.logger.info("\u5de5\u8d44\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\uff1a\u5b50\u8868[id-{}]\u539f\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u73b0\u53d8\u66f4\u4e3a\u5931\u8d25", (Object)detailEntity.getId());
                                    detailEntity.setRecordRegister(true);
                                    detailEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                    detailEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                    detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                }
                                detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode()));
                                if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) break;
                                for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                    if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(salaryPayApplyDetailWorkerEntity.getWorkerPayState().toString())) {
                                        this.logger.info("\u5de5\u8d44\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\uff1a\u5b50\u8868[id-{}]\u539f\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u73b0\u53d8\u66f4\u4e3a\u5931\u8d25", (Object)salaryPayApplyDetailWorkerEntity.getId());
                                        salaryPayApplyDetailWorkerEntity.setRecordRegister(true);
                                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                    }
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode()));
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());
                                }
                                break;
                            }
                            case \u94f6\u884c\u652f\u4ed8\u4e2d: {
                                detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u94f6\u884c\u652f\u4ed8\u4e2d.getCode()));
                                if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) break;
                                for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.\u94f6\u884c\u652f\u4ed8\u4e2d.getCode()));
                                    salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());
                                }
                                break;
                            }
                        }
                        detailEntity.setWorkerPayDate(new Date());
                        noRepeatDetailList.add(detailEntity);
                        if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) continue;
                        noRepeatDetailWorkerList.addAll(salaryPayApplyDetailWorkerEntities);
                    }
                    if (CollectionUtils.isNotEmpty(noRepeatDetailList)) {
                        ArrayList<SalaryPayApplyDetailEntity> needUpdateList = new ArrayList<SalaryPayApplyDetailEntity>();
                        needUpdateList.addAll(noRepeatDetailList);
                        ArrayList needUpdateDetailList = new ArrayList();
                        needUpdateDetailList.addAll(noRepeatDetailWorkerList);
                        List sucList = noRepeatDetailList.stream().filter(SalaryPayApplyDetailEntity::getRecordRegister).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(sucList)) {
                            Map<Long, SalaryPayApplyDetailEntity> repeatMap;
                            ArrayList<Long> oldIds;
                            List repeatList = sucList.stream().filter(item -> item.getWorkerIsRepeatBill() == 1).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(repeatList) && CollectionUtils.isNotEmpty(oldIds = new ArrayList<Long>((repeatMap = repeatList.stream().collect(Collectors.toMap(item -> item.getIdOld(), item -> item))).keySet()))) {
                                QueryParam oldDataQuery = new QueryParam();
                                oldDataQuery.getParams().put("id", new Parameter("in", oldIds));
                                List oldDataList = this.salaryPayApplyDetailService.queryList(oldDataQuery);
                                if (CollectionUtils.isNotEmpty((Collection)oldDataList)) {
                                    for (SalaryPayApplyDetailEntity detailEntity : oldDataList) {
                                        detailEntity.setWorkerPayState(repeatMap.get(detailEntity.getId()).getWorkerPayState());
                                        if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(repeatMap.get(detailEntity.getId()).getWorkerPayState().toString())) {
                                            detailEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                            detailEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                        } else {
                                            detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                                            detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                                        }
                                        detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                        if (detailEntity.getSalaryIds() == null) continue;
                                        QueryParam oldDetailDataQuery = new QueryParam();
                                        oldDetailDataQuery.getParams().put("id", new Parameter("in", Arrays.asList(detailEntity.getSalaryIds().split(","))));
                                        List salaryPayApplyDetailWorkerEntities = this.salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                                        if (!CollectionUtils.isNotEmpty((Collection)salaryPayApplyDetailWorkerEntities)) continue;
                                        for (SalaryPayApplyDetailWorkerEntity detailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                            detailWorkerEntity.setWorkerPayState(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState());
                                            if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState().toString())) {
                                                detailWorkerEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                                detailWorkerEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                            } else {
                                                detailWorkerEntity.setWorkerActualPaidTaxMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                                detailWorkerEntity.setWorkerActualPaidMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                            }
                                            detailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                        }
                                        needUpdateDetailList.addAll(salaryPayApplyDetailWorkerEntities);
                                    }
                                    this.logger.info("\u66f4\u65b0\u539f\u652f\u4ed8\u7533\u8bf7\u5b50\u8868\u7684\u76f8\u5173\u652f\u4ed8\u6570\u636e\uff1a{}", (Object)oldDataList.toString());
                                    needUpdateList.addAll(oldDataList);
                                }
                            }
                            this.payrollRegisterService.generateBatchPayrollRegister(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));
                            List collect = noRepeatDetailWorkerList.stream().filter(SalaryPayApplyDetailWorkerEntity::getRecordRegister).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(collect)) {
                                this.salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));
                            } else {
                                this.salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(collect, SalaryPayApplyDetailVO.class));
                            }
                        }
                        this.salaryPayApplyDetailService.saveOrUpdateBatch(needUpdateList, needUpdateList.size(), false);
                        this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u66f4\u65b0\u72b6\u6001\u540e\u7684\u5b50\u8868\u4fe1\u606f\u8fdb\u884c\u4fdd\u5b58-\u66f4\u65b0\u540e\uff1a{}", (Object)JSONObject.toJSONString(noRepeatDetailList));
                        this.salaryPayApplyDetailWorkerService.saveOrUpdateBatch(needUpdateDetailList, needUpdateDetailList.size(), false);
                        this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u66f4\u65b0\u72b6\u6001\u540e\u7684\u660e\u7ec6\u5b50\u8868\u4fe1\u606f\u8fdb\u884c\u4fdd\u5b58-\u66f4\u65b0\u540e\uff1a{}", (Object)JSONObject.toJSONString(needUpdateDetailList));
                        this.resetMainPayState(needUpdateList);
                    }
                }
            }
        }
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--end\uff01");
    }

    @Override
    public String isNewestApplyById(Long applyId) {
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)super.selectById((Serializable)applyId));
        QueryWrapper salaryPayApplyEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)salaryPayApplyEntityQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"dr", (Object)0)).eq((Object)"contract_id", (Object)salaryPayApplyEntity.getContractId())).gt((Object)"create_time", (Object)salaryPayApplyEntity.getCreateTime());
        List salaryPayApplyEntities = this.salaryPayApplyMapper.selectList((Wrapper)salaryPayApplyEntityQueryWrapper);
        if (salaryPayApplyEntities != null && salaryPayApplyEntities.size() > 0) {
            return "\u5173\u95ed\u5931\u8d25,\u5f53\u524d\u5408\u540c\u4e0b\u5df2\u5b58\u5728\u65b0\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff01";
        }
        List<SalaryPayApplyDetailEntity> salaryList = salaryPayApplyEntity.getSalaryList();
        if (salaryList != null && salaryList.size() > 0) {
            List collect = salaryList.stream().filter(u -> u.getWorkerPayState() == 3).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList(collect, SalaryPayApplyDetailVO.class));
            }
            BigDecimal reduce = collect.stream().map(SalaryPayApplyDetailEntity::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            salaryPayApplyEntity.setApplyTaxMny(salaryPayApplyEntity.getApplyTaxMny().subtract(reduce));
            salaryPayApplyEntity.setIsClose(1);
            super.saveOrUpdate((Object)salaryPayApplyEntity);
        }
        return "\u5173\u95ed\u6210\u529f";
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<SalaryPayApplyDetailVO> successList = new ArrayList<SalaryPayApplyDetailVO>();
            ArrayList<SalaryPayApplyDetailVO> errorList = new ArrayList<SalaryPayApplyDetailVO>();
            int sucNum = 0;
            String warnType = "";
            for (int i = 1; i < result.size(); ++i) {
                int flag;
                List datas = (List)result.get(i);
                SalaryPayApplyDetailVO vo = new SalaryPayApplyDetailVO();
                SalaryPayApplyDetailEntity salaryDetailEntity = new SalaryPayApplyDetailEntity();
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    flag = i + 2;
                    warnType = warnType + "\u7b2c" + flag + "\u884c\u4e3b\u952e\u9519\u8bef,";
                } else {
                    salaryDetailEntity = (SalaryPayApplyDetailEntity)((Object)this.salaryPayApplyDetailService.selectById(Long.valueOf((String)datas.get(1))));
                }
                if (salaryDetailEntity != null && salaryDetailEntity.getId() != null) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                        vo.setWorkerBankName(null);
                        flag = i + 2;
                        warnType = warnType + "\u7b2c" + flag + "\u884c[\u5f00\u6237\u884c\u4e3a\u7a7a]";
                    } else {
                        salaryDetailEntity.setWorkerBankName((String)datas.get(3));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                        BigDecimal workerApplyTaxMny;
                        BigDecimal workerRemainderTaxMny = salaryDetailEntity.getWorkerRemainderTaxMny();
                        if (workerRemainderTaxMny.compareTo(workerApplyTaxMny = new BigDecimal((String)datas.get(7))) < 0) {
                            salaryDetailEntity.setWorkerApplyTaxMny(workerRemainderTaxMny);
                        } else {
                            salaryDetailEntity.setWorkerApplyTaxMny(workerApplyTaxMny);
                        }
                    } else {
                        salaryDetailEntity.setWorkerApplyTaxMny(new BigDecimal(0.0));
                        flag = i + 2;
                        warnType = warnType + "\u7b2c" + flag + "\u884c[\u672c\u671f\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a]";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                        BigDecimal workerApplyTax = new BigDecimal((String)datas.get(8));
                        salaryDetailEntity.setWorkerApplyTax(workerApplyTax);
                        salaryDetailEntity.setWorkerApplyMny(salaryDetailEntity.getWorkerApplyTaxMny().add(workerApplyTax));
                    } else {
                        salaryDetailEntity.setWorkerApplyTax(new BigDecimal(0.0));
                        salaryDetailEntity.setWorkerApplyMny(salaryDetailEntity.getWorkerApplyTaxMny());
                    }
                    ++sucNum;
                } else {
                    flag = i + 2;
                    warnType = warnType + "\u7b2c" + flag + "\u884c\u4e3b\u952e\u9519\u8bef,";
                }
                vo.setRowState("add");
                vo = (SalaryPayApplyDetailVO)BeanMapper.map((Object)((Object)salaryDetailEntity), SalaryPayApplyDetailVO.class);
                successList.add(vo);
                if (!StringUtils.isNotEmpty((CharSequence)warnType)) continue;
                errorList.add(vo);
            }
            JSONObject resp = new JSONObject();
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)warnType);
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private void resetMainPayState(List<SalaryPayApplyDetailEntity> noRepeatDetailList) {
        List salaryPayApplyList = new ArrayList();
        List salaryPayApplyIds = noRepeatDetailList.stream().map(SalaryPayApplyDetailEntity::getPid).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(salaryPayApplyIds)) {
            LinkedHashMap detailMap = new LinkedHashMap();
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", salaryPayApplyIds));
            List detailResultList = this.salaryPayApplyDetailService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)detailResultList)) {
                this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u9700\u8981\u66f4\u65b0\u72b6\u6001\u7684\u4e3b\u8868-\u66f4\u65b0\u524d\uff1a{}", (Object)JSONObject.toJSONString((Object)detailResultList));
                for (SalaryPayApplyDetailEntity detail : detailResultList) {
                    if (detailMap.containsKey(detail.getPid())) {
                        ((List)detailMap.get(detail.getPid())).add(detail);
                        continue;
                    }
                    ArrayList<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = new ArrayList<SalaryPayApplyDetailEntity>();
                    salaryPayApplyDetailEntityList.add(detail);
                    detailMap.put(detail.getPid(), salaryPayApplyDetailEntityList);
                }
                QueryParam salaryPayApplyQueryParam = new QueryParam();
                salaryPayApplyQueryParam.getParams().put("id", new Parameter("in", salaryPayApplyIds));
                salaryPayApplyList = super.queryList(salaryPayApplyQueryParam);
                if (CollectionUtils.isNotEmpty(salaryPayApplyList)) {
                    for (SalaryPayApplyEntity salaryPayApplyEntity : salaryPayApplyList) {
                        BigDecimal curTotalActualPaidTaxMny = BigDecimal.ZERO;
                        BigDecimal curTotalActualPaidTMny = BigDecimal.ZERO;
                        BigDecimal curTotalActualPaidTax = BigDecimal.ZERO;
                        if (detailMap.containsKey(salaryPayApplyEntity.getId())) {
                            salaryPayApplyEntity.getSalaryList().addAll((Collection)detailMap.get(salaryPayApplyEntity.getId()));
                        }
                        this.logger.info("\u4e3b\u8868id\uff1a{}\uff0c\u4e3b\u8868\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u6539\u53d8\u6570\u503c\u524d\uff1a{}", (Object)salaryPayApplyEntity.getId(), (Object)salaryPayApplyEntity.getActualPaidTaxMny());
                        if (CollectionUtils.isNotEmpty(salaryPayApplyEntity.getSalaryList())) {
                            int successNum = 0;
                            int fileNum = 0;
                            int payingNum = 0;
                            int waitPayNum = 0;
                            List<SalaryPayApplyDetailEntity> payApplyDetailList = salaryPayApplyEntity.getSalaryList();
                            for (SalaryPayApplyDetailEntity detailEntity : payApplyDetailList) {
                                switch (SalaryDetailWorkerPayStateEnum.getEnumByCode(detailEntity.getWorkerPayState().toString())) {
                                    case \u5f85\u652f\u4ed8: {
                                        ++waitPayNum;
                                        break;
                                    }
                                    case \u652f\u4ed8\u6210\u529f: {
                                        curTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(null == detailEntity.getWorkerActualPaidTaxMny() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidTaxMny());
                                        curTotalActualPaidTMny = curTotalActualPaidTMny.add(null == detailEntity.getWorkerActualPaidMny() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidMny());
                                        curTotalActualPaidTax = curTotalActualPaidTax.add(null == detailEntity.getWorkerActualPaidTax() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidTax());
                                        ++successNum;
                                        break;
                                    }
                                    case \u94f6\u884c\u652f\u4ed8\u4e2d: {
                                        ++payingNum;
                                        break;
                                    }
                                    case \u652f\u4ed8\u5931\u8d25: {
                                        ++fileNum;
                                    }
                                }
                            }
                            salaryPayApplyEntity.setActualPaidTaxMny(curTotalActualPaidTaxMny);
                            salaryPayApplyEntity.setActualPaidMny(curTotalActualPaidTMny);
                            salaryPayApplyEntity.setActualPaidTax(curTotalActualPaidTax);
                            salaryPayApplyEntity.setPayDate(new Date());
                            if (payApplyDetailList.size() == successNum) {
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode()));
                            } else if (payApplyDetailList.size() == fileNum) {
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode()));
                            } else if (payApplyDetailList.size() == waitPayNum) {
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.\u5f85\u652f\u4ed8.getCode()));
                            } else if (successNum > 0 && payingNum == 0) {
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.\u90e8\u5206\u652f\u4ed8.getCode()));
                            } else {
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.\u652f\u4ed8\u4e2d.getCode()));
                            }
                        }
                        this.logger.info("\u4e3b\u8868id\uff1a{}\uff0c\u4e3b\u8868\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u540e\uff1a{}", (Object)salaryPayApplyEntity.getId(), (Object)curTotalActualPaidTaxMny);
                    }
                    super.saveOrUpdateBatch(salaryPayApplyList, salaryPayApplyList.size(), false);
                    this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u66f4\u65b0\u72b6\u6001\u540e\u7684\u4e3b\u8868\u8fdb\u884c\u4fdd\u5b58-\u66f4\u65b0\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)detailResultList));
                }
            }
        }
    }

    private boolean checkPayState(String curState, Integer workerPayState) {
        Boolean sameFlag = false;
        if (PMPayStateEnum.\u5f85\u652f\u4ed8.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.\u5f85\u652f\u4ed8.getCode().equals(workerPayState.toString())) {
            return true;
        }
        if (PMPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u6210\u529f.getCode().equals(workerPayState.toString())) {
            return true;
        }
        if (PMPayStateEnum.\u94f6\u884c\u652f\u4ed8\u4e2d.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.\u94f6\u884c\u652f\u4ed8\u4e2d.getCode().equals(workerPayState.toString())) {
            return true;
        }
        if (PMPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(workerPayState.toString())) {
            return true;
        }
        return sameFlag;
    }
}

