/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.RegisterDetailEntity;
import com.ejianc.business.profinance.bean.RegulateEntity;
import com.ejianc.business.profinance.mapper.PaymentRegisterMapper;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.business.profinance.plan.bean.PlanEntity;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;
import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.business.profinance.plan.bean.PlanTemporaryEntity;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.business.profinance.plan.service.IPlanService;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.business.profinance.service.IRegulateService;
import com.ejianc.business.profinance.vo.ImportPaymentRegisterVO;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.business.profinance.vo.RegisterDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="paymentRegisterService")
public class PaymentRegisterServiceImpl
extends BaseServiceImpl<PaymentRegisterMapper, PaymentRegisterEntity>
implements IPaymentRegisterService {
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IContractPoolApi contractApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierWebApi iShareSupplierWebApi;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IRegisterDetailService detailService;
    @Autowired
    private IPlanContractService planContractService;
    @Autowired
    private IPlanMaterialService planMaterialService;
    @Autowired
    private IPlanTemporaryService planTemporaryService;
    @Autowired
    private IPlanFeeService planFeeService;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IRegulateService regulateService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPaymentApplyService paymentApplyService;
    private static final String BILL_CODE = "PAYMENT_REGISTER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<PaymentRegisterEntity> queryPaymentRegisterByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("not_in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        return super.queryList(param);
    }

    @Override
    public Map<String, BigDecimal> queryAlreadyPayMny(Long contractId) {
        HashMap<String, BigDecimal> info = new HashMap<String, BigDecimal>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum( pay_mny ) AS alreadyPayMny"});
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = super.getMap((Wrapper)queryWrapper);
        info.put("alreadyPayMny", null != resultMap && null != resultMap.get("alreadyPayMny") ? new BigDecimal(resultMap.get("alreadyPayMny").toString()) : BigDecimal.ZERO);
        return info;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        for (int i = 1; i < 6; ++i) {
            typeList.add(i);
        }
        Date startDate = new Date();
        this.logger.info("\u5bfc\u5165\u6821\u9a8c\u5f00\u59cb\uff1a\u5f00\u59cb\u65f6\u95f4----------->{}", (Object)startDate);
        CommonResponse accountList = this.iShareSupplierWebApi.queryBankAccountList();
        this.logger.info("\u8d26\u6237\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
        CommonResponse defSettleList = this.defdocApi.getDefDocByDefCode("profinance-settle-type");
        this.logger.info("\u81ea\u5b9a\u4e49\u6863\u6848\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
        CommonResponse defFeeList = this.defdocApi.getDefDocByDefCode("no_contract_fee_type");
        this.logger.info("\u81ea\u5b9a\u4e49\u6863\u6848\u7ed3\u7b97\u7c7b\u578b\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
        if (!accountList.isSuccess()) {
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        if (!defSettleList.isSuccess()) {
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u6863\u6848\u4e0b\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        if (!defFeeList.isSuccess()) {
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        Map accountMap = ((List)accountList.getData()).stream().collect(Collectors.toMap(BankAccountVO::getBankAccount, Function.identity(), (key1, key2) -> key2));
        HashMap supplierDTOMap = new HashMap();
        HashMap projectPoolSetVOMap = new HashMap();
        HashMap orgVOMap = new HashMap();
        HashMap contractPoolVOMap = new HashMap();
        Map defFeeMap = ((List)defFeeList.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map defSettleMap = ((List)defSettleList.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<ImportPaymentRegisterVO> successList = new ArrayList<ImportPaymentRegisterVO>();
        ArrayList<ImportPaymentRegisterVO> errorList = new ArrayList<ImportPaymentRegisterVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 14) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                ImportPaymentRegisterVO paymentRegisterVO = new ImportPaymentRegisterVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u652f\u4ed8\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        paymentRegisterVO.setPaymentDate(DateUtils.parseDate((String)((String)datas.get(1)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u652f\u4ed8\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    errorMessage.append("[\u652f\u51fa\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879]");
                } else if (((String)datas.get(2)).equals("\u6709\u5408\u540c\u4ed8\u6b3e")) {
                    paymentRegisterVO.setPaymentContractFlag(Integer.valueOf(0));
                    paymentRegisterVO.setPaymentContractFlagName("\u6709\u5408\u540c\u4ed8\u6b3e");
                } else if (((String)datas.get(2)).equals("\u65e0\u5408\u540c\u4ed8\u6b3e")) {
                    paymentRegisterVO.setPaymentContractFlag(Integer.valueOf(1));
                    paymentRegisterVO.setPaymentContractFlagName("\u65e0\u5408\u540c\u4ed8\u6b3e");
                } else {
                    errorMessage.append("[\u652f\u51fa\u7c7b\u578b\u586b\u5199\u9519\u8bef]");
                }
                if (paymentRegisterVO.getPaymentContractFlag() != null && paymentRegisterVO.getPaymentContractFlag().equals(0)) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                        paymentRegisterVO.setContractCode((String)datas.get(4));
                        if (((String)datas.get(4)).length() > 64) {
                            errorMessage.append("[\u586b\u5199\u5408\u540c\u7f16\u53f7\u957f\u5ea6\u4e3a1~64\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) == null) {
                            CommonResponse contractData = this.contractApi.queryContractByCode((String)datas.get(4));
                            if (contractData.isSuccess() && contractData.getData() != null) {
                                contractPoolVOMap.put(datas.get(4), contractData.getData());
                            } else {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5408\u540c\u7f16\u53f7\u7684\u5408\u540c]");
                            }
                        }
                    } else {
                        errorMessage.append("[\u652f\u51fa\u7c7b\u578b\u4e3a\u6709\u5408\u540c\u4ed8\u6b3e\u65f6\uff0c\u5408\u540c\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                        paymentRegisterVO.setContractName((String)datas.get(3));
                        if (((String)datas.get(3)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u5408\u540c\u540d\u79f0\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                            if (((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getContractName() == null || !((String)datas.get(3)).equals(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getContractName())) {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u540d\u79f0\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                            } else {
                                paymentRegisterVO.setContractId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getContractId());
                                paymentRegisterVO.setContractCode((String)datas.get(4));
                                paymentRegisterVO.setContractTaxMny(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getContractTaxMny());
                                paymentRegisterVO.setContractMny(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getContractMny());
                                paymentRegisterVO.setOrgCode(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getOrgCode());
                                paymentRegisterVO.setContractLinkUrl(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getPcCardUrl());
                            }
                        }
                    } else {
                        errorMessage.append("[\u652f\u51fa\u7c7b\u578b\u4e3a\u6709\u5408\u540c\u4ed8\u6b3e\u65f6\uff0c\u5408\u540c\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        paymentRegisterVO.setContractCategoryName((String)datas.get(5));
                        if (((String)datas.get(5)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u5408\u540c\u7c7b\u522b\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                            if (((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getCategoryName() == null || !((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getCategoryName().equals(datas.get(5))) {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u5408\u540c\u7c7b\u522b\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                            } else {
                                paymentRegisterVO.setContractCategoryId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getCategoryId());
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        paymentRegisterVO.setProjectName((String)datas.get(7));
                        if (((String)datas.get(7)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u9879\u76ee\u540d\u79f0\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                            if (((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getProjectName() == null || !((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getProjectName().equals(datas.get(7))) {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                            } else {
                                paymentRegisterVO.setProjectId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getProjectId());
                                paymentRegisterVO.setOrgId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getOrgId());
                                paymentRegisterVO.setOrgName(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getOrgName());
                            }
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                        errorMessage.append("[\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                    } else {
                        paymentRegisterVO.setParentOrgName((String)datas.get(0));
                        if (((String)datas.get(0)).length() > 128) {
                            errorMessage.append("[\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u586b\u5199\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                            if (((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getParentOrgName() == null || !((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getParentOrgName().equals(datas.get(0))) {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u540d\u79f0\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                            } else {
                                paymentRegisterVO.setParentOrgCode(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getParentOrgCode());
                                paymentRegisterVO.setParentOrgId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getParentOrgId());
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        paymentRegisterVO.setProjectCode((String)datas.get(8));
                        if (((String)datas.get(8)).length() > 64) {
                            errorMessage.append("[\u586b\u5199\u9879\u76ee\u7f16\u7801\u957f\u5ea6\u4e3a1~64\u5b57]");
                        } else if (!(contractPoolVOMap.get(datas.get(4)) == null || ((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getProjectCode() != null && ((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getProjectCode().equals(datas.get(8)))) {
                            errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u9879\u76ee\u7f16\u7801\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                        paymentRegisterVO.setSupplierName((String)datas.get(9));
                        if (((String)datas.get(9)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u6536\u6b3e\u5355\u4f4d\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                            if (((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getPartybName() == null || !((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getPartybName().equals(datas.get(9))) {
                                errorMessage.append("[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u6536\u6b3e\u5355\u4f4d\u548c\u5408\u540c\u7f16\u53f7\u4e0d\u7b26\u5408]");
                            } else {
                                paymentRegisterVO.setSupplierId(((ContractPoolVO)contractPoolVOMap.get(datas.get(4))).getPartybId());
                            }
                        }
                    } else {
                        errorMessage.append("[\u6536\u6b3e\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                    }
                } else if (paymentRegisterVO.getPaymentContractFlag() != null && paymentRegisterVO.getPaymentContractFlag().equals(1)) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                        paymentRegisterVO.setFeeTypeName((String)datas.get(6));
                        if (((String)datas.get(6)).length() > 100) {
                            errorMessage.append("[\u586b\u5199\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b\u957f\u5ea6\u4e3a1~100\u5b57]");
                        } else if (defFeeMap.get(datas.get(6)) == null) {
                            errorMessage.append("[\u81ea\u5b9a\u4e49\u6863\u6848\u4e0d\u5b58\u5728\u5f53\u524d\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b]");
                        } else {
                            paymentRegisterVO.setFeeTypeId(((DefdocDetailVO)defFeeMap.get(datas.get(6))).getId());
                            paymentRegisterVO.setFeeTypeCode(((DefdocDetailVO)defFeeMap.get(datas.get(6))).getCode());
                            paymentRegisterVO.setPersonalPrepaid(Integer.valueOf(0));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                        paymentRegisterVO.setProjectName((String)datas.get(7));
                        if (((String)datas.get(7)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u9879\u76ee\u540d\u79f0\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (projectPoolSetVOMap.get(datas.get(7)) != null) {
                            paymentRegisterVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getId());
                            paymentRegisterVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getProjectDepartmentId());
                            paymentRegisterVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getProjectDepartmentName());
                        } else {
                            CommonResponse projectData = this.projectPoolApi.queryProjectListByNameAndTenantId((String)datas.get(7), tenantId);
                            if (!projectData.isSuccess()) {
                                errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u540d\u79f0\u7684\u9879\u76ee]");
                            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)projectData.getData())) && null != ((List)projectData.getData()).get(0)) {
                                projectPoolSetVOMap.put(datas.get(7), ((List)projectData.getData()).get(0));
                                paymentRegisterVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getId());
                                paymentRegisterVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getProjectDepartmentId());
                                paymentRegisterVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getProjectDepartmentName());
                            } else {
                                errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u540d\u79f0\u7684\u9879\u76ee]");
                            }
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                        errorMessage.append("[\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                    } else {
                        paymentRegisterVO.setParentOrgName((String)datas.get(0));
                        if (((String)datas.get(0)).length() > 128) {
                            errorMessage.append("[\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u586b\u5199\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (orgVOMap.get(datas.get(0)) != null) {
                            paymentRegisterVO.setParentOrgCode(((OrgVO)orgVOMap.get(datas.get(0))).getCode());
                            paymentRegisterVO.setParentOrgId(((OrgVO)orgVOMap.get(datas.get(0))).getId());
                        } else {
                            CommonResponse orgData = this.iOrgApi.findByNameAndTenantId((String)datas.get(0), tenantId);
                            if (!orgData.isSuccess()) {
                                errorMessage.append("[\u7ec4\u7ec7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u6240\u5c5e\u5355\u4f4d]");
                            } else if (datas.get(7) != null && ((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getOrgName() != null && !((String)datas.get(0)).equals(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getOrgName())) {
                                errorMessage.append("[\u9879\u76ee\u6c60\u4e2d\u5f53\u524d\u9879\u76ee\u6240\u5c5e\u5355\u4f4d\u548c\u9879\u76ee\u540d\u79f0\u4e0d\u7b26\u5408]");
                            } else {
                                orgVOMap.put(datas.get(7), orgData.getData());
                                paymentRegisterVO.setParentOrgCode(((OrgVO)orgVOMap.get(datas.get(7))).getCode());
                                paymentRegisterVO.setParentOrgId(((OrgVO)orgVOMap.get(datas.get(7))).getId());
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        paymentRegisterVO.setProjectCode((String)datas.get(8));
                        if (((String)datas.get(8)).length() > 64) {
                            errorMessage.append("[\u586b\u5199\u9879\u76ee\u7f16\u7801\u957f\u5ea6\u4e3a1~64\u5b57]");
                        } else if (projectPoolSetVOMap.get(datas.get(7)) == null) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u540d\u79f0\u7684\u9879\u76ee]");
                        } else if (!((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(7))).getCode().equals(datas.get(8))) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e2d\u9879\u76ee\u7f16\u7801\u548c\u9879\u76ee\u540d\u79f0\u4e0d\u7b26\u5408]");
                        }
                    } else {
                        errorMessage.append("[\u9879\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                        paymentRegisterVO.setSupplierName((String)datas.get(9));
                        if (((String)datas.get(9)).length() > 128) {
                            errorMessage.append("[\u586b\u5199\u6536\u6b3e\u5355\u4f4d\u957f\u5ea6\u4e3a1~128\u5b57]");
                        } else if (supplierDTOMap.get(datas.get(9)) != null) {
                            paymentRegisterVO.setSupplierId(((SupplierDTO)supplierDTOMap.get(datas.get(9))).getId());
                        } else {
                            ArrayList supplierNameList = new ArrayList();
                            supplierNameList.add(datas.get(9));
                            CommonResponse supplierData = this.iProSupplierApi.querySupplierByNames(supplierNameList);
                            if (!supplierData.isSuccess()) {
                                errorMessage.append("[\u5ba2\u6237\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)supplierData.getData())) && null != ((List)supplierData.getData()).get(0)) {
                                supplierDTOMap.put(datas.get(9), ((List)supplierData.getData()).get(0));
                                paymentRegisterVO.setSupplierId(((SupplierDTO)((List)supplierData.getData()).get(0)).getId());
                            } else {
                                errorMessage.append("[\u5ba2\u6237\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                            }
                        }
                    } else {
                        errorMessage.append("[\u6536\u6b3e\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        paymentRegisterVO.setPayMny(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    if (((String)datas.get(11)).length() > 500) {
                        errorMessage.append("[\u586b\u5199\u4ed8\u6b3e\u8bf4\u660e\u957f\u5ea6\u4e3a1~500\u5b57]");
                    }
                    paymentRegisterVO.setPaymentReason((String)datas.get(11));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    paymentRegisterVO.setAccountName((String)datas.get(12));
                    if (((String)datas.get(12)).length() > 500) {
                        errorMessage.append("[\u586b\u5199\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (accountMap.get(datas.get(12)) == null) {
                        errorMessage.append("[\u94f6\u884c\u8d26\u6237\u4e0b\u4e0d\u5b58\u5728\u5f53\u524d\u8d26\u6237]");
                    } else {
                        paymentRegisterVO.setAccountId(((BankAccountVO)accountMap.get(datas.get(12))).getId());
                        paymentRegisterVO.setAccountNum(((BankAccountVO)accountMap.get(datas.get(12))).getBankCode());
                        paymentRegisterVO.setBankAccount(((BankAccountVO)accountMap.get(datas.get(12))).getBankName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    paymentRegisterVO.setSettleTypeName((String)datas.get(13));
                    if (defSettleMap.get(datas.get(13)) == null) {
                        errorMessage.append("[\u6863\u6848\u4e0b\u4e0d\u5b58\u5728\u5f53\u524d\u7ed3\u7b97\u7c7b\u578b]");
                    } else {
                        paymentRegisterVO.setSettleTypeId(((DefdocDetailVO)defSettleMap.get(datas.get(13))).getId());
                        paymentRegisterVO.setSettleTypeCode(((DefdocDetailVO)defSettleMap.get(datas.get(13))).getCode());
                    }
                }
                paymentRegisterVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(paymentRegisterVO);
                    continue;
                }
                paymentRegisterVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(paymentRegisterVO);
            }
        }
        this.logger.info("\u5bfc\u5165\u7ed3\u675f\u65f6\u95f4----------->{}", (Object)new Date());
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<PaymentRegisterVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List entityList = BeanMapper.mapList(importVOS, PaymentRegisterEntity.class);
        Map<Object, Object> mny = new HashMap();
        for (PaymentRegisterEntity entity : entityList) {
            mny = this.queryAlreadyPayMny(entity.getContractId());
            entity.setAlreadyPayMny((BigDecimal)mny.get("alreadyPayMny"));
            entity.setPersonalPrepaid(0);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)entity), PaymentRegisterVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u4ed8\u6b3e\u767b\u8bb0\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public BigDecimal getTotalPaidMny(QueryParam param) {
        QueryWrapper wrapper = PaymentRegisterServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(pay_mny) as totalPaidMny"});
        Map result = super.getMap((Wrapper)wrapper);
        return null != result && null != result.get("totalPaidMny") ? (BigDecimal)result.get("totalPaidMny") : BigDecimal.ZERO;
    }

    @Override
    public void writeBack(PaymentRegisterEntity entity, boolean check) {
        QueryParam queryParam = new QueryParam();
        Integer paymentContractFlag = entity.getPaymentContractFlag();
        if (paymentContractFlag != null && paymentContractFlag == 2) {
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)entity.getSourceId()));
        } else {
            List sourceIdS = entity.getDetailList().stream().filter(item -> item.getSourceId() != null).map(RegisterDetailEntity::getSourceId).collect(Collectors.toList());
            if (!sourceIdS.isEmpty()) {
                queryParam.getParams().put("sourceId", new Parameter("in", sourceIdS));
            }
        }
        List regulateEntities = this.regulateService.queryList(queryParam);
        BigDecimal mny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)regulateEntities)) {
            for (RegulateEntity regulateEntity : regulateEntities) {
                if (paymentContractFlag != null && paymentContractFlag == 2) {
                    mny = entity.getPayMny();
                } else if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    Map collect = entity.getDetailList().stream().collect(Collectors.toMap(RegisterDetailEntity::getSourceId, Function.identity()));
                    mny = ((RegisterDetailEntity)((Object)collect.get(regulateEntity.getSourceId()))).getActualMny();
                }
                BigDecimal paidMny = regulateEntity.getPaidMny() == null ? BigDecimal.ZERO : regulateEntity.getPaidMny();
                regulateEntity.setPaidMny(check ? paidMny.add(mny) : paidMny.subtract(mny));
                regulateEntity.setUnpaidMny(regulateEntity.getPlanPayMny().subtract(regulateEntity.getPaidMny()));
                this.logger.info("\u56de\u5199\u8d44\u91d1\u8ba1\u5212 \u4e2d\u95f4\u8868---PaidMny {}   ---UnpaidMny {}", (Object)regulateEntity.getPaidMny(), (Object)regulateEntity.getUnpaidMny());
                Long planId = null;
                switch (paymentContractFlag) {
                    case 2: {
                        QueryWrapper listQuery = new QueryWrapper();
                        listQuery.eq((Object)"id", (Object)regulateEntity.getSourceId());
                        PlanContractEntity contractServiceOne = (PlanContractEntity)((Object)this.planContractService.getOne((Wrapper)listQuery));
                        BigDecimal totalActualPaymentMny = contractServiceOne.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : contractServiceOne.getTotalActualPaymentMny();
                        contractServiceOne.setTotalActualPaymentMny(check ? totalActualPaymentMny.add(mny) : totalActualPaymentMny.subtract(mny));
                        contractServiceOne.setUnpaidMny(contractServiceOne.getContractPlanPayment().subtract(contractServiceOne.getTotalActualPaymentMny()));
                        this.logger.info("\u56de\u5199\u8d44\u91d1\u8ba1\u5212 \u5bf9\u5e94\u5b50\u8868---TotalActualPaymentMny {}   ---UnpaidMny {}", (Object)contractServiceOne.getTotalActualPaymentMny(), (Object)contractServiceOne.getUnpaidMny());
                        this.planContractService.saveOrUpdate((Object)contractServiceOne);
                        planId = contractServiceOne.getPlanId();
                        break;
                    }
                    case 3: {
                        QueryWrapper materialQuery = new QueryWrapper();
                        materialQuery.eq((Object)"id", (Object)regulateEntity.getSourceId());
                        PlanMaterialEntity materialEntity = (PlanMaterialEntity)((Object)this.planMaterialService.getOne((Wrapper)materialQuery));
                        BigDecimal materialMny = materialEntity.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : materialEntity.getTotalActualPaymentMny();
                        materialEntity.setTotalActualPaymentMny(check ? materialMny.add(mny) : materialMny.subtract(mny));
                        materialEntity.setUnpaidMny(materialEntity.getMaterialPlanPaymentMny().subtract(materialEntity.getTotalActualPaymentMny()));
                        this.logger.info("\u56de\u5199\u8d44\u91d1\u8ba1\u5212 \u5bf9\u5e94\u5b50\u8868---TotalActualPaymentMny {}   ---UnpaidMny {}", (Object)materialEntity.getTotalActualPaymentMny(), (Object)materialEntity.getUnpaidMny());
                        this.planMaterialService.saveOrUpdate((Object)materialEntity);
                        planId = materialEntity.getPlanId();
                        break;
                    }
                    case 4: {
                        QueryWrapper temporaryQuery = new QueryWrapper();
                        temporaryQuery.eq((Object)"id", (Object)regulateEntity.getSourceId());
                        PlanTemporaryEntity temporaryEntity = (PlanTemporaryEntity)((Object)this.planTemporaryService.getOne((Wrapper)temporaryQuery));
                        BigDecimal temporaryMny = temporaryEntity.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : temporaryEntity.getTotalActualPaymentMny();
                        temporaryEntity.setTotalActualPaymentMny(check ? temporaryMny.add(mny) : temporaryMny.subtract(mny));
                        temporaryEntity.setUnpaidMny(temporaryEntity.getTemporaryPlanPaymentMny().subtract(temporaryEntity.getTotalActualPaymentMny()));
                        this.logger.info("\u56de\u5199\u8d44\u91d1\u8ba1\u5212 \u5bf9\u5e94\u5b50\u8868---TotalActualPaymentMny {}   ---UnpaidMny {}", (Object)temporaryEntity.getTotalActualPaymentMny(), (Object)temporaryEntity.getUnpaidMny());
                        this.planTemporaryService.saveOrUpdate((Object)temporaryEntity);
                        planId = temporaryEntity.getPlanId();
                        break;
                    }
                    case 5: {
                        QueryWrapper planFeeQuery = new QueryWrapper();
                        planFeeQuery.eq((Object)"id", (Object)regulateEntity.getSourceId());
                        PlanFeeEntity planFeeEntity = (PlanFeeEntity)((Object)this.planFeeService.getOne((Wrapper)planFeeQuery));
                        BigDecimal planFeeMny = planFeeEntity.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : planFeeEntity.getTotalActualPaymentMny();
                        planFeeEntity.setTotalActualPaymentMny(check ? planFeeMny.add(mny) : planFeeMny.subtract(mny));
                        planFeeEntity.setUnpaidMny(planFeeEntity.getFeePlanPaymentMny().subtract(planFeeEntity.getTotalActualPaymentMny()));
                        this.logger.info("\u56de\u5199\u8d44\u91d1\u8ba1\u5212 \u5bf9\u5e94\u5b50\u8868---TotalActualPaymentMny {}   ---UnpaidMny {}", (Object)planFeeEntity.getTotalActualPaymentMny(), (Object)planFeeEntity.getUnpaidMny());
                        this.planFeeService.saveOrUpdate((Object)planFeeEntity);
                        planId = planFeeEntity.getPlanId();
                        break;
                    }
                }
                if (planId == null) continue;
                PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(planId));
                BigDecimal cueTotalActualPaymentMny = planEntity.getCurTotalActualPaymentMny() == null ? BigDecimal.ZERO : planEntity.getCurTotalActualPaymentMny();
                planEntity.setCurTotalActualPaymentMny(check ? cueTotalActualPaymentMny.add(mny) : cueTotalActualPaymentMny.subtract(mny));
                this.logger.info("\u56de\u5199 \u8d44\u91d1\u8ba1\u5212 \u4e3b\u8868---CueTotalActualPaymentMny {}  ", (Object)planEntity.getCurTotalActualPaymentMny());
                this.planService.saveOrUpdate((Object)planEntity);
            }
            this.regulateService.saveOrUpdateBatch(regulateEntities);
        }
    }

    @Override
    public void checkStatus(PaymentRegisterVO entity) {
        if (entity.getPaymentContractFlag() == 2) {
            if ("\u5f15\u7528".equals(entity.getRefStatus())) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u3010\u4ed8\u6b3e\u767b\u8bb0\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4\u652f\u4ed8\u3002");
            }
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"source_id", (Object)entity.getSourceId());
            listQuery.notIn((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            int resultCount = super.count((Wrapper)listQuery);
            if (resultCount > 0) {
                throw new BusinessException(" \u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u3010\u4ed8\u6b3e\u767b\u8bb0\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4\u652f\u4ed8\u3002");
            }
        } else {
            List detailList = entity.getDetailList();
            for (RegisterDetailVO vo : detailList) {
                if ("\u5f15\u7528".equals(vo.getRefStatus())) {
                    throw new BusinessException(" \u64cd\u4f5c\u5931\u8d25\uff01\u7ed3\u7b97\u5355\u53f7" + vo.getSourceBillCode() + "\u5b58\u5728\u672a\u751f\u6548\u7684\u3010\u4ed8\u6b3e\u767b\u8bb0\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4\u652f\u4ed8\u3002");
                }
                QueryWrapper listQuery = new QueryWrapper();
                listQuery.eq((Object)"source_id", (Object)vo.getSourceId());
                listQuery.notIn((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
                int resultCount = this.detailService.count((Wrapper)listQuery);
                if (resultCount <= 0) continue;
                throw new BusinessException(" \u64cd\u4f5c\u5931\u8d25\uff01\u7ed3\u7b97\u5355\u53f7" + vo.getSourceBillCode() + "\u5b58\u5728\u672a\u751f\u6548\u7684\u3010\u4ed8\u6b3e\u767b\u8bb0\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4\u652f\u4ed8\u3002");
            }
        }
    }

    @Override
    public void updateStatus(PaymentRegisterEntity entity, int flag) {
        ArrayList<Long> delIds = new ArrayList<Long>();
        ArrayList<Long> addIds = new ArrayList<Long>();
        if (entity.getPaymentContractFlag() == 2) {
            if (flag == 1 || flag == 2) {
                delIds.add(entity.getSourceId());
            } else {
                addIds.add(entity.getSourceId());
            }
        } else {
            List<RegisterDetailEntity> detailList = entity.getDetailList();
            for (RegisterDetailEntity vo : detailList) {
                if (flag == 1 || flag == 2) {
                    delIds.add(vo.getSourceId());
                    continue;
                }
                if (vo.getRowState() != null && vo.getRowState().equals("del")) {
                    delIds.add(vo.getSourceId());
                }
                if (vo.getRowState() == null || !vo.getRowState().equals("add")) continue;
                addIds.add(vo.getSourceId());
            }
        }
        if (!delIds.isEmpty()) {
            this.logger.info("\u8bbe\u7f6e\u672a\u5f15\u7528 ---{}", (Object)JSONObject.toJSONString(delIds));
            this.regulateService.updateColumnValue(delIds, "ref_status", "\u672a\u5f15\u7528");
        }
        if (!addIds.isEmpty()) {
            this.logger.info("\u8bbe\u7f6e\u4e3a\u5f15\u7528 ---{}", (Object)JSONObject.toJSONString(addIds));
            this.regulateService.updateColumnValue(addIds, "ref_status", "\u5f15\u7528");
        }
    }

    @Override
    public Map<String, BigDecimal> queryActualPayGroupByMonth(QueryParam queryParam) {
        QueryWrapper query = PaymentRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(pay_mny) as totalMny, date_format(payment_date,'%Y-%m') as yearMonth"});
        query.groupBy((Object[])new String[]{"date_format(payment_date,'%Y-%m')"});
        List rs = super.listMaps((Wrapper)query);
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)rs)) {
            for (Map m : rs) {
                resp.put(m.get("yearMonth").toString(), new BigDecimal(m.get("totalMny").toString()));
            }
        }
        return resp;
    }

    @Override
    public BigDecimal getAcutalPayAndRegisterDiffMny(Long projectId, Long supplyId, Long payeeId, Long contractId) {
        QueryWrapper query = new QueryWrapper();
        QueryWrapper paymentQuery = new QueryWrapper();
        query.select(new String[]{"sum(pay_mny) as totalPaidMny"});
        if (null == contractId || contractId.equals(-1L)) {
            query.isNull((Object)"contract_id");
            paymentQuery.isNull((Object)"contract_id");
        } else {
            query.eq((Object)"contract_id", (Object)contractId);
            paymentQuery.eq((Object)"contract_id", (Object)contractId);
        }
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"supplier_id", (Object)supplyId);
        query.eq((Object)"payee_id", (Object)payeeId);
        Map result = super.getMap((Wrapper)query);
        BigDecimal totalRegisterMny = null != result && null != result.get("totalPaidMny") ? new BigDecimal(result.get("totalPaidMny").toString()) : BigDecimal.ZERO;
        paymentQuery.select(new String[]{"sum(actual_mny) as totalActualPayMny"});
        paymentQuery.eq((Object)"project_id", (Object)projectId);
        paymentQuery.eq((Object)"supplier_id", (Object)supplyId);
        paymentQuery.eq((Object)"payee_id", (Object)payeeId);
        Map payResult = this.paymentApplyService.getMap((Wrapper)paymentQuery);
        BigDecimal totalActualPayMny = null != payResult && null != payResult.get("totalActualPayMny") ? new BigDecimal(payResult.get("totalActualPayMny").toString()) : BigDecimal.ZERO;
        return totalActualPayMny.subtract(totalRegisterMny);
    }

    @Override
    public Map<String, BigDecimal> queryActualPayGroupByContractCategoryType(QueryParam queryParam) {
        QueryWrapper query = PaymentRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(pay_mny) as totalMny, source_category_type as contractType"});
        query.isNotNull((Object)"source_category_type");
        query.groupBy((Object[])new String[]{"source_category_type"});
        List rs = super.listMaps((Wrapper)query);
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)rs)) {
            for (Map m : rs) {
                resp.put(m.get("contractType").toString(), new BigDecimal(m.get("totalMny").toString()));
            }
        }
        return resp;
    }
}

