package com.ejianc.business.profinance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工人工资支付申请子表明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_salary_pay_apply_worker_detail")
public class SalaryPayApplyDetailWorkerEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者名称
    @TableField(value="salary_id")
    private Long salaryId; // 工人工资单主表ID（工人工资单也有主子表，子表存储具体的工人的工资单），跳转工资单详情时的参数id就是此值
    @TableField(value="source_id")
    private Long sourceId; // 来源id，存的是选择的工资单的子表的id（工人工资单也有主子表，子表存储具体的工人的工资单）
    @TableField(value="source_type")
    private Integer sourceType; // 数据来源方式 （0-同步劳务实名系统新增 1-直接新增）
    @TableField(value="pay_res_source")
    private String payResSource; // 支付结果来源，0-系统自动推送，1-手动确认
    @TableField(value="pid")
    private Long pid; // 当前表的主表ID，主表：ejc_profinance_salary_pay_apply
    @TableField(value="worker_bill_code")
    private String workerBillCode; // 工人工资单号，存的是选择的工人工资单的主表的billCode
    @TableField(value="worker_id")
    private Long workerId; // 工人ID
    @TableField(value="worker_code")
    private String workerCode; // 工人编码
    @TableField(value="worker_name")
    private String workerName; // 工人名称
    @TableField(value="worker_id_card")
    private String workerIdCard; // 工人身份证号-已脱敏，默认展示已脱敏
    @TableField(value="worker_id_card_un_sensitive")
    private String workerIdCardUnSensitive; // 工人身份证号-未脱敏
    @TableField(value="team_id")
    private Long teamId; // 队伍ID
    @TableField(value="team_code")
    private String teamCode; // 队伍编码
    @TableField(value="team_name")
    private String teamName; // 队伍名称
    @TableField(value="group_id")
    private Long groupId; // 班组ID
    @TableField(value="group_code")
    private String groupCode; // 班组编码
    @TableField(value="group_name")
    private String groupName; // 班组名称
    @TableField(value="statistical_date")
    private Date statisticalDate; // 统计日期
    @TableField(value="worker_pay_date")
    private Date workerPayDate; // 支付日期
    @TableField(value="worker_account_id")
    private Long workerAccountId; // 银行账号id
    @TableField(value="worker_account_num")
    private String workerAccountNum; // 银行账号
    @TableField(value="worker_account_name")
    private String workerAccountName; // 银行账户名称
    @TableField(value="worker_bank_name")
    private String workerBankName; // 开户行
    @TableField(value="worker_pay_state")
    private Integer workerPayState; // 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
    @TableField(value="worker_should_pay_tax_mny")
    private BigDecimal workerShouldPayTaxMny; // 应发金额（有税）
    @TableField(value="worker_should_pay_mny")
    private BigDecimal workerShouldPayMny; // 应发金额（无税）
    @TableField(value="worker_should_pay_tax")
    private BigDecimal workerShouldPayTax; // 应发金额（税额）
    @TableField(value="worker_remainder_tax_mny")
    private BigDecimal workerRemainderTaxMny; // 剩余可发金额（有税）
    @TableField(value="worker_remainder_mny")
    private BigDecimal workerRemainderMny; // 剩余可发金额（无税）
    @TableField(value="worker_remainder_tax")
    private BigDecimal workerRemainderTax; // 剩余可发金额（税额）
    @TableField(value="worker_total_apply_tax_mny")
    private BigDecimal workerTotalApplyTaxMny; // 累计本期申请金额（有税）
    @TableField(value="worker_total_apply_mny")
    private BigDecimal workerTotalApplyMny; // 累计本期申请金额（无税）
    @TableField(value="worker_total_apply_tax")
    private BigDecimal workerTotalApplyTax; // 累计本期申请金额（税额）
    @TableField(value="worker_apply_tax_mny")
    private BigDecimal workerApplyTaxMny; // 本期申请金额（有税）
    @TableField(value="worker_apply_mny")
    private BigDecimal workerApplyMny; // 本期申请金额（无税）
    @TableField(value="worker_apply_tax")
    private BigDecimal workerApplyTax; // 本期申请金额（税额）
    @TableField(value="worker_actual_paid_tax_mny")
    private BigDecimal workerActualPaidTaxMny; // 实际支付金额（有税）
    @TableField(value="worker_actual_paid_mny")
    private BigDecimal workerActualPaidMny; // 实际支付金额（无税）
    @TableField(value="worker_actual_paid_tax")
    private BigDecimal workerActualPaidTax; // 实际支付金额（税额）
    @TableField(value="worker_is_repeat_bill")
    private Integer workerIsRepeatBill; // 是否重发：1-是，0-否
    @TableField(value="id_old")
    private Long idOld; // 原申请单子表ID
    @TableField(value="worker_apply_tax_mny_old")
    private BigDecimal workerApplyTaxMnyOld; // 原申请子表金额
    @TableField(value="worker_memo")
    private String workerMemo; // 备注
    @TableField(value="pm_pay_apply_detail_id")
    private String pmPayApplyDetailId; // 中间库工资支付申请子表id
    @TableField(value="worker_inter_bank_num")
    private String workerInterBankNum; // 联行号
    @TableField(value="worker_bank_province")
    private String workerBankProvince; // 开户行省份
    @TableField(value="proposed_payment_mny")
    private BigDecimal proposedPaymentMny; // 拟支付金额
    @TableField(value="worker_phone")
    private String workerPhone; // 电话号码
    @TableField(value="generate_id")
    private Long generateId; // 支付申请子表手动生成的id
    /**
     * 工资支付状态更新使用
     * 是否记录到工资发放登记、付款等级中
     */
    @TableField(exist = false)
    private Boolean recordRegister = false;


    public Boolean getRecordRegister() {
        return recordRegister;
    }

    public void setRecordRegister(Boolean recordRegister) {
        this.recordRegister = recordRegister;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getPayResSource() {
        return payResSource;
    }

    public void setPayResSource(String payResSource) {
        this.payResSource = payResSource;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getWorkerBillCode() {
        return workerBillCode;
    }

    public void setWorkerBillCode(String workerBillCode) {
        this.workerBillCode = workerBillCode;
    }
    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerCode() {
        return workerCode;
    }

    public void setWorkerCode(String workerCode) {
        this.workerCode = workerCode;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public String getWorkerIdCard() {
        return workerIdCard;
    }

    public void setWorkerIdCard(String workerIdCard) {
        this.workerIdCard = workerIdCard;
    }
    public String getWorkerIdCardUnSensitive() {
        return workerIdCardUnSensitive;
    }

    public void setWorkerIdCardUnSensitive(String workerIdCardUnSensitive) {
        this.workerIdCardUnSensitive = workerIdCardUnSensitive;
    }
    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }
    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }
    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
    public Date getStatisticalDate() {
        return statisticalDate;
    }

    public void setStatisticalDate(Date statisticalDate) {
        this.statisticalDate = statisticalDate;
    }
    public Date getWorkerPayDate() {
        return workerPayDate;
    }

    public void setWorkerPayDate(Date workerPayDate) {
        this.workerPayDate = workerPayDate;
    }
    public Long getWorkerAccountId() {
        return workerAccountId;
    }

    public void setWorkerAccountId(Long workerAccountId) {
        this.workerAccountId = workerAccountId;
    }
    public String getWorkerAccountNum() {
        return workerAccountNum;
    }

    public void setWorkerAccountNum(String workerAccountNum) {
        this.workerAccountNum = workerAccountNum;
    }
    public String getWorkerAccountName() {
        return workerAccountName;
    }

    public void setWorkerAccountName(String workerAccountName) {
        this.workerAccountName = workerAccountName;
    }
    public String getWorkerBankName() {
        return workerBankName;
    }

    public void setWorkerBankName(String workerBankName) {
        this.workerBankName = workerBankName;
    }
    public Integer getWorkerPayState() {
        return workerPayState;
    }

    public void setWorkerPayState(Integer workerPayState) {
        this.workerPayState = workerPayState;
    }
    public BigDecimal getWorkerShouldPayTaxMny() {
        return workerShouldPayTaxMny;
    }

    public void setWorkerShouldPayTaxMny(BigDecimal workerShouldPayTaxMny) {
        this.workerShouldPayTaxMny = workerShouldPayTaxMny;
    }
    public BigDecimal getWorkerShouldPayMny() {
        return workerShouldPayMny;
    }

    public void setWorkerShouldPayMny(BigDecimal workerShouldPayMny) {
        this.workerShouldPayMny = workerShouldPayMny;
    }
    public BigDecimal getWorkerShouldPayTax() {
        return workerShouldPayTax;
    }

    public void setWorkerShouldPayTax(BigDecimal workerShouldPayTax) {
        this.workerShouldPayTax = workerShouldPayTax;
    }
    public BigDecimal getWorkerRemainderTaxMny() {
        return workerRemainderTaxMny;
    }

    public void setWorkerRemainderTaxMny(BigDecimal workerRemainderTaxMny) {
        this.workerRemainderTaxMny = workerRemainderTaxMny;
    }
    public BigDecimal getWorkerRemainderMny() {
        return workerRemainderMny;
    }

    public void setWorkerRemainderMny(BigDecimal workerRemainderMny) {
        this.workerRemainderMny = workerRemainderMny;
    }
    public BigDecimal getWorkerRemainderTax() {
        return workerRemainderTax;
    }

    public void setWorkerRemainderTax(BigDecimal workerRemainderTax) {
        this.workerRemainderTax = workerRemainderTax;
    }
    public BigDecimal getWorkerTotalApplyTaxMny() {
        return workerTotalApplyTaxMny;
    }

    public void setWorkerTotalApplyTaxMny(BigDecimal workerTotalApplyTaxMny) {
        this.workerTotalApplyTaxMny = workerTotalApplyTaxMny;
    }
    public BigDecimal getWorkerTotalApplyMny() {
        return workerTotalApplyMny;
    }

    public void setWorkerTotalApplyMny(BigDecimal workerTotalApplyMny) {
        this.workerTotalApplyMny = workerTotalApplyMny;
    }
    public BigDecimal getWorkerTotalApplyTax() {
        return workerTotalApplyTax;
    }

    public void setWorkerTotalApplyTax(BigDecimal workerTotalApplyTax) {
        this.workerTotalApplyTax = workerTotalApplyTax;
    }
    public BigDecimal getWorkerApplyTaxMny() {
        return workerApplyTaxMny;
    }

    public void setWorkerApplyTaxMny(BigDecimal workerApplyTaxMny) {
        this.workerApplyTaxMny = workerApplyTaxMny;
    }
    public BigDecimal getWorkerApplyMny() {
        return workerApplyMny;
    }

    public void setWorkerApplyMny(BigDecimal workerApplyMny) {
        this.workerApplyMny = workerApplyMny;
    }
    public BigDecimal getWorkerApplyTax() {
        return workerApplyTax;
    }

    public void setWorkerApplyTax(BigDecimal workerApplyTax) {
        this.workerApplyTax = workerApplyTax;
    }
    public BigDecimal getWorkerActualPaidTaxMny() {
        return workerActualPaidTaxMny;
    }

    public void setWorkerActualPaidTaxMny(BigDecimal workerActualPaidTaxMny) {
        this.workerActualPaidTaxMny = workerActualPaidTaxMny;
    }
    public BigDecimal getWorkerActualPaidMny() {
        return workerActualPaidMny;
    }

    public void setWorkerActualPaidMny(BigDecimal workerActualPaidMny) {
        this.workerActualPaidMny = workerActualPaidMny;
    }
    public BigDecimal getWorkerActualPaidTax() {
        return workerActualPaidTax;
    }

    public void setWorkerActualPaidTax(BigDecimal workerActualPaidTax) {
        this.workerActualPaidTax = workerActualPaidTax;
    }
    public Integer getWorkerIsRepeatBill() {
        return workerIsRepeatBill;
    }

    public void setWorkerIsRepeatBill(Integer workerIsRepeatBill) {
        this.workerIsRepeatBill = workerIsRepeatBill;
    }
    public Long getIdOld() {
        return idOld;
    }

    public void setIdOld(Long idOld) {
        this.idOld = idOld;
    }
    public BigDecimal getWorkerApplyTaxMnyOld() {
        return workerApplyTaxMnyOld;
    }

    public void setWorkerApplyTaxMnyOld(BigDecimal workerApplyTaxMnyOld) {
        this.workerApplyTaxMnyOld = workerApplyTaxMnyOld;
    }
    public String getWorkerMemo() {
        return workerMemo;
    }

    public void setWorkerMemo(String workerMemo) {
        this.workerMemo = workerMemo;
    }
    public String getPmPayApplyDetailId() {
        return pmPayApplyDetailId;
    }

    public void setPmPayApplyDetailId(String pmPayApplyDetailId) {
        this.pmPayApplyDetailId = pmPayApplyDetailId;
    }
    public String getWorkerInterBankNum() {
        return workerInterBankNum;
    }

    public void setWorkerInterBankNum(String workerInterBankNum) {
        this.workerInterBankNum = workerInterBankNum;
    }
    public String getWorkerBankProvince() {
        return workerBankProvince;
    }

    public void setWorkerBankProvince(String workerBankProvince) {
        this.workerBankProvince = workerBankProvince;
    }
    public BigDecimal getProposedPaymentMny() {
        return proposedPaymentMny;
    }

    public void setProposedPaymentMny(BigDecimal proposedPaymentMny) {
        this.proposedPaymentMny = proposedPaymentMny;
    }
    public String getWorkerPhone() {
        return workerPhone;
    }

    public void setWorkerPhone(String workerPhone) {
        this.workerPhone = workerPhone;
    }
    public Long getGenerateId() {
        return generateId;
    }

    public void setGenerateId(Long generateId) {
        this.generateId = generateId;
    }
    
}
