package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.profinance.person.bean.PersonLoanEntity;
import com.ejianc.business.profinance.plan.service.*;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.mapper.RegulateMapper;
import com.ejianc.business.profinance.bean.RegulateEntity;
import com.ejianc.business.profinance.service.IRegulateService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款管理 中间表
 * 
 * @author generator
 * 
 */
@Service("regulateService")
public class RegulateServiceImpl extends BaseServiceImpl<RegulateMapper, RegulateEntity> implements IRegulateService{

    @Override
    public Map<String, BigDecimal> fetchTotalMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("ifnull(sum(plan_pay_mny), 0) as totalPlanPayMny, ifnull(sum(paid_mny), 0) as totalPaidMny");
        return super.getMap(wrapper);
    }


    @Override
    public void updateColumnValue(List<Long> ids, String column, String value) {
        UpdateWrapper<RegulateEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("source_id", ids);
        updateWrapper.set(column, value);
        super.update(updateWrapper);
    }

}
