package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目资金计划-零星材料采购
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan_material")
public class PlanMaterialEntity extends BaseEntity {
	private static final long serialVersionUID = 7841910269385220226L;

	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "material_settle_type")
	private String materialSettleType; // 结算单类型
	@TableField(value = "material_settle_type_name")
	private String materialSettleTypeName; // 结算单类型名称
	@TableField(value = "material_settle_id")
	private Long materialSettleId; // 结算单Id
	@TableField(value = "material_settle_code")
	private String materialSettleCode; // 结算单编码
	@TableField(value = "material_settle_date")
	private Date materialSettleDate; // 结算日期
	@TableField(value = "material_settle_route_url")
	private String materialSettleRouteUrl; // 零星材料采购路由地址
	@TableField(value = "material_pay_type_no_contract_id")
	private Long materialPayTypeNoContractId; // 无合同费用类型id
	@TableField(value = "material_pay_type_no_contract_code")
	private String materialPayTypeNoContractCode; // 无合同费用类型编码
	@TableField(value = "material_pay_type_no_contract_name")
	private String materialPayTypeNoContractName; // 无合同费用类型名称
	@TableField(value = "material_partyb_id")
	private Long materialPartybId; // 结算乙方Id
	@TableField(value = "material_partyb_name")
	private String materialPartybName; // 收款单位 =结算乙方名称
	@TableField(value = "material_settle_mny")
	private BigDecimal materialSettleMny; // 结算金额
	@TableField(value = "material_payment_content")
	private String materialPaymentContent; // 付款内容
	@TableField(value = "material_settle_mode_id")
	private Long materialSettleModeId; // 结算方式id =自定义档案【大企业收付款登记-结算方式】
	@TableField(value = "material_settle_mode_code")
	private String materialSettleModeCode; // 结算方式编码
	@TableField(value = "material_settle_mode_name")
	private String materialSettleModeName; // 结算方式名称
	@TableField(value = "material_applied_mny")
	private BigDecimal materialAppliedMny; // 已申请金额(不含本次)
	@TableField(value = "material_can_apply_mny")
	private BigDecimal materialCanApplyMny; // 本次可申请金额
	@TableField(value = "material_plan_payment_mny")
	private BigDecimal materialPlanPaymentMny; // 本次计划付款金额
	@TableField(value = "material_total_apply_payment_mny")
	private BigDecimal materialTotalApplyPaymentMny; // 累计申请付款金额(含本次)
	@TableField(value = "material_paid_scale")
	private BigDecimal materialPaidScale; // 已付款比例%（含本次）
	@TableField(value = "material_memo")
	private String materialMemo; // 备注
	@TableField(value = "total_actual_payment_mny")
	private BigDecimal totalActualPaymentMny; // 本次累计实付金额
	@TableField(value = "unpaid_mny")
	private BigDecimal unpaidMny; // 本次未支付金额
	@TableField(value = "release_apply_mny")
	private BigDecimal releaseApplyMny; // 本次释放申请金额
	@TableField(value = "close_state")
	private String closeState; // 关闭状态 已关闭 未关闭
	@TableField(value = "close_date_time")
	private Date closeDateTime; // 关闭时间
	@TableField(value = "close_user_id")
	private Long closeUserId; // 关闭人
	@TableField(value = "close_user_name")
	private String closeUserName; // 关闭人名称
	@TableField(value = "close_user_code")
	private String closeUserCode; // 关闭人编码
	@TableField(value = "plan_id")
	private Long planId; // 项目资金计划id


	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public String getMaterialSettleType() {
		return materialSettleType;
	}

	public void setMaterialSettleType(String materialSettleType) {
		this.materialSettleType = materialSettleType;
	}

	public String getMaterialSettleTypeName() {
		return materialSettleTypeName;
	}

	public void setMaterialSettleTypeName(String materialSettleTypeName) {
		this.materialSettleTypeName = materialSettleTypeName;
	}

	public Long getMaterialSettleId() {
		return materialSettleId;
	}

	public void setMaterialSettleId(Long materialSettleId) {
		this.materialSettleId = materialSettleId;
	}

	public String getMaterialSettleCode() {
		return materialSettleCode;
	}

	public void setMaterialSettleCode(String materialSettleCode) {
		this.materialSettleCode = materialSettleCode;
	}

	public Date getMaterialSettleDate() {
		return materialSettleDate;
	}

	public void setMaterialSettleDate(Date materialSettleDate) {
		this.materialSettleDate = materialSettleDate;
	}

	public String getMaterialSettleRouteUrl() {
		return materialSettleRouteUrl;
	}

	public void setMaterialSettleRouteUrl(String materialSettleRouteUrl) {
		this.materialSettleRouteUrl = materialSettleRouteUrl;
	}

	public Long getMaterialPayTypeNoContractId() {
		return materialPayTypeNoContractId;
	}

	public void setMaterialPayTypeNoContractId(Long materialPayTypeNoContractId) {
		this.materialPayTypeNoContractId = materialPayTypeNoContractId;
	}

	public String getMaterialPayTypeNoContractCode() {
		return materialPayTypeNoContractCode;
	}

	public void setMaterialPayTypeNoContractCode(String materialPayTypeNoContractCode) {
		this.materialPayTypeNoContractCode = materialPayTypeNoContractCode;
	}

	public String getMaterialPayTypeNoContractName() {
		return materialPayTypeNoContractName;
	}

	public void setMaterialPayTypeNoContractName(String materialPayTypeNoContractName) {
		this.materialPayTypeNoContractName = materialPayTypeNoContractName;
	}

	public Long getMaterialPartybId() {
		return materialPartybId;
	}

	public void setMaterialPartybId(Long materialPartybId) {
		this.materialPartybId = materialPartybId;
	}

	public String getMaterialPartybName() {
		return materialPartybName;
	}

	public void setMaterialPartybName(String materialPartybName) {
		this.materialPartybName = materialPartybName;
	}

	public BigDecimal getMaterialSettleMny() {
		return materialSettleMny;
	}

	public void setMaterialSettleMny(BigDecimal materialSettleMny) {
		this.materialSettleMny = materialSettleMny;
	}

	public String getMaterialPaymentContent() {
		return materialPaymentContent;
	}

	public void setMaterialPaymentContent(String materialPaymentContent) {
		this.materialPaymentContent = materialPaymentContent;
	}

	public Long getMaterialSettleModeId() {
		return materialSettleModeId;
	}

	public void setMaterialSettleModeId(Long materialSettleModeId) {
		this.materialSettleModeId = materialSettleModeId;
	}

	public String getMaterialSettleModeCode() {
		return materialSettleModeCode;
	}

	public void setMaterialSettleModeCode(String materialSettleModeCode) {
		this.materialSettleModeCode = materialSettleModeCode;
	}

	public String getMaterialSettleModeName() {
		return materialSettleModeName;
	}

	public void setMaterialSettleModeName(String materialSettleModeName) {
		this.materialSettleModeName = materialSettleModeName;
	}

	public BigDecimal getMaterialAppliedMny() {
		return materialAppliedMny;
	}

	public void setMaterialAppliedMny(BigDecimal materialAppliedMny) {
		this.materialAppliedMny = materialAppliedMny;
	}

	public BigDecimal getMaterialCanApplyMny() {
		return materialCanApplyMny;
	}

	public void setMaterialCanApplyMny(BigDecimal materialCanApplyMny) {
		this.materialCanApplyMny = materialCanApplyMny;
	}

	public BigDecimal getMaterialPlanPaymentMny() {
		return materialPlanPaymentMny;
	}

	public void setMaterialPlanPaymentMny(BigDecimal materialPlanPaymentMny) {
		this.materialPlanPaymentMny = materialPlanPaymentMny;
	}

	public BigDecimal getMaterialTotalApplyPaymentMny() {
		return materialTotalApplyPaymentMny;
	}

	public void setMaterialTotalApplyPaymentMny(BigDecimal materialTotalApplyPaymentMny) {
		this.materialTotalApplyPaymentMny = materialTotalApplyPaymentMny;
	}

	public BigDecimal getMaterialPaidScale() {
		return materialPaidScale;
	}

	public void setMaterialPaidScale(BigDecimal materialPaidScale) {
		this.materialPaidScale = materialPaidScale;
	}

	public String getMaterialMemo() {
		return materialMemo;
	}

	public void setMaterialMemo(String materialMemo) {
		this.materialMemo = materialMemo;
	}

	public BigDecimal getTotalActualPaymentMny() {
		return totalActualPaymentMny;
	}

	public void setTotalActualPaymentMny(BigDecimal totalActualPaymentMny) {
		this.totalActualPaymentMny = totalActualPaymentMny;
	}

	public BigDecimal getUnpaidMny() {
		return unpaidMny;
	}

	public void setUnpaidMny(BigDecimal unpaidMny) {
		this.unpaidMny = unpaidMny;
	}

	public BigDecimal getReleaseApplyMny() {
		return releaseApplyMny;
	}

	public void setReleaseApplyMny(BigDecimal releaseApplyMny) {
		this.releaseApplyMny = releaseApplyMny;
	}

	public String getCloseState() {
		return closeState;
	}

	public void setCloseState(String closeState) {
		this.closeState = closeState;
	}

	public Date getCloseDateTime() {
		return closeDateTime;
	}

	public void setCloseDateTime(Date closeDateTime) {
		this.closeDateTime = closeDateTime;
	}

	public Long getCloseUserId() {
		return closeUserId;
	}

	public void setCloseUserId(Long closeUserId) {
		this.closeUserId = closeUserId;
	}

	public String getCloseUserName() {
		return closeUserName;
	}

	public void setCloseUserName(String closeUserName) {
		this.closeUserName = closeUserName;
	}

	public String getCloseUserCode() {
		return closeUserCode;
	}

	public void setCloseUserCode(String closeUserCode) {
		this.closeUserCode = closeUserCode;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

}
