/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.PMPayEntity;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.common.enums.BillHandleTypeEnum;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.service.ICommonBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.business.profinance.enums.PaymentTypeEnum;
import com.ejianc.business.profinance.mapper.PMPayMapper;
import com.ejianc.business.profinance.service.IPMPayService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.vo.PMPayVO;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="pMPayService")
public class PMPayServiceImpl
extends BaseServiceImpl<PMPayMapper, PMPayEntity>
implements IPMPayService,
ICommonBillHandleResultService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IPaymentApplyService paymentApplyService;
    @Autowired
    private IPMPayApplyApi pmPayApplyApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPaymentRegisterService registerService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillHandleResultService billHandleResultService;
    private final String OPERATE = "PROFINANCE_PAY_RESULT";
    private long retryInterval = 5000L;
    private final int maxRetryTime = 10;
    private static final String REGISTER_BILL_CODE = "PAYMENT_REGISTER";
    private final String tenantRootAuth = "TENANT_ROOT_AUTH::";

    @Override
    public void sendMessage(PMPayVO pmPayVO) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)pmPayVO);
        this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u4ed8\u6b3e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)pmPayVO));
        this.rabbitTemplate.convertAndSend("payresult", (Object)mqMessage);
    }

    @Override
    public boolean recordBillHandleResult(BillHandleResultVO billHandleResultVO) {
        this.logger.info("\u4ece\u961f\u5217\u4e2d\u6536\u5230\u652f\u4ed8\u901a\u77e5\u5355\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billHandleResultVO));
        if (BillHandleResultVO.HANDLE_CODE_FAIL.equals(billHandleResultVO.getHandleResultCode())) {
            PMPayVO pmPayVO = (PMPayVO)JSONObject.parseObject((String)billHandleResultVO.getBillDataJson(), PMPayVO.class);
            PMPayEntity entity = (PMPayEntity)((Object)this.selectById(pmPayVO.getId()));
            this.logger.info("\u6839\u636e\u9884\u6838\u9500\u6570\u636e-{} \u67e5\u8be2\u5230\u5339\u914d\u7684\u5f85\u6838\u9500\u8bb0\u5f55-{}", (Object)billHandleResultVO.getBillDataJson(), (Object)(null != entity ? JSONObject.toJSONString((Object)((Object)entity)) : null));
            entity.setPaidFlag(PMPayVO.PAID_FLAG_HANDLE_FAIL);
            entity.setPayResultMessage(billHandleResultVO.getHandleResultMsg());
            super.saveOrUpdate((Object)entity, false);
        }
        return true;
    }

    public String getAuthority(Long tenantId) {
        String authority = (String)((Object)this.cacheManager.get("TENANT_ROOT_AUTH::" + tenantId.toString()));
        if (StringUtils.isBlank((CharSequence)authority)) {
            try {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("tenantId", tenantId);
                this.logger.info("baseHost " + this.BASE_HOST);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/json;charset=UTF-8");
                String back = HttpTookit.get((String)(this.BASE_HOST + "ejc-idm-web/user/context/getBytenantid"), params, headers);
                JSONObject jsonBack = JSONObject.parseObject((String)back);
                if (jsonBack.get((Object)"data") != null) {
                    JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                    this.logger.info("data  " + data.toJSONString());
                    if (data.get((Object)"userContext") != null) {
                        JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                        this.cacheManager.setex("TENANT_ROOT_AUTH::" + tenantId.toString(), (Serializable)((Object)authority), 1500);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u6a21\u62df\u767b\u5f55\u5f02\u5e38: ", (Throwable)e);
                return null;
            }
        }
        return authority;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handPayResult(String payResultMsg) {
        block28: {
            this.logger.info("\u4ece\u6d88\u606f\u961f\u5217\u4e2d\u83b7\u53d6\u5230\u5f85\u5904\u7406\u7684\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)payResultMsg);
            PMPayVO payResultVO = (PMPayVO)JSONObject.parseObject((String)payResultMsg, PMPayVO.class);
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("\u4e00\u5efa\u8d22\u52a1\u4ed8\u6b3e\u7ed3\u679c\u901a\u77e5\u5355\uff1a[id-").append(payResultVO.getId()).append("]\u4e2d\u95f4\u8868\u6838\u9500\u5904\u7406");
            this.logger.info("\u5904\u7406\u4ed8\u6b3e\u6570\u636e-{}\u524d\u52a0\u9501", (Object)JSONObject.toJSONString((Object)payResultVO));
            String redisKey = payResultVO.getProjectId() + "::" + payResultVO.getSupplyId() + "::" + payResultVO.getContractId() + "::" + payResultVO.getPayeeId();
            this.logger.info("\u5bf9\u4fdd\u5b58\u64cd\u4f5c\u6dfb\u52a0Redis\u9501\uff0credisKey-{}", (Object)redisKey);
            Jedis jedis = this.jedisPool.getResource();
            this.logger.info("\u4ecejedisPool\u83b7\u53d6jedis\u5bf9\u8c61\uff0cjedis\u5bf9\u8c61-{}", (Object)jedis);
            boolean lock = this.getLock(redisKey, jedis);
            if (!lock) {
                this.logger.info("\u952e-{}\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25,\u5c06\u4ed8\u6b3e\u7ed3\u679c-{}\u91cd\u65b0\u653e\u5165\u961f\u5217\u8fdb\u884c\u5904\u7406", (Object)redisKey, (Object)payResultMsg);
                this.sendMessage(payResultVO);
                return;
            }
            try {
                if (null == payResultVO) break block28;
                QueryParam registerQuery = new QueryParam();
                QueryWrapper listQuery = new QueryWrapper();
                this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u6838\u9500\u63a5\u53e3---ejc-profinance\u9879\u76ee---payResultServiceImpl\u7c7b---handPayResult\u65b9\u6cd5---begin------------->");
                this.logger.info("\u901a\u8fc7\u4ed8\u6b3e\u7ed3\u679c\u56db\u4e2a\u7ef4\u5ea6 \u9879\u76eeid-projectId {}\uff0c\u5408\u540cid-contractId {}\uff0c\u4f9b\u5e94\u5546id-supplierId {}\uff0c\u6536\u6b3e\u5355\u4f4did-payeeId {} \u67e5\u8be2\u5bf9\u5e94\u7684\u4ed8\u6b3e\u7533\u8bf7\u3002", new Object[]{payResultVO.getProjectId(), payResultVO.getContractId(), payResultVO.getSupplyId(), payResultVO.getPayeeId()});
                if ("-1".equals(payResultVO.getContractId().toString())) {
                    listQuery.isNull((Object)"contract_id");
                } else {
                    listQuery.eq((Object)"contract_id", (Object)payResultVO.getContractId());
                }
                BigDecimal payMnyActual = payResultVO.getPayMnyActual();
                boolean isRefund = payMnyActual.compareTo(BigDecimal.ZERO) < 0;
                listQuery.eq((Object)"project_id", (Object)payResultVO.getProjectId());
                listQuery.eq((Object)"supplier_id", (Object)payResultVO.getSupplyId());
                listQuery.eq((Object)"payee_id", (Object)payResultVO.getPayeeId());
                listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                if (isRefund) {
                    listQuery.ge((Object)"actual_mny", (Object)BigDecimal.ZERO);
                    listQuery.orderByDesc((Object)"apply_date");
                } else {
                    listQuery.orderByAsc((Object)"apply_date");
                }
                List paymentApplyList = this.paymentApplyService.list((Wrapper)listQuery);
                this.logger.info("\u901a\u8fc7\u4ed8\u6b3e\u7ed3\u679c\u56db\u4e2a\u7ef4\u5ea6 \u67e5\u51fa\u76f8\u5e94\u4ed8\u6b3e\u7533\u8bf7 {} \u6761", (Object)paymentApplyList.size());
                registerQuery.getParams().put("project_id", new Parameter("eq", (Object)payResultVO.getProjectId()));
                registerQuery.getParams().put("supplier_id", new Parameter("eq", (Object)payResultVO.getProjectId()));
                registerQuery.getParams().put("project_id", new Parameter("eq", (Object)payResultVO.getProjectId()));
                registerQuery.getParams().put("project_id", new Parameter("eq", (Object)payResultVO.getProjectId()));
                BigDecimal totalActualPayAndRegisterDiffMny = this.registerService.getAcutalPayAndRegisterDiffMny(payResultVO.getProjectId(), payResultVO.getSupplyId(), payResultVO.getPayeeId(), payResultVO.getContractId());
                this.logger.info("\u901a\u8fc7\u4ed8\u6b3e\u7ed3\u679c\u56db\u4e2a\u7ef4\u5ea6 \u9879\u76eeid-projectId {}\uff0c\u5408\u540cid-contractId {}\uff0c\u4f9b\u5e94\u5546id-supplierId {}\uff0c\u6536\u6b3e\u5355\u4f4did-payeeId {}\u7edf\u8ba1\uff0c\u67e5\u8be2\u51fa\u4ed8\u6b3e\u7533\u8bf7\u5355\u5b9e\u4ed8\u603b\u91d1\u989d - \u4ed8\u6b3e\u767b\u8bb0\u603b\u91d1\u989d \u7684\u5dee\u989d\uff1a{}", new Object[]{payResultVO.getProjectId(), payResultVO.getContractId(), payResultVO.getSupplyId(), payResultVO.getPayeeId(), totalActualPayAndRegisterDiffMny});
                BigDecimal payRegisterAddMny = BigDecimal.ZERO;
                ArrayList<PaymentApplyEntity> updateList = new ArrayList<PaymentApplyEntity>();
                if (CollectionUtils.isNotEmpty((Collection)paymentApplyList)) {
                    BigDecimal actualPaidMny = payResultVO.getPayMnyActual();
                    BigDecimal remainAbleMny = null;
                    if (isRefund) {
                        if (totalActualPayAndRegisterDiffMny.compareTo(BigDecimal.ZERO) > 0) {
                            payRegisterAddMny = totalActualPayAndRegisterDiffMny;
                            this.logger.info("\u901a\u8fc7\u4ed8\u6b3e\u7ed3\u679c\u56db\u4e2a\u7ef4\u5ea6 \u9879\u76eeid-projectId {}\uff0c\u5408\u540cid-contractId {}\uff0c\u4f9b\u5e94\u5546id-supplierId {}\uff0c\u6536\u6b3e\u5355\u4f4did-payeeId {}\u7edf\u8ba1\uff0c\u4ed8\u6b3e\u5355\u5b9e\u4ed8\u5927\u4e8e\u767b\u8bb0\u603b\u91d1\u989d\uff0c\u4ed8\u6b3e\u767b\u8bb0\u51b2\u8d26\u91d1\u989d\u4e3a\uff1a{} + {}", new Object[]{payResultVO.getProjectId(), payResultVO.getContractId(), payResultVO.getSupplyId(), payResultVO.getPayeeId(), actualPaidMny, payRegisterAddMny});
                        } else if (totalActualPayAndRegisterDiffMny.compareTo(BigDecimal.ZERO) < 0) {
                            actualPaidMny = actualPaidMny.subtract(totalActualPayAndRegisterDiffMny);
                            this.logger.info("\u901a\u8fc7\u4ed8\u6b3e\u7ed3\u679c\u56db\u4e2a\u7ef4\u5ea6 \u9879\u76eeid-projectId {}\uff0c\u5408\u540cid-contractId {}\uff0c\u4f9b\u5e94\u5546id-supplierId {}\uff0c\u6536\u6b3e\u5355\u4f4did-payeeId {}\u7edf\u8ba1\uff0c\u4ed8\u6b3e\u5355\u5b9e\u4ed8\u5927\u4e8e\u767b\u8bb0\u603b\u91d1\u989d\uff0c\u4ed8\u6b3e\u5b9e\u9645\u51b2\u8d26\u91d1\u989d\u8c03\u6574\u4e3a\uff1a{}", new Object[]{payResultVO.getProjectId(), payResultVO.getContractId(), payResultVO.getSupplyId(), payResultVO.getPayeeId(), actualPaidMny});
                        }
                        for (PaymentApplyEntity paymentApply : paymentApplyList) {
                            updateList.add(paymentApply);
                            this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355-[{}] \u6267\u884c\u9000\u6b3e\u64cd\u4f5c", (Object)JSONObject.toJSONString((Object)((Object)paymentApply), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                            if (actualPaidMny.abs().compareTo(paymentApply.getActualMny()) < 0) {
                                this.logger.info("\u4ed8\u6b3e\u5355\u7533\u8bf7\u91d1\u989d\uff1a{}\uff0c\u5b9e\u4ed8\u91d1\u989d\uff1a{}, \u672c\u6b21\u9000\u6b3e\u91d1\u989d: {}", new Object[]{paymentApply.getApprovalMny(), paymentApply.getActualMny(), actualPaidMny.abs()});
                                paymentApply.setActualMny(paymentApply.getActualMny().add(actualPaidMny));
                                this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u6267\u884c\u9000\u6b3e\u64cd\u4f5c\u5b8c\u6210\uff0c\u7ec8\u6b62\u5faa\u73af\uff01");
                                break;
                            }
                            this.logger.info("\u4ed8\u6b3e\u5355\u7533\u8bf7\u91d1\u989d\uff1a{}\uff0c\u5b9e\u4ed8\u91d1\u989d\uff1a{}, \u672c\u6b21\u9000\u6b3e\u91d1\u989d: {}", new Object[]{paymentApply.getApprovalMny(), paymentApply.getActualMny(), paymentApply.getActualMny()});
                            paymentApply.setPaymentStatus(1);
                            actualPaidMny = actualPaidMny.add(paymentApply.getActualMny());
                            paymentApply.setActualMny(BigDecimal.ZERO);
                        }
                    } else {
                        for (PaymentApplyEntity paymentApply : paymentApplyList) {
                            if (null == paymentApply.getActualMny()) {
                                paymentApply.setActualMny(BigDecimal.ZERO);
                            } else if (paymentApply.getActualMny().compareTo(paymentApply.getApprovalMny()) >= 0) {
                                this.logger.info("\u4ed8\u6b3e\u5355-{}\u5df2\u652f\u4ed8\u91d1\u989d-{}\u7b49\u4e8e\u6279\u590d\u91d1\u989d-{}\uff0c\u8df3\u8fc7\u6b64\u4ed8\u6b3e\u5355\u7684\u6838\u9500\u5904\u7406\uff01", new Object[]{paymentApply.getId().toString(), paymentApply.getActualMny(), paymentApply.getApprovalMny()});
                                continue;
                            }
                            remainAbleMny = paymentApply.getApprovalMny().subtract(paymentApply.getActualMny());
                            paymentApply.setPaymentStatus(2);
                            updateList.add(paymentApply);
                            this.logger.info("\u7ed9\u4ed8\u6b3e\u7533\u8bf7\u5355\u6267\u884c\u6838\u9500\u64cd\u4f5c\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355{}", (Object)JSONObject.toJSONString((Object)((Object)paymentApply), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                            if (actualPaidMny.compareTo(remainAbleMny) == 1) {
                                this.logger.info("\u4ed8\u6b3e\u5355\u7533\u8bf7\u91d1\u989d\uff1a{}\uff0c\u5b9e\u4ed8\u91d1\u989d\uff1a{}, \u672c\u6b21\u589e\u52a0\u5b9e\u4ed8\u91d1\u989d: {}", new Object[]{paymentApply.getApprovalMny(), paymentApply.getActualMny(), remainAbleMny});
                                paymentApply.setActualMny(paymentApply.getApprovalMny());
                                actualPaidMny = actualPaidMny.subtract(remainAbleMny);
                                continue;
                            }
                            this.logger.info("\u4ed8\u6b3e\u5355\u7533\u8bf7\u91d1\u989d\uff1a{}\uff0c\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0c\u672c\u6b21\u589e\u52a0\u5b9e\u4ed8\u91d1\u989d: {}", new Object[]{paymentApply.getApprovalMny(), paymentApply.getActualMny(), actualPaidMny});
                            paymentApply.setActualMny(paymentApply.getActualMny().add(actualPaidMny));
                            actualPaidMny = BigDecimal.ZERO;
                            break;
                        }
                    }
                    if (actualPaidMny.compareTo(BigDecimal.ZERO) != 0) {
                        this.billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, "\u6ce8\u610f\uff1a\u8be5\u4ed8\u6b3e\u7533\u8bf7\u5355\u91d1\u989d\u672a\u5168\u90e8\u5904\u7406\uff01\uff01\uff01", false);
                    }
                    if (CollectionUtils.isEmpty(updateList)) {
                        this.logger.error("\u5f85\u6838\u9500\u4ed8\u6b3e-{}\u6ca1\u6709\u53ef\u7528\u4e8e\u6838\u9500\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff01", (Object)payResultMsg);
                        msgBuilder.append("\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u7528\u4e8e\u6838\u9500\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff01");
                    } else {
                        this.paymentApplyService.saveOrUpdateBatch(updateList, updateList.size(), false);
                        PMPayApplyVO pmPayApplyVO = new PMPayApplyVO();
                        pmPayApplyVO.setProjectId(payResultVO.getProjectId().toString());
                        pmPayApplyVO.setSupplierId(payResultVO.getSupplyId().toString());
                        pmPayApplyVO.setContractRegisterId(payResultVO.getContractId().toString());
                        pmPayApplyVO.setPayeeId(payResultVO.getPayeeId().toString());
                        pmPayApplyVO.setPayMnyActual(payResultVO.getPayMnyActual());
                        pmPayApplyVO.setIsContract(Integer.valueOf("-1".equals(payResultVO.getContractId().toString()) ? 0 : 1));
                        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u9500\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString((Object)payResultVO));
                        CommonResponse res = this.pmPayApplyApi.writeOff(pmPayApplyVO);
                        PMPayEntity payResultEntity = (PMPayEntity)((Object)BeanMapper.map((Object)payResultVO, PMPayEntity.class));
                        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u9500\u63a5\u53e3---ejc-profinance\u9879\u76ee---payResultServiceImpl\u7c7b---handPayResult\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                        if (!res.isSuccess()) {
                            this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u5355-{}\u6838\u9500\u5931\u8d25\uff0c\u8bbe\u7f6e\u66f4\u65b0\u4e2d\u95f4\u8868\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)payResultEntity.getId(), (Object)res.getMsg());
                            msgBuilder.append("\u5931\u8d25\uff0c\u66f4\u65b0\u4e2d\u95f4\u8868\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + res.getMsg());
                            this.billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString());
                            throw new BusinessException("\u4ed8\u6b3e\u7533\u8bf7\u5355-" + payResultEntity.getId() + "\u6838\u9500\u5931\u8d25, \u66f4\u65b0\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff01");
                        }
                        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u9500\u6210\u529f\uff01\u8bbe\u7f6e\u4ed8\u6b3e\u8bb0\u5f55\u5355\u4ed8\u6b3e\u7ed3\u679c\u4fe1\u606f \u4ed8\u6b3e\u6210\u529f");
                        payResultEntity.setPaidFlag(1);
                        payResultEntity.setPayResultMessage("\u4ed8\u6b3e\u6838\u9500\u6210\u529f!");
                        super.saveOrUpdate((Object)payResultEntity);
                        this.generatePayRecord((PaymentApplyEntity)((Object)paymentApplyList.get(0)), payResultVO, payResultVO.getPayMnyActual().add(payRegisterAddMny));
                        msgBuilder.append("\u6210\u529f\uff01");
                    }
                    this.billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_SUC, msgBuilder.toString(), false);
                    break block28;
                }
                this.logger.error("\u5f85\u6838\u9500\u4ed8\u6b3e-{}\u6ca1\u6709\u53ef\u7528\u4e8e\u6838\u9500\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff01", (Object)payResultMsg);
                this.billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, "\u6ca1\u6709\u53ef\u7528\u4e8e\u6838\u9500\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355!");
            }
            catch (Exception e) {
                this.logger.error("\u5904\u7406\u4ed8\u6b3e\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)JSONObject.toJSONString((Object)payResultVO), (Object)e);
                msgBuilder.append("\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                this.billHandleResultService.sendHandleResult(payResultMsg, payResultVO.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString());
                if (e.getMessage() == null) {
                    throw new BusinessException("\u4ed8\u6b3e\u7533\u8bf7\u5355-" + payResultVO.getId() + "\u6838\u9500\u5931\u8d25, \u66f4\u65b0\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff01");
                }
                throw new BusinessException("\u4ed8\u6b3e\u7533\u8bf7\u5355-" + payResultVO.getId() + e.getMessage());
            }
            finally {
                this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)redisKey);
                this.unLock(jedis, true, redisKey, "PROFINANCE_PAY_RESULT");
            }
        }
    }

    public String getPayType(Integer payType) {
        switch (payType) {
            case 1: {
                return "\u9884\u4ed8\u6b3e";
            }
            case 2: {
                return "\u8bc9\u8bbc\u6b3e";
            }
            case 3: {
                return "\u96f6\u661f\u6750\u6599\u8d39\u7528";
            }
            case 4: {
                return "\u4e34\u65f6\u8bbe\u5907\u8d39\u7528";
            }
        }
        return "\u6b63\u5e38\u4ed8\u6b3e";
    }

    private void generatePayRecord(PaymentApplyEntity entity, PMPayVO payResultVO, BigDecimal actualPayMny) {
        String authority = this.getAuthority(payResultVO.getTenantId());
        try {
            if (StringUtils.isBlank((CharSequence)authority)) {
                this.logger.error("\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355- [{}], \u652f\u4ed8\u7ed3\u679c-[{}], \u83b7\u53d6\u6a21\u62df\u767b\u5f55\u5931\u8d25\uff0c\u65e0\u6cd5\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\uff01", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)payResultVO));
                return;
            }
            InvocationInfoProxy.setTenantid((Long)payResultVO.getTenantId());
            String key = "userCode";
            int idx = authority.indexOf(";" + key + "=");
            if (idx >= 0) {
                String tmp = authority.substring(idx + 1);
                InvocationInfoProxy.setUsercode((String)tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
            }
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            PaymentRegisterEntity register = (PaymentRegisterEntity)((Object)BeanMapper.map((Object)((Object)entity), PaymentRegisterEntity.class));
            register.setPayMny(null != actualPayMny ? actualPayMny : payResultVO.getPayMnyActual());
            register.setPaymentDate(null != payResultVO.getPushTime() ? payResultVO.getPushTime() : new Date());
            register.setFeeTypeId(Long.parseLong(PaymentTypeEnum.\u6b63\u5e38\u4ed8\u6b3e.getCode()));
            register.setFeeTypeName(PaymentTypeEnum.\u6b63\u5e38\u4ed8\u6b3e.getDescription());
            register.setPaymentReason(payResultVO.getId().toString());
            register.setAccountId(null);
            register.setSourceType("\u4ed8\u6b3e\u7533\u8bf7");
            register.setSourceBillType(PaymentRegisterVO.SOURCE_BILL_TYPE_PAYMENT_APPLY);
            register.setAccountName(null);
            register.setId(null);
            if (null == entity.getContractId() || entity.getContractId().equals(-1L)) {
                register.setFeeTypeName(null != entity.getPaymentType() ? this.getPayType(entity.getPaymentType()) : "\u6b63\u5e38\u4ed8\u6b3e");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)REGISTER_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)register), PaymentRegisterVO.class)));
            Map reqParams = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)billCodeParam), Map.class);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            headers.put("Content-Type", "application/json;charset=UTF-8");
            this.logger.info("\u652f\u4ed8\u7ed3\u679c\u6838\u9500\uff0c\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u7f16\u7801\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)billCodeParam));
            String url = this.BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
            String codeRespStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString((Object)reqParams), headers, (Integer)10000, (Integer)10000);
            this.logger.info("\u83b7\u53d6\u4ed8\u6b3e\u767b\u8bb0\u7f16\u7801\u7ed3\u679c\uff1a{}", (Object)codeRespStr);
            CommonResponse codeResp = (CommonResponse)JSONObject.parseObject((String)codeRespStr, CommonResponse.class);
            if (!codeResp.isSuccess()) {
                this.logger.error("\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)codeRespStr);
                return;
            }
            register.setBillCode(codeResp.getData().toString());
            register.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            register.setCreateUserCode(entity.getCreateUserCode());
            register.setCreateTime(null != payResultVO.getPushTime() ? payResultVO.getPushTime() : new Date());
            this.logger.info("\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f-{}\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)((Object)register)), (Object)JSONObject.toJSONString((Object)((Object)entity)));
            this.registerService.saveOrUpdate((Object)register);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355- [{}], \u652f\u4ed8\u7ed3\u679c-[{}], \u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u5f02\u5e38\uff01", new Object[]{JSONObject.toJSONString((Object)((Object)entity)), JSONObject.toJSONString((Object)payResultVO), e});
        }
    }

    public boolean getLock(String key, Jedis jedis) {
        boolean lock = false;
        for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
            try {
                if (retryTime <= 0) continue;
                this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                Thread.sleep((long)retryTime * this.retryInterval);
                lock = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PROFINANCE_PAY_RESULT", (int)600);
                if (!lock) continue;
                return true;
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)key));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)operate);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

