/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.receipt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.pro.recipetApply.api.IWbRecipetApplyApi;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receiptRegister")
public class ReceiptRegisterBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReceiptRegisterService service;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IWbRecipetApplyApi wbrecip;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiptRegisterEntity entity = (ReceiptRegisterEntity)((Object)this.service.selectById(billId));
        this.contractPoolApi.updateActualPayRecMny(entity.getContractId(), entity.getSumReceivedMny(), entity.getSumReceivedMny(), true);
        if (entity.getRecipetApplyId() != null) {
            this.wbrecip.wbActualReceivedMny(entity.getSumReceivedMny(), entity.getRecipetApplyId(), true);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReceiptRegisterEntity entity = (ReceiptRegisterEntity)((Object)this.service.selectById(billId));
        this.contractPoolApi.updateActualPayRecMny(entity.getContractId(), entity.getSumReceivedMny(), entity.getSumReceivedMny(), false);
        if (entity.getRecipetApplyId() != null) {
            this.wbrecip.wbActualReceivedMny(entity.getSumReceivedMny(), entity.getRecipetApplyId(), false);
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ReceiptRegisterEntity entity = (ReceiptRegisterEntity)((Object)this.service.selectById(billId));
        if (entity.getSourceFlag() != null) {
            return CommonResponse.error((String)"\u5de5\u7a0b\u6536\u6b3e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        if (entity.getReceiptContractFlag() == 0) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"contract_id", (Object)entity.getContractId());
            listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            int resultCount = this.service.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u6536\u6b3e\u767b\u8bb0 \u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
            QueryWrapper listQueryOrderByTime = new QueryWrapper();
            listQueryOrderByTime.eq((Object)"contract_id", (Object)entity.getContractId());
            listQueryOrderByTime.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            listQueryOrderByTime.orderByDesc((Object)"create_time");
            List listOrderByTime = this.service.list((Wrapper)listQueryOrderByTime);
            if (CollectionUtils.isNotEmpty((Collection)listOrderByTime) && null != listOrderByTime.get(0) && !((ReceiptRegisterEntity)((Object)listOrderByTime.get(0))).getId().equals(billId)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u7684\u6536\u6b3e\u767b\u8bb0\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

