package com.ejianc.business.profinance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.profinance.bean.PayrollRegisterDetailEntity;
/**
 * 工资发放登记主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_payroll_register")
public class PayrollRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private String contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="provide_date")
    private Date provideDate; // 发放日期：默认显示当天
    @TableField(value="provide_type")
    private Integer provideType; // 发放类型：0：劳务公司直发，1：第三方垫付，2：总包代发
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 非必填，0-2000字
    @TableField(value="total_actual_mny")
    private BigDecimal totalActualMny; // 本期实发金额（子表汇总）
    @TableField(value="account_id")
    private Long accountId; // 银行账户id
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="salary_pay_apply_id")
    private Long salaryPayApplyId; // 付款申请单id
    @TableField(value="source_type")
    private Integer sourceType; // 数据来源方式 （0-手动确认支付结果为成功时推送，1-直接新增，2-财务推送）
    @TableField(value="contract_link_url")
    private String contractLinkUrl; //合同详情页面
    @TableField(value="salary_pay_apply_code")
    private String salaryPayApplyCode; //付款申请单编码

    
    @TableField(exist=false)
    @SubEntity(serviceName="payrollRegisterDetailService", pidName="payrollRegisterId")//此处有pid="xxx"，默认值pid="pid"
    private List<PayrollRegisterDetailEntity> payrollRegisterDetailList = new ArrayList<>(); // 工资发放登记子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getProvideDate() {
        return provideDate;
    }

    public void setProvideDate(Date provideDate) {
        this.provideDate = provideDate;
    }
    public Integer getProvideType() {
        return provideType;
    }

    public void setProvideType(Integer provideType) {
        this.provideType = provideType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTotalActualMny() {
        return totalActualMny;
    }

    public void setTotalActualMny(BigDecimal totalActualMny) {
        this.totalActualMny = totalActualMny;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    
    public List<PayrollRegisterDetailEntity> getPayrollRegisterDetailList() {
        return payrollRegisterDetailList;
    }

    public void setPayrollRegisterDetailList(List<PayrollRegisterDetailEntity> payrollRegisterDetailList) {
        this.payrollRegisterDetailList = payrollRegisterDetailList;
    }

    public Long getSalaryPayApplyId() {
        return salaryPayApplyId;
    }

    public void setSalaryPayApplyId(Long salaryPayApplyId) {
        this.salaryPayApplyId = salaryPayApplyId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    public String getSalaryPayApplyCode() {
        return salaryPayApplyCode;
    }

    public void setSalaryPayApplyCode(String salaryPayApplyCode) {
        this.salaryPayApplyCode = salaryPayApplyCode;
    }
}
