/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.profinance.odd.bean.OddAllocationEntity;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.service.IOddAllocationService;
import com.ejianc.business.profinance.odd.service.IOddFeeService;
import com.ejianc.business.profinance.odd.vo.OddAllocationVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oddAllocation")
public class OddAllocationBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOddFeeService oddFeeService;
    @Autowired
    private IOddAllocationService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateOddFee(true, billId);
        this.service.costPush((OddAllocationEntity)((Object)this.service.selectById(billId)));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        OddAllocationEntity oddAllocationEntity = (OddAllocationEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OddAllocationEntity::getOddFeeId, (Object)oddAllocationEntity.getOddFeeId());
        lambdaQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("\u6700\u65b0\u96f6\u661f\u8d39\u7528\u5206\u914d\u5355id:{},\u96f6\u661f\u8d39\u7528\u5355id:{}", (Object)((OddAllocationEntity)((Object)list.get(0))).getId(), (Object)((OddAllocationEntity)((Object)list.get(0))).getOddFeeId());
            if (!billId.equals(((OddAllocationEntity)((Object)list.get(0))).getId())) {
                return CommonResponse.error((String)"\u53ea\u80fd\u64a4\u56de\u8be5\u96f6\u661f\u8d39\u7528\u5355\u6700\u65b0\u7684\u96f6\u661f\u8d39\u7528\u5206\u914d\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.updateOddFee(false, billId);
        this.service.deleteCost(billId);
        return CommonResponse.success();
    }

    public void updateOddFee(Boolean flag, Long billId) {
        OddAllocationVO vo = (OddAllocationVO)BeanMapper.map((Object)this.service.selectById(billId), OddAllocationVO.class);
        this.logger.info("\u96f6\u661f\u5206\u914did: {}-\u7f16\u7801--{},\u96f6\u661f\u5355\u636eid: {}--\u7f16\u7801--{}" + (flag != false ? "\u5ba1\u6279\u901a\u8fc7" : "\u64a4\u56de"), new Object[]{vo.getId(), vo.getBillCode(), vo.getOddFeeId(), vo.getOddFeeCode()});
        BigDecimal haveAllocatedTaxMny = null == vo.getHaveAllocatedTaxMny() ? BigDecimal.ZERO : vo.getHaveAllocatedTaxMny();
        BigDecimal haveAllocatedMny = null == vo.getHaveAllocatedMny() ? BigDecimal.ZERO : vo.getHaveAllocatedMny();
        BigDecimal surplusAllocatedTaxMny = null == vo.getSurplusAllocatedTaxMny() ? BigDecimal.ZERO : vo.getSurplusAllocatedTaxMny();
        BigDecimal surplusAllocatedMny = null == vo.getSurplusAllocatedMny() ? BigDecimal.ZERO : vo.getSurplusAllocatedMny();
        BigDecimal totalAllocatedTaxMny = null == vo.getTotalAllocatedTaxMny() ? BigDecimal.ZERO : vo.getTotalAllocatedTaxMny();
        BigDecimal totalAllocatedMny = null == vo.getTotalAllocatedMny() ? BigDecimal.ZERO : vo.getTotalAllocatedMny();
        BigDecimal allocatedTaxMny = null == vo.getAllocatedTaxMny() ? BigDecimal.ZERO : vo.getAllocatedTaxMny();
        BigDecimal allocatedMny = null == vo.getAllocatedMny() ? BigDecimal.ZERO : vo.getAllocatedMny();
        this.logger.info("\u96f6\u661f\u5206\u914d\uff0c\u5df2\u5206\u644a\u91d1\u989d: {}---{},\u5269\u4f59\u91d1\u989d: {}---{},\u7d2f\u8ba1\u91d1\u989d: {}---{},\u672c\u6b21\u91d1\u989d\uff1a{}--{}", new Object[]{haveAllocatedTaxMny, haveAllocatedMny, surplusAllocatedTaxMny, surplusAllocatedMny, totalAllocatedTaxMny, totalAllocatedMny, allocatedTaxMny, allocatedMny});
        if (flag.booleanValue()) {
            haveAllocatedTaxMny = totalAllocatedTaxMny;
            haveAllocatedMny = totalAllocatedMny;
            surplusAllocatedTaxMny = ComputeUtil.safeSub((BigDecimal)surplusAllocatedTaxMny, (BigDecimal)allocatedTaxMny);
            surplusAllocatedMny = ComputeUtil.safeSub((BigDecimal)surplusAllocatedMny, (BigDecimal)allocatedMny);
        }
        this.logger.info("\u4fee\u6539\u56de\u663e\u96f6\u661f\u5355\uff0c\u5df2\u5206\u644a\u91d1\u989d: {}---{},\u5269\u4f59\u91d1\u989d: {}---{}", new Object[]{haveAllocatedTaxMny, haveAllocatedMny, surplusAllocatedTaxMny, surplusAllocatedMny});
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)vo.getOddFeeId());
        updateWrapper.set(OddFeeEntity::getHaveAllocatedTaxMny, (Object)haveAllocatedTaxMny);
        updateWrapper.set(OddFeeEntity::getHaveAllocatedMny, (Object)haveAllocatedMny);
        updateWrapper.set(OddFeeEntity::getSurplusAllocatedTaxMny, (Object)surplusAllocatedTaxMny);
        updateWrapper.set(OddFeeEntity::getSurplusAllocatedMny, (Object)surplusAllocatedMny);
        this.oddFeeService.update((Wrapper)updateWrapper);
    }
}

