/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.business.profinance.plan.bean.PlanEntity;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;
import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.business.profinance.plan.bean.PlanTemporaryEntity;
import com.ejianc.business.profinance.plan.enums.CloseStateEnum;
import com.ejianc.business.profinance.plan.mapper.PlanMapper;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.business.profinance.plan.service.IPlanService;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private final IReceiptRegisterService receiptRegisterService;
    private final ISettlePoolApi settlePoolApi;
    private final IPlanContractService planContractService;
    private final IPlanMaterialService planMaterialService;
    private final IPlanTemporaryService planTemporaryService;
    private final IPlanFeeService planFeeService;

    public PlanServiceImpl(IReceiptRegisterService receiptRegisterService, ISettlePoolApi settlePoolApi, IPlanContractService planContractService, IPlanMaterialService planMaterialService, IPlanTemporaryService planTemporaryService, IPlanFeeService planFeeService) {
        this.receiptRegisterService = receiptRegisterService;
        this.settlePoolApi = settlePoolApi;
        this.planContractService = planContractService;
        this.planMaterialService = planMaterialService;
        this.planTemporaryService = planTemporaryService;
        this.planFeeService = planFeeService;
    }

    @Override
    public void setSubDefaultValue(PlanEntity entity) {
        List<PlanContractEntity> planContractList = entity.getPlanContractList();
        List<PlanMaterialEntity> planMaterialList = entity.getPlanMaterialList();
        List<PlanTemporaryEntity> planTemporaryList = entity.getPlanTemporaryList();
        List<PlanFeeEntity> planFeeList = entity.getPlanFeeList();
        this.resetPid(planContractList);
        if (CollectionUtils.isNotEmpty(planMaterialList)) {
            for (PlanMaterialEntity planMaterialEntity : planMaterialList) {
                planMaterialEntity.setCloseState(CloseStateEnum.NOT_CLOSED.getName());
            }
        }
        if (CollectionUtils.isNotEmpty(planTemporaryList)) {
            for (PlanTemporaryEntity planTemporaryEntity : planTemporaryList) {
                planTemporaryEntity.setCloseState(CloseStateEnum.NOT_CLOSED.getName());
            }
        }
        if (CollectionUtils.isNotEmpty(planFeeList)) {
            for (PlanFeeEntity planFeeEntity : planFeeList) {
                planFeeEntity.setCloseState(CloseStateEnum.NOT_CLOSED.getName());
            }
        }
    }

    private void resetPid(List<PlanContractEntity> planContractList) {
        if (CollectionUtils.isNotEmpty(planContractList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanContractEntity cdEntity : planContractList) {
                if ("del".equals(cdEntity.getRowState())) continue;
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (PlanContractEntity cdEntity : planContractList) {
                if ("del".equals(cdEntity.getRowState()) || !StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setCloseState(CloseStateEnum.NOT_CLOSED.getName());
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
    }

    @Override
    public PlanEntity fetchLastPlan(Long projectId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(PlanEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq(PlanEntity::getProjectId, (Object)projectId);
        queryWrapper.orderByDesc(PlanEntity::getPlanDate);
        List plans = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)plans)) {
            return (PlanEntity)((Object)plans.get(0));
        }
        return null;
    }

    @Override
    public BigDecimal fetchTotalReceiptRegister(Long projectId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.select(new String[]{"ifnull(sum(sum_received_mny), 0) as total"});
        Map resultMap = this.receiptRegisterService.getMap((Wrapper)queryWrapper);
        return new BigDecimal(resultMap.get("total").toString());
    }

    @Override
    public BigDecimal fetchTotalProductValue(Long projectId) {
        CommonResponse res = this.settlePoolApi.fetchTotalProductValueTaxMny(projectId);
        if (!res.isSuccess() || res.getData() == null) {
            throw new BusinessException("\u6839\u636e\u9879\u76eeid\uff1a" + projectId + "\u67e5\u8be2\u7ed3\u7b97\u6c60\u4e2d\u7ed3\u7b97\u7c7b\u578b\u4e3a\u4ea7\u503c\u62a5\u91cf\u7684\u7d2f\u8ba1\u4ea7\u503c\u91d1\u989d\uff0c\u8c03\u7528\u7ed3\u7b97\u6c60\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        return (BigDecimal)res.getData();
    }

    @Override
    public Map<String, Object> fetchValue(Long projectId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(PlanEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq(PlanEntity::getProjectId, (Object)projectId);
        queryWrapper.orderByDesc(PlanEntity::getPlanDate);
        List plans = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)plans)) {
            resultMap.put("lastPlanDate", ((PlanEntity)((Object)plans.get(0))).getPlanDate());
        }
        QueryWrapper queryWrapper1 = Wrappers.query();
        queryWrapper1.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper1.eq((Object)"project_id", (Object)projectId);
        queryWrapper1.select(new String[]{"ifnull(sum(sum_received_mny), 0) as total"});
        Map resultMap1 = this.receiptRegisterService.getMap((Wrapper)queryWrapper1);
        if (resultMap1.isEmpty()) {
            resultMap.put("lastTotalProjectReceipt", BigDecimal.ZERO);
        } else {
            resultMap.put("lastTotalProjectReceipt", new BigDecimal(resultMap1.get("total").toString()));
        }
        CommonResponse res = this.settlePoolApi.fetchTotalProductValueTaxMny(projectId);
        if (!res.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u9879\u76eeid\uff1a" + projectId + "\u67e5\u8be2\u7ed3\u7b97\u6c60\u4e2d\u7ed3\u7b97\u7c7b\u578b\u4e3a\u4ea7\u503c\u62a5\u91cf\u7684\u7d2f\u8ba1\u4ea7\u503c\u91d1\u989d\uff0c\u8c03\u7528\u7ed3\u7b97\u6c60\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        resultMap.put("lastTotalOutputValueTaxMny", res.getData());
        return resultMap;
    }

    @Override
    public void checkReferQuote(JSONObject referMap) {
        Collection settleIds;
        List entityList;
        LambdaQueryWrapper queryWrapper;
        if (referMap.isEmpty()) {
            throw new BusinessException("\u53c2\u7167\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        if (referMap.containsKey((Object)"contract")) {
            Collection contractIds = (Collection)referMap.get((Object)"contract");
            if (CollectionUtils.isEmpty((Collection)contractIds)) {
                throw new BusinessException("\u53c2\u7167\u7684\u5408\u540c\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.notIn(PlanContractEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.in(PlanContractEntity::getContractId, contractIds);
            if (referMap.containsKey((Object)"excludePlanId")) {
                queryWrapper.ne(PlanContractEntity::getPlanId, referMap.get((Object)"excludePlanId"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(entityList = this.planContractService.list((Wrapper)queryWrapper)))) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u7f16\u53f7\u3010" + ((PlanContractEntity)((Object)entityList.get(0))).getContractCode() + "\u3011\u7684\u6570\u636e\u5df2\u88ab\u672a\u751f\u6548\u7684\u3010\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u3011\u5f15\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u4f7f\u7528\u8be5\u6570\u636e\u3002");
            }
        }
        if (referMap.containsKey((Object)"material")) {
            settleIds = (Collection)referMap.get((Object)"material");
            if (CollectionUtils.isEmpty((Collection)settleIds)) {
                throw new BusinessException("\u53c2\u7167\u7684\u96f6\u661f\u6750\u6599\u91c7\u8d2d\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.notIn(PlanMaterialEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.in(PlanMaterialEntity::getMaterialSettleId, settleIds);
            if (referMap.containsKey((Object)"excludePlanId")) {
                queryWrapper.ne(PlanMaterialEntity::getPlanId, referMap.get((Object)"excludePlanId"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(entityList = this.planMaterialService.list((Wrapper)queryWrapper)))) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u7f16\u53f7\u3010" + ((PlanMaterialEntity)((Object)entityList.get(0))).getMaterialSettleCode() + "\u3011\u7684\u6570\u636e\u5df2\u88ab\u672a\u751f\u6548\u7684\u3010\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u3011\u5f15\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u4f7f\u7528\u8be5\u6570\u636e\u3002");
            }
        }
        if (referMap.containsKey((Object)"temporary")) {
            settleIds = (Collection)referMap.get((Object)"temporary");
            if (CollectionUtils.isEmpty((Collection)settleIds)) {
                throw new BusinessException("\u53c2\u7167\u7684\u4e34\u65f6\u673a\u68b0\u79df\u8d41\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.notIn(PlanTemporaryEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.in(PlanTemporaryEntity::getTemporarySettleId, settleIds);
            if (referMap.containsKey((Object)"excludePlanId")) {
                queryWrapper.ne(PlanTemporaryEntity::getPlanId, referMap.get((Object)"excludePlanId"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(entityList = this.planTemporaryService.list((Wrapper)queryWrapper)))) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u7f16\u53f7\u3010" + ((PlanTemporaryEntity)((Object)entityList.get(0))).getTemporarySettleCode() + "\u3011\u7684\u6570\u636e\u5df2\u88ab\u672a\u751f\u6548\u7684\u3010\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u3011\u5f15\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u4f7f\u7528\u8be5\u6570\u636e\u3002");
            }
        }
        if (referMap.containsKey((Object)"fee")) {
            Collection feeIds = (Collection)referMap.get((Object)"fee");
            if (CollectionUtils.isEmpty((Collection)feeIds)) {
                throw new BusinessException("\u53c2\u7167\u7684\u5176\u4ed6\u96f6\u661f\u8d39\u7528\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.notIn(PlanFeeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.in(PlanFeeEntity::getFeeId, feeIds);
            if (referMap.containsKey((Object)"excludePlanId")) {
                queryWrapper.ne(PlanFeeEntity::getPlanId, referMap.get((Object)"excludePlanId"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(entityList = this.planFeeService.list((Wrapper)queryWrapper)))) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u7f16\u53f7\u3010" + ((PlanFeeEntity)((Object)entityList.get(0))).getFeeCode() + "\u3011\u7684\u6570\u636e\u5df2\u88ab\u672a\u751f\u6548\u7684\u3010\u9879\u76ee\u8d44\u91d1\u8ba1\u5212\u3011\u5f15\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u4f7f\u7528\u8be5\u6570\u636e\u3002");
            }
        }
    }

    @Override
    public void checkOnlyOne(Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff01");
        }
    }
}

