package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;
import com.ejianc.business.profinance.plan.mapper.PlanFeeMapper;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 项目资金计划-零星费用
 *
 * @author generator
 */
@Service("planFeeService")
public class PlanFeeServiceImpl extends BaseServiceImpl<PlanFeeMapper, PlanFeeEntity> implements IPlanFeeService {

	private static final String FEE_ID = "fee_id";

	/**
	 * 根据项目资金计划id，修改项目资金计划-零星费用的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	@Override
	public void updateBillState(Long planId, Integer billStateCode) {
		LambdaUpdateWrapper<PlanFeeEntity> updateWrapper = Wrappers.lambdaUpdate();
		updateWrapper.eq(PlanFeeEntity::getPlanId, planId);
		updateWrapper.set(PlanFeeEntity::getBillState, billStateCode);
		updateWrapper.set(PlanFeeEntity::getBillStateName, BillStateEnum.getEnumByStateCode(billStateCode).getDescription());
		super.update(updateWrapper);
	}

	/**
	 * 已申请金额(不含本次)=根据零星费用单ids查询所有审批通过或已提交的【项目资金计划】-【零星费用】页签数据，统计该结算单的“本次计划付款金额”
	 *
	 * @param feeIds 零星费用单ids
	 *
	 * @return 已申请金额(不含本次)
	 */
	@Override
	public Map<String, Object> fetchFeeValue(Collection<Long> feeIds) {
		HashMap<String, Object> result = new HashMap<>();

		QueryWrapper<PlanFeeEntity> queryWrapper = Wrappers.query();
		queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		queryWrapper.in(FEE_ID, feeIds);
		queryWrapper.groupBy(FEE_ID);
		queryWrapper.select("fee_id as feeId,ifnull(sum(fee_plan_payment_mny), 0) as feeAppliedMny");
		List<Map<String, Object>> resultMap = super.listMaps(queryWrapper);
		if (CollectionUtils.isNotEmpty(resultMap)) {
			return converToMap(resultMap);
		}

		return result;
	}

	private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
		Map<String, Object> resultMap = new HashMap<>();
		for (Map<String, Object> map : listMap) {
			if (!resultMap.containsKey(map.get("feeId").toString())) {
				resultMap.put(map.get("feeId").toString(), map.get("feeAppliedMny").toString());
			}
		}
		return resultMap;
	}

}
