package com.ejianc.business.profinance.service;

import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.bean.PaymentApplyDetailEntity;

import java.math.BigDecimal;

/**
 * 付款申请详情
 * 
 * @author generator
 * 
 */
public interface IPaymentApplyDetailService extends IBaseService<PaymentApplyDetailEntity> {

    /**
     * 查询当前结算单的 已申请金额
     * @param sourceId
     * @return
     */
    BigDecimal queryAlreadyApplyMny(String sourceId);

    /**
     * 设置剩余可申请金额
     * @param settlePoolVO
     * @return
     */
    SettlePoolVO setResidueMny(SettlePoolVO settlePoolVO);



    boolean releaseApplyList(PaymentApplyEntity entity);
}
