package com.ejianc.business.profinance.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.vo.PayrollRegisterVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.bean.PayrollRegisterEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 工资发放登记主实体
 *
 * @author generator
 *
 */
public interface IPayrollRegisterService extends IBaseService<PayrollRegisterEntity> {

    PayrollRegisterVO insertOrUpdate(PayrollRegisterVO payrollRegisterVO);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    PayrollRegisterVO generatePayrollRegister(SalaryPayApplyVO salaryPayApplyVO, BigDecimal actualTotalPaidTaxMny);

    IPage<PayrollRegisterVO> queryPayrollRegisterList(Page<PayrollRegisterVO> pg, Long salaryPayApplyId);

    /**
     * 批量生成工资发放登记单
     * @param sucList 支付状态为已支付的 支付申请子表
     */
    void generateBatchPayrollRegister(List<SalaryPayApplyDetailVO> sucList);

    void generatePaymentRegister(List<PayrollRegisterVO> payrollRegisterVOList);
}
