package com.ejianc.business.cwpush;



import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMReceiptRegister.api.IPMMnyInfoApi;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMMnyInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/cwPush/")
public class CwPushController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

@Autowired
private CwPushMapper mapper;

@Autowired
private IPMMnyInfoApi mnyInfoApi;

    /**
     * @Description  每月推送财务中间库，项目金额数据
     * @param
     * @Return
     */
    @RequestMapping(value = "/cwPushPMXMQKSJ", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> cwPushPMXMQKSJ(HttpServletRequest request) {

        //查询本月所有数据
        List<CwPushEntity> cwPushEntities = mapper.selectCwPushList();
        logger.info("共查询出{}条数据",cwPushEntities.size());
        List<PMMnyInfoVO> pmMnyInfoVOS = BeanMapper.mapList(cwPushEntities, PMMnyInfoVO.class);
        CommonResponse<String> stringCommonResponse = mnyInfoApi.insertList(pmMnyInfoVOS);

        return CommonResponse.success("执行成功！");
    }
    /**
     * @Description  每月推送财务中间库，项目金额数据
     * @param
     * @Return
     */
    @RequestMapping(value = "/cwPushPMXMQKSJUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> cwPushPMXMQKSJUpdate(HttpServletRequest request) {

        //查询本月所有数据
        List<CwPushEntity> cwPushEntities = mapper.updateCwPushList();
        logger.info("共查询出{}条数据",cwPushEntities.size());
        List<PMMnyInfoVO> pmMnyInfoVOS = BeanMapper.mapList(cwPushEntities, PMMnyInfoVO.class);
        CommonResponse<String> stringCommonResponse = mnyInfoApi.updateList(pmMnyInfoVOS);

        return CommonResponse.success("执行成功！");
    }



    /**
     * @Description  每月推送财务中间库，首次
     * @param
     * @Return
     */
    @RequestMapping(value = "/selectCwPushListWithMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> selectCwPushListWithMonth(String ywdate) {

        //查询本月所有数据
        List<CwPushEntity> cwPushEntities = mapper.selectCwPushListWithMonth(ywdate);
        logger.info("共查询出{}条数据",cwPushEntities.size());
        List<PMMnyInfoVO> pmMnyInfoVOS = BeanMapper.mapList(cwPushEntities, PMMnyInfoVO.class);
        CommonResponse<String> stringCommonResponse = mnyInfoApi.insertList(pmMnyInfoVOS);

        return CommonResponse.success("执行成功！");
    }
}
