/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.PayrollRegisterEntity;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.vo.PayrollRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payrollRegister"})
public class PayrollRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPayrollRegisterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayrollRegisterVO> saveOrUpdate(@RequestBody PayrollRegisterVO payrollRegisterVO) {
        PayrollRegisterVO vo = this.service.insertOrUpdate(payrollRegisterVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayrollRegisterVO> queryDetail(Long id) {
        PayrollRegisterEntity entity = (PayrollRegisterEntity)((Object)this.service.selectById(id));
        PayrollRegisterVO vo = (PayrollRegisterVO)BeanMapper.map((Object)((Object)entity), PayrollRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayrollRegisterVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayrollRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<PayrollRegisterVO>> commonResponse = this.queryList(param);
        List salaryVOList = new ArrayList();
        if (null != commonResponse.getData() && CollectionUtils.isNotEmpty(salaryVOList = ((IPage)commonResponse.getData()).getRecords())) {
            for (PayrollRegisterVO payrollRegisterVO : salaryVOList) {
                payrollRegisterVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)payrollRegisterVO.getBillState()).getDescription());
                switch (payrollRegisterVO.getProvideType()) {
                    case 0: {
                        payrollRegisterVO.setProvideTypeName("\u52b3\u52a1\u516c\u53f8\u76f4\u53d1");
                        break;
                    }
                    case 1: {
                        payrollRegisterVO.setProvideTypeName("\u7b2c\u4e09\u65b9\u57ab\u4ed8");
                        break;
                    }
                    case 2: {
                        payrollRegisterVO.setProvideTypeName("\u603b\u5305\u4ee3\u53d1");
                    }
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", salaryVOList);
        ExcelExport.getInstance().export("payrollRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"payrollRegisterDetail-import.xlsx", (String)"\u5de5\u4eba\u5de5\u8d44\u5355-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/refPayrollRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> refPayrollRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayrollRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPayrollRegisterList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayrollRegisterVO>> queryPayrollRegisterList(@RequestBody QueryParam param) {
        String salaryPayApplyId = "";
        if (param.getParams().get("salaryPayApplyId") != null) {
            salaryPayApplyId = String.valueOf(((Parameter)param.getParams().get("salaryPayApplyId")).getValue());
        }
        Page pg = new Page(1L, 10L);
        pg.setSize(-1L);
        IPage<PayrollRegisterVO> page = this.service.queryPayrollRegisterList((Page<PayrollRegisterVO>)pg, Long.valueOf(salaryPayApplyId));
        Page pageData = new Page(page.getCurrent(), 10L, (long)page.getRecords().size());
        pageData.setRecords(page.getRecords());
        return CommonResponse.success((String)"\u901a\u8fc7\u652f\u4ed8\u7533\u8bf7id\u67e5\u8be2\u4ed8\u6b3e\u767b\u8bb0\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/generatePaymentRegister"})
    @ResponseBody
    public void generatePaymentRegister(HttpServletRequest request, HttpServletResponse response) {
        this.service.generatePaymentRegister(null);
    }
}

