/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.bean.GlodonProjectRelateEntity;
import com.ejianc.business.profinance.mapper.GlodonProjectRelateMapper;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.service.IGlodonProjectRelateService;
import com.ejianc.business.profinance.utils.GlodonSalaryApiClient;
import com.ejianc.business.profinance.vo.GlodonProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="glodonProjectRelateService")
public class GlodonProjectRelateServiceImpl
extends BaseServiceImpl<GlodonProjectRelateMapper, GlodonProjectRelateEntity>
implements IGlodonProjectRelateService {
    private static final String GLODON_TENANT_ID = "1438833";
    private static final String GLODON_ORG_ID = "1441301";
    private static final String PROJECT_LIST = "/admin/project/listByOrgId";
    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;

    @Override
    public List<GlodonProjectRelateEntity> querySynchronizeFlagByProjectId(String projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        return super.queryList(param);
    }

    @Override
    public JSONObject getGlodonProjectList(Long projectId, Integer pageNumber, Integer pageSize, String searchText) {
        String data;
        String success;
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", GLODON_TENANT_ID);
        params.put("orgId", GLODON_ORG_ID);
        String resultStr = openApiTestClient.sendGETRequest(PROJECT_LIST, params);
        System.out.println(resultStr);
        JSONObject resultObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)resultStr)) {
            resultObject = JSONObject.parseObject((String)resultStr);
        }
        JSONObject page = new JSONObject();
        if (resultObject != null && StringUtils.isNotBlank((CharSequence)(success = resultObject.getString("success"))) && success.equals("true") && StringUtils.isNotBlank((CharSequence)(data = resultObject.getString("data")))) {
            List glodonProjectVOList = JSONArray.parseArray((String)data, GlodonProjectVO.class);
            String total = String.valueOf(glodonProjectVOList.size());
            String current = String.valueOf(pageNumber);
            String size = null != pageSize ? pageSize + "" : "10";
            String pages = String.valueOf(glodonProjectVOList.size() > 0 ? Integer.valueOf((int)Math.ceil((double)glodonProjectVOList.size() * 1.0 / 10.0)) : 0);
            List<Long> sourceProjectIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)glodonProjectVOList)) {
                Object sourceProjectMap;
                if (StringUtils.isNotBlank((CharSequence)searchText) && null != (sourceProjectMap = glodonProjectVOList.stream().collect(Collectors.toMap(GlodonProjectVO::getName, Function.identity(), (key1, key2) -> key2)))) {
                    ArrayList glodonProjectSearchVOList = new ArrayList();
                    for (String key : sourceProjectMap.keySet()) {
                        if (!key.contains(searchText)) continue;
                        glodonProjectSearchVOList.add(sourceProjectMap.get(key));
                    }
                    if (glodonProjectSearchVOList.size() > 0) {
                        glodonProjectVOList = glodonProjectSearchVOList;
                    }
                }
                total = String.valueOf(glodonProjectVOList.size());
                pages = String.valueOf(glodonProjectVOList.size() > 0 ? Integer.valueOf((int)Math.ceil((double)glodonProjectVOList.size() * 1.0 / 10.0)) : 0);
                glodonProjectVOList = 1 == Integer.valueOf(current) ? (glodonProjectVOList.size() > 10 ? glodonProjectVOList.subList(0, 10) : glodonProjectVOList.subList(0, glodonProjectVOList.size())) : ((pageNumber - 1) * 10 <= glodonProjectVOList.size() ? (glodonProjectVOList.size() > pageNumber * 10 ? glodonProjectVOList.subList((pageNumber - 1) * 10, pageNumber * 10) : glodonProjectVOList.subList((pageNumber - 1) * 10, glodonProjectVOList.size())) : null);
                if (null != glodonProjectVOList) {
                    for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                        sourceProjectIds.add(glodonProjectVO.getId());
                    }
                    sourceProjectIds = glodonProjectVOList.stream().map(GlodonProjectVO::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(sourceProjectIds)) {
                        List<Long> useGlodonProjectIds;
                        QueryParam param = new QueryParam();
                        param.getParams().put("project_id", new Parameter("eq", (Object)projectId));
                        List relateEntityList = super.queryList(param);
                        if (CollectionUtils.isNotEmpty((Collection)relateEntityList) && null != relateEntityList.get(0)) {
                            useGlodonProjectIds = this.glodonProjectRelateDetailService.selectUseGlodonProjectIds(sourceProjectIds, ((GlodonProjectRelateEntity)((Object)relateEntityList.get(0))).getId());
                            for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                                if (!CollectionUtils.isNotEmpty(useGlodonProjectIds) || !useGlodonProjectIds.contains(glodonProjectVO.getId())) continue;
                                glodonProjectVO.setIfChose("\u5df2\u9009\u62e9");
                            }
                        } else {
                            useGlodonProjectIds = this.glodonProjectRelateDetailService.selectUseGlodonProjectIds(sourceProjectIds, null);
                            for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                                if (!CollectionUtils.isNotEmpty(useGlodonProjectIds) || !useGlodonProjectIds.contains(glodonProjectVO.getId())) continue;
                                glodonProjectVO.setIfChose("\u5df2\u9009\u62e9");
                            }
                        }
                    }
                }
            }
            page.put("records", (Object)glodonProjectVOList);
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
        }
        return page;
    }
}

