/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.bean.GlodonProjectRelateDetailEntity;
import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.service.IGlodonSalaryService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.utils.GlodonSalaryApiClient;
import com.ejianc.business.profinance.vo.GlodonSalaryDetailVO;
import com.ejianc.business.profinance.vo.GlodonSalaryVO;
import com.ejianc.business.profinance.vo.SalaryDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="glodonSalaryService")
public class IGlodonSalaryImpl
implements IGlodonSalaryService {
    @Autowired
    private SalaryDetailMapper SalaryDetailMapper;
    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;
    private static final String SALARY = "/salaryV2/pageV2";
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";

    @Override
    public JSONObject getSalary(String projectId, String year, String month) {
        JSONObject dataObject;
        String data;
        String success;
        projectId = projectId == null ? "281492017440768" : projectId;
        year = StringUtils.isBlank((CharSequence)year) ? "2020" : year;
        month = StringUtils.isBlank((CharSequence)month) ? "10" : month;
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", projectId);
        params.put("year", year);
        params.put("month", month);
        params.put("pageNum", "1");
        params.put("pageSize", "50");
        String salaryResultStr = openApiTestClient.sendGETRequest(SALARY, params);
        System.out.println(salaryResultStr);
        JSONObject salaryResultObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)salaryResultStr)) {
            salaryResultObject = JSONObject.parseObject((String)salaryResultStr);
        }
        JSONObject page = new JSONObject();
        if (salaryResultObject != null && StringUtils.isNotBlank((CharSequence)(success = salaryResultObject.getString("success"))) && success.equals("true") && StringUtils.isNotBlank((CharSequence)(data = salaryResultObject.getString("data"))) && (dataObject = JSONObject.parseObject((String)data)) != null) {
            String total = dataObject.getString("totalElements");
            String current = dataObject.getString("page");
            String size = dataObject.getString("size");
            String pages = dataObject.getString("totalPages");
            String contentStr = dataObject.getString("content");
            List salaryList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)contentStr)) {
                salaryList = JSONArray.parseArray((String)contentStr).toJavaList(GlodonSalaryVO.class);
                HashSet<Long> sourceSalaryIds = new HashSet<Long>();
                if (CollectionUtils.isNotEmpty(salaryList)) {
                    for (GlodonSalaryVO glodonSalaryVO : salaryList) {
                        sourceSalaryIds.add(glodonSalaryVO.getId());
                        String groupNameListStr = JSONObject.toJSONString((Object)glodonSalaryVO.getGroupNames());
                        groupNameListStr = groupNameListStr.substring(1, groupNameListStr.length() - 1);
                        groupNameListStr = groupNameListStr.replace(",", "\uff0c");
                        groupNameListStr = groupNameListStr.replace("\"", "");
                        glodonSalaryVO.setGroupNameList(groupNameListStr);
                    }
                    List<Long> useSalaryIds = this.salaryDetailService.selectUseGlodonSalaryIds(sourceSalaryIds);
                    for (GlodonSalaryVO glodonSalaryVO : salaryList) {
                        glodonSalaryVO.setProjectId(Long.valueOf(projectId));
                        if (CollectionUtils.isNotEmpty(useSalaryIds) && useSalaryIds.contains(glodonSalaryVO.getId())) {
                            glodonSalaryVO.setIfChose("\u5df2\u9009\u62e9");
                            continue;
                        }
                        glodonSalaryVO.setIfChose("\u672a\u9009\u62e9");
                    }
                }
            }
            page.put("records", salaryList);
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
        }
        return page;
    }

    @Override
    public List<SalaryDetailVO> getSalaryDetail(String projectId, Object o, String year, String month, String ids) {
        String contentStr;
        JSONObject dataObject;
        String data;
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", projectId);
        params.put("year", year);
        params.put("month", month);
        params.put("pageNum", "1");
        params.put("salaryIds", ids);
        params.put("pageSize", "1000");
        String workerDetailResultStr = openApiTestClient.sendGETRequest(WORKER_DETAIL, params);
        JSONObject workerDetailObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)workerDetailResultStr)) {
            workerDetailObject = JSONObject.parseObject((String)workerDetailResultStr);
        }
        List<Object> workerDetailList = new ArrayList();
        String success = workerDetailObject.getString("success");
        if (StringUtils.isNotBlank((CharSequence)success) && success.equals("true") && StringUtils.isNotBlank((CharSequence)(data = workerDetailObject.getString("data"))) && (dataObject = JSONObject.parseObject((String)data)) != null && StringUtils.isNotBlank((CharSequence)(contentStr = dataObject.getString("content")))) {
            workerDetailList = JSONArray.parseArray((String)contentStr).toJavaList(GlodonSalaryDetailVO.class);
        }
        LinkedList<SalaryDetailVO> salaryDetailVOList = new LinkedList<SalaryDetailVO>();
        if (CollectionUtils.isNotEmpty(workerDetailList)) {
            QueryParam projectQueryParam = new QueryParam();
            projectQueryParam.getParams().put("glodonProjectId", new Parameter("eq", (Object)projectId));
            List glodonProjectRelateList = this.glodonProjectRelateDetailService.queryList(projectQueryParam);
            String glodonProjectName = "";
            if (CollectionUtils.isNotEmpty((Collection)glodonProjectRelateList) && null != glodonProjectRelateList.get(0)) {
                glodonProjectName = ((GlodonProjectRelateDetailEntity)((Object)glodonProjectRelateList.get(0))).getGlodonProjectName();
            }
            workerDetailList = workerDetailList.stream().filter(item -> null != item.getTotalSalaryOfMonth() && BigDecimal.ZERO.compareTo(item.getTotalSalaryOfMonth()) != 0).collect(Collectors.toList());
            for (GlodonSalaryDetailVO glodonSalaryDetailVO : workerDetailList) {
                SalaryDetailVO salaryDetailVO = new SalaryDetailVO();
                salaryDetailVO.setSourceId(glodonSalaryDetailVO.getId());
                salaryDetailVO.setSourceType(Integer.valueOf(0));
                salaryDetailVO.setSourceSalaryId(glodonSalaryDetailVO.getSalaryId());
                salaryDetailVO.setWorkerId(glodonSalaryDetailVO.getWorkerId());
                salaryDetailVO.setWorkerName(glodonSalaryDetailVO.getName());
                salaryDetailVO.setWorkerIdCard(glodonSalaryDetailVO.getIdentification());
                salaryDetailVO.setTeamName(glodonSalaryDetailVO.getTeamName());
                salaryDetailVO.setGroupName(glodonSalaryDetailVO.getGroupName());
                salaryDetailVO.setWorkNum(glodonSalaryDetailVO.getWorkingQuantityOfMonth());
                salaryDetailVO.setWorkDayCount(glodonSalaryDetailVO.getWorkDayCount());
                salaryDetailVO.setWorkTypeCode(glodonSalaryDetailVO.getWorkTypeCode());
                salaryDetailVO.setWorkType(glodonSalaryDetailVO.getWorkTypeName());
                salaryDetailVO.setAccountNum(glodonSalaryDetailVO.getBankCode());
                salaryDetailVO.setBankName(glodonSalaryDetailVO.getBankName());
                salaryDetailVO.setBankProvince(glodonSalaryDetailVO.getOpenBankProvince());
                salaryDetailVO.setProposedPaymentMny(BigDecimal.ZERO);
                if (null != glodonSalaryDetailVO.getSalaryWay()) {
                    switch (glodonSalaryDetailVO.getSalaryWay()) {
                        case 1: {
                            salaryDetailVO.setMeasureType(Integer.valueOf(0));
                            break;
                        }
                        case 2: {
                            salaryDetailVO.setMeasureType(Integer.valueOf(2));
                            break;
                        }
                        case 3: {
                            salaryDetailVO.setMeasureType(Integer.valueOf(3));
                            break;
                        }
                        case 4: {
                            salaryDetailVO.setMeasureType(Integer.valueOf(1));
                            break;
                        }
                        case 0: {
                            salaryDetailVO.setMeasureType(null);
                        }
                    }
                }
                salaryDetailVO.setPrice(glodonSalaryDetailVO.getSalaryVerification());
                salaryDetailVO.setActualPrice(glodonSalaryDetailVO.getSalaryVerificationActual());
                salaryDetailVO.setAward(glodonSalaryDetailVO.getAward());
                salaryDetailVO.setDeductMny(glodonSalaryDetailVO.getLoanOfMonth());
                salaryDetailVO.setWorkingDayOfMonth(glodonSalaryDetailVO.getWorkingDayOfMonth());
                salaryDetailVO.setSalaryMny(glodonSalaryDetailVO.getTotalSalaryOfMonth());
                salaryDetailVO.setOweSalaryMny(glodonSalaryDetailVO.getTotalSalaryOfMonth());
                salaryDetailVO.setMemo(glodonSalaryDetailVO.getRemark());
                salaryDetailVO.setWorkerRemainderTaxMny(salaryDetailVO.getSalaryMny());
                salaryDetailVO.setTotalSalary(glodonSalaryDetailVO.getBaseSalary());
                salaryDetailVO.setOtherDeduct(glodonSalaryDetailVO.getOtherDeduct());
                salaryDetailVO.setApprovalSalaryMny(glodonSalaryDetailVO.getPostSalary());
                salaryDetailVO.setInterBankNum(glodonSalaryDetailVO.getInterBankNumber());
                salaryDetailVO.setGlodonProjectId(Long.valueOf(projectId));
                salaryDetailVO.setGlodonProjectName(glodonProjectName);
                salaryDetailVO.setWorkerPhone(glodonSalaryDetailVO.getPhone());
                salaryDetailVOList.add(salaryDetailVO);
            }
        }
        return salaryDetailVOList;
    }
}

