package com.ejianc.business.profinance.odd.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.odd.vo.OddFeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 零星费用单
 *
 * @author generator
 */
public interface IOddFeeService extends IBaseService<OddFeeEntity> {

    /**
     * 查询统计累计金额
     *
     * @param queryParam 查询条件
     * @return 查询结果
     */
    Map<String, BigDecimal> countOddFeeAmount(QueryParam queryParam);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<OddFeeVO> importVOS);
}
