package com.ejianc.business.profinance.projectloan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.profinance.person.bean.PersonLoanEntity;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.projectloan.mapper.ProjectLoanMapper;
import com.ejianc.business.profinance.projectloan.bean.ProjectLoanEntity;
import com.ejianc.business.profinance.projectloan.service.IProjectLoanService;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 借款管理-项目借款实体
 *
 * @author baipengyan
 */
@Service("projectLoanService")
public class ProjectLoanServiceImpl extends BaseServiceImpl<ProjectLoanMapper, ProjectLoanEntity> implements IProjectLoanService {

	/**
	 * 金额合计
	 *
	 * @param param 查询参数
	 *
	 * @return 金额合计
	 */
	@Override
	public Map<String, BigDecimal> fetchTotalMny(QueryParam param) {
		QueryWrapper wrapper = changeToQueryWrapper(param);
		wrapper.select("ifnull(sum(loan_mny), 0) as totalLoanMny, ifnull(sum(repaid_loan_mny), 0) as totalRepaidLoanMny, ifnull(sum(left_loan_mny), 0) as totalLeftLoanMny");
		return super.getMap(wrapper);
	}

	@Override
	public void updateColumnValue(List<Long> ids, String column, String value) {
		UpdateWrapper<ProjectLoanEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.in("id", ids);
		updateWrapper.set(column, value);
		super.update(updateWrapper);
	}
}
