package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.profinance.bean.*;
import com.ejianc.business.profinance.enums.PMPayStateEnum;
import com.ejianc.business.profinance.enums.SalaryDetailWorkerPayStateEnum;
import com.ejianc.business.profinance.enums.SalaryPayStateEnum;
import com.ejianc.business.profinance.mapper.PaymentApplyMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailWorkerMapper;
import com.ejianc.business.profinance.service.*;
import com.ejianc.business.profinance.mapper.SalaryPayApplyMapper;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工人工资支付申请主实体
 *
 * @author generator
 */
@Service("salaryPayApplyService")
public class SalaryPayApplyServiceImpl extends BaseServiceImpl<SalaryPayApplyMapper, SalaryPayApplyEntity> implements ISalaryPayApplyService {

    @Autowired
    private PaymentApplyMapper paymentApplyMapper;

    @Autowired
    private IPaymentApplyService paymentApplyService;

    @Autowired
    private SalaryPayApplyDetailMapper salaryPayApplyDetailMapper;
    @Autowired
    private SalaryPayApplyDetailWorkerMapper salaryPayApplyDetailWorkerMapper;
    @Autowired
    private SalaryPayApplyMapper salaryPayApplyMapper;

    @Autowired
    private ISalaryPayApplyDetailService salaryPayApplyDetailService;

    @Autowired
    private  ISalaryPayApplyDetailWorkerService salaryPayApplyDetailWorkerService;

    @Autowired
    private ISalaryDetailService salaryDetailService;

    @Autowired
    private ISettlePoolApi iSettlePoolApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISalaryService salaryService;

    @Autowired
    private IPayrollRegisterService payrollRegisterService;

    @Override
    public List<PaymentApplyVO> queryPaymentByContractIdAndBillState(Long id, Long tenantId) {
        QueryWrapper<PaymentApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("bill_state", 0)/* 单据状态：0-自由态 */
                .eq("payment_contract_flag", 0)/* 是否有合同：0-有合同 */
                .eq("contract_id", id)/* contract_id：合同ID */
                .eq("tenant_id", tenantId);/* 租户编码 */
        return BeanMapper.mapList(paymentApplyMapper.selectList(wrapper), PaymentApplyVO.class);
    }

    @Override
    public SalaryPayApplyEntity selectById2(Serializable id) {
        SalaryPayApplyEntity salaryPayApplyEntity = super.selectById(id);
        if (salaryPayApplyEntity == null) {
            return null;
        }
        if (salaryPayApplyEntity.getBillState() == 0) {
            // 自由态的申请单只需要展示详情即可
            return salaryPayApplyEntity;
        }
        /*
        支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
        支付状态：
            1、“支付状态”图标，在单据审批通过或已通过后再显示在界面上
            2、待支付：工资清单表体所有行都未发生支付确认状态变化时，单据的支付状态为“待支付”
            3、部分支付：工资清单表体行上有些支付结果是“支付成功”、有些是“支付失败”的，单据的支付状态显示为“部分支付”
            4、支付失败：工资清单表体行所有支付结果为“支付失败”时，单据的支付状态显示为“支付失败”
            5、支付成功：工资清单表体行所有支付结果为“支付成功”时，单据的支付状态显示为“支付成功”

        重发状态：0-无需重发，1-已重发，2-待重发
        重发状态：
            1、“重发状态”图标，在单据审批通过或已通过后再显示在界面上
            2、无需重发：当支付状态为“待支付”和“支付成功”时，单据的重发状态为“无需重发”，【重发支付申请单】按钮不可编辑
            3、待重发：当支付状态为“部分支付”和“支付失败”，且不存在“待支付”的【工人工资支付申请调整单】时，单据的重发状态为“待重发”，【重发支付申请单】按钮可编辑
            4、已重发：当支付状态为“部分支付”和“支付失败”，且存在一个新生成的【工人工资支付申请调整单】（即【工人工资支付申请调整单】的“支付状态”是“待支付”）时，单据的重发状态为“已重发”，【重发支付申请单】按钮不可编辑
         */
        // 查询当前申请单下的调整单
        QueryWrapper<SalaryPayApplyEntity> adjustWrapper = new QueryWrapper<>();
        adjustWrapper.eq("bill_code_old", salaryPayApplyEntity.getBillCode()).eq("is_repeat_bill", 1).eq("tenant_id", salaryPayApplyEntity.getTenantId());
        adjustWrapper.orderByDesc("create_time");
        List<SalaryPayApplyEntity> adjustDetailEntityList = salaryPayApplyMapper.selectList(adjustWrapper);
        List<SalaryPayApplyDetailEntity> salaryList = salaryPayApplyEntity.getSalaryList();

        // 设置重发状态
        // 当前单子状态是部分支付，但是子表状态不全是（支付成功、支付失败）则不能重发
        // 重发状态：0-无需重发，1-已重发，2-待重发
        //如果关闭则无需重发
        if (!repeatCheck(salaryPayApplyEntity) || salaryPayApplyEntity.getIsClose() == 1){
            salaryPayApplyEntity.setRepeatState(0);
        }else {
            if (CollectionUtils.isEmpty(adjustDetailEntityList)) {
                // 没有调整单，重发状态为 2-待重发
                salaryPayApplyEntity.setRepeatState(2);
            } else {
                SalaryPayApplyEntity adjustEntity = super.selectById(adjustDetailEntityList.get(0).getId());
                if (null != adjustEntity && !repeatCheck(adjustEntity)){
                    // 有调整单，重发状态为 1-已重发
                    salaryPayApplyEntity.setRepeatState(1);
                }else {
                    // 调整单状态为终极状态，重发状态为 2-待重发
                    salaryPayApplyEntity.setRepeatState(2);
                }
                // todo：重发单终极状态的支付状态不是支付成功时（支付失败、部分支付（子表除了支付成功，剩下的都是支付失败））可以再次点击重发
            }
        }


        return salaryPayApplyEntity;
    }

    /**
     *  检查当前支付申请单是否能重发
     *
     *  支付申请单是待支付、支付成功的不能重发
     *  支付申请单状态是部分支付，子表数据除了支付成功剩下的都是支付失败，则可以重发
     *
     *  待支付、支付成功、支付中不可重发
     *  部分支付时，如果子表支付状态为部分支付成功、部分支付失败，则可以重发
     *  支付失败可以重发
     */
    public boolean repeatCheck(SalaryPayApplyEntity salaryPayApplyEntity) {
        Boolean repeatFlag = false;
        if (SalaryPayStateEnum.待支付.getCode().equals(salaryPayApplyEntity.getPayState().toString())
                || SalaryPayStateEnum.支付成功.getCode().equals(salaryPayApplyEntity.getPayState().toString())
                || SalaryPayStateEnum.支付中.getCode().equals(salaryPayApplyEntity.getPayState().toString())){
            return false;
        }else if (SalaryPayStateEnum.部分支付.getCode().equals(salaryPayApplyEntity.getPayState().toString())) {
            List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = salaryPayApplyEntity.getSalaryList();
            if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)){
                int successNum = 0;
                int fileNum = 0;
                for (SalaryPayApplyDetailEntity detailEntity : salaryPayApplyDetailEntityList) {
                    if (SalaryDetailWorkerPayStateEnum.支付成功.getCode().equals(detailEntity.getWorkerPayState().toString())){
                        successNum++;
                    }else if (SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(detailEntity.getWorkerPayState().toString())){
                        fileNum++;
                    }
                }
                if (salaryPayApplyDetailEntityList.size() == (successNum + fileNum)){
                    repeatFlag = true;
                }
            }
        }else if (SalaryPayStateEnum.支付失败.getCode().equals(salaryPayApplyEntity.getPayState().toString())){
            repeatFlag = true;
        }
        return repeatFlag;
    }


    /**
     * 判断当前申请单下是否有自由态或者审批中或者驳回的调整单
     * @param billCode
     * @return
     */
    @Override
    public boolean queryAdjustByContractId(String billCode) {
        QueryWrapper<SalaryPayApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("is_repeat_bill", 1)/*是重发的申请单*/
                .eq("bill_code_old", billCode)/*当前这条数据的源单据编码*/
                .in("bill_state", Arrays.asList(
                        BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),/*0-自由态*/
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),/*2-审批中*/
                        BillStateEnum.UNAPPROVED.getBillStateCode()/*4-驳回*/
                ));
        // 查询当前申请单下自由态或者审批中或者驳回的调整单
        List<SalaryPayApplyEntity> detailEntityList = salaryPayApplyMapper.selectList(wrapper);
        return CollectionUtils.isEmpty(detailEntityList);
    }

    // 查询当前申请单下的工资清单是否全部完成
    @Override
    public Map<String, Object> queryIsCompleteApply(Long id) {
        HashMap<String, Object> result = new HashMap<>();
        result.put("state", 0);
        result.put("entity", null);
        QueryWrapper<SalaryPayApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("id", id);
        SalaryPayApplyEntity salaryPayApplyEntity = super.selectById(id);
        if (salaryPayApplyEntity == null) {
            return result;
        }
        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = salaryPayApplyEntity.getSalaryList();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)) {
            // 支付成功list
            List<SalaryPayApplyDetailEntity> sucList = salaryPayApplyDetailEntityList.stream().filter(item -> item.getWorkerPayState() == 1).collect(Collectors.toList());
            // 支付失败list
            List<SalaryPayApplyDetailEntity> falList = salaryPayApplyDetailEntityList.stream().filter(item -> item.getWorkerPayState() == 3).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sucList) && sucList.size() == salaryPayApplyDetailEntityList.size()) {
                // 全部成功
                result.put("state", 1);
            } else if (CollectionUtils.isNotEmpty(falList) && falList.size() == salaryPayApplyDetailEntityList.size()) {
                // 全部失败
                result.put("state", 3);
            } else {
                // 部分支付
                result.put("state", 2);
            }
            result.put("entity", salaryPayApplyEntity);
        }
        return result;
    }

    // 查询当前合同下是否有自由态度申请单
    @Override
    public List<SalaryPayApplyEntity> queryApplyByContractId(Long contractId) {
        QueryWrapper<SalaryPayApplyEntity> salaryPayApplyEntityQueryWrapper = new QueryWrapper<>();
        salaryPayApplyEntityQueryWrapper
                .eq("tenant_id", InvocationInfoProxy.getTenantid())
                .eq("dr", 0)
                .eq("contract_id", contractId)
                .notIn("bill_state", Arrays.asList(new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        return salaryPayApplyMapper.selectList(salaryPayApplyEntityQueryWrapper);
    }

    @Override
    public void deleteData(List<SalaryPayApplyVO> vos) {
        List<String> billCodeList = vos.stream().map(SalaryPayApplyVO::getBillCode).collect(Collectors.toList());
        List<Long> idList = vos.stream().map(SalaryPayApplyVO::getId).collect(Collectors.toList());
        QueryWrapper<SalaryPayApplyEntity> salaryPayApplyEntityQueryWrapper = new QueryWrapper<>();
        salaryPayApplyEntityQueryWrapper.in("bill_code_old", billCodeList);
        // 查询到当前申请单下的所有调整单
        List<Long> adjustIds = new ArrayList<>();
        List<Long> allIds = new ArrayList<>(idList);
        List<SalaryPayApplyEntity> salaryPayApplyEntities = salaryPayApplyMapper.selectList(salaryPayApplyEntityQueryWrapper);

        if (CollectionUtils.isNotEmpty(salaryPayApplyEntities)) {
            adjustIds = salaryPayApplyEntities.stream().map(SalaryPayApplyEntity::getId).collect(Collectors.toList());
            allIds.addAll(adjustIds);
        }
        //汇总子表
        QueryWrapper<SalaryPayApplyDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.in("pid", allIds);
        wrapper.eq("dr", 0);
        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = salaryPayApplyDetailMapper.selectList(wrapper);
        //明细子表
//        QueryWrapper<SalaryPayApplyDetailWorkerEntity> wrapperDetail = new QueryWrapper<>();
//        wrapper.in("pid", allIds);
//        List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailDetailEntityList = salaryPayApplyDetailWorkerMapper.selectList(wrapperDetail);
        List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailDetailEntityList = salaryPayApplyDetailWorkerMapper.selectByPids(allIds);

        //修改工人工资表的剩可发金额(汇总子表不为空且明细子表为空表示为改造前逻辑)
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList) && CollectionUtils.isEmpty(salaryPayApplyDetailDetailEntityList)){
            salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList(salaryPayApplyDetailEntityList, SalaryPayApplyDetailVO.class));
        }

        for (SalaryPayApplyVO vo : vos) {
            SalaryPayApplyEntity salaryPayApplyEntity = this.selectById(vo.getId());
            //修改工人工资表的剩可发金额(明细子表不为空表示为改造后逻辑)  需要判断不是重发单
            if (CollectionUtils.isNotEmpty(salaryPayApplyEntity.getSalaryDetailList()) && salaryPayApplyEntity.getIsRepeatBill() != 1){
                salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList(salaryPayApplyEntity.getSalaryDetailList(), SalaryPayApplyDetailVO.class));
            }
        }

        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)) {
            List<Long> detailIds = salaryPayApplyDetailEntityList.stream().map(SalaryPayApplyDetailEntity::getId).collect(Collectors.toList());
            // 删除当前申请单和申请单下的调整单   下的所有工资清单
            salaryPayApplyDetailService.removeByIds(detailIds);
        }
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailDetailEntityList)) {
            List<Long> detailIds = salaryPayApplyDetailDetailEntityList.stream().map(SalaryPayApplyDetailWorkerEntity::getId).collect(Collectors.toList());
            // 删除当前申请单和申请单下的调整单   下的所有明细子表
            logger.info("删除工资申请单所有明细子表:{}",detailIds.toString());
            salaryPayApplyDetailWorkerService.removeByIds(detailIds);
        }
        // 删除当前申请单和申请单下的调整单
        super.removeByIds(allIds);
    }

    @Override
    public Map<String, BigDecimal> getContractSalaryApplyInfo(Long contractId) {
        Map<String, BigDecimal> info = new HashMap<>();
        QueryWrapper<SalaryPayApplyEntity> applyQuery = new QueryWrapper<>();
        applyQuery.select("sum( actual_paid_tax_mny ) AS totalActualPaidTaxMny, sum( apply_tax_mny ) as lastApplyTaxMny");
        applyQuery.eq("contract_id", contractId);
        applyQuery.eq("is_repeat_bill", "0");
        applyQuery.eq("pay_type", "1");

        Map applyResult = super.getMap(applyQuery);
        info.put("totalActualPaidTaxMny", null != applyResult && null != applyResult.get("totalActualPaidTaxMny") ? new BigDecimal(applyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("lastApplyTaxMny", null != applyResult && null != applyResult.get("lastApplyTaxMny") ? new BigDecimal(applyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);

        //查询累计合同付款申请单金额，合同累计付款申请单实付金额
        applyQuery.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        Map validApplyResult = super.getMap(applyQuery);
        QueryWrapper<PaymentApplyEntity> payApplyQuery = new QueryWrapper<>();
        payApplyQuery.select("sum( actual_mny ) AS totalActualPaidTaxMny, sum( approval_mny ) as totalApproveTaxMny");
        payApplyQuery.eq("contract_id", contractId);
        payApplyQuery.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        Map validPayApplyResult = paymentApplyService.getMap(payApplyQuery);
        info.put("totalContractActualPaidTaxMny", null != validApplyResult && null != validApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractApproveTaxMny", null != validApplyResult && null != validApplyResult.get("lastApplyTaxMny") ? new BigDecimal(validApplyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractActualPaidTaxMny",info.get("totalContractActualPaidTaxMny").add(null != validPayApplyResult && null != validPayApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validPayApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO));
        info.put("totalContractApproveTaxMny", info.get("totalContractApproveTaxMny").add(null != validPayApplyResult && null != validPayApplyResult.get("totalApproveTaxMny") ? new BigDecimal(validPayApplyResult.get("totalApproveTaxMny").toString()) : BigDecimal.ZERO));

        QueryWrapper<SalaryEntity> salaryQuery = new QueryWrapper<>();
        salaryQuery.select("sum(total_salary_mny) AS totalShouldPayTaxMny");
        salaryQuery.eq("contract_id", contractId);
        salaryQuery.in("bill_state", Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        Map salaryResult = salaryService.getMap(salaryQuery);
        info.put("totalShouldPayTaxMny", null != salaryResult && null != salaryResult.get("totalShouldPayTaxMny") ? new BigDecimal(salaryResult.get("totalShouldPayTaxMny").toString()) : BigDecimal.ZERO);

        //结计算本期可申请金额
        info.put("curCanApplyTaxMny", info.get("totalShouldPayTaxMny").subtract(info.get("lastApplyTaxMny")));
        return info;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessage(String salaryPayApplyResultMsg) {
        /*
            处理中间库定时任务推送的工资支付数据
            1.拿到工资支付数据集合然后遍历，通过中间表子表id给相对应的支付申请子表状态、实付金额赋值更新
            //    23-11-21 需要更新其他实付相关字段4个
            2.生成工资发放登记单，更新工人工资单实付金额
            3.拿到更新后的数据判断支付申请子表支付状态，更新主表支付状态

            24-03-28工资改造：需要判断工资申请明细子表中是否含有数据，含有数据则需要更新明细子表数据，且工人工资单数据需要从明细子表更新

         */
        logger.info("profinance处理中间库工资支付-修改支付状态申请定时任务---SalaryPayApplyServiceImpl--handMQMessage--begin！");
        logger.info("从消息队列中获取到待处理的工资支付申请付款结果：{}", salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank(salaryPayApplyResultMsg)){
            List<PMSalaryPayApplyDetailVO> resultList = JSONObject.parseArray(salaryPayApplyResultMsg, PMSalaryPayApplyDetailVO.class);
            logger.info("接收一建财务系统的工资支付付款结果：{}", JSONObject.toJSONString(resultList));
            List<SalaryPayApplyDetailEntity> salaryPayApplyDetailList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(resultList)){
                List<String> payApplyDetailIds = resultList.stream().map(PMSalaryPayApplyDetailVO::getId).distinct().collect(Collectors.toList());
                Map<String, String> payStateResultMap = resultList.stream().collect(Collectors.toMap(PMSalaryPayApplyDetailVO::getId, PMSalaryPayApplyDetailVO::getPayState, (key1, key2) -> key2));

                //获取要更新的子表信息
                if (CollectionUtils.isNotEmpty(payApplyDetailIds)){
                    QueryParam param = new QueryParam();
                    param.getParams().put("pm_pay_apply_detail_id", new Parameter(QueryParam.IN, payApplyDetailIds));
                    salaryPayApplyDetailList = salaryPayApplyDetailService.queryList(param);
                }
                //第一步：更新工资支付申请子表支付状态 及 相关实付金额
                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailList)){
                    logger.info("工资支付申请需要更新状态的子表信息-更新前：{}", JSONObject.toJSONString(salaryPayApplyDetailList));
                    List<SalaryPayApplyDetailEntity> noRepeatDetailList = new ArrayList<>();

                    List<SalaryPayApplyDetailWorkerEntity> noRepeatDetailWorkerList = new ArrayList<>();

                    for (SalaryPayApplyDetailEntity detailEntity : salaryPayApplyDetailList) {
                        //判断是否存在明细子表
                        List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailWorkerEntities = null;
                        if (detailEntity.getSalaryIds() != null){
                            QueryParam oldDetailDataQuery = new QueryParam();
                            oldDetailDataQuery.getParams().put("source_id", new Parameter(QueryParam.IN,Arrays.asList(detailEntity.getSalaryIds().split(","))));
                            oldDetailDataQuery.getParams().put("pid", new Parameter(QueryParam.EQ,detailEntity.getPid()));
                             salaryPayApplyDetailWorkerEntities = salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                        }
                        String curState = null;
                        if (payStateResultMap.containsKey(detailEntity.getPmPayApplyDetailId())){
                            curState = payStateResultMap.get(detailEntity.getPmPayApplyDetailId());
                            //如果最新状态和子表数据之前状态一样，就不需要更新，只需要记录一下
                            if (null != curState && checkPayState(curState, detailEntity.getWorkerPayState())){
                                logger.info("工资支付申请不需要更新状态的子表信息（支付状态和之前一样）：{}", JSONObject.toJSONString(detailEntity));
                            }else {
                                switch (PMPayStateEnum.getEnumByCode(curState)){
                                    // 支付申请的支付状态：0-待支付，1-支付成功，2-银行支付中，3-支付失败，
                                    case 待支付://待支付
                                        detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.待支付.getCode()));

                                        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)){
                                            for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.待支付.getCode()));
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());

                                            }
                                        }
                                        break;
                                    case 支付成功://支付成功
                                        logger.info("工资支付状态变更：子表[id-{}]现变更为成功", detailEntity.getId());
                                        //设置支付状态
                                        detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付成功.getCode()));
                                        //更新实付金额
                                        //工资实付金额含税
                                        detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                                        //目前税率按照0来处理
                                        //计算工资实付金额无税
                                        detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                                        //计算工资实付金额数额
                                        detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                        detailEntity.setRecordRegister(true);

                                        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)){
                                            for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                //设置支付状态
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付成功.getCode()));
                                                //更新实付金额
                                                //工资实付金额含税
                                                salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTaxMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                                                //目前税率按照0来处理
                                                //计算工资实付金额无税
                                                salaryPayApplyDetailWorkerEntity.setWorkerActualPaidMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                                                //计算工资实付金额数额
                                                salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                                salaryPayApplyDetailWorkerEntity.setRecordRegister(true);

                                                salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());

                                            }
                                        }
                                        break;
                                    case 支付失败://支付失败
                                        if(SalaryDetailWorkerPayStateEnum.支付成功.getCode().equals(detailEntity.getWorkerPayState().toString())) {
                                            logger.info("工资支付状态变更：子表[id-{}]原状态为成功，现变更为失败", detailEntity.getId());
                                            //此处针对状态变为支付成功后 又变为支付失败场景
                                            detailEntity.setRecordRegister(true);
                                            detailEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                            detailEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                            detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                        }
                                        detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付失败.getCode()));

                                        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)){
                                            for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                if(SalaryDetailWorkerPayStateEnum.支付成功.getCode().equals(salaryPayApplyDetailWorkerEntity.getWorkerPayState().toString())) {
                                                    logger.info("工资支付状态变更：子表[id-{}]原状态为成功，现变更为失败", salaryPayApplyDetailWorkerEntity.getId());
                                                    //此处针对状态变为支付成功后 又变为支付失败场景
                                                    salaryPayApplyDetailWorkerEntity.setRecordRegister(true);
                                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                                    salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                                                }
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付失败.getCode()));
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());

                                            }
                                        }
                                        break;
                                    case 银行支付中://银行支付中
                                        detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.银行支付中.getCode()));

                                        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)){
                                            for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.银行支付中.getCode()));
                                                salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());

                                            }
                                        }
                                        break;
                                }
                                detailEntity.setWorkerPayDate(new Date());
                                //只更新支付状态和之前不一样的数据
                                noRepeatDetailList.add(detailEntity);

                                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)){
                                    noRepeatDetailWorkerList.addAll(salaryPayApplyDetailWorkerEntities);
                                }

                            }
                        }
                    }
                    //确定需要更新的数据
                    if (CollectionUtils.isNotEmpty(noRepeatDetailList)){
                        //需更新的数据集合汇总
                        List<SalaryPayApplyDetailEntity> needUpdateList = new ArrayList<>();

                        needUpdateList.addAll(noRepeatDetailList);

                        List<SalaryPayApplyDetailWorkerEntity> needUpdateDetailList = new ArrayList<>();

                        needUpdateDetailList.addAll(noRepeatDetailWorkerList);

                        //只给支付成功的子表数据生成发放登记单，更新工人工资实发金额
                        List<SalaryPayApplyDetailEntity> sucList = noRepeatDetailList.stream().filter(SalaryPayApplyDetailEntity::getRecordRegister).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(sucList)){
                            //成功状态的重发单子表数据 需要把原子表数据 的状态也改成 支付成功
                            List<SalaryPayApplyDetailEntity> repeatList = sucList.stream().filter(item -> item.getWorkerIsRepeatBill() == 1).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(repeatList)){
                                //筛选出原支付申请子表
                                Map<Long, SalaryPayApplyDetailEntity> repeatMap = repeatList.stream().collect(Collectors.toMap(item -> item.getIdOld(), item -> item));
                                List<Long> oldIds = new ArrayList<>(repeatMap.keySet());
                                if (CollectionUtils.isNotEmpty(oldIds)){
                                    QueryParam oldDataQuery = new QueryParam();
                                    oldDataQuery.getParams().put("id", new Parameter(QueryParam.IN, oldIds));
                                    List<SalaryPayApplyDetailEntity> oldDataList = salaryPayApplyDetailService.queryList(oldDataQuery);
                                    if (CollectionUtils.isNotEmpty(oldDataList)){
                                        for (SalaryPayApplyDetailEntity detailEntity : oldDataList) {
                                            //设置 重发单 原 支付申请单 子表数据 支付状态
                                            detailEntity.setWorkerPayState(repeatMap.get(detailEntity.getId()).getWorkerPayState());
                                            if (SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(repeatMap.get(detailEntity.getId()).getWorkerPayState().toString())){
                                                //如果是支付成功又改为支付失败，则把实付金额赋值为0
                                                detailEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                                detailEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                            }else {
                                                //更新实付金额
                                                //工资实付金额含税
                                                detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                                                //目前税率按照0来处理
                                                //计算工资实付金额无税
                                                detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                                            }
                                            //计算工资实付金额税额
                                            detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);

                                            //判断如果存在明细子表，则需要继续处理明细子表的数据
                                            if(detailEntity.getSalaryIds() != null){
                                                QueryParam oldDetailDataQuery = new QueryParam();
                                                oldDetailDataQuery.getParams().put("id", new Parameter(QueryParam.IN,Arrays.asList(detailEntity.getSalaryIds().split(","))));
                                                List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailWorkerEntities = salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                                                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)) {
                                                    for (SalaryPayApplyDetailWorkerEntity detailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                        //设置 重发单 原 支付申请单 子表数据 支付状态
                                                        detailWorkerEntity.setWorkerPayState(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState());
                                                        if (SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState().toString())){
                                                            //如果是支付成功又改为支付失败，则把实付金额赋值为0
                                                            detailWorkerEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                                            detailWorkerEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                                        }else {
                                                            //更新实付金额
                                                            //工资实付金额含税
                                                            detailWorkerEntity.setWorkerActualPaidTaxMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                                            //目前税率按照0来处理
                                                            //计算工资实付金额无税
                                                            detailWorkerEntity.setWorkerActualPaidMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                                        }
                                                        //计算工资实付金额税额
                                                        detailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);

                                                    }
                                                    needUpdateDetailList.addAll(salaryPayApplyDetailWorkerEntities);
                                                }
                                            }
                                        }
                                        //更新原支付申请子表的相关支付数据
                                        logger.info("更新原支付申请子表的相关支付数据：{}", oldDataList.toString());
//                                        salaryPayApplyDetailService.saveOrUpdateBatch(oldDataList, oldDataList.size(), false);

                                        //更新原支付申请主表的相关支付数据
                                        needUpdateList.addAll(oldDataList);
                                    }
                                }
                            }

                            //取出支付状态为支付成功的数据，批量生成工资发放登记单
                            payrollRegisterService.generateBatchPayrollRegister(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));

                            List<SalaryPayApplyDetailWorkerEntity> collect = noRepeatDetailWorkerList.stream().filter(SalaryPayApplyDetailWorkerEntity::getRecordRegister).collect(Collectors.toList());

                            if (CollectionUtils.isEmpty(collect)) {
                                //更新工人工资单实发金额
                                salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));
                            }else {
                                //更新工人工资单实发金额
                                salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(collect, SalaryPayApplyDetailVO.class));
                            }
                        }
                        //更新 工资支付子表 和 重发单的原工资支付主表
                        salaryPayApplyDetailService.saveOrUpdateBatch(needUpdateList, needUpdateList.size(), false);
                        logger.info("工资支付申请更新状态后的子表信息进行保存-更新后：{}", JSONObject.toJSONString(noRepeatDetailList));
                        if(CollectionUtils.isNotEmpty(needUpdateDetailList)) {
                            salaryPayApplyDetailWorkerService.saveOrUpdateBatch(needUpdateDetailList, needUpdateDetailList.size(), false);
                            logger.info("工资支付申请更新状态后的明细子表信息进行保存-更新后：{}", JSONObject.toJSONString(needUpdateDetailList));
                        }
                        //第三步：获取更新后的支付申请表，更新主表支付状态 及 相关实付金额字段
                        resetMainPayState(needUpdateList);
                    }
                }
            }
        }
        logger.info("profinance处理中间库工资支付-修改支付状态定时任务---SalaryPayApplyServiceImpl--handMQMessage--end！");
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handSalaryData(SalaryPayApplyEntity sourceEntity) {

        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailList = sourceEntity.getSalaryList();

        //第一步：更新工资支付申请子表支付状态 及 相关实付金额
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailList)) {
            logger.info("工资支付申请需要更新状态的子表信息-更新前：{}", JSONObject.toJSONString(salaryPayApplyDetailList));
            List<SalaryPayApplyDetailEntity> noRepeatDetailList = new ArrayList<>();

            List<SalaryPayApplyDetailWorkerEntity> noRepeatDetailWorkerList = new ArrayList<>();

            for (SalaryPayApplyDetailEntity detailEntity : salaryPayApplyDetailList) {
                //判断是否存在明细子表
                List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailWorkerEntities = null;
                if (detailEntity.getSalaryIds() != null) {
                    QueryParam oldDetailDataQuery = new QueryParam();
                    oldDetailDataQuery.getParams().put("source_id", new Parameter(QueryParam.IN, Arrays.asList(detailEntity.getSalaryIds().split(","))));
                    oldDetailDataQuery.getParams().put("pid", new Parameter(QueryParam.EQ, detailEntity.getPid()));
                    salaryPayApplyDetailWorkerEntities = salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                }
                logger.info("工资支付状态变更：子表[id-{}]现变更为成功", detailEntity.getId());
                //设置支付状态
                detailEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付成功.getCode()));
                //更新实付金额
                //工资实付金额含税
                detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                //目前税率按照0来处理
                //计算工资实付金额无税
                detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                //计算工资实付金额数额
                detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                detailEntity.setRecordRegister(true);

                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)) {
                    for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                        //设置支付状态
                        salaryPayApplyDetailWorkerEntity.setWorkerPayState(Integer.valueOf(SalaryDetailWorkerPayStateEnum.支付成功.getCode()));
                        //更新实付金额
                        //工资实付金额含税
                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTaxMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                        //目前税率按照0来处理
                        //计算工资实付金额无税
                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidMny(salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny());
                        //计算工资实付金额数额
                        salaryPayApplyDetailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);
                        salaryPayApplyDetailWorkerEntity.setRecordRegister(true);

                        salaryPayApplyDetailWorkerEntity.setWorkerPayDate(new Date());

                    }
                }


                detailEntity.setWorkerPayDate(new Date());
                //只更新支付状态和之前不一样的数据
                noRepeatDetailList.add(detailEntity);

                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)) {
                    noRepeatDetailWorkerList.addAll(salaryPayApplyDetailWorkerEntities);
                }

            }
            //确定需要更新的数据
            if (CollectionUtils.isNotEmpty(noRepeatDetailList)) {
                //需更新的数据集合汇总
                List<SalaryPayApplyDetailEntity> needUpdateList = new ArrayList<>();

                needUpdateList.addAll(noRepeatDetailList);

                List<SalaryPayApplyDetailWorkerEntity> needUpdateDetailList = new ArrayList<>();

                needUpdateDetailList.addAll(noRepeatDetailWorkerList);

                //只给支付成功的子表数据生成发放登记单，更新工人工资实发金额
                List<SalaryPayApplyDetailEntity> sucList = noRepeatDetailList.stream().filter(SalaryPayApplyDetailEntity::getRecordRegister).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sucList)) {
                    //成功状态的重发单子表数据 需要把原子表数据 的状态也改成 支付成功
                    List<SalaryPayApplyDetailEntity> repeatList = sucList.stream().filter(item -> item.getWorkerIsRepeatBill() == 1).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(repeatList)) {
                        //筛选出原支付申请子表
                        Map<Long, SalaryPayApplyDetailEntity> repeatMap = repeatList.stream().collect(Collectors.toMap(item -> item.getIdOld(), item -> item));
                        List<Long> oldIds = new ArrayList<>(repeatMap.keySet());
                        if (CollectionUtils.isNotEmpty(oldIds)) {
                            QueryParam oldDataQuery = new QueryParam();
                            oldDataQuery.getParams().put("id", new Parameter(QueryParam.IN, oldIds));
                            List<SalaryPayApplyDetailEntity> oldDataList = salaryPayApplyDetailService.queryList(oldDataQuery);
                            if (CollectionUtils.isNotEmpty(oldDataList)) {
                                for (SalaryPayApplyDetailEntity detailEntity : oldDataList) {
                                    //设置 重发单 原 支付申请单 子表数据 支付状态
                                    detailEntity.setWorkerPayState(repeatMap.get(detailEntity.getId()).getWorkerPayState());
                                    if (SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(repeatMap.get(detailEntity.getId()).getWorkerPayState().toString())) {
                                        //如果是支付成功又改为支付失败，则把实付金额赋值为0
                                        detailEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                        detailEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                    } else {
                                        //更新实付金额
                                        //工资实付金额含税
                                        detailEntity.setWorkerActualPaidTaxMny(detailEntity.getWorkerApplyTaxMny());
                                        //目前税率按照0来处理
                                        //计算工资实付金额无税
                                        detailEntity.setWorkerActualPaidMny(detailEntity.getWorkerApplyTaxMny());
                                    }
                                    //计算工资实付金额税额
                                    detailEntity.setWorkerActualPaidTax(BigDecimal.ZERO);

                                    //判断如果存在明细子表，则需要继续处理明细子表的数据
                                    if (detailEntity.getSalaryIds() != null) {
                                        QueryParam oldDetailDataQuery = new QueryParam();
                                        oldDetailDataQuery.getParams().put("id", new Parameter(QueryParam.IN, Arrays.asList(detailEntity.getSalaryIds().split(","))));
                                        List<SalaryPayApplyDetailWorkerEntity> salaryPayApplyDetailWorkerEntities = salaryPayApplyDetailWorkerService.queryList(oldDetailDataQuery);
                                        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailWorkerEntities)) {
                                            for (SalaryPayApplyDetailWorkerEntity detailWorkerEntity : salaryPayApplyDetailWorkerEntities) {
                                                //设置 重发单 原 支付申请单 子表数据 支付状态
                                                detailWorkerEntity.setWorkerPayState(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState());
                                                if (SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(repeatMap.get(detailWorkerEntity.getId()).getWorkerPayState().toString())) {
                                                    //如果是支付成功又改为支付失败，则把实付金额赋值为0
                                                    detailWorkerEntity.setWorkerActualPaidTaxMny(BigDecimal.ZERO);
                                                    detailWorkerEntity.setWorkerActualPaidMny(BigDecimal.ZERO);
                                                } else {
                                                    //更新实付金额
                                                    //工资实付金额含税
                                                    detailWorkerEntity.setWorkerActualPaidTaxMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                                    //目前税率按照0来处理
                                                    //计算工资实付金额无税
                                                    detailWorkerEntity.setWorkerActualPaidMny(detailWorkerEntity.getWorkerApplyTaxMny());
                                                }
                                                //计算工资实付金额税额
                                                detailWorkerEntity.setWorkerActualPaidTax(BigDecimal.ZERO);

                                            }
                                            needUpdateDetailList.addAll(salaryPayApplyDetailWorkerEntities);
                                        }
                                    }
                                }
                                //更新原支付申请子表的相关支付数据
                                logger.info("更新原支付申请子表的相关支付数据：{}", oldDataList.toString());
//                                        salaryPayApplyDetailService.saveOrUpdateBatch(oldDataList, oldDataList.size(), false);

                                //更新原支付申请主表的相关支付数据
                                needUpdateList.addAll(oldDataList);
                            }
                        }
                    }

                    //取出支付状态为支付成功的数据，批量生成工资发放登记单
                    payrollRegisterService.generateBatchPayrollRegister(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));

                    List<SalaryPayApplyDetailWorkerEntity> collect = noRepeatDetailWorkerList.stream().filter(SalaryPayApplyDetailWorkerEntity::getRecordRegister).collect(Collectors.toList());

                    if (CollectionUtils.isEmpty(collect)) {
                        //更新工人工资单实发金额
                        salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(sucList, SalaryPayApplyDetailVO.class));
                    } else {
                        //更新工人工资单实发金额
                        salaryDetailService.writeBackSalaryDetail(BeanMapper.mapList(collect, SalaryPayApplyDetailVO.class));
                    }
                }
                //更新 工资支付子表 和 重发单的原工资支付主表
                salaryPayApplyDetailService.saveOrUpdateBatch(needUpdateList, needUpdateList.size(), false);
                logger.info("工资支付申请更新状态后的子表信息进行保存-更新后：{}", JSONObject.toJSONString(noRepeatDetailList));
                if (CollectionUtils.isNotEmpty(needUpdateDetailList)) {
                    salaryPayApplyDetailWorkerService.saveOrUpdateBatch(needUpdateDetailList, needUpdateDetailList.size(), false);
                    logger.info("工资支付申请更新状态后的明细子表信息进行保存-更新后：{}", JSONObject.toJSONString(needUpdateDetailList));
                }
                //第三步：获取更新后的支付申请表，更新主表支付状态 及 相关实付金额字段
                resetMainPayState(needUpdateList);
            }
        }

    }
    @Override
    public String isNewestApplyById(Long applyId) {
        SalaryPayApplyEntity salaryPayApplyEntity = super.selectById(applyId);

        QueryWrapper<SalaryPayApplyEntity> salaryPayApplyEntityQueryWrapper = new QueryWrapper<>();
        salaryPayApplyEntityQueryWrapper
                .eq("tenant_id", InvocationInfoProxy.getTenantid())
                .eq("dr", 0)
                .eq("contract_id", salaryPayApplyEntity.getContractId())
                .gt("create_time", salaryPayApplyEntity.getCreateTime());

        List<SalaryPayApplyEntity> salaryPayApplyEntities = salaryPayApplyMapper.selectList(salaryPayApplyEntityQueryWrapper);

//  25.7.14 修改:不是最新的申请单也允许关闭
//        //存在之后创建时间的申请单，则不允许关闭
//        if (salaryPayApplyEntities != null && salaryPayApplyEntities.size() > 0){
//            //不可以关闭
//            return "关闭失败,当前合同下已存在新的付款申请单！";
//        }

        List<SalaryPayApplyDetailEntity> salaryList = salaryPayApplyEntity.getSalaryList();

        List<SalaryPayApplyDetailWorkerEntity> salaryDetailList = salaryPayApplyEntity.getSalaryDetailList();
        if (salaryList != null && salaryList.size() > 0){
            //查询未支付成功的单据，释放工资单明细的金额；并计算金额合计，从申请金额中减掉
            List<SalaryPayApplyDetailEntity> collect = salaryList.stream().filter(u -> u.getWorkerPayState() == 3).collect(Collectors.toList());

            if(CollectionUtils.isNotEmpty(salaryDetailList)){
                List<SalaryPayApplyDetailWorkerEntity> collect1 = salaryDetailList.stream().filter(u -> u.getWorkerPayState() == 3).collect(Collectors.toList());
                //修改工人工资表的剩可发金额
                if (CollectionUtils.isNotEmpty(collect1)) {
                    salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList(collect1, SalaryPayApplyDetailVO.class));
                }
            }else {
                //修改工人工资表的剩可发金额
                if (CollectionUtils.isNotEmpty(collect)) {
                    salaryDetailService.modifyWorkerRemainderTaxMny(BeanMapper.mapList(collect, SalaryPayApplyDetailVO.class));
                }
            }
            //计算金额合计，从申请金额中减掉
            BigDecimal reduce = collect.stream().map(SalaryPayApplyDetailEntity::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            salaryPayApplyEntity.setApplyTaxMny(salaryPayApplyEntity.getApplyTaxMny().subtract(reduce));
            salaryPayApplyEntity.setIsClose(1);
            super.saveOrUpdate(salaryPayApplyEntity);
        }
        return "关闭成功";
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                // 处理成功列表和失败列表
                List<SalaryPayApplyDetailVO> successList = new ArrayList<>();
                List<SalaryPayApplyDetailVO> errorList = new ArrayList<>();
                int sucNum = 0;
                String warnType = "";
                for (int i = 1; i < result.size(); i++) {

                    List<String> datas = result.get(i);
                    SalaryPayApplyDetailVO vo = new SalaryPayApplyDetailVO();

                    SalaryPayApplyDetailEntity salaryDetailEntity = new SalaryPayApplyDetailEntity();

                    if (StringUtils.isEmpty(datas.get(1))) {// 主键
                        int flag = i+2;
                        warnType = warnType + "第"+flag+"行主键错误,";
                    } else {
                         salaryDetailEntity = salaryPayApplyDetailService.selectById(Long.valueOf(datas.get(1)));

                    }

                    //
                    if (salaryDetailEntity != null && salaryDetailEntity.getId() != null){
                        //开户行
                        if (StringUtils.isEmpty(datas.get(3))) {
                            vo.setWorkerBankName(null);
                            int flag = i+2;
                            warnType = warnType + "第"+flag+"行[开户行为空]";
                        } else {
                            salaryDetailEntity.setWorkerBankName(datas.get(3));
                        }
                        //本期申请金额  (需要小于剩可发金额)
                        if (StringUtils.isNotEmpty(datas.get(7))) {
                            BigDecimal workerRemainderTaxMny = salaryDetailEntity.getWorkerRemainderTaxMny();//剩可发金额
                            BigDecimal workerApplyTaxMny = new BigDecimal(datas.get(7));//本期申请金额
                            if (workerRemainderTaxMny.compareTo(workerApplyTaxMny)  < 0){
                                salaryDetailEntity.setWorkerApplyTaxMny(workerRemainderTaxMny);
                            }else {
                                salaryDetailEntity.setWorkerApplyTaxMny(workerApplyTaxMny);
                            }
                        }else {
                            salaryDetailEntity.setWorkerApplyTaxMny(new BigDecimal(0.0));
                            int flag = i+2;
                            warnType = warnType + "第"+flag+"行[本期申请金额为空]";
                        }

                        //本期申请税额
                        if (StringUtils.isNotEmpty(datas.get(8))) {
                            BigDecimal workerApplyTax = new BigDecimal(datas.get(8));//本期申请税额
                            salaryDetailEntity.setWorkerApplyTax(workerApplyTax);
                            salaryDetailEntity.setWorkerApplyMny(salaryDetailEntity.getWorkerApplyTaxMny().add(workerApplyTax));//此字段为总金额赋值
                        }else {
                            salaryDetailEntity.setWorkerApplyTax(new BigDecimal(0.0));
                            salaryDetailEntity.setWorkerApplyMny(salaryDetailEntity.getWorkerApplyTaxMny());//此字段为总金额赋值
                        }

                        sucNum++;
                    }else {
                        int flag = i+2;
                        warnType = warnType + "第"+flag+"行主键错误,";
                    }


                    vo.setRowState("add");
                    vo =  BeanMapper.map(salaryDetailEntity,SalaryPayApplyDetailVO.class);
                    successList.add(vo);
                    if (StringUtils.isNotEmpty(warnType)){
                        errorList.add(vo);
                    }
                }

                JSONObject resp = new JSONObject();
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", warnType);
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    /**
     * 更新工资支付申请主表相关支付状态
     * @param noRepeatDetailList
     */
    private void resetMainPayState(List<SalaryPayApplyDetailEntity> noRepeatDetailList) {
        List<SalaryPayApplyEntity> salaryPayApplyList = new ArrayList<>();
        //取得带子表的支付申请数据
        List<Long> salaryPayApplyIds = noRepeatDetailList.stream().map(SalaryPayApplyDetailEntity::getPid).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(salaryPayApplyIds)){
            Map<Long, List<SalaryPayApplyDetailEntity>> detailMap = new LinkedHashMap<>();
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter(QueryParam.IN, salaryPayApplyIds));
            List<SalaryPayApplyDetailEntity> detailResultList = salaryPayApplyDetailService.queryList(param);
            if (CollectionUtils.isNotEmpty(detailResultList)){
                logger.info("工资支付申请需要更新状态的主表-更新前：{}", JSONObject.toJSONString(detailResultList));
                for (SalaryPayApplyDetailEntity detail : detailResultList) {
                    if (detailMap.containsKey(detail.getPid())){
                        detailMap.get(detail.getPid()).add(detail);
                    }else {
                        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = new ArrayList<>();
                        salaryPayApplyDetailEntityList.add(detail);
                        detailMap.put(detail.getPid(), salaryPayApplyDetailEntityList);
                    }
                }
                //获取主表信息
                QueryParam salaryPayApplyQueryParam = new QueryParam();
                salaryPayApplyQueryParam.getParams().put("id", new Parameter(QueryParam.IN, salaryPayApplyIds));
                salaryPayApplyList = super.queryList(salaryPayApplyQueryParam);
                if (CollectionUtils.isNotEmpty(salaryPayApplyList)){
                    for (SalaryPayApplyEntity salaryPayApplyEntity : salaryPayApplyList) {
                        //主表实付含税
                        BigDecimal curTotalActualPaidTaxMny = BigDecimal.ZERO;
                        //主表实付无税
                        BigDecimal curTotalActualPaidTMny = BigDecimal.ZERO;
                        //主表实付税额
                        BigDecimal curTotalActualPaidTax = BigDecimal.ZERO;
                        //salaryPayApplyEntity
                        if (detailMap.containsKey(salaryPayApplyEntity.getId())){
                            salaryPayApplyEntity.getSalaryList().addAll(detailMap.get(salaryPayApplyEntity.getId()));
                        }
                        logger.info("主表id：{}，主表实付含税金额改变数值前：{}", salaryPayApplyEntity.getId(), salaryPayApplyEntity.getActualPaidTaxMny());
                        if (CollectionUtils.isNotEmpty(salaryPayApplyEntity.getSalaryList())){
                                        /*
                                            i) 如果所有子表全部为“支付成功”，则给【工人工资支付申请】表头“支付状态”更新为“支付成功”
                                            ii) 如果所有子表全部为“支付失败”，则给【工人工资支付申请】表头“支付状态”更新为“支付失败”
                                            iii) 如果有一条数据是“支付成功”，则给【工人工资支付申请】表头“支付状态”更新为“部分支付”
                                            iv) 如果没有支付成功，有一条不是“待支付”，则给【工人工资支付申请】表头“支付状态”更新为“支付中”
                                         */
                            int successNum = 0;
                            int fileNum = 0;
                            int payingNum = 0;
                            int waitPayNum = 0;
                            List<SalaryPayApplyDetailEntity> payApplyDetailList = salaryPayApplyEntity.getSalaryList();
                            //统计子表支付状态数
                            for (SalaryPayApplyDetailEntity detailEntity : payApplyDetailList) {
                                // 子表支付状态：0-待支付，1-支付成功，2-银行支付中，3-支付失败
                                switch (SalaryDetailWorkerPayStateEnum.getEnumByCode(detailEntity.getWorkerPayState().toString())) {
                                    case 待支付://待支付
                                        waitPayNum++;
                                        break;
                                    case 支付成功://支付成功
                                        curTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(null == detailEntity.getWorkerActualPaidTaxMny() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidTaxMny());
                                        curTotalActualPaidTMny = curTotalActualPaidTMny.add(null == detailEntity.getWorkerActualPaidMny() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidMny());
                                        curTotalActualPaidTax = curTotalActualPaidTax.add(null == detailEntity.getWorkerActualPaidTax() ? BigDecimal.ZERO : detailEntity.getWorkerActualPaidTax());
                                        successNum++;
                                        break;
                                    case 银行支付中://银行支付中
                                        payingNum++;
                                        break;
                                    case 支付失败://支付失败
                                        fileNum++;
                                        break;
                                }
                            }
                            //设置主表实付金额
                            salaryPayApplyEntity.setActualPaidTaxMny(curTotalActualPaidTaxMny);
                            salaryPayApplyEntity.setActualPaidMny(curTotalActualPaidTMny);
                            salaryPayApplyEntity.setActualPaidTax(curTotalActualPaidTax);
                            salaryPayApplyEntity.setPayDate(new Date());

//                            //【工资累计实付金额（含本期）】sumActualPaidTaxMny=截止上期工资实付金额totalActualPaidTaxMny+本期实付金额actualPaidTaxMny
//                            if(salaryPayApplyEntity.getTotalActualPaidTaxMny() != null && salaryPayApplyEntity.getActualPaidTaxMny() != null){
//                                salaryPayApplyEntity.setSumActualPaidTaxMny(salaryPayApplyEntity.getTotalActualPaidTaxMny().add(salaryPayApplyEntity.getActualPaidTaxMny()));
//                            }
//
//                            //【工资累计实付比例（占应发）】actualShouldPayScale=工资累计实付金额（含本期）sumActualPaidTaxMny/累计应发金额totalShouldPayTaxMny
//                            if(salaryPayApplyEntity.getSumActualPaidTaxMny() != null && salaryPayApplyEntity.getTotalShouldPayTaxMny() != null && !BigDecimal.ZERO.equals(salaryPayApplyEntity.getTotalShouldPayTaxMny())){
//                                salaryPayApplyEntity.setActualShouldPayScale(salaryPayApplyEntity.getSumActualPaidTaxMny().divide(salaryPayApplyEntity.getTotalShouldPayTaxMny()).multiply(new BigDecimal(100)));
//                            }
//                            //【合同总计实付金额（含本期）】contractActualTaxMnySum=合同累计实付金额contractTotalActualTaxMny+本期实付金额actualPaidTaxMny
//                           if(salaryPayApplyEntity.getContractTotalActualTaxMny() != null && salaryPayApplyEntity.getActualPaidTaxMny() != null){
//                                salaryPayApplyEntity.setContractActualTaxMnySum(salaryPayApplyEntity.getContractTotalActualTaxMny().add(salaryPayApplyEntity.getActualPaidTaxMny()));
//                            }
//                            //【合同总计实付比例】contractActualTaxMnyScale=合同总计实付金额contractActualTaxMnySum/合同金额contractTaxMny
//                            if(salaryPayApplyEntity.getContractActualTaxMnySum() != null && salaryPayApplyEntity.getContractTaxMny() != null && !BigDecimal.ZERO.equals(salaryPayApplyEntity.getContractTaxMny())){
//                                salaryPayApplyEntity.setContractActualTaxMnyScale(salaryPayApplyEntity.getContractActualTaxMnySum().divide(salaryPayApplyEntity.getContractTaxMny()).multiply(new BigDecimal(100)));
//                            }
//
                            // 主表支付状态: 0-待支付，1-支付成功，2-部分支付，3-支付失败，4-支付中
                            if (payApplyDetailList.size() == successNum){//全部成功
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.支付成功.getCode()));
                            }else if (payApplyDetailList.size() == fileNum){//全部失败
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.支付失败.getCode()));
                            }else if (payApplyDetailList.size() == waitPayNum){//全部待支付
                                salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.待支付.getCode()));
                            }else {
                                //iv) 如果没有支付成功，有一条不是“待支付”，则给【工人工资支付申请】表头“支付状态”更新为“支付中”
                                if (successNum > 0 && payingNum == 0){
                                    salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.部分支付.getCode()));
                                }else {
                                    salaryPayApplyEntity.setPayState(Integer.valueOf(SalaryPayStateEnum.支付中.getCode()));
                                }
                            }
                        }
                        logger.info("主表id：{}，主表实付含税金额后：{}", salaryPayApplyEntity.getId(), curTotalActualPaidTaxMny);
                    }
                    super.saveOrUpdateBatch(salaryPayApplyList, salaryPayApplyList.size(), false);
                    logger.info("工资支付申请更新状态后的主表进行保存-更新后：{}", JSONObject.toJSONString(detailResultList));
                }
            }
        }
    }

    /**
     * 校验子表支付状态是否和中间表传过来的支付状态一致
     * @param curState
     * @param workerPayState
     * @return
     */
    private boolean checkPayState(String curState, Integer workerPayState) {
        Boolean sameFlag = false;
        if (PMPayStateEnum.待支付.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.待支付.getCode().equals(workerPayState.toString())){
            return true;
        }
        if (PMPayStateEnum.支付成功.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.支付成功.getCode().equals(workerPayState.toString())){
            return true;
        }
        if (PMPayStateEnum.银行支付中.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.银行支付中.getCode().equals(workerPayState.toString())){
            return true;
        }
        if (PMPayStateEnum.支付失败.getCode().equals(curState) && SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(workerPayState.toString())){
            return true;
        }
        return sameFlag;
    }
}
