package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.utils.DateUtil;
import com.ejianc.business.report.vo.DailyFinanceInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/3/10 16:57
 */
@RestController
@RequestMapping(value = "/dailyFinanceWarn/")
public class DailyFinanceWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMPayApplyApi pmPayApplyApi;

    @Autowired
    private IPaymentApplyService paymentApplyService;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value = "dailyFind")
    public CommonResponse<String> dailyFind(@RequestBody JSONArray jsonParam) {
        logger.info("开始执行资金付款情况统计任务-----{}", JSONObject.toJSONString(jsonParam));
        String yesterday = DateUtil.getYesterdayOfDay(new Date());
        Map<String, DailyFinanceInfoVO> dailFinanceMap = null;
        CommonResponse<List<Map<String, Object>>> dailyFinanceInfoListResp = pmPayApplyApi.dailyFinanceInfo(yesterday);
        List<DailyFinanceInfoVO> dailyFinanceList = new ArrayList<>();
        if(!dailyFinanceInfoListResp.isSuccess()) {
            logger.error("昨日财务通知PM付款情况列表查询为空");
            dailFinanceMap = new HashMap<>();
        } else {
            dailyFinanceList = BeanMapper.mapList(dailyFinanceInfoListResp.getData(), DailyFinanceInfoVO.class);
            if(CollectionUtils.isEmpty(dailyFinanceList)) {
                logger.info("昨日财务通知PM付款情况列表查询为空");
                dailFinanceMap = new HashMap<>();
            } else {
                dailFinanceMap = dailyFinanceList.stream().collect(Collectors.toMap(item -> item.getProjectId().toString() + item.getSupplierId().toString() + item.getPayeeId().toString() + item.getContractId().toString(), item -> item));
            }
        }

        List<DailyFinanceInfoVO> pmDailyFinanceList = paymentApplyService.dailyFinanceInfo(yesterday);
        DailyFinanceInfoVO tmp = null;
        if(CollectionUtils.isNotEmpty(pmDailyFinanceList)) {
            for(DailyFinanceInfoVO item : pmDailyFinanceList) {
                tmp = dailFinanceMap.get(item.getProjectId().toString() + item.getSupplierId().toString() + item.getPayeeId().toString() + item.getContractId().toString());
                if(null != tmp) {
                    tmp.setFinanceDate(item.getFinanceDate());
                    tmp.setSucMny(item.getSucMny());
                    tmp.setSucNum(item.getSucNum());
                    tmp.setFailMny(item.getFailMny());
                    tmp.setFailNum(item.getFailNum());
                    tmp.setPsNum(item.getPsNum());
                    tmp.setPsMny(item.getPsMny());
                    tmp.setPMRecTime(item.getPMRecTime());
                    tmp.setPMRecMny(item.getPMRecMny());
                    tmp.setRegisterMny(item.getRegisterMny());
                    tmp.setProjectName(item.getProjectName());
                    tmp.setContractName(item.getContractName());
                    tmp.setSupplierName(item.getSupplierName());
                    tmp.setPayeeName(item.getPayeeName());
                } else {
                    dailyFinanceList.add(item);
                }
            }
        }

        JSONObject warnInfo = jsonParam.getJSONObject(0);
        Long tenantId = warnInfo.getLong("tenantId");
        String warnCode = warnInfo.getString("warnCode");
        JSONObject setting = warnInfo.getJSONArray("settings").getJSONObject(0);
        JSONObject warnSettings = setting.getJSONArray("warningSetings").getJSONObject(0);
        String templateContent = setting.getString("warningContentTemplate");

        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        EarlyWarnTransVO warnTmp = null;
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<OrgVO> orgResp = orgApi.getOneById(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("资金对账情况统计任务执行失败，查询当前组织信息失败，{}", JSONObject.toJSONString(orgResp));
            return CommonResponse.error("资金对账情况统计任务执行失败，查询当前组织信息失败");
        }
        OrgVO org = orgResp.getData();

        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
        for(DailyFinanceInfoVO item : dailyFinanceList) {
            logger.info("item ---: {}", JSONObject.toJSONString(item));
            if((null != item.getNotifyPMFailNum() && item.getNotifyPMFailNum() > 0) || (null != item.getFailNum() && item.getFailNum() > 0) || (null != item.getSucMny() && null != item.getRegisterMny() && item.getSucMny().compareTo(item.getRegisterMny()) != 0)) {
                //如果当日有财务通知PM失败、PM核销失败，PM核销成功总金额与付款登记总金额不一致情况，则发出预警
                warnTmp = new EarlyWarnTransVO();
                warnTmp.setWarnSetId(warnSettings.getLong("paramId"));
                warnTmp.setWarnSetParamId(warnSettings.getLong("id"));
                warnTmp.setWarnLevel(warnSettings.getString("warningLevel"));
                warnTmp.setTenantId(tenantId);
                warnTmp.setWarnType(setting.getString("warnType"));
                warnTmp.setEarlywarnName(setting.getString("warnName"));
                warnTmp.setOrgId(orgId);
                warnTmp.setOrgName(org.getName());
                warnTmp.setBillName("付款申请资金日对账");
                warnTmp.setSendOrgId(InvocationInfoProxy.getOrgId().toString());
                warnTmp.setEarlywarnContent(
                        templateContent.replaceAll("#projectName#", item.getProjectName() != null ? item.getProjectName() : null != item.getProjectId() ? item.getProjectId().toString() : "")
                                .replaceAll("#supplierName#", item.getSupplierName() != null ? item.getSupplierName() : null != item.getSupplierId() ? item.getSupplierId().toString() : "")
                                .replaceAll("#payeeName#", item.getPayeeName() != null ? item.getPayeeName() : null != item.getPayeeId() ? item.getPayeeId().toString() : "")
                                .replaceAll("#contractName#", null != item.getContractName() ? item.getContractName() : "")
                                .replaceAll("#payTime#", null != item.getPayTime() ? item.getPayTime().toString() : "0")
                                .replaceAll("#payMny#", decimalFormat.format(null != item.getPayMny() ? item.getPayMny() : BigDecimal.ZERO))
                                .replaceAll("#notifyPMSucNum#", null != item.getNotifyPMSucNum() ? item.getNotifyPMSucNum().toString() : "0")
                                .replaceAll("#notifyPMSucMny#", decimalFormat.format(null != item.getNotifyPMSucMny() ? item.getNotifyPMSucMny() : BigDecimal.ZERO))
                                .replaceAll("#notifyPMFailNum#", null != item.getNotifyPMFailNum() ? item.getNotifyPMFailNum().toString() : "0")
                                .replaceAll("#notifyPMFailMny#", decimalFormat.format(null != item.getNotifyPMFailMny() ? item.getNotifyPMFailMny() : BigDecimal.ZERO))
                                .replaceAll("#sucNum#", null != item.getSucNum() ? item.getSucNum().toString() : "0")
                                .replaceAll("#sucMny#", decimalFormat.format(null != item.getSucMny() ? item.getSucMny() : BigDecimal.ZERO))
                                .replaceAll("#failNum#", null != item.getFailNum() ? item.getFailNum().toString() : "0")
                                .replaceAll("#failMny#", decimalFormat.format(null != item.getFailMny() ? item.getFailMny() : BigDecimal.ZERO))
                                .replaceAll("#psNum#", null != item.getPsNum() ? item.getPsNum().toString() : "0")
                                .replaceAll("#psMny#", decimalFormat.format(null != item.getPsMny() ? item.getPsMny() : BigDecimal.ZERO))
                                .replaceAll("#registerMny#", decimalFormat.format(null != item.getRegisterMny() ? item.getRegisterMny() : BigDecimal.ZERO))

                );
                warnList.add(warnTmp);
            }
        }

        if(CollectionUtils.isEmpty(warnList)) {
            logger.info("昨天资金对账情况无异常，对账任务结束。。。");
            return CommonResponse.success("昨天资金对账情况无异常，对账任务结束。。。");
        }

        logger.info("发送预警消息：list-【{}】,code-【{}】", JSONObject.toJSONString(warnList), warnCode);
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("资金对账情况统计任务发送预警消息失败，{}", warnResp.getMsg());
            return CommonResponse.error("资金对账情况统计任务发送预警消息失败 " + warnResp.getMsg());
        }
        return CommonResponse.success("资金对账情况统计任务结束！");
    }
}
