package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目资金计划-支出合同
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan_contract")
public class PlanContractEntity extends BaseEntity {
	private static final long serialVersionUID = -7424236533238852475L;

	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "tree_index")
	private String treeIndex; // 序号
	@TableField(value = "contract_source_type")
	private String contractSourceType; // contraction-施工合同，prosub-专业分包合同，laborsub-劳务分包合同，materialPurchase-物资采购合同，concrete-混凝土合同，otherIn-其他合同，otherOut-其他支出
	@TableField(value = "contract_source_type_name")
	private String contractSourceTypeName; // 合同所属大分类名称
	@TableField(value = "contract_category_id")
	private Long contractCategoryId; // 合同分类Id
	@TableField(value = "contract_category_name")
	private String contractCategoryName; // 合同分类名称
	@TableField(value = "contract_category_property")
	private String contractCategoryProperty; // 合同分类属性
	@TableField(value = "contract_id")
	private Long contractId; // 合同Id
	@TableField(value = "contract_code")
	private String contractCode; // 合同编码
	@TableField(value = "contract_name")
	private String contractName; // 合同名称
	@TableField(value = "contract_route_url")
	private String contractRouteUrl; // 支出合同路由地址
	@TableField(value = "contract_partyb_id")
	private Long contractPartybId; // 合同乙方Id
	@TableField(value = "contract_partyb_name")
	private String contractPartybName; // 收款单位 =合同乙方名称
	@TableField(value = "contract_tax_mny")
	private BigDecimal contractTaxMny; // 合同金额 =合同总金额（含税）
	@TableField(value = "contract_payment_type")
	private String contractPaymentType; // 款项类别 预付款、进度款
	@TableField(value = "contract_payment_stage_id")
	private Long contractPaymentStageId; // 付款阶段 =来源于合同的【付款节点】的数据的id
	@TableField(value = "contract_payment_stage_name")
	private String contractPaymentStageName; // 付款阶段 =来源于合同的【付款节点】的数据的名称
	@TableField(value = "contract_payment_stage_scale")
	private BigDecimal contractPaymentStageScale; // 付款比例% =来源于合同的【付款节点】的数据的“付款阶段比例(%)”
	@TableField(value = "contract_payment_content")
	private String contractPaymentContent; // 付款内容
	@TableField(value = "contract_settle_mode_id")
	private Long contractSettleModeId; // 结算方式id =自定义档案【大企业收付款登记-结算方式】
	@TableField(value = "contract_settle_mode_code")
	private String contractSettleModeCode; // 结算方式编码
	@TableField(value = "contract_settle_mode_name")
	private String contractSettleModeName; // 结算方式名称
	@TableField(value = "contract_total_settle_mny")
	private BigDecimal contractTotalSettleMny; // 累计结算金额 =该合同的所有【结算池】数据，汇总“本期结算金额”之和
	@TableField(value = "contract_last_total_apply_advance_payment")
	private BigDecimal contractLastTotalApplyAdvancePayment; // 累计申请预付款(不含本次) =项目资金计划-支出合同生效的相同合同的“款项类别”为“预付款”的“本次计划付款金额”之和，要减去关闭后释放金额部分
	@TableField(value = "contract_last_total_deduction_advance_payment")
	private BigDecimal contractLastTotalDeductionAdvancePayment; // 累计已扣减预付款(不含本次) =项目资金计划-支出合同生效的相同合同的“款项类别”为“进度款”的“本次扣减预付款”
	@TableField(value = "contract_to_be_deduct_advance_payment")
	private BigDecimal contractToBeDeductAdvancePayment; // 待扣回预付款 =累计申请预付款金额(不含本次)-累计已扣减预付款(不含本次)
	@TableField(value = "contract_deduction_advance_payment")
	private BigDecimal contractDeductionAdvancePayment; // 本次扣减预付款
	@TableField(value = "contract_last_total_apply_schedule_payment")
	private BigDecimal contractLastTotalApplySchedulePayment; // 累计申请进度款(不含本次) =项目资金计划-支出合同生效的相同合同的“款项类别”为“进度款”的“本次计划付款金额”之和，要减去关闭后释放金额部分
	@TableField(value = "contract_last_total_applied_payment")
	private BigDecimal contractLastTotalAppliedPayment; // 累计已申请付款(不含本次) =项目资金计划-支出合同生效的相同合同的“本次计划付款金额”之和，要减去关闭后释放金额部分
	@TableField(value = "contract_can_apply_payment")
	private BigDecimal contractCanApplyPayment; // 本次可申请付款金额
	@TableField(value = "contract_plan_payment")
	private BigDecimal contractPlanPayment; // 本次计划付款金额
	@TableField(value = "contract_apply_occupy_mny")
	private BigDecimal contractApplyOccupyMny; // 申请占用金额 =本次计划付款金额
	@TableField(value = "contract_total_apply_payment")
	private BigDecimal contractTotalApplyPayment; // 累计申请付款金额(含本次) =累计已申请付款(不含本次)+本次计划付款金额
	@TableField(value = "contract_paid_scale")
	private BigDecimal contractPaidScale; // 已付款比例%（含本次）
	@TableField(value = "contract_memo")
	private String contractMemo; // 备注
	@TableField(value = "total_actual_payment_mny")
	private BigDecimal totalActualPaymentMny; // 本次累计实付金额
	@TableField(value = "unpaid_mny")
	private BigDecimal unpaidMny; // 本次未支付金额
	@TableField(value = "release_apply_mny")
	private BigDecimal releaseApplyMny; // 本次释放申请金额
	@TableField(value = "close_state")
	private String closeState; // 关闭状态 已关闭 未关闭
	@TableField(value = "close_date_time")
	private Date closeDateTime; // 关闭时间
	@TableField(value = "close_user_id")
	private Long closeUserId; // 关闭人
	@TableField(value = "close_user_name")
	private String closeUserName; // 关闭人名称
	@TableField(value = "close_user_code")
	private String closeUserCode; // 关闭人编码
	@TableField(value = "parent_id")
	private Long parentId; // 父id
	@TableField(value = "plan_id")
	private Long planId; // 项目资金计划id
	@TableField(exist = false)
	private String tid; // 主键
	@TableField(exist = false)
	private String tpid; // 父id
	@TableField(value = "leaf_flag")
	private Boolean leafFlag; // 是否末级


	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public String getTreeIndex() {
		return treeIndex;
	}

	public void setTreeIndex(String treeIndex) {
		this.treeIndex = treeIndex;
	}

	public String getContractSourceType() {
		return contractSourceType;
	}

	public void setContractSourceType(String contractSourceType) {
		this.contractSourceType = contractSourceType;
	}

	public String getContractSourceTypeName() {
		return contractSourceTypeName;
	}

	public void setContractSourceTypeName(String contractSourceTypeName) {
		this.contractSourceTypeName = contractSourceTypeName;
	}

	public Long getContractCategoryId() {
		return contractCategoryId;
	}

	public void setContractCategoryId(Long contractCategoryId) {
		this.contractCategoryId = contractCategoryId;
	}

	public String getContractCategoryName() {
		return contractCategoryName;
	}

	public void setContractCategoryName(String contractCategoryName) {
		this.contractCategoryName = contractCategoryName;
	}

	public String getContractCategoryProperty() {
		return contractCategoryProperty;
	}

	public void setContractCategoryProperty(String contractCategoryProperty) {
		this.contractCategoryProperty = contractCategoryProperty;
	}

	public Long getContractId() {
		return contractId;
	}

	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}

	public String getContractCode() {
		return contractCode;
	}

	public void setContractCode(String contractCode) {
		this.contractCode = contractCode;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public String getContractRouteUrl() {
		return contractRouteUrl;
	}

	public void setContractRouteUrl(String contractRouteUrl) {
		this.contractRouteUrl = contractRouteUrl;
	}

	public Long getContractPartybId() {
		return contractPartybId;
	}

	public void setContractPartybId(Long contractPartybId) {
		this.contractPartybId = contractPartybId;
	}

	public String getContractPartybName() {
		return contractPartybName;
	}

	public void setContractPartybName(String contractPartybName) {
		this.contractPartybName = contractPartybName;
	}

	public BigDecimal getContractTaxMny() {
		return contractTaxMny;
	}

	public void setContractTaxMny(BigDecimal contractTaxMny) {
		this.contractTaxMny = contractTaxMny;
	}

	public String getContractPaymentType() {
		return contractPaymentType;
	}

	public void setContractPaymentType(String contractPaymentType) {
		this.contractPaymentType = contractPaymentType;
	}

	public Long getContractPaymentStageId() {
		return contractPaymentStageId;
	}

	public void setContractPaymentStageId(Long contractPaymentStageId) {
		this.contractPaymentStageId = contractPaymentStageId;
	}

	public String getContractPaymentStageName() {
		return contractPaymentStageName;
	}

	public void setContractPaymentStageName(String contractPaymentStageName) {
		this.contractPaymentStageName = contractPaymentStageName;
	}

	public BigDecimal getContractPaymentStageScale() {
		return contractPaymentStageScale;
	}

	public void setContractPaymentStageScale(BigDecimal contractPaymentStageScale) {
		this.contractPaymentStageScale = contractPaymentStageScale;
	}

	public String getContractPaymentContent() {
		return contractPaymentContent;
	}

	public void setContractPaymentContent(String contractPaymentContent) {
		this.contractPaymentContent = contractPaymentContent;
	}

	public Long getContractSettleModeId() {
		return contractSettleModeId;
	}

	public void setContractSettleModeId(Long contractSettleModeId) {
		this.contractSettleModeId = contractSettleModeId;
	}

	public String getContractSettleModeCode() {
		return contractSettleModeCode;
	}

	public void setContractSettleModeCode(String contractSettleModeCode) {
		this.contractSettleModeCode = contractSettleModeCode;
	}

	public String getContractSettleModeName() {
		return contractSettleModeName;
	}

	public void setContractSettleModeName(String contractSettleModeName) {
		this.contractSettleModeName = contractSettleModeName;
	}

	public BigDecimal getContractTotalSettleMny() {
		return contractTotalSettleMny;
	}

	public void setContractTotalSettleMny(BigDecimal contractTotalSettleMny) {
		this.contractTotalSettleMny = contractTotalSettleMny;
	}

	public BigDecimal getContractLastTotalApplyAdvancePayment() {
		return contractLastTotalApplyAdvancePayment;
	}

	public void setContractLastTotalApplyAdvancePayment(BigDecimal contractLastTotalApplyAdvancePayment) {
		this.contractLastTotalApplyAdvancePayment = contractLastTotalApplyAdvancePayment;
	}

	public BigDecimal getContractLastTotalDeductionAdvancePayment() {
		return contractLastTotalDeductionAdvancePayment;
	}

	public void setContractLastTotalDeductionAdvancePayment(BigDecimal contractLastTotalDeductionAdvancePayment) {
		this.contractLastTotalDeductionAdvancePayment = contractLastTotalDeductionAdvancePayment;
	}

	public BigDecimal getContractToBeDeductAdvancePayment() {
		return contractToBeDeductAdvancePayment;
	}

	public void setContractToBeDeductAdvancePayment(BigDecimal contractToBeDeductAdvancePayment) {
		this.contractToBeDeductAdvancePayment = contractToBeDeductAdvancePayment;
	}

	public BigDecimal getContractDeductionAdvancePayment() {
		return contractDeductionAdvancePayment;
	}

	public void setContractDeductionAdvancePayment(BigDecimal contractDeductionAdvancePayment) {
		this.contractDeductionAdvancePayment = contractDeductionAdvancePayment;
	}

	public BigDecimal getContractLastTotalApplySchedulePayment() {
		return contractLastTotalApplySchedulePayment;
	}

	public void setContractLastTotalApplySchedulePayment(BigDecimal contractLastTotalApplySchedulePayment) {
		this.contractLastTotalApplySchedulePayment = contractLastTotalApplySchedulePayment;
	}

	public BigDecimal getContractLastTotalAppliedPayment() {
		return contractLastTotalAppliedPayment;
	}

	public void setContractLastTotalAppliedPayment(BigDecimal contractLastTotalAppliedPayment) {
		this.contractLastTotalAppliedPayment = contractLastTotalAppliedPayment;
	}

	public BigDecimal getContractCanApplyPayment() {
		return contractCanApplyPayment;
	}

	public void setContractCanApplyPayment(BigDecimal contractCanApplyPayment) {
		this.contractCanApplyPayment = contractCanApplyPayment;
	}

	public BigDecimal getContractPlanPayment() {
		return contractPlanPayment;
	}

	public void setContractPlanPayment(BigDecimal contractPlanPayment) {
		this.contractPlanPayment = contractPlanPayment;
	}

	public BigDecimal getContractApplyOccupyMny() {
		return contractApplyOccupyMny;
	}

	public void setContractApplyOccupyMny(BigDecimal contractApplyOccupyMny) {
		this.contractApplyOccupyMny = contractApplyOccupyMny;
	}

	public BigDecimal getContractTotalApplyPayment() {
		return contractTotalApplyPayment;
	}

	public void setContractTotalApplyPayment(BigDecimal contractTotalApplyPayment) {
		this.contractTotalApplyPayment = contractTotalApplyPayment;
	}

	public BigDecimal getContractPaidScale() {
		return contractPaidScale;
	}

	public void setContractPaidScale(BigDecimal contractPaidScale) {
		this.contractPaidScale = contractPaidScale;
	}

	public String getContractMemo() {
		return contractMemo;
	}

	public void setContractMemo(String contractMemo) {
		this.contractMemo = contractMemo;
	}

	public BigDecimal getTotalActualPaymentMny() {
		return totalActualPaymentMny;
	}

	public void setTotalActualPaymentMny(BigDecimal totalActualPaymentMny) {
		this.totalActualPaymentMny = totalActualPaymentMny;
	}

	public BigDecimal getUnpaidMny() {
		return unpaidMny;
	}

	public void setUnpaidMny(BigDecimal unpaidMny) {
		this.unpaidMny = unpaidMny;
	}

	public BigDecimal getReleaseApplyMny() {
		return releaseApplyMny;
	}

	public void setReleaseApplyMny(BigDecimal releaseApplyMny) {
		this.releaseApplyMny = releaseApplyMny;
	}

	public String getCloseState() {
		return closeState;
	}

	public void setCloseState(String closeState) {
		this.closeState = closeState;
	}

	public Date getCloseDateTime() {
		return closeDateTime;
	}

	public void setCloseDateTime(Date closeDateTime) {
		this.closeDateTime = closeDateTime;
	}

	public Long getCloseUserId() {
		return closeUserId;
	}

	public void setCloseUserId(Long closeUserId) {
		this.closeUserId = closeUserId;
	}

	public String getCloseUserName() {
		return closeUserName;
	}

	public void setCloseUserName(String closeUserName) {
		this.closeUserName = closeUserName;
	}

	public String getCloseUserCode() {
		return closeUserCode;
	}

	public void setCloseUserCode(String closeUserCode) {
		this.closeUserCode = closeUserCode;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

	public String getTid() {
		return tid;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}

	public String getTpid() {
		return tpid;
	}

	public void setTpid(String tpid) {
		this.tpid = tpid;
	}

	public Boolean getLeafFlag() {
		return leafFlag;
	}

	public void setLeafFlag(Boolean leafFlag) {
		this.leafFlag = leafFlag;
	}
}
