package com.ejianc.business.profinance.plan.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.plan.bean.PlanEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 项目资金计划
 *
 * @author generator
 */
public interface IPlanService extends IBaseService<PlanEntity> {


	/**
	 * 设置子表默认值
	 *
	 * @param entity 项目资金计划实体
	 */
	void setSubDefaultValue(PlanEntity entity);

	/**
	 * 根据项目id查询最新的项目资金计划信息
	 *
	 * @param projectId 项目id
	 *
	 * @return PlanEntity
	 */
	PlanEntity fetchLastPlan(Long projectId);

	/**
	 * 根据项目id查询已审批通过的【收款登记】“本次实收金额”之和
	 *
	 * @param projectId 项目id
	 *
	 * @return 累计工程收款(含本次)
	 */
	BigDecimal fetchTotalReceiptRegister(Long projectId);

	/**
	 * 根据项目id查询结算池中结算类型为产值报量“本期结算金额(含税)”之和
	 *
	 * @param projectId 项目id
	 *
	 * @return 累计产值金额
	 */
	BigDecimal fetchTotalProductValue(Long projectId);

	/**
	 * 根据项目id获取上期计划日期、累计工程收款(不含本次)、累计产值金额
	 *
	 * @param projectId 项目id
	 *
	 * @return 上期计划日期、累计工程收款(不含本次)、累计产值金额
	 */
	Map<String, Object> fetchValue(Long projectId);

	/**
	 * 校验引用的参照数据
	 *
	 * @param referMap 参照数据
	 */
	void checkReferQuote(JSONObject referMap);

	/**
	 * 校验只能有一个未生效的单据
	 * @param projectId 项目id
	 */
	void checkOnlyOne(Long projectId);
}
