package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.RegisterDetailEntity;
import com.ejianc.business.profinance.bean.RegulateEntity;
import com.ejianc.business.profinance.mapper.PaymentRegisterMapper;
import com.ejianc.business.profinance.plan.bean.*;
import com.ejianc.business.profinance.plan.service.*;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegisterDetailService;
import com.ejianc.business.profinance.service.IRegulateService;
import com.ejianc.business.profinance.vo.ImportPaymentRegisterVO;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.business.profinance.vo.RegisterDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 付款登记主实体
 *
 * @author generator
 */
@Service("paymentRegisterService")
public class PaymentRegisterServiceImpl extends BaseServiceImpl<PaymentRegisterMapper, PaymentRegisterEntity> implements IPaymentRegisterService {
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IContractPoolApi contractApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IShareSupplierWebApi iShareSupplierWebApi;

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IRegisterDetailService detailService;
    @Autowired
    private IPlanContractService planContractService;
    @Autowired
    private IPlanMaterialService planMaterialService;
    @Autowired
    private IPlanTemporaryService planTemporaryService;
    @Autowired
    private IPlanFeeService planFeeService;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IRegulateService regulateService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPaymentApplyService paymentApplyService;

    private static final String BILL_CODE = "PAYMENT_REGISTER";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<PaymentRegisterEntity> queryPaymentRegisterByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        param.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        return super.queryList(param);
    }

    @Override
    public Map<String, BigDecimal> queryAlreadyPayMny(Long contractId) {
        Map<String, BigDecimal> info = new HashMap<>();
        QueryWrapper<PaymentRegisterEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("sum( pay_mny ) AS alreadyPayMny");
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = super.getMap(queryWrapper);

        info.put("alreadyPayMny", null != resultMap && null != resultMap.get("alreadyPayMny") ? new BigDecimal(resultMap.get("alreadyPayMny").toString()) : BigDecimal.ZERO);
        return info;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        List<Integer> typeList = new ArrayList<>();
        for (int i = 1; i < 6; i++) {
            typeList.add(i);
        }
        Date startDate = new Date();
        logger.info("导入校验开始：开始时间----------->{}", startDate);
        CommonResponse<List<BankAccountVO>> accountList = iShareSupplierWebApi.queryBankAccountList();

        logger.info("账户查询使用时间----------->{}", new Date());

        CommonResponse<List<DefdocDetailVO>> defSettleList = defdocApi.getDefDocByDefCode("profinance-settle-type");
        logger.info("自定义档案查询使用时间----------->{}", new Date());

        CommonResponse<List<DefdocDetailVO>> defFeeList = defdocApi.getDefDocByDefCode("no_contract_fee_type");
        logger.info("自定义档案结算类型使用时间----------->{}", new Date());

        if (!accountList.isSuccess()) {
            return CommonResponse.error("导入失败，查询银行账户信息失败，请重试！");
        }
        if (!defSettleList.isSuccess()) {
            return CommonResponse.error("导入失败，查询档案下结算类型失败，请重试！");
        }
        if (!defFeeList.isSuccess()) {
            return CommonResponse.error("导入失败，查询自定义档案失败，请重试！");
        }

        Map<String, BankAccountVO> accountMap = accountList.getData().stream().collect(Collectors.toMap(BankAccountVO::getBankAccount, Function.identity(), (key1, key2) -> key2));
        //todo 后期验证走供应商验证银行账户时再放开
        //Map<String, BankAccountVO> bankAccountVOMap = new HashMap<>();
        Map<String, SupplierDTO> supplierDTOMap = new HashMap<>();
        Map<String, ProjectPoolSetVO> projectPoolSetVOMap = new HashMap<>();
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        Map<String, ContractPoolVO> contractPoolVOMap = new HashMap<>();

        Map<String, DefdocDetailVO> defFeeMap = defFeeList.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map<String, DefdocDetailVO> defSettleMap = defSettleList.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportPaymentRegisterVO> successList = new ArrayList<>();
            List<ImportPaymentRegisterVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 14) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                /*
                    凡是组织有关字段都和项目池对照
                    凡是合同有关字段，都和合同池数据对照
                 */

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportPaymentRegisterVO paymentRegisterVO = new ImportPaymentRegisterVO();

                    //支付日期-PaymentDate
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[支付日期为必填项]");
                    } else {
                        try {
                            paymentRegisterVO.setPaymentDate(DateUtils.parseDate(datas.get(1), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[支付日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //支出类型-PaymentContractFlag
                    if (StringUtils.isBlank(datas.get(2))) {
                        errorMessage.append("[支出类型为必填项]");
                    } else {
                        if (datas.get(2).equals("有合同付款")) {
                            paymentRegisterVO.setPaymentContractFlag(0);
                            paymentRegisterVO.setPaymentContractFlagName("有合同付款");
                        } else if (datas.get(2).equals("无合同付款")) {
                            paymentRegisterVO.setPaymentContractFlag(1);
                            paymentRegisterVO.setPaymentContractFlagName("无合同付款");
                        } else {
                            errorMessage.append("[支出类型填写错误]");
                        }
                    }

                    //支出类型为有合同付款时，合同名称，合同编码为必填项
                    if (paymentRegisterVO.getPaymentContractFlag() != null && paymentRegisterVO.getPaymentContractFlag().equals(0)) {

                        //合同编号-contractCode
                        if (StringUtils.isNotBlank(datas.get(4))) {
                            paymentRegisterVO.setContractCode(datas.get(4));
                            if (datas.get(4).length() > 64) {
                                errorMessage.append("[填写合同编号长度为1~64字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) == null) {
                                CommonResponse<ContractPoolVO> contractData = contractApi.queryContractByCode(datas.get(4));
                                if (contractData.isSuccess() && contractData.getData() != null) {
                                    contractPoolVOMap.put(datas.get(4), contractData.getData());
                                } else {
                                    errorMessage.append("[合同池中不存在当前合同编号的合同]");
                                }
                            }
                        } else {
                            errorMessage.append("[支出类型为有合同付款时，合同编号为必填项]");
                        }

                        //合同名称-ContractName
                        if (StringUtils.isNotBlank(datas.get(3))) {
                            paymentRegisterVO.setContractName(datas.get(3));
                            if (datas.get(3).length() > 128) {
                                errorMessage.append("[填写合同名称长度为1~128字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getContractName() == null || !datas.get(3).equals(contractPoolVOMap.get(datas.get(4)).getContractName())) {
                                    errorMessage.append("[合同池中当前名称和合同编号不符合]");
                                } else {
                                    paymentRegisterVO.setContractId(contractPoolVOMap.get(datas.get(4)).getContractId());
                                    paymentRegisterVO.setContractCode(datas.get(4));
                                    paymentRegisterVO.setContractTaxMny(contractPoolVOMap.get(datas.get(4)).getContractTaxMny());
                                    paymentRegisterVO.setContractMny(contractPoolVOMap.get(datas.get(4)).getContractMny());

                                    paymentRegisterVO.setOrgCode(contractPoolVOMap.get(datas.get(4)).getOrgCode());
                                    paymentRegisterVO.setContractLinkUrl(contractPoolVOMap.get(datas.get(4)).getPcCardUrl());
                                }
                            }
                        } else {
                            errorMessage.append("[支出类型为有合同付款时，合同名称为必填项]");
                        }

                        //合同类别
                        if (StringUtils.isNotBlank(datas.get(5))) {
                            paymentRegisterVO.setContractCategoryName(datas.get(5));
                            if (datas.get(5).length() > 128) {
                                errorMessage.append("[填写合同类别长度为1~128字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getCategoryName() == null || !contractPoolVOMap.get(datas.get(4)).getCategoryName().equals(datas.get(5))) {
                                    errorMessage.append("[合同池中当前合同类别和合同编号不符合]");
                                } else {
                                    paymentRegisterVO.setContractCategoryId(contractPoolVOMap.get(datas.get(4)).getCategoryId());
                                }
                            }
                        }

                        //项目名称
                        if (StringUtils.isNotBlank(datas.get(7))) {
                            paymentRegisterVO.setProjectName(datas.get(7));
                            if (datas.get(7).length() > 128) {
                                errorMessage.append("[填写项目名称长度为1~128字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getProjectName() == null || !contractPoolVOMap.get(datas.get(4)).getProjectName().equals(datas.get(7))) {
                                    errorMessage.append("[合同池中当前项目名称和合同编号不符合]");
                                } else {
                                    paymentRegisterVO.setProjectId(contractPoolVOMap.get(datas.get(4)).getProjectId());
                                    paymentRegisterVO.setOrgId(contractPoolVOMap.get(datas.get(4)).getOrgId());
                                    paymentRegisterVO.setOrgName(contractPoolVOMap.get(datas.get(4)).getOrgName());
                                }
                            }
                        } else {
                            errorMessage.append("[项目名称为必填项]");
                        }

                        //项目所属单位-ParentOrgName
                        if (StringUtils.isBlank(datas.get(0))) {
                            errorMessage.append("[项目所属单位为必填项]");
                        } else {
                            paymentRegisterVO.setParentOrgName(datas.get(0));
                            if (datas.get(0).length() > 128) {
                                errorMessage.append("[项目所属单位填写长度为1~128字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getParentOrgName() == null || !contractPoolVOMap.get(datas.get(4)).getParentOrgName().equals(datas.get(0))) {
                                    errorMessage.append("[合同池中当前项目所属单位名称和合同编号不符合]");
                                } else {
                                    paymentRegisterVO.setParentOrgCode(contractPoolVOMap.get(datas.get(4)).getParentOrgCode());
                                    paymentRegisterVO.setParentOrgId(contractPoolVOMap.get(datas.get(4)).getParentOrgId());
                                }
                            }
                        }

                        //项目编码
                        if (StringUtils.isNotBlank(datas.get(8))) {
                            paymentRegisterVO.setProjectCode(datas.get(8));
                            if (datas.get(8).length() > 64) {
                                errorMessage.append("[填写项目编码长度为1~64字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getProjectCode() == null || !contractPoolVOMap.get(datas.get(4)).getProjectCode().equals(datas.get(8))) {
                                    errorMessage.append("[合同池中当前项目编码和合同编号不符合]");
                                }
                            }
                        } else {
                            errorMessage.append("[项目编码为必填项]");
                        }

                        //收款单位
                        if (StringUtils.isNotBlank(datas.get(9))) {
                            paymentRegisterVO.setSupplierName(datas.get(9));
                            if (datas.get(9).length() > 128) {
                                errorMessage.append("[填写收款单位长度为1~128字]");
                            } else if (contractPoolVOMap.get(datas.get(4)) != null) {
                                if (contractPoolVOMap.get(datas.get(4)).getPartybName() == null || !contractPoolVOMap.get(datas.get(4)).getPartybName().equals(datas.get(9))) {
                                    errorMessage.append("[合同池中当前收款单位和合同编号不符合]");
                                } else {
                                    paymentRegisterVO.setSupplierId(contractPoolVOMap.get(datas.get(4)).getPartybId());
                                }
                            }
                        } else {
                            errorMessage.append("[收款单位为必填项]");
                        }

                    } else if (paymentRegisterVO.getPaymentContractFlag() != null && paymentRegisterVO.getPaymentContractFlag().equals(1)) {
                        //无合同费用类型
                        if (StringUtils.isNotBlank(datas.get(6))) {
                            paymentRegisterVO.setFeeTypeName(datas.get(6));
                            if (datas.get(6).length() > 100) {
                                errorMessage.append("[填写无合同费用类型长度为1~100字]");
                            } else {
                                if (defFeeMap.get(datas.get(6)) == null) {
                                    errorMessage.append("[自定义档案不存在当前无合同费用类型]");
                                } else {
                                    paymentRegisterVO.setFeeTypeId(defFeeMap.get(datas.get(6)).getId());
                                    paymentRegisterVO.setFeeTypeCode(defFeeMap.get(datas.get(6)).getCode());
                                    paymentRegisterVO.setPersonalPrepaid(0);
                                }
                            }
                        }


                        //项目名称
                        if (StringUtils.isNotBlank(datas.get(7))) {
                            paymentRegisterVO.setProjectName(datas.get(7));
                            if (datas.get(7).length() > 128) {
                                errorMessage.append("[填写项目名称长度为1~128字]");
                            } else {
                                if (projectPoolSetVOMap.get(datas.get(7)) != null) {
                                    paymentRegisterVO.setProjectId(projectPoolSetVOMap.get(datas.get(7)).getId());
                                    paymentRegisterVO.setOrgId(projectPoolSetVOMap.get(datas.get(7)).getProjectDepartmentId());
                                    paymentRegisterVO.setOrgName(projectPoolSetVOMap.get(datas.get(7)).getProjectDepartmentName());
                                } else {
                                    CommonResponse<List<ProjectPoolSetVO>> projectData = projectPoolApi.queryProjectListByNameAndTenantId(datas.get(7), tenantId);
                                    if (!projectData.isSuccess()) {
                                        errorMessage.append("[项目池不存在当前项目名称的项目]");
                                    } else {
                                        if (CollectionUtils.isNotEmpty(projectData.getData()) && null != projectData.getData().get(0)) {
                                            projectPoolSetVOMap.put(datas.get(7), projectData.getData().get(0));
                                            paymentRegisterVO.setProjectId(projectPoolSetVOMap.get(datas.get(7)).getId());
                                            paymentRegisterVO.setOrgId(projectPoolSetVOMap.get(datas.get(7)).getProjectDepartmentId());
                                            paymentRegisterVO.setOrgName(projectPoolSetVOMap.get(datas.get(7)).getProjectDepartmentName());
                                        } else {
                                            errorMessage.append("[项目池不存在当前项目名称的项目]");
                                        }
                                    }
                                }
                            }
                        } else {
                            errorMessage.append("[项目名称为必填项]");
                        }





                        //项目所属单位-ParentOrgName
                        if (StringUtils.isBlank(datas.get(0))) {
                            errorMessage.append("[项目所属单位为必填项]");
                        } else {
                            paymentRegisterVO.setParentOrgName(datas.get(0));
                            if (datas.get(0).length() > 128) {
                                errorMessage.append("[项目所属单位填写长度为1~128字]");
                            } else {
                                if (orgVOMap.get(datas.get(0)) != null) {
                                    paymentRegisterVO.setParentOrgCode(orgVOMap.get(datas.get(0)).getCode());
                                    paymentRegisterVO.setParentOrgId(orgVOMap.get(datas.get(0)).getId());
                                } else {
                                    CommonResponse<OrgVO> orgData = iOrgApi.findByNameAndTenantId(datas.get(0), tenantId);
                                    if (!orgData.isSuccess()) {
                                        errorMessage.append("[组织管理中不存在当前项目所属单位]");
                                    } else {
                                        if (datas.get(7) != null && projectPoolSetVOMap.get(datas.get(7)).getOrgName() != null && !datas.get(0).equals(projectPoolSetVOMap.get(datas.get(7)).getOrgName())) {
                                            errorMessage.append("[项目池中当前项目所属单位和项目名称不符合]");
                                        } else {
                                            orgVOMap.put(datas.get(7), orgData.getData());
                                            paymentRegisterVO.setParentOrgCode(orgVOMap.get(datas.get(7)).getCode());
                                            paymentRegisterVO.setParentOrgId(orgVOMap.get(datas.get(7)).getId());
                                        }
                                    }
                                }

                            }
                        }

                        //项目编码
                        if (StringUtils.isNotBlank(datas.get(8))) {
                            paymentRegisterVO.setProjectCode(datas.get(8));
                            if (datas.get(8).length() > 64) {
                                errorMessage.append("[填写项目编码长度为1~64字]");
                            } else {
                                if (projectPoolSetVOMap.get(datas.get(7)) == null) {
                                    errorMessage.append("[项目池中不存在当前项目名称的项目]");
                                } else {
                                    if (!projectPoolSetVOMap.get(datas.get(7)).getCode().equals(datas.get(8))) {
                                        errorMessage.append("[项目池中项目编码和项目名称不符合]");
                                    }
                                }
                            }
                        } else {
                            errorMessage.append("[项目编码为必填项]");
                        }

                        //收款单位
                        if (StringUtils.isNotBlank(datas.get(9))) {
                            paymentRegisterVO.setSupplierName(datas.get(9));
                            if (datas.get(9).length() > 128) {
                                errorMessage.append("[填写收款单位长度为1~128字]");
                            } else {
                                if (supplierDTOMap.get(datas.get(9)) != null) {
                                    paymentRegisterVO.setSupplierId(supplierDTOMap.get(datas.get(9)).getId());
                                } else {
                                    List<String> supplierNameList = new ArrayList<>();
                                    supplierNameList.add(datas.get(9));
                                    CommonResponse<List<SupplierDTO>> supplierData = iProSupplierApi.querySupplierByNames(supplierNameList);
                                    if (!supplierData.isSuccess()) {
                                        errorMessage.append("[客户档案数据不存在]");
                                    } else {
                                        if (CollectionUtils.isNotEmpty(supplierData.getData()) && null != supplierData.getData().get(0)) {
                                            supplierDTOMap.put(datas.get(9), supplierData.getData().get(0));
                                            paymentRegisterVO.setSupplierId(supplierData.getData().get(0).getId());
                                        } else {
                                            errorMessage.append("[客户档案数据不存在]");
                                        }
                                    }
                                }
                            }
                        } else {
                            errorMessage.append("[收款单位为必填项]");
                        }
                    }

                    //本次付款金额
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            paymentRegisterVO.setPayMny(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            errorMessage.append("[本次付款金额必须为数字]");
                        }
                    } else {
                        errorMessage.append("[本次付款金额为必填项]");
                    }

                    //付款说明
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        if (datas.get(11).length() > 500) {
                            errorMessage.append("[填写付款说明长度为1~500字]");
                        }
                        paymentRegisterVO.setPaymentReason(datas.get(11));
                    }


                    //收款银行账户
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        paymentRegisterVO.setAccountName(datas.get(12));
                        if (datas.get(12).length() > 500) {
                            errorMessage.append("[填写收款银行账户长度为1~64字]");
                        } else {
                            if (accountMap.get(datas.get(12)) == null) {
                                errorMessage.append("[银行账户下不存在当前账户]");
                            } else {
                                paymentRegisterVO.setAccountId(accountMap.get(datas.get(12)).getId());
                                paymentRegisterVO.setAccountNum(accountMap.get(datas.get(12)).getBankCode());
                                paymentRegisterVO.setBankAccount(accountMap.get(datas.get(12)).getBankName());
                            }
                        }
                        //todo：后期走供应商验证收款银行账户时再放开
//                        }else {
//                            if (bankAccountVOMap.get(datas.get(12)) != null) {
//                                paymentRegisterVO.setAccountId(bankAccountVOMap.get(datas.get(12)).getId());
//                                paymentRegisterVO.setAccountNum(bankAccountVOMap.get(datas.get(12)).getBankCode());
//                                paymentRegisterVO.setBankAccount(bankAccountVOMap.get(datas.get(12)).getBankName());
//                            } else {
//                                //判断收款单位是否为空
//                                if (StringUtils.isNotBlank(datas.get(9)) && supplierDTOMap.get(datas.get(9)) != null) {
//                                    BankAccountVO bankAccountVO = new BankAccountVO();
//                                    bankAccountVO.setSupplierId(supplierDTOMap.get(datas.get(9)).getId());
//                                    CommonResponse<List<BankAccountVO>> bankAccountData = iBankApi.getBankAccountsByCondition(bankAccountVO);
//                                    if (bankAccountData.isSuccess()){
//                                        if (CollectionUtils.isNotEmpty(bankAccountData.getData())){
//                                            Map<String, BankAccountVO> accountMap = bankAccountData.getData().stream().collect(Collectors.toMap(BankAccountVO::getBankAccount, Function.identity(), (key1, key2) -> key2));
//                                            if (accountMap.containsKey(datas.get(12))){
//                                                paymentRegisterVO.setAccountId(accountMap.get(datas.get(12)).getId());
//                                                paymentRegisterVO.setAccountNum(accountMap.get(datas.get(12)).getBankCode());
//                                                paymentRegisterVO.setBankAccount(accountMap.get(datas.get(12)).getBankName());
//                                                bankAccountVOMap.putAll(accountMap);
//                                            }else {
//                                                errorMessage.append("[当前收款单位没有该收款银行账户]");
//                                            }
//                                        }else {
//                                            errorMessage.append("[当前收款单位无收款银行账户]");
//                                        }
//                                    }else {
//                                        errorMessage.append("[当前收款单位无收款银行账户]");
//                                    }
//                                }
//                            }
//                        }
                    }

                    //结算方式
                    //现金支付、银行支付、内部转账、应付银行承兑票据、应付商业承兑票据、应收银行承兑票据
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        paymentRegisterVO.setSettleTypeName(datas.get(13));
                        if (defSettleMap.get(datas.get(13)) == null) {
                            errorMessage.append("[档案下不存在当前结算类型]");
                        } else {
                            paymentRegisterVO.setSettleTypeId(defSettleMap.get(datas.get(13)).getId());
                            paymentRegisterVO.setSettleTypeCode(defSettleMap.get(datas.get(13)).getCode());
                        }
                    }

                    paymentRegisterVO.setId(IdWorker.getId());
                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(paymentRegisterVO);
                    } else {
                        paymentRegisterVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(paymentRegisterVO);
                    }
                }
            }
            logger.info("导入结束时间----------->{}", new Date());
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<PaymentRegisterVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<PaymentRegisterEntity> entityList = BeanMapper.mapList(importVOS, PaymentRegisterEntity.class);
        Map<String, BigDecimal> mny = new HashMap<>();
        for (PaymentRegisterEntity entity : entityList) {
            mny = queryAlreadyPayMny(entity.getContractId());
            entity.setAlreadyPayMny(mny.get("alreadyPayMny"));
            entity.setPersonalPrepaid(0);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, PaymentRegisterVO.class));
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                logger.error("保存付款登记失败，自动生成付款登记单编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "保存成功";
    }

    @Override
    public BigDecimal getTotalPaidMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(pay_mny) as totalPaidMny");
        Map<String, BigDecimal> result = super.getMap(wrapper);
        return null != result && null != result.get("totalPaidMny") ? result.get("totalPaidMny") : BigDecimal.ZERO;
    }

    /**
     *
     * @param entity
     * @param check 为true +  flase -
     */
    @Override
    public void writeBack(PaymentRegisterEntity entity ,boolean check) {
        QueryParam queryParam = new QueryParam();
        Integer paymentContractFlag = entity.getPaymentContractFlag();
        if (paymentContractFlag != null && paymentContractFlag == 2) {
            queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, entity.getSourceId()));
        } else {
            List<Long> sourceIdS = entity.getDetailList().stream().filter(item -> item.getSourceId() != null).map(RegisterDetailEntity::getSourceId).collect(Collectors.toList());
            if (!sourceIdS.isEmpty()){
                queryParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIdS));
            }
        }
        List<RegulateEntity> regulateEntities = regulateService.queryList(queryParam);


        BigDecimal mny = BigDecimal.ZERO;

        if (CollectionUtils.isNotEmpty(regulateEntities)) {
            for (RegulateEntity regulateEntity : regulateEntities) {
                if (paymentContractFlag != null && paymentContractFlag == 2) {
                    mny = entity.getPayMny();
                } else {
                    if (CollectionUtils.isNotEmpty(entity.getDetailList())){
                        Map<Long, RegisterDetailEntity> collect = entity.getDetailList().stream().collect(Collectors.toMap(RegisterDetailEntity::getSourceId, Function.identity()));
                        mny = collect.get(regulateEntity.getSourceId()).getActualMny();
                    }
                }
                BigDecimal paidMny = regulateEntity.getPaidMny() == null ? BigDecimal.ZERO : regulateEntity.getPaidMny();
                regulateEntity.setPaidMny(check?paidMny.add(mny):paidMny.subtract(mny));
                regulateEntity.setUnpaidMny(regulateEntity.getPlanPayMny().subtract(regulateEntity.getPaidMny()));
                logger.info("回写资金计划 中间表---PaidMny {}   ---UnpaidMny {}", regulateEntity.getPaidMny(), regulateEntity.getUnpaidMny());
                Long planId =null;
//                // 支出类型 有无合同 0：有合同；1：无合同；2：合同付款；3：零星材料；4：临时机械；5：零星费用
                switch (paymentContractFlag){
                    case 2:
                        //回写资金计划 对应子表
                        QueryWrapper<PlanContractEntity> listQuery = new QueryWrapper<>();
                        listQuery.eq("id", regulateEntity.getSourceId());
                        PlanContractEntity contractServiceOne = planContractService.getOne(listQuery);
                        BigDecimal totalActualPaymentMny = contractServiceOne.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : contractServiceOne.getTotalActualPaymentMny();
                        contractServiceOne.setTotalActualPaymentMny(check?totalActualPaymentMny.add(mny):totalActualPaymentMny.subtract(mny));
                        contractServiceOne.setUnpaidMny(contractServiceOne.getContractPlanPayment().subtract(contractServiceOne.getTotalActualPaymentMny()));
                        logger.info("回写资金计划 对应子表---TotalActualPaymentMny {}   ---UnpaidMny {}",
                                contractServiceOne.getTotalActualPaymentMny(), contractServiceOne.getUnpaidMny());
                        planContractService.saveOrUpdate(contractServiceOne);
                        planId = contractServiceOne.getPlanId();
                        break;
                    case 3:
                        //回写资金计划 对应子表
                        QueryWrapper<PlanMaterialEntity> materialQuery = new QueryWrapper<>();
                        materialQuery.eq("id", regulateEntity.getSourceId());
                        PlanMaterialEntity materialEntity = planMaterialService.getOne(materialQuery);
                        BigDecimal materialMny = materialEntity.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : materialEntity.getTotalActualPaymentMny();
                        materialEntity.setTotalActualPaymentMny(check?materialMny.add(mny):materialMny.subtract(mny));
                        materialEntity.setUnpaidMny(materialEntity.getMaterialPlanPaymentMny().subtract(materialEntity.getTotalActualPaymentMny()));
                        logger.info("回写资金计划 对应子表---TotalActualPaymentMny {}   ---UnpaidMny {}",
                                materialEntity.getTotalActualPaymentMny(), materialEntity.getUnpaidMny());
                        planMaterialService.saveOrUpdate(materialEntity);
                        planId = materialEntity.getPlanId();
                        break;
                    case 4:
                        //回写资金计划 对应子表
                        QueryWrapper<PlanTemporaryEntity> temporaryQuery = new QueryWrapper<>();
                        temporaryQuery.eq("id", regulateEntity.getSourceId());
                        PlanTemporaryEntity temporaryEntity = planTemporaryService.getOne(temporaryQuery);
                        BigDecimal temporaryMny = temporaryEntity.getTotalActualPaymentMny() == null ? BigDecimal.ZERO : temporaryEntity.getTotalActualPaymentMny();
                        temporaryEntity.setTotalActualPaymentMny(check?temporaryMny.add(mny):temporaryMny.subtract(mny));
                        temporaryEntity.setUnpaidMny(temporaryEntity.getTemporaryPlanPaymentMny().subtract(temporaryEntity.getTotalActualPaymentMny()));
                        logger.info("回写资金计划 对应子表---TotalActualPaymentMny {}   ---UnpaidMny {}",
                                temporaryEntity.getTotalActualPaymentMny(), temporaryEntity.getUnpaidMny());
                        planTemporaryService.saveOrUpdate(temporaryEntity);
                        planId = temporaryEntity.getPlanId();

                        break;

                    case 5:

                        //回写资金计划 对应子表
                        QueryWrapper<PlanFeeEntity> planFeeQuery = new QueryWrapper<>();
                        planFeeQuery.eq("id", regulateEntity.getSourceId());
                        PlanFeeEntity planFeeEntity = planFeeService.getOne(planFeeQuery);
                        BigDecimal planFeeMny = planFeeEntity.getTotalActualPaymentMny() == null ?BigDecimal.ZERO : planFeeEntity.getTotalActualPaymentMny();
                        planFeeEntity.setTotalActualPaymentMny(check?planFeeMny.add(mny):planFeeMny.subtract(mny));
                        planFeeEntity.setUnpaidMny(planFeeEntity.getFeePlanPaymentMny().subtract(planFeeEntity.getTotalActualPaymentMny()));
                        logger.info("回写资金计划 对应子表---TotalActualPaymentMny {}   ---UnpaidMny {}",
                                planFeeEntity.getTotalActualPaymentMny(), planFeeEntity.getUnpaidMny());
                        planFeeService.saveOrUpdate(planFeeEntity);
                        planId = planFeeEntity.getPlanId();

                        break;
                    default:
                        break;
                }
                if ( planId!=null){
                    //回写 资金计划 主表
                    PlanEntity planEntity = planService.selectById(planId);
                    BigDecimal cueTotalActualPaymentMny = planEntity.getCurTotalActualPaymentMny() == null ? BigDecimal.ZERO : planEntity.getCurTotalActualPaymentMny();
                    planEntity.setCurTotalActualPaymentMny(check?cueTotalActualPaymentMny.add(mny):cueTotalActualPaymentMny.subtract(mny));
                    logger.info("回写 资金计划 主表---CueTotalActualPaymentMny {}  ", planEntity.getCurTotalActualPaymentMny());
                    planService.saveOrUpdate(planEntity);
                }
            }
            regulateService.saveOrUpdateBatch(regulateEntities);

        }
    }


    @Override
    public void checkStatus(PaymentRegisterVO entity) {
        if (entity.getPaymentContractFlag() == 2) {
            if ("引用".equals(entity.getRefStatus())){
                throw new BusinessException("操作失败！该合同存在未生效的【付款登记】，不允许再次确认支付。");

            }
            QueryWrapper<PaymentRegisterEntity> listQuery = new QueryWrapper<>();
            listQuery.eq("source_id",entity.getSourceId());
            listQuery.notIn("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            int resultCount = super.count(listQuery);
            if (resultCount > 0) {
                throw new BusinessException(" 操作失败！该合同存在未生效的【付款登记】，不允许再次确认支付。");
            }
        } else {
            List<RegisterDetailVO> detailList = entity.getDetailList();
            for (RegisterDetailVO vo : detailList) {
                if ("引用".equals(vo.getRefStatus())) {
                    throw new BusinessException(" 操作失败！结算单号" + vo.getSourceBillCode() + "存在未生效的【付款登记】，不允许再次确认支付。");
                }
                QueryWrapper<RegisterDetailEntity> listQuery = new QueryWrapper<>();
                listQuery.eq("source_id",vo.getSourceId());
                listQuery.notIn("bill_state",BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                int resultCount = detailService.count(listQuery);
                if (resultCount > 0) {
                    throw new BusinessException(" 操作失败！结算单号" + vo.getSourceBillCode() + "存在未生效的【付款登记】，不允许再次确认支付。");
                }
            }
        }
    }


    /**
     *
     * @param entity
     * @param flag 0 保存  1删除 2提交
     */
    @Override
    public void updateStatus(PaymentRegisterEntity entity,int flag) {
        List<Long> delIds = new ArrayList<>();
        List<Long> addIds = new ArrayList<>();
        if (entity.getPaymentContractFlag() == 2) {
            if (flag==1||flag==2){
                delIds.add(entity.getSourceId());
            }else {
                addIds.add(entity.getSourceId());
            }
        } else {
            List<RegisterDetailEntity> detailList = entity.getDetailList();
            for (RegisterDetailEntity vo : detailList) {
                if (flag==1||flag==2){
                    delIds.add(vo.getSourceId());
                }else {
                    if (vo.getRowState() != null && vo.getRowState().equals("del")) {
                        delIds.add(vo.getSourceId());
                    }
                    if (vo.getRowState() != null && vo.getRowState().equals("add")) {
                        addIds.add(vo.getSourceId());
                    }
                }
            }
        }
        if (!delIds.isEmpty()) {
            logger.info("设置未引用 ---{}",JSONObject.toJSONString(delIds));
            regulateService.updateColumnValue(delIds, "ref_status", "未引用");
        }
        if (!addIds.isEmpty()) {
            logger.info("设置为引用 ---{}",JSONObject.toJSONString(addIds));
            regulateService.updateColumnValue(addIds, "ref_status", "引用");
        }
    }

    @Override
    public Map<String, BigDecimal> queryActualPayGroupByMonth(QueryParam queryParam) {
        QueryWrapper<PaymentRegisterEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(pay_mny) as totalMny, date_format(payment_date,'%Y-%m') as yearMonth");
        query.groupBy("date_format(payment_date,'%Y-%m')");
        List<Map<String, Object>> rs = super.listMaps(query);
        Map<String, BigDecimal> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(rs)) {
            for(Map<String, Object> m : rs) {
                resp.put(m.get("yearMonth").toString(), new BigDecimal(m.get("totalMny").toString()));
            }
        }
        return resp;
    }

    @Override
    public BigDecimal getAcutalPayAndRegisterDiffMny(Long projectId, Long supplyId, Long payeeId, Long contractId) {
        QueryWrapper<PaymentRegisterEntity> query = new QueryWrapper<>();
        QueryWrapper<PaymentApplyEntity> paymentQuery = new QueryWrapper<>();

        query.select("sum(pay_mny) as totalPaidMny");
        if(null == contractId || contractId.equals(-1L)) {
            query.isNull("contract_id");
            paymentQuery.isNull("contract_id");
        } else {
            query.eq("contract_id", contractId);
            paymentQuery.eq("contract_id", contractId);
        }
        query.eq("project_id", projectId);
        query.eq("supplier_id", supplyId);
        query.eq("payee_id", payeeId);
        Map<String, Object> result = super.getMap(query);
        BigDecimal totalRegisterMny = null != result && null != result.get("totalPaidMny") ? new BigDecimal(result.get("totalPaidMny").toString()) : BigDecimal.ZERO;

        paymentQuery.select("sum(actual_mny) as totalActualPayMny");
        paymentQuery.eq("project_id", projectId);
        paymentQuery.eq("supplier_id", supplyId);
        paymentQuery.eq("payee_id", payeeId);
        Map<String, Object> payResult = paymentApplyService.getMap(paymentQuery);
        BigDecimal totalActualPayMny = null != payResult && null != payResult.get("totalActualPayMny") ? new BigDecimal(payResult.get("totalActualPayMny").toString()) : BigDecimal.ZERO;

        return totalActualPayMny.subtract(totalRegisterMny);
    }

    @Override
    public Map<String, BigDecimal> queryActualPayGroupByContractCategoryType(QueryParam queryParam) {
        QueryWrapper<PaymentRegisterEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(pay_mny) as totalMny, source_category_type as contractType");
        query.isNotNull("source_category_type");
        query.groupBy("source_category_type");
        List<Map<String, Object>> rs = super.listMaps(query);
        Map<String, BigDecimal> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(rs)) {
            for(Map<String, Object> m : rs) {
                resp.put(m.get("contractType").toString(), new BigDecimal(m.get("totalMny").toString()));
            }
        }
        return resp;
    }

    @Override
    public List<PaymentRegisterVO> querySumPaymentMny(QueryParam param) {
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        return baseMapper.querySumPaymentMny(wrapper);
    }


}
