/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.projectloan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.profinance.projectloan.bean.ProjectRepayDetailEntity;
import com.ejianc.business.profinance.projectloan.bean.ProjectRepayEntity;
import com.ejianc.business.profinance.projectloan.service.IProjectLoanService;
import com.ejianc.business.profinance.projectloan.service.IProjectRepayService;
import com.ejianc.business.profinance.projectloan.vo.ProjectRepayDetailVO;
import com.ejianc.business.profinance.projectloan.vo.ProjectRepayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectRepay"})
public class ProjectRepayController
implements Serializable {
    private static final long serialVersionUID = -7949596054926672689L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "PROJECT_REPAY";
    private static final String BILL_CODE = "EJCBT202208000002";
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IProjectRepayService service;
    private final SessionManager sessionManager;
    private final IProjectLoanService loanService;

    public ProjectRepayController(IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IProjectRepayService service, SessionManager sessionManager, IProjectLoanService loanService) {
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.sessionManager = sessionManager;
        this.loanService = loanService;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<ProjectRepayVO> saveOrUpdate(@RequestBody ProjectRepayVO saveOrUpdateVO) {
        ProjectRepayEntity entity = (ProjectRepayEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectRepayEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u9879\u76ee\u8fd8\u6b3e");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        List detailList = saveOrUpdateVO.getProjectRepayDetailList();
        ArrayList<Long> delIds = new ArrayList<Long>();
        ArrayList<Long> addIds = new ArrayList<Long>();
        for (ProjectRepayDetailVO vo : detailList) {
            if (vo.getRowState() != null && vo.getRowState().equals("del")) {
                Long sourceLoanId = vo.getSourceId();
                delIds.add(sourceLoanId);
            }
            if (vo.getRowState() == null || !vo.getRowState().equals("add")) continue;
            addIds.add(vo.getSourceId());
        }
        if (!delIds.isEmpty()) {
            this.loanService.updateColumnValue(delIds, "ref_status", "\u672a\u5f15\u7528");
        }
        if (!addIds.isEmpty()) {
            this.loanService.updateColumnValue(addIds, "ref_status", "\u5f15\u7528");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectRepayVO vo = (ProjectRepayVO)BeanMapper.map((Object)((Object)entity), ProjectRepayVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<ProjectRepayVO> queryDetail(Long id) {
        ProjectRepayEntity entity = (ProjectRepayEntity)((Object)this.service.selectById(id));
        ProjectRepayVO vo = (ProjectRepayVO)BeanMapper.map((Object)((Object)entity), ProjectRepayVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectRepayVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectRepayVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
                }
                ProjectRepayEntity repayEntity = (ProjectRepayEntity)((Object)this.service.selectById(vo.getId()));
                List<ProjectRepayDetailEntity> detailList = repayEntity.getProjectRepayDetailList();
                List<Long> sourceLoanIds = detailList.stream().map(ProjectRepayDetailEntity::getSourceId).collect(Collectors.toList());
                this.loanService.updateColumnValue(sourceLoanIds, "ref_status", "\u672a\u5f15\u7528");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("repayUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("repay_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Map<String, BigDecimal> map = this.service.fetchTotalMny(param);
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        List projectRepayVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectRepayVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)projectRepayVOS);
        resp.put("totalCurTotalRepayMny", (Object)map.get("totalCurTotalRepayMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("repayUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("repay_unit_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        ArrayList projectRepayVOS = new ArrayList();
        page.getRecords().forEach(e -> {
            ProjectRepayVO projectRepayVO = (ProjectRepayVO)BeanMapper.map((Object)e, ProjectRepayVO.class);
            projectRepayVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)projectRepayVO.getBillState()).getDescription());
            projectRepayVOS.add(projectRepayVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", projectRepayVOS);
        ExcelExport.getInstance().export("projectRepay-export.xlsx", beans, response);
    }
}

