/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.performance.service.impl;

import com.ejianc.business.performance.bean.PerformanceContractEntity;
import com.ejianc.business.performance.bean.PerformanceDeductedEntity;
import com.ejianc.business.performance.service.IPerformanceContractService;
import com.ejianc.business.performance.service.IPerformanceDeductedService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="performanceDeducted")
public class PerformanceDeductedBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPerformanceDeductedService performanceDeductedService;
    @Autowired
    private IPerformanceContractService contractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String> stringCommonResponse = this.performanceDeductedService.pushDataToFinance(billId);
        if (!stringCommonResponse.isSuccess()) {
            return stringCommonResponse;
        }
        PerformanceDeductedEntity performanceDeductedEntity = (PerformanceDeductedEntity)((Object)this.performanceDeductedService.selectById(billId));
        QueryParam queryParam1 = new QueryParam();
        queryParam1.getParams().put("projectId", new Parameter("eq", (Object)performanceDeductedEntity.getProjectId()));
        List performanceDeductedEntities = this.performanceDeductedService.queryList(queryParam1);
        BigDecimal deductedMnySum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)performanceDeductedEntities)) {
            deductedMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getDeductedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal amountDue = performanceDeductedEntity.getAmountDue();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)performanceDeductedEntity.getProjectId()));
        queryParam.getParams().put("payType", new Parameter("in", Arrays.asList(1)));
        queryParam.getParams().put("withholdingType", new Parameter("in", Arrays.asList(1)));
        queryParam.getParams().put("performanceBondReturn", new Parameter("in", Arrays.asList(1)));
        List performanceContractEntities = this.contractService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)performanceContractEntities)) {
            PerformanceContractEntity performanceContractEntity = (PerformanceContractEntity)((Object)performanceContractEntities.get(0));
            performanceContractEntity.setAlreadyDeductedAmount(deductedMnySum);
            performanceContractEntity.setRemainAmount(performanceContractEntity.getAmountDue().subtract(deductedMnySum));
            this.contractService.saveOrUpdate((Object)performanceContractEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5df2\u63a8\u9001\u8d22\u52a1\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

