/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.utils.DateUtil;
import com.ejianc.business.report.vo.DailyFinanceInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dailyFinanceWarn/"})
public class DailyFinanceWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMPayApplyApi pmPayApplyApi;
    @Autowired
    private IPaymentApplyService paymentApplyService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"dailyFind"})
    public CommonResponse<String> dailyFind(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u5f00\u59cb\u6267\u884c\u8d44\u91d1\u4ed8\u6b3e\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1-----{}", (Object)JSONObject.toJSONString((Object)jsonParam));
        String yesterday = DateUtil.getYesterdayOfDay(new Date());
        Map<Object, Object> dailFinanceMap = null;
        CommonResponse dailyFinanceInfoListResp = this.pmPayApplyApi.dailyFinanceInfo(yesterday);
        List<DailyFinanceInfoVO> dailyFinanceList = new ArrayList();
        if (!dailyFinanceInfoListResp.isSuccess()) {
            this.logger.error("\u6628\u65e5\u8d22\u52a1\u901a\u77e5PM\u4ed8\u6b3e\u60c5\u51b5\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a");
            dailFinanceMap = new HashMap();
        } else {
            dailyFinanceList = BeanMapper.mapList((Iterable)((Iterable)dailyFinanceInfoListResp.getData()), DailyFinanceInfoVO.class);
            if (CollectionUtils.isEmpty(dailyFinanceList)) {
                this.logger.info("\u6628\u65e5\u8d22\u52a1\u901a\u77e5PM\u4ed8\u6b3e\u60c5\u51b5\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a");
                dailFinanceMap = new HashMap();
            } else {
                dailFinanceMap = dailyFinanceList.stream().collect(Collectors.toMap(item -> item.getProjectId().toString() + item.getSupplierId().toString() + item.getPayeeId().toString() + item.getContractId().toString(), item -> item));
            }
        }
        List<DailyFinanceInfoVO> pmDailyFinanceList = this.paymentApplyService.dailyFinanceInfo(yesterday);
        DailyFinanceInfoVO tmp = null;
        if (CollectionUtils.isNotEmpty(pmDailyFinanceList)) {
            for (DailyFinanceInfoVO item2 : pmDailyFinanceList) {
                tmp = (DailyFinanceInfoVO)dailFinanceMap.get(item2.getProjectId().toString() + item2.getSupplierId().toString() + item2.getPayeeId().toString() + item2.getContractId().toString());
                if (null != tmp) {
                    tmp.setFinanceDate(item2.getFinanceDate());
                    tmp.setSucMny(item2.getSucMny());
                    tmp.setSucNum(item2.getSucNum());
                    tmp.setFailMny(item2.getFailMny());
                    tmp.setFailNum(item2.getFailNum());
                    tmp.setPsNum(item2.getPsNum());
                    tmp.setPsMny(item2.getPsMny());
                    tmp.setPMRecTime(item2.getPMRecTime());
                    tmp.setPMRecMny(item2.getPMRecMny());
                    tmp.setRegisterMny(item2.getRegisterMny());
                    tmp.setProjectName(item2.getProjectName());
                    tmp.setContractName(item2.getContractName());
                    tmp.setSupplierName(item2.getSupplierName());
                    tmp.setPayeeName(item2.getPayeeName());
                    continue;
                }
                dailyFinanceList.add(item2);
            }
        }
        JSONObject warnInfo = jsonParam.getJSONObject(0);
        Long tenantId = warnInfo.getLong("tenantId");
        String warnCode = warnInfo.getString("warnCode");
        JSONObject setting = warnInfo.getJSONArray("settings").getJSONObject(0);
        JSONObject warnSettings = setting.getJSONArray("warningSetings").getJSONObject(0);
        String templateContent = setting.getString("warningContentTemplate");
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        EarlyWarnTransVO warnTmp = null;
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.orgApi.getOneById(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)orgResp));
            return CommonResponse.error((String)"\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
        }
        OrgVO org = (OrgVO)orgResp.getData();
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
        for (DailyFinanceInfoVO item3 : dailyFinanceList) {
            this.logger.info("item ---: {}", (Object)JSONObject.toJSONString((Object)item3));
            if (!(null != item3.getNotifyPMFailNum() && item3.getNotifyPMFailNum() > 0 || null != item3.getFailNum() && item3.getFailNum() > 0) && (null == item3.getSucMny() || null == item3.getRegisterMny() || item3.getSucMny().compareTo(item3.getRegisterMny()) == 0)) continue;
            warnTmp = new EarlyWarnTransVO();
            warnTmp.setWarnSetId(warnSettings.getLong("paramId"));
            warnTmp.setWarnSetParamId(warnSettings.getLong("id"));
            warnTmp.setWarnLevel(warnSettings.getString("warningLevel"));
            warnTmp.setTenantId(tenantId);
            warnTmp.setWarnType(setting.getString("warnType"));
            warnTmp.setEarlywarnName(setting.getString("warnName"));
            warnTmp.setOrgId(orgId);
            warnTmp.setOrgName(org.getName());
            warnTmp.setBillName("\u4ed8\u6b3e\u7533\u8bf7\u8d44\u91d1\u65e5\u5bf9\u8d26");
            warnTmp.setSendOrgId(InvocationInfoProxy.getOrgId().toString());
            warnTmp.setEarlywarnContent(templateContent.replaceAll("#projectName#", item3.getProjectName() != null ? item3.getProjectName() : (null != item3.getProjectId() ? item3.getProjectId().toString() : "")).replaceAll("#supplierName#", item3.getSupplierName() != null ? item3.getSupplierName() : (null != item3.getSupplierId() ? item3.getSupplierId().toString() : "")).replaceAll("#payeeName#", item3.getPayeeName() != null ? item3.getPayeeName() : (null != item3.getPayeeId() ? item3.getPayeeId().toString() : "")).replaceAll("#contractName#", null != item3.getContractName() ? item3.getContractName() : "").replaceAll("#payTime#", null != item3.getPayTime() ? item3.getPayTime().toString() : "0").replaceAll("#payMny#", decimalFormat.format(null != item3.getPayMny() ? item3.getPayMny() : BigDecimal.ZERO)).replaceAll("#notifyPMSucNum#", null != item3.getNotifyPMSucNum() ? item3.getNotifyPMSucNum().toString() : "0").replaceAll("#notifyPMSucMny#", decimalFormat.format(null != item3.getNotifyPMSucMny() ? item3.getNotifyPMSucMny() : BigDecimal.ZERO)).replaceAll("#notifyPMFailNum#", null != item3.getNotifyPMFailNum() ? item3.getNotifyPMFailNum().toString() : "0").replaceAll("#notifyPMFailMny#", decimalFormat.format(null != item3.getNotifyPMFailMny() ? item3.getNotifyPMFailMny() : BigDecimal.ZERO)).replaceAll("#sucNum#", null != item3.getSucNum() ? item3.getSucNum().toString() : "0").replaceAll("#sucMny#", decimalFormat.format(null != item3.getSucMny() ? item3.getSucMny() : BigDecimal.ZERO)).replaceAll("#failNum#", null != item3.getFailNum() ? item3.getFailNum().toString() : "0").replaceAll("#failMny#", decimalFormat.format(null != item3.getFailMny() ? item3.getFailMny() : BigDecimal.ZERO)).replaceAll("#psNum#", null != item3.getPsNum() ? item3.getPsNum().toString() : "0").replaceAll("#psMny#", decimalFormat.format(null != item3.getPsMny() ? item3.getPsMny() : BigDecimal.ZERO)).replaceAll("#registerMny#", decimalFormat.format(null != item3.getRegisterMny() ? item3.getRegisterMny() : BigDecimal.ZERO)));
            warnList.add(warnTmp);
        }
        if (CollectionUtils.isEmpty(warnList)) {
            this.logger.info("\u6628\u5929\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u65e0\u5f02\u5e38\uff0c\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002");
            return CommonResponse.success((String)"\u6628\u5929\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u65e0\u5f02\u5e38\uff0c\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002");
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u6d88\u606f\uff1alist-\u3010{}\u3011,code-\u3010{}\u3011", (Object)JSONObject.toJSONString(warnList), (Object)warnCode);
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5931\u8d25 " + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u8d44\u91d1\u5bf9\u8d26\u60c5\u51b5\u7edf\u8ba1\u4efb\u52a1\u7ed3\u675f\uff01");
    }
}

