/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.person.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.person.bean.PersonLoanEntity;
import com.ejianc.business.profinance.person.bean.PersonRepayDetailEntity;
import com.ejianc.business.profinance.person.bean.PersonRepayEntity;
import com.ejianc.business.profinance.person.service.IPersonLoanService;
import com.ejianc.business.profinance.person.service.IPersonRepayService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="personRepay")
public class PersonRepayBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IOrgApi iOrgApi;
    private final SessionManager sessionManager;
    private final IPersonRepayService service;
    private final IBillTypeApi billTypeApi;
    private final IPersonLoanService personLoanService;

    public PersonRepayBpmServiceImpl(IOrgApi iOrgApi, SessionManager sessionManager, IPersonRepayService service, IBillTypeApi billTypeApi, IPersonLoanService personLoanService) {
        this.iOrgApi = iOrgApi;
        this.sessionManager = sessionManager;
        this.service = service;
        this.billTypeApi = billTypeApi;
        this.personLoanService = personLoanService;
    }

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u4e2a\u4eba\u8fd8\u6b3e\uff0c \u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PersonRepayEntity entity = (PersonRepayEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4e2a\u4eba\u8fd8\u6b3e \u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PersonRepayEntity entity = (PersonRepayEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            entity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        List<PersonRepayDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map collect = detailList.stream().collect(Collectors.toMap(PersonRepayDetailEntity::getSourceLoanId, Function.identity()));
            Set<Long> personLoanIds = collect.keySet();
            Collection personLoanEntities = this.personLoanService.listByIds(personLoanIds);
            for (PersonLoanEntity person : personLoanEntities) {
                PersonRepayDetailEntity personRepayDetailEntity = (PersonRepayDetailEntity)((Object)collect.get(person.getId()));
                person.setRepaidLoanMny(person.getRepaidLoanMny().add(personRepayDetailEntity.getCurRepayMny()).setScale(2, RoundingMode.HALF_UP));
                person.setLeftLoanMny(person.getLoanMny().subtract(person.getRepaidLoanMny()).setScale(2, RoundingMode.HALF_UP));
            }
            this.personLoanService.saveOrUpdateBatch(new ArrayList(personLoanEntities), 10, false);
            List<Long> sourceLoanIds = detailList.stream().map(PersonRepayDetailEntity::getSourceLoanId).collect(Collectors.toList());
            this.personLoanService.updateColumnValue(sourceLoanIds, "ref_status", "\u672a\u5f15\u7528");
        }
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u4e2a\u4eba\u8fd8\u6b3e \u7ec8\u5ba1\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PersonRepayEntity entity = (PersonRepayEntity)((Object)this.service.selectById(billId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("repayPersonId", new Parameter("eq", (Object)entity.getRepayPersonId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("effective_date", "desc");
        queryParam.setOrderMap(orderMap);
        List personRepayEntities = this.service.queryList(queryParam);
        if (!((PersonRepayEntity)((Object)personRepayEntities.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de\u6216\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        this.writeBackProjectLoan(entity);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void writeBackProjectLoan(PersonRepayEntity entity) {
        List<PersonRepayDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map repayDetailEntityMap = detailList.stream().collect(Collectors.toMap(PersonRepayDetailEntity::getSourceLoanId, Function.identity()));
            Set<Long> projectLoanIds = repayDetailEntityMap.keySet();
            Collection personLoanEntities = this.personLoanService.listByIds(projectLoanIds);
            for (PersonLoanEntity person : personLoanEntities) {
                PersonRepayDetailEntity repayDetail = (PersonRepayDetailEntity)((Object)repayDetailEntityMap.get(person.getId()));
                this.logger.info("\u4fee\u6539\u8fd8 \u5b50\u8868\u5b9e\u4f53\u2014\u2014\u2014\u2014\u2014\u2014:{}", (Object)JSONObject.toJSONString((Object)((Object)repayDetail)));
                this.logger.info("\u4fee\u6539\u524d\u5b9e\u4f53\u2014\u2014\u2014\u2014\u2014\u2014:{}", (Object)JSONObject.toJSONString((Object)((Object)person)));
                person.setRepaidLoanMny(person.getRepaidLoanMny().subtract(repayDetail.getCurRepayMny()).setScale(2, RoundingMode.HALF_UP));
                this.logger.info("\u4fee\u6539\u540e\u5b9e\u4f53\u2014\u2014\u2014\u2014\u2014\u2014:{}", (Object)JSONObject.toJSONString((Object)((Object)person)));
                person.setLeftLoanMny(person.getLoanMny().subtract(person.getRepaidLoanMny()).setScale(2, RoundingMode.HALF_UP));
            }
            this.personLoanService.saveOrUpdateBatch(new ArrayList(personLoanEntities), 10, false);
            List<Long> sourceLoanIds = detailList.stream().map(PersonRepayDetailEntity::getSourceLoanId).collect(Collectors.toList());
            this.personLoanService.updateColumnValue(sourceLoanIds, "ref_status", "\u5f15\u7528");
        }
    }
}

