package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目资金计划-零星费用
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan_fee")
public class PlanFeeEntity extends BaseEntity {
	private static final long serialVersionUID = -3820662884844330616L;

	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "fee_id")
	private Long feeId; // 零星费用单Id
	@TableField(value = "fee_code")
	private String feeCode; // 零星费用单编码
	@TableField(value = "fee_name")
	private String feeName; // 零星费用单名称
	@TableField(value = "fee_route_url")
	private String feeRouteUrl; // 零星费用路由地址
	@TableField(value = "pay_type_no_contract_id")
	private Long payTypeNoContractId; // 无合同费用类型id
	@TableField(value = "pay_type_no_contract_code")
	private String payTypeNoContractCode; // 无合同费用类型编码
	@TableField(value = "pay_type_no_contract_name")
	private String payTypeNoContractName; // 无合同费用类型名称
	@TableField(value = "happen_date")
	private Date happenDate; // 发生日期
	@TableField(value = "payment_object")
	private String paymentObject; // 支付对象 1-供应商 2-内部员工
	@TableField(value = "supplier_org_id")
	private Long supplierOrgId; // 收款单位id
	@TableField(value = "supplier_org_name")
	private String supplierOrgName; // 收款单位名称
	@TableField(value = "supplier_org_code")
	private String supplierOrgCode; // 收款单位编码
	@TableField(value = "supplier_user_id")
	private Long supplierUserId; // 收款人id
	@TableField(value = "supplier_user_name")
	private String supplierUserName; // 收款人名称
	@TableField(value = "supplier_user_code")
	private String supplierUserCode; // 收款人编码
	@TableField(value = "supplier_name")
	private String supplierName; // 收款单位/收款人名称
	@TableField(value = "fee_payment_content")
	private String feePaymentContent; // 付款内容
	@TableField(value = "fee_settle_mode_id")
	private Long feeSettleModeId; // 结算方式id =自定义档案【大企业收付款登记-结算方式】
	@TableField(value = "fee_settle_mode_code")
	private String feeSettleModeCode; // 结算方式编码
	@TableField(value = "fee_settle_mode_name")
	private String feeSettleModeName; // 结算方式名称
	@TableField(value = "fee_should_pay_tax_mny")
	private BigDecimal feeShouldPayTaxMny; // 应付费用金额
	@TableField(value = "fee_applied_mny")
	private BigDecimal feeAppliedMny; // 已申请金额
	@TableField(value = "fee_can_apply_mny")
	private BigDecimal feeCanApplyMny; // 本次可申请金额
	@TableField(value = "fee_plan_payment_mny")
	private BigDecimal feePlanPaymentMny; // 本次计划付款金额
	@TableField(value = "fee_total_apply_payment_mny")
	private BigDecimal feeTotalApplyPaymentMny; // 累计申请付款金额(含本次)
	@TableField(value = "fee_paid_scale")
	private BigDecimal feePaidScale; // 已付款比例%（含本次）
	@TableField(value = "fee_memo")
	private String feeMemo; // 备注
	@TableField(value = "total_actual_payment_mny")
	private BigDecimal totalActualPaymentMny; // 本次累计实付金额
	@TableField(value = "unpaid_mny")
	private BigDecimal unpaidMny; // 本次未支付金额
	@TableField(value = "release_apply_mny")
	private BigDecimal releaseApplyMny; // 本次释放申请金额
	@TableField(value = "close_state")
	private String closeState; // 关闭状态 已关闭 未关闭
	@TableField(value = "close_date_time")
	private Date closeDateTime; // 关闭时间
	@TableField(value = "close_user_id")
	private Long closeUserId; // 关闭人
	@TableField(value = "close_user_name")
	private String closeUserName; // 关闭人名称
	@TableField(value = "close_user_code")
	private String closeUserCode; // 关闭人编码
	@TableField(value = "plan_id")
	private Long planId; // 项目资金计划id


	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getFeeId() {
		return feeId;
	}

	public void setFeeId(Long feeId) {
		this.feeId = feeId;
	}

	public String getFeeCode() {
		return feeCode;
	}

	public void setFeeCode(String feeCode) {
		this.feeCode = feeCode;
	}

	public String getFeeName() {
		return feeName;
	}

	public void setFeeName(String feeName) {
		this.feeName = feeName;
	}

	public String getFeeRouteUrl() {
		return feeRouteUrl;
	}

	public void setFeeRouteUrl(String feeRouteUrl) {
		this.feeRouteUrl = feeRouteUrl;
	}

	public Long getPayTypeNoContractId() {
		return payTypeNoContractId;
	}

	public void setPayTypeNoContractId(Long payTypeNoContractId) {
		this.payTypeNoContractId = payTypeNoContractId;
	}

	public String getPayTypeNoContractCode() {
		return payTypeNoContractCode;
	}

	public void setPayTypeNoContractCode(String payTypeNoContractCode) {
		this.payTypeNoContractCode = payTypeNoContractCode;
	}

	public String getPayTypeNoContractName() {
		return payTypeNoContractName;
	}

	public void setPayTypeNoContractName(String payTypeNoContractName) {
		this.payTypeNoContractName = payTypeNoContractName;
	}

	public Date getHappenDate() {
		return happenDate;
	}

	public void setHappenDate(Date happenDate) {
		this.happenDate = happenDate;
	}

	public String getPaymentObject() {
		return paymentObject;
	}

	public void setPaymentObject(String paymentObject) {
		this.paymentObject = paymentObject;
	}

	public Long getSupplierOrgId() {
		return supplierOrgId;
	}

	public void setSupplierOrgId(Long supplierOrgId) {
		this.supplierOrgId = supplierOrgId;
	}

	public String getSupplierOrgName() {
		return supplierOrgName;
	}

	public void setSupplierOrgName(String supplierOrgName) {
		this.supplierOrgName = supplierOrgName;
	}

	public String getSupplierOrgCode() {
		return supplierOrgCode;
	}

	public void setSupplierOrgCode(String supplierOrgCode) {
		this.supplierOrgCode = supplierOrgCode;
	}

	public Long getSupplierUserId() {
		return supplierUserId;
	}

	public void setSupplierUserId(Long supplierUserId) {
		this.supplierUserId = supplierUserId;
	}

	public String getSupplierUserName() {
		return supplierUserName;
	}

	public void setSupplierUserName(String supplierUserName) {
		this.supplierUserName = supplierUserName;
	}

	public String getSupplierUserCode() {
		return supplierUserCode;
	}

	public void setSupplierUserCode(String supplierUserCode) {
		this.supplierUserCode = supplierUserCode;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getFeePaymentContent() {
		return feePaymentContent;
	}

	public void setFeePaymentContent(String feePaymentContent) {
		this.feePaymentContent = feePaymentContent;
	}

	public Long getFeeSettleModeId() {
		return feeSettleModeId;
	}

	public void setFeeSettleModeId(Long feeSettleModeId) {
		this.feeSettleModeId = feeSettleModeId;
	}

	public String getFeeSettleModeCode() {
		return feeSettleModeCode;
	}

	public void setFeeSettleModeCode(String feeSettleModeCode) {
		this.feeSettleModeCode = feeSettleModeCode;
	}

	public String getFeeSettleModeName() {
		return feeSettleModeName;
	}

	public void setFeeSettleModeName(String feeSettleModeName) {
		this.feeSettleModeName = feeSettleModeName;
	}

	public BigDecimal getFeeShouldPayTaxMny() {
		return feeShouldPayTaxMny;
	}

	public void setFeeShouldPayTaxMny(BigDecimal feeShouldPayTaxMny) {
		this.feeShouldPayTaxMny = feeShouldPayTaxMny;
	}

	public BigDecimal getFeeAppliedMny() {
		return feeAppliedMny;
	}

	public void setFeeAppliedMny(BigDecimal feeAppliedMny) {
		this.feeAppliedMny = feeAppliedMny;
	}

	public BigDecimal getFeeCanApplyMny() {
		return feeCanApplyMny;
	}

	public void setFeeCanApplyMny(BigDecimal feeCanApplyMny) {
		this.feeCanApplyMny = feeCanApplyMny;
	}

	public BigDecimal getFeePlanPaymentMny() {
		return feePlanPaymentMny;
	}

	public void setFeePlanPaymentMny(BigDecimal feePlanPaymentMny) {
		this.feePlanPaymentMny = feePlanPaymentMny;
	}

	public BigDecimal getFeeTotalApplyPaymentMny() {
		return feeTotalApplyPaymentMny;
	}

	public void setFeeTotalApplyPaymentMny(BigDecimal feeTotalApplyPaymentMny) {
		this.feeTotalApplyPaymentMny = feeTotalApplyPaymentMny;
	}

	public BigDecimal getFeePaidScale() {
		return feePaidScale;
	}

	public void setFeePaidScale(BigDecimal feePaidScale) {
		this.feePaidScale = feePaidScale;
	}

	public String getFeeMemo() {
		return feeMemo;
	}

	public void setFeeMemo(String feeMemo) {
		this.feeMemo = feeMemo;
	}

	public BigDecimal getTotalActualPaymentMny() {
		return totalActualPaymentMny;
	}

	public void setTotalActualPaymentMny(BigDecimal totalActualPaymentMny) {
		this.totalActualPaymentMny = totalActualPaymentMny;
	}

	public BigDecimal getUnpaidMny() {
		return unpaidMny;
	}

	public void setUnpaidMny(BigDecimal unpaidMny) {
		this.unpaidMny = unpaidMny;
	}

	public BigDecimal getReleaseApplyMny() {
		return releaseApplyMny;
	}

	public void setReleaseApplyMny(BigDecimal releaseApplyMny) {
		this.releaseApplyMny = releaseApplyMny;
	}

	public String getCloseState() {
		return closeState;
	}

	public void setCloseState(String closeState) {
		this.closeState = closeState;
	}

	public Date getCloseDateTime() {
		return closeDateTime;
	}

	public void setCloseDateTime(Date closeDateTime) {
		this.closeDateTime = closeDateTime;
	}

	public Long getCloseUserId() {
		return closeUserId;
	}

	public void setCloseUserId(Long closeUserId) {
		this.closeUserId = closeUserId;
	}

	public String getCloseUserName() {
		return closeUserName;
	}

	public void setCloseUserName(String closeUserName) {
		this.closeUserName = closeUserName;
	}

	public String getCloseUserCode() {
		return closeUserCode;
	}

	public void setCloseUserCode(String closeUserCode) {
		this.closeUserCode = closeUserCode;
	}

	public Long getPlanId() {
		return planId;
	}

	public void setPlanId(Long planId) {
		this.planId = planId;
	}

}
